/*
 * Decompiled with CFR 0.152.
 */
package hec.clientapp.rmi.admin;

import hec.clientapp.client.RmiTextFileReaderJDialog;
import hec.clientapp.model.ManagerProxy;
import hec.clientapp.model.ManagerProxyList;
import hec.clientapp.rmi.csinterface.RmiWorkspace;
import hec.io.Identifier;
import hec.lang.UserId;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.invoke.CallSite;
import java.rmi.RemoteException;
import java.util.Date;
import java.util.TimeZone;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.table.TableModel;
import mil.army.usace.hec.rmi.admin.InfoJDialog;
import mil.army.usace.hec.rmi.csinterface.RmiFileManager;
import rma.swing.RmaJTable;
import rma.swing.table.RmaTableModel;

public class WorkspaceInfoJDialog
extends InfoJDialog {
    private JList userList;
    private JList wkspList;
    private JLabel lockedBy;
    private JLabel wkspPath;
    private JLabel wkspDesc;
    private JLabel wkspName;
    private JLabel urlLabel;
    private JLabel timeZoneLabel;
    private JLabel unitsLabel;
    protected RmiWorkspace _wksp;
    protected JPanel buttonPanel;

    public WorkspaceInfoJDialog(Frame parent) {
        super(parent);
        this.setSize(400, 400);
        Insets insets5505 = new Insets(5, 5, 0, 5);
        int gridy = 0;
        JLabel label = new JLabel("URL:");
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = gridy;
        gbc.gridwidth = 1;
        gbc.weightx = 1.0;
        gbc.insets = insets5505;
        gbc.anchor = 18;
        gbc.fill = 0;
        this.urlLabel = new JLabel("Unknown");
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = gridy++;
        gbc.gridwidth = 1;
        gbc.weightx = 1.0;
        gbc.insets = insets5505;
        gbc.anchor = 18;
        gbc.fill = 2;
        label = new JLabel("Name:");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = gridy;
        gbc.gridwidth = 1;
        gbc.weightx = 1.0;
        gbc.insets = insets5505;
        gbc.anchor = 18;
        gbc.fill = 0;
        this.getContentPane().add((Component)label, gbc);
        this.wkspName = new JLabel("Unknown");
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = gridy++;
        gbc.gridwidth = 1;
        gbc.weightx = 1.0;
        gbc.insets = insets5505;
        gbc.anchor = 18;
        gbc.fill = 2;
        this.getContentPane().add((Component)this.wkspName, gbc);
        label = new JLabel("Description:");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = gridy;
        gbc.gridwidth = 1;
        gbc.weightx = 1.0;
        gbc.insets = insets5505;
        gbc.anchor = 18;
        gbc.fill = 0;
        this.getContentPane().add((Component)label, gbc);
        this.wkspDesc = new JLabel("Unknown");
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = gridy++;
        gbc.gridwidth = 1;
        gbc.weightx = 1.0;
        gbc.insets = insets5505;
        gbc.anchor = 18;
        gbc.fill = 0;
        this.getContentPane().add((Component)this.wkspDesc, gbc);
        label = new JLabel("Path:");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = gridy;
        gbc.gridwidth = 1;
        gbc.weightx = 1.0;
        gbc.insets = insets5505;
        gbc.anchor = 18;
        gbc.fill = 0;
        this.getContentPane().add((Component)label, gbc);
        this.wkspPath = new JLabel("Unknown");
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = gridy++;
        gbc.gridwidth = 1;
        gbc.weightx = 1.0;
        gbc.insets = insets5505;
        gbc.anchor = 18;
        gbc.fill = 2;
        this.getContentPane().add((Component)this.wkspPath, gbc);
        label = new JLabel("Units:");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = gridy;
        gbc.gridwidth = 1;
        gbc.weightx = 1.0;
        gbc.insets = insets5505;
        gbc.anchor = 18;
        gbc.fill = 0;
        this.getContentPane().add((Component)label, gbc);
        this.unitsLabel = new JLabel("Unknown");
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = gridy++;
        gbc.gridwidth = 1;
        gbc.weightx = 1.0;
        gbc.insets = insets5505;
        gbc.anchor = 18;
        gbc.fill = 2;
        this.getContentPane().add((Component)this.unitsLabel, gbc);
        label = new JLabel("TimeZone:");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = gridy;
        gbc.gridwidth = 1;
        gbc.weightx = 1.0;
        gbc.insets = insets5505;
        gbc.anchor = 18;
        gbc.fill = 0;
        this.getContentPane().add((Component)label, gbc);
        this.timeZoneLabel = new JLabel("Unknown");
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = gridy++;
        gbc.gridwidth = 1;
        gbc.weightx = 1.0;
        gbc.insets = insets5505;
        gbc.anchor = 18;
        gbc.fill = 2;
        this.getContentPane().add((Component)this.timeZoneLabel, gbc);
        label = new JLabel("Locked By:");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = gridy;
        gbc.gridwidth = 1;
        gbc.weightx = 1.0;
        gbc.insets = insets5505;
        gbc.anchor = 18;
        gbc.fill = 0;
        this.getContentPane().add((Component)label, gbc);
        this.lockedBy = new JLabel("Unknown");
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = gridy++;
        gbc.gridwidth = 1;
        gbc.weightx = 1.0;
        gbc.insets = insets5505;
        gbc.anchor = 18;
        gbc.fill = 2;
        this.getContentPane().add((Component)this.lockedBy, gbc);
        label = new JLabel("Users:");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = gridy;
        gbc.gridwidth = 1;
        gbc.weightx = 1.0;
        gbc.insets = insets5505;
        gbc.anchor = 18;
        gbc.fill = 0;
        this.getContentPane().add((Component)label, gbc);
        this.userList = new JList(){

            @Override
            public Dimension getPreferredScrollableViewportSize() {
                Dimension d = super.getPreferredScrollableViewportSize();
                d.height = 100;
                return d;
            }
        };
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = gridy++;
        gbc.gridwidth = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 3.0;
        gbc.insets = insets5505;
        gbc.anchor = 18;
        gbc.fill = 1;
        JScrollPane sp = new JScrollPane(this.userList);
        this.getContentPane().add((Component)sp, gbc);
        label = new JLabel("Open Child Workspaces:");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = gridy;
        gbc.gridwidth = 1;
        gbc.weightx = 1.0;
        gbc.insets = insets5505;
        gbc.anchor = 18;
        gbc.fill = 0;
        this.getContentPane().add((Component)label, gbc);
        this.wkspList = new JList(){

            @Override
            public Dimension getPreferredScrollableViewportSize() {
                Dimension d = super.getPreferredScrollableViewportSize();
                d.height = 100;
                return d;
            }
        };
        this.wkspList.setEnabled(false);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = gridy++;
        gbc.gridwidth = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 3.0;
        gbc.insets = insets5505;
        gbc.anchor = 18;
        gbc.fill = 1;
        sp = new JScrollPane(this.wkspList);
        this.getContentPane().add((Component)sp, gbc);
        this.buttonPanel = new JPanel();
        this.buttonPanel.setLayout(new GridBagLayout());
        gbc.gridx = 0;
        gbc.gridy = gridy;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.gridwidth = 2;
        gbc.insets = insets5505;
        gbc.anchor = 13;
        gbc.fill = 2;
        this.getContentPane().add((Component)this.buttonPanel, gbc);
        JButton closeWkspButton = new JButton("Close Watershed");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weighty = 1.0;
        gbc.insets = new Insets(5, 5, 5, 5);
        gbc.anchor = 13;
        gbc.fill = 0;
        this.buttonPanel.add((Component)closeWkspButton, gbc);
        JButton managerButton = new JButton("Manager Info");
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weighty = 1.0;
        gbc.insets = new Insets(5, 5, 5, 5);
        gbc.anchor = 13;
        gbc.fill = 0;
        this.buttonPanel.add((Component)managerButton, gbc);
        JButton removeUserButton = new JButton("Remove User");
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 0;
        gbc.weighty = 1.0;
        gbc.insets = new Insets(5, 5, 5, 5);
        gbc.anchor = 13;
        gbc.fill = 0;
        this.buttonPanel.add((Component)removeUserButton, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 4;
        gbc.gridy = 0;
        gbc.insets = new Insets(5, 5, 5, 5);
        gbc.anchor = 13;
        gbc.fill = 0;
        this.buttonPanel.add((Component)this.okButton, gbc);
        this.okButton.setText("Close");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WorkspaceInfoJDialog.this.setVisible(false);
                WorkspaceInfoJDialog.this.dispose();
            }
        });
        removeUserButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WorkspaceInfoJDialog.this.removeUser();
            }
        });
        managerButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WorkspaceInfoJDialog.this.managerInfo();
            }
        });
        closeWkspButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WorkspaceInfoJDialog.this.closeWorkspace();
            }
        });
        this.getRootPane().registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WorkspaceInfoJDialog.this.enterPressed();
            }
        }, KeyStroke.getKeyStroke(10, 0, true), 1);
        this.getRootPane().registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WorkspaceInfoJDialog.this.closeDialog();
            }
        }, KeyStroke.getKeyStroke(27, 0, true), 1);
    }

    public void setWorkspace(RmiWorkspace wksp) {
        this._wksp = wksp;
        this.fillForm();
    }

    private void fillForm() {
        if (this._wksp == null) {
            return;
        }
        try {
            String s = this._wksp.getTitleName();
            this.wkspName.setText(s);
            this.setTitle("Watershed " + this._wksp.getTitleName());
            TimeZone tz = this._wksp.getTimeZone();
            this.timeZoneLabel.setText(tz.getDisplayName());
            int unitId = this._wksp.getUnitSystem();
            if (unitId == 1) {
                this.unitsLabel.setText("English");
            } else if (unitId == 2) {
                this.unitsLabel.setText("SI");
            } else {
                this.unitsLabel.setText("undef");
            }
            s = this._wksp.getDescription();
            this.wkspDesc.setText(s);
            s = this._wksp.getLockedBy();
            this.lockedBy.setText(s);
            s = this._wksp.getWorkspacePath();
            this.wkspPath.setText(s);
            Vector v = this._wksp.getUsers();
            this.userList.setListData(v);
            this.getChildWkspInfo();
        }
        catch (RemoteException re) {
            System.out.println("fillForm(): remoteException getting wksp info " + re);
        }
    }

    private void getChildWkspInfo() {
        Vector<CallSite> v2 = new Vector<CallSite>();
        try {
            Vector v = this._wksp.getOpenChildWorkspaces();
            if (v != null) {
                for (int i = 0; i < v.size(); ++i) {
                    try {
                        RmiWorkspace child = this._wksp.getChildWorkspace((String)v.elementAt(i));
                        if (child == null) continue;
                        String user = child.getLockedBy();
                        v2.addElement((CallSite)((Object)(v.elementAt(i) + " - Locked by: " + user)));
                        continue;
                    }
                    catch (Exception e) {
                        System.out.println("getChildWkspInfo: Error getting info for child " + v.elementAt(i));
                        v2.addElement((CallSite)((Object)(v.elementAt(i) + " - Locked by: ?")));
                    }
                }
            }
        }
        catch (Exception e2) {
            System.out.println("getChildWkspInfo: Error getting child workspace list " + e2);
        }
        this.wkspList.setListData(v2);
    }

    public void setVisible(boolean b) {
        if (b && this._wksp == null) {
            return;
        }
        super.setVisible(b);
    }

    private void removeUser() {
        Object[] userNames = this.userList.getSelectedValues();
        if (userNames == null || userNames.length == 0) {
            return;
        }
        for (int i = 0; i < userNames.length; ++i) {
            try {
                this._wksp.removeUser((String)userNames[i]);
                continue;
            }
            catch (RemoteException re) {
                System.out.println("Failed to remove user " + userNames[i] + " error " + re);
            }
        }
        this.fillForm();
    }

    protected void managerInfo() {
        ManagerInfoDialog dlg = new ManagerInfoDialog(this.wkspName.getText());
        dlg.setVisible(true);
    }

    protected void viewConfigFile(String wkspType) {
        RmiTextFileReaderJDialog dialog = new RmiTextFileReaderJDialog((Dialog)((Object)this), this.isModal());
        dialog.setTitle("Configuration file for Workspace " + wkspType);
        Object path = this.wkspPath.getText() + "/";
        path = wkspType.equals("Main") ? ((String)path).concat(this.wkspName.getText()).concat(".wksp") : ((String)path).concat(wkspType).concat("/").concat(wkspType).concat(".conf");
        try {
            RmiFileManager fm = this._wksp.getFileManager();
            if (fm == null) {
                System.out.println("viewConfigFile: failed to get RmiFileManager");
                return;
            }
            Identifier id = new Identifier((String)path);
            Identifier openId = fm.openFile(UserId.getUserId(), id);
            if (openId == null) {
                System.out.println("viewConfigFile: failed to open " + id.getPath());
                return;
            }
            dialog.fillForm(openId);
            dialog.setVisible(true);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    void closeWorkspace() {
        int opt;
        if (this.userList.getModel().getSize() > 0 && (opt = JOptionPane.showConfirmDialog((Component)((Object)this), "Closing the Watershed will force all users currently using this Watershed to reopen it.\nAll unsaved changes will be lost. Continue?", "Confirm Watershed Close", 0)) == 1) {
            return;
        }
        for (int i = 0; i < this.userList.getModel().getSize(); ++i) {
            String user = (String)this.userList.getModel().getElementAt(i);
            try {
                this._wksp.closeWorkspace(user);
                continue;
            }
            catch (RemoteException re) {
                System.out.println("Error closing watershed " + re);
            }
        }
    }

    class ManagerInfoDialog
    extends JDialog {
        String[] wkspNames;
        private RmaJTable managerInfoTable;
        private JComboBox wkspNameCombo;
        private RmaTableModel headerModel;

        public ManagerInfoDialog(String wkspName) {
            super((Dialog)((Object)WorkspaceInfoJDialog.this), "Manager Information for " + wkspName, WorkspaceInfoJDialog.this.isModal());
            this.wkspNames = new String[]{"cavi", "dssmapgui", "fda", "fia", "gridUtil", "hfp", "Main", "mfp", "ras", "rss", "supplemental"};
            this.buildControls();
        }

        protected void buildControls() {
            this.getContentPane().setLayout(new GridBagLayout());
            Insets insets5505 = new Insets(5, 5, 0, 5);
            JLabel label = new JLabel("Workspace:");
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.gridwidth = 1;
            gbc.anchor = 18;
            gbc.fill = 0;
            gbc.insets = insets5505;
            this.getContentPane().add((Component)label, gbc);
            this.wkspNameCombo = new JComboBox<String>(this.wkspNames);
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = 0;
            gbc.gridwidth = 1;
            gbc.weightx = 1.0;
            gbc.anchor = 18;
            gbc.fill = 0;
            gbc.insets = insets5505;
            this.getContentPane().add((Component)this.wkspNameCombo, gbc);
            this.managerInfoTable = new RmaJTable(this, new String[]{"Description", "Path", "Type", "Index", "Modified Time"}){

                public Dimension getPreferredScrollableViewportSize() {
                    Dimension d = super.getPreferredScrollableViewportSize();
                    d.height = 200;
                    return d;
                }
            };
            this.headerModel = new RmaTableModel(new String[]{"Name"}, new Object[0][0], new boolean[]{false});
            this.managerInfoTable.setViewportRowHeader((TableModel)this.headerModel, null, null, 150);
            this.managerInfoTable.setEditable(false);
            this.managerInfoTable.setHorizontalAlignment(4, 3);
            this.managerInfoTable.setAutoResizeMode(0);
            this.managerInfoTable.setColumnWidths(new int[]{150, 200, 200, 50, 150});
            this.managerInfoTable.setCellSelectionEnabled(false);
            this.managerInfoTable.setColumnSelectionAllowed(false);
            this.managerInfoTable.setRowSelectionAllowed(true);
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 1;
            gbc.gridwidth = 2;
            gbc.weightx = 1.0;
            gbc.weighty = 2.0;
            gbc.anchor = 18;
            gbc.fill = 1;
            gbc.insets = insets5505;
            this.getContentPane().add((Component)this.managerInfoTable.getScrollPane(), gbc);
            JPanel panel = new JPanel(new GridBagLayout());
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = 2;
            gbc.gridwidth = 1;
            gbc.anchor = 14;
            gbc.fill = 0;
            gbc.insets = insets5505;
            this.getContentPane().add((Component)panel, gbc);
            JButton viewConfButton = new JButton("View Configuration File");
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.gridwidth = 1;
            gbc.anchor = 14;
            gbc.fill = 0;
            gbc.insets = insets5505;
            panel.add((Component)viewConfButton, gbc);
            JButton closeButton = new JButton("Close");
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = 0;
            gbc.gridwidth = 1;
            gbc.anchor = 14;
            gbc.fill = 0;
            gbc.insets = insets5505;
            panel.add((Component)closeButton, gbc);
            this.wkspNameCombo.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ManagerInfoDialog.this.fillForm((String)ManagerInfoDialog.this.wkspNameCombo.getSelectedItem());
                }
            });
            closeButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ManagerInfoDialog.this.setVisible(false);
                    ManagerInfoDialog.this.dispose();
                }
            });
            viewConfButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    WorkspaceInfoJDialog.this.viewConfigFile((String)ManagerInfoDialog.this.wkspNameCombo.getSelectedItem());
                }
            });
            this.wkspNameCombo.setSelectedItem("Main");
            this.pack();
            this.setLocationRelativeTo((Component)((Object)WorkspaceInfoJDialog.this));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void fillForm(String wkspName) {
            RmiWorkspace child;
            block10: {
                block9: {
                    this.setCursor(Cursor.getPredefinedCursor(3));
                    if (this.managerInfoTable.getRowCount() > 0) {
                        this.managerInfoTable.deleteCells();
                        this.headerModel.clearAll();
                    }
                    if (wkspName != null && WorkspaceInfoJDialog.this._wksp != null) break block9;
                    this.setCursor(Cursor.getDefaultCursor());
                    return;
                }
                child = wkspName.equals("Main") ? WorkspaceInfoJDialog.this._wksp : WorkspaceInfoJDialog.this._wksp.getChildWorkspace(wkspName);
                if (child != null) break block10;
                this.setCursor(Cursor.getDefaultCursor());
                return;
            }
            try {
                try {
                    ManagerProxyList list = child.getManagers();
                    Date dt = new Date();
                    for (int i = 0; i < list.size(); ++i) {
                        ManagerProxy proxy = (ManagerProxy)list.get(i);
                        if (proxy == null) continue;
                        Vector<String> row = new Vector<String>(5);
                        Vector<String> headerRow = new Vector<String>(1);
                        headerRow.add(proxy.getName());
                        this.headerModel.addRow(headerRow);
                        row.add(proxy.getDescription());
                        row.add(proxy.getId().getPath());
                        row.add(proxy.getClassName());
                        row.add(String.valueOf(proxy.getIndex()));
                        dt.setTime(proxy.getLastModifiedTime());
                        row.add(dt.toString().substring(4));
                        this.managerInfoTable.appendRow(row);
                    }
                }
                catch (RemoteException re) {
                    System.out.println("Error getting child workspace " + wkspName + " Error:" + re);
                }
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                this.setCursor(Cursor.getDefaultCursor());
            }
        }
    }
}

