/*
 * Decompiled with CFR 0.152.
 */
package hec.clientapp.script;

import hec.appInterface.AppDaddy;
import hec.clientapp.client.ObjectChooser;
import hec.clientapp.client.RemoteFileChooser;
import hec.clientapp.script.ScriptManagerImpl;
import hec.event.ConfigChangeListener;
import hec.event.ConfigFileChangeEvent;
import hec.event.ScriptEvent;
import hec.event.ScriptEventListener;
import hec.io.Identifier;
import hec.lang.ClientAppCheck;
import hec.script.LineNumberPanel;
import hec.script.Script;
import hec.script.ScriptConstants;
import hec.script.ScriptEngine;
import hec.script.ScriptGroup;
import hec.script.ScriptIdentifier;
import hec.script.ScriptIdentifierData;
import hec.script.ScriptIdentifierSelection;
import hec.script.ScriptManager;
import hec.script.ScriptableObject;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.print.PrinterException;
import java.beans.PropertyChangeEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ComboBoxModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.EventListenerList;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.plaf.basic.BasicTextAreaUI;
import javax.swing.text.BadLocationException;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rtextarea.Gutter;
import org.fife.ui.rtextarea.RTextArea;
import org.fife.ui.rtextarea.RTextScrollPane;
import org.fife.ui.rtextarea.SearchContext;
import org.fife.ui.rtextarea.SearchEngine;
import org.fife.ui.rtextarea.SearchResult;
import rma.lang.Modifiable;
import rma.swing.ButtonCmdPanel;
import rma.swing.ButtonCmdPanelListener;
import rma.swing.EditableComponent;
import rma.swing.FindDialog;
import rma.swing.FindListener;
import rma.swing.FontChooser;
import rma.swing.FormManagementListener;
import rma.swing.InsertDlg;
import rma.swing.RmaColor;
import rma.swing.RmaImage;
import rma.swing.RmaInsets;
import rma.swing.RmaJCheckBox;
import rma.swing.RmaJColorButton;
import rma.swing.RmaJComboBox;
import rma.swing.RmaJFrame;
import rma.swing.RmaJTextArea;
import rma.swing.RmaJTextField;
import rma.swing.event.InsertModeChangedListener;
import rma.swing.event.ReflectMultiListener;
import rma.swing.list.ImageFileCellRenderer;
import rma.swing.list.RmaListModel;
import rma.swing.text.ToggleInsertDocument;
import rma.util.RMAIO;
import rma.util.RMAUtil;
import rma.util.logging.MarkingClassLogger;
import rma.util.logging.marking.ScriptingLoggingMarker;

public abstract class AbstractScriptEditor
extends RmaJFrame
implements ScriptConstants,
ConfigChangeListener,
ClipboardOwner {
    private static final MarkingClassLogger SCRIPTING_LOGGER = MarkingClassLogger.forMarkingClass(ScriptingLoggingMarker.class);
    protected static Vector _iconList;
    protected static final String NO_ICON = "-None-";
    protected static final String FONT_PROP = "scriptEditor.font";
    protected static final String BACKGROUND_PROP = "scriptEditor.background";
    protected static final String FOREGROUND_PROP = "scriptEditor.foreground";
    protected static final String SIZE_PROP = "scriptEditor.size";
    protected static final String LOCATION_PROP = "scriptEditor.position";
    protected static final String TABSIZE_PROP = "scriptEditor.tabsize";
    protected LineNumberPanel _lnPanel = null;
    protected JTree tree;
    protected RmaJTextField _scriptNameText;
    protected RmaJTextField _fileNameText;
    protected RmaJTextField _argumentText;
    protected RmaJTextArea _descriptionText;
    protected ScriptTextArea _scriptText;
    protected JSplitPane _hSplitter;
    protected RmaJCheckBox _displayScript;
    protected RmaJCheckBox _displayScriptInMenu;
    protected RmaJCheckBox _displayScriptInSelector;
    protected RmaJTextField _labelDisplayText;
    protected JButton _browseButton;
    protected JPopupMenu _nodePopup = null;
    protected JPopupMenu _folderPopup = null;
    protected JMenu _fileMenu = null;
    protected JMenuItem _newMenuItem;
    protected JMenuItem _editMenuItem;
    protected JMenuItem _importMenuItem;
    protected JMenuItem _saveMenuItem;
    protected JMenuItem _saveAsMenuItem;
    protected JMenuItem _deleteMenuItem;
    protected JMenuItem _testMenuItem;
    protected JMenuItem _cutScriptMenuItem;
    protected JMenuItem _copyScriptMenuItem;
    protected JMenuItem _pasteScriptMenuItem;
    protected JMenuItem _findMenuItem;
    protected JMenuItem _findNextMenuItem;
    protected RemoteFileChooser _browseDialog = null;
    protected TreeSelectionListener _treeSelectListener;
    protected RmaJTextField _statusLine;
    protected RmaJTextField _modifiedField;
    protected RmaJTextField _lockedField;
    protected RmaJTextField _insertField;
    protected RmaJTextField _positionField;
    protected RmaJComboBox _iconCombo;
    protected JPanel _buttonPanel;
    protected ButtonCmdPanel _testPanel;
    protected ButtonCmdPanel _okPanel;
    protected JButton _editButton;
    protected JButton _editExternalButton;
    protected JButton _saveButton;
    protected JButton _testButton;
    protected FindDialog _findDlg;
    protected boolean _editingExistingScript = false;
    protected boolean _editScript = false;
    protected boolean _resetingPath = false;
    protected String _lockedPath = null;
    protected boolean _scriptModified = false;
    protected int _splitterLocation = 200;
    protected boolean _overrodeScriptFile = false;
    protected EventListenerList _listenerList = new EventListenerList();
    private JCheckBoxMenuItem _showWhitespaceMenuItem;
    private JMenuItem _printMenuItem;
    private JMenuItem _undoMenuItem;
    private JMenuItem _redoMenuItem;
    private JMenuItem _cutMenuItem;
    private JMenuItem _copyMenuItem;
    private JMenuItem _pasteMenuItem;
    protected JPanel _namePanel;
    protected RmaJColorButton _bgColorBtn;
    protected RmaJComboBox _groupCombo;
    protected JLabel _groupLabel;
    protected JMenuItem _newGroupMenu;
    protected JMenuItem _deleteGroupMenu;
    private Vector<ScriptGroup> _groupList = new Vector();

    public AbstractScriptEditor(Frame parent, boolean modal) {
        this.setTitle("Script Editor");
        this.buildMenus();
        this.buildDialog(parent);
    }

    protected JTree createJTree() {
        return new JTree(new ScriptTreeModel(ClientAppCheck.haveClientApp())){

            @Override
            public String getToolTipText(MouseEvent e) {
                TreePath path = AbstractScriptEditor.this.tree.getPathForLocation(e.getX(), e.getY());
                if (path == null) {
                    return null;
                }
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
                if (node instanceof FolderNode) {
                    return AbstractScriptEditor.this.getScriptManager().getPathFromTreePath(AbstractScriptEditor.this.getModulePath(path));
                }
                if (node.getUserObject() instanceof ScriptIdentifier) {
                    return ((ScriptIdentifier)node.getUserObject()).getHtmlDescription();
                }
                return null;
            }

            @Override
            public Dimension getPreferredScrollableViewportSize() {
                Dimension d = super.getPreferredScrollableViewportSize();
                d.width = 200;
                d.height = 400;
                return d;
            }
        };
    }

    protected void buildDialog(Frame parent) {
        int iy;
        Insets insets = new Insets(5, 5, 0, 0);
        this.getContentPane().setLayout(new GridBagLayout());
        if (_iconList == null || _iconList.size() < 1) {
            _iconList = this.createImageList();
        }
        this.tree = this.createJTree();
        this.tree.setToolTipText("");
        JScrollPane treeSp = new JScrollPane(this.tree);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridheight = 4;
        gbc.insets = insets;
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        JPanel topPanel = new JPanel(new GridBagLayout());
        this._namePanel = new JPanel(new GridBagLayout());
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.insets = new Insets(0, 0, 0, 2);
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        topPanel.add((Component)this._namePanel, gbc);
        JLabel label = new JLabel("Label:");
        label.setDisplayedMnemonic('L');
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.insets = new Insets(8, 5, 0, 0);
        gbc.anchor = 18;
        gbc.fill = 0;
        this._namePanel.add((Component)label, gbc);
        this._labelDisplayText = new RmaJTextField("");
        this._labelDisplayText.setColumns(20);
        this._labelDisplayText.setDisabledTextColor(Color.black);
        this._labelDisplayText.setToolTipText("The label that is displayed to the user");
        label.setLabelFor((Component)this._labelDisplayText);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.insets = insets;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        this._namePanel.add((Component)this._labelDisplayText, gbc);
        Dimension d = this._labelDisplayText.getPreferredSize();
        this._labelDisplayText.setMinimumSize(d);
        this._bgColorBtn = new RmaJColorButton();
        this._bgColorBtn.setToolTipText("Background Color for Script Button");
        this._bgColorBtn.setVisible(false);
        gbc.gridx = 2;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.INSETS5505;
        this._namePanel.add((Component)this._bgColorBtn, gbc);
        this._groupLabel = new JLabel("Script Set:");
        this._groupLabel.setVisible(false);
        gbc.gridx = 3;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.INSETS5505;
        this._namePanel.add((Component)this._groupLabel, gbc);
        this._groupCombo = new RmaJComboBox();
        this._groupCombo.setVisible(false);
        label.setLabelFor((Component)this._groupCombo);
        gbc.gridx = 4;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.INSETS5505;
        this._namePanel.add((Component)this._groupCombo, gbc);
        this._scriptNameText = new RmaJTextField("");
        this._scriptNameText.setDisabledTextColor(Color.black);
        gbc = new GridBagConstraints();
        gbc.gridx = 3;
        gbc.gridy = 0;
        gbc.ipadx = 60;
        gbc.insets = insets;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        JPanel selectPanel = new JPanel(new GridBagLayout());
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.insets = new Insets(0, 0, 0, 2);
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.weightx = 1.0;
        topPanel.add((Component)selectPanel, gbc);
        this._displayScriptInMenu = new RmaJCheckBox("Show in Scripts Menu");
        this._displayScriptInMenu.setToolTipText("Activates the script menu and adds this script to that menu");
        this._displayScriptInMenu.setVisible(false);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.insets = new Insets(2, 5, 0, 0);
        gbc.anchor = 18;
        gbc.fill = 0;
        selectPanel.add((Component)this._displayScriptInMenu, gbc);
        this._displayScriptInSelector = new RmaJCheckBox("Show in Script Selector");
        this._displayScriptInSelector.setToolTipText("Whether the script is displayed in the Script Selector");
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.insets = new Insets(2, 10, 0, 0);
        gbc.anchor = 18;
        gbc.fill = 0;
        selectPanel.add((Component)this._displayScriptInSelector, gbc);
        this._displayScript = new RmaJCheckBox("Display Script to User");
        this._displayScript.setToolTipText("Whether the script is displayed to the user");
        this._displayScript.setMnemonic('D');
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 0;
        gbc.insets = new Insets(2, 10, 0, 0);
        gbc.anchor = 18;
        gbc.fill = 0;
        selectPanel.add((Component)this._displayScript, gbc);
        JPanel fileNamePanel = new JPanel(new GridBagLayout());
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.gridwidth = 3;
        gbc.insets = new Insets(0, 0, 0, 2);
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        topPanel.add((Component)fileNamePanel, gbc);
        label = new JLabel("Script:");
        label.setDisplayedMnemonic('S');
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.insets = insets;
        gbc.anchor = 18;
        gbc.fill = 0;
        fileNamePanel.add((Component)label, gbc);
        this._fileNameText = new RmaJTextField("");
        this._fileNameText.setToolTipText("The location that the script resides on the disk");
        label.setLabelFor((Component)this._fileNameText);
        this._fileNameText.setEditable(false);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.insets = insets;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        fileNamePanel.add((Component)this._fileNameText, gbc);
        this._browseButton = new JButton("..."){

            @Override
            public Dimension getPreferredSize() {
                Dimension dim = super.getPreferredSize();
                dim.height = AbstractScriptEditor.this._fileNameText.getPreferredSize().height;
                return dim;
            }
        };
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 0;
        gbc.insets = insets;
        gbc.anchor = 18;
        gbc.fill = 0;
        fileNamePanel.add((Component)this._browseButton, gbc);
        JPanel iconPanel = new JPanel(new GridBagLayout());
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.gridwidth = 3;
        gbc.insets = new Insets(0, 0, 0, 2);
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        topPanel.add((Component)iconPanel, gbc);
        label = new JLabel("Icon:");
        label.setDisplayedMnemonic('I');
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.insets = new Insets(18, 6, 0, 0);
        gbc.anchor = 18;
        gbc.fill = 0;
        iconPanel.add((Component)label, gbc);
        this._iconCombo = new RmaJComboBox((ComboBoxModel)new RmaListModel(true, (Collection)_iconList));
        this._iconCombo.setRenderer((ListCellRenderer)new ImageFileCellRenderer((JComboBox)this._iconCombo));
        this._iconCombo.setEnabled(false);
        this._iconCombo.setToolTipText("The Icon displayed for this script on its button");
        Dimension size = this._iconCombo.getPreferredSize();
        size.setSize(size.getWidth(), 30.0);
        this._iconCombo.setPreferredSize(size);
        label.setLabelFor((Component)this._iconCombo);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.insets = new Insets(10, 13, 5, 5);
        gbc.anchor = 18;
        gbc.fill = 0;
        iconPanel.add((Component)this._iconCombo, gbc);
        label = new JLabel("Test Arguments:");
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        gbc.insets = new Insets(18, 10, 0, 5);
        gbc.anchor = 18;
        gbc.fill = 0;
        iconPanel.add((Component)label, gbc);
        this._argumentText = new RmaJTextField("");
        label.setLabelFor((Component)this._argumentText);
        this._argumentText.setEditable(true);
        gbc = new GridBagConstraints();
        gbc.gridx = 3;
        gbc.gridy = 0;
        gbc.insets = new Insets(16, 5, 0, 0);
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        iconPanel.add((Component)this._argumentText, gbc);
        label = new JLabel("Description:");
        label.setDisplayedMnemonic('D');
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 4;
        gbc.insets = insets;
        gbc.anchor = 18;
        gbc.fill = 0;
        topPanel.add((Component)label, gbc);
        this._descriptionText = new RmaJTextArea(4, 40);
        this._descriptionText.setToolTipText("<html>The script's description.<br>Also used for the ToolTip on this script's button</html>");
        label.setLabelFor((Component)this._descriptionText);
        this._descriptionText.setDisabledTextColor(Color.black);
        JScrollPane scrollPane = new JScrollPane((Component)this._descriptionText);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 5;
        gbc.gridwidth = 4;
        gbc.insets = insets;
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        topPanel.add((Component)scrollPane, gbc);
        JPanel bottomPanel = new JPanel(new GridBagLayout());
        this._scriptText = new ScriptTextArea(9, 40);
        this._scriptText.setDisabledTextColor(Color.black);
        this._scriptText.setToolTipText("The script text");
        scrollPane = new JScrollPane((Component)((Object)this._scriptText));
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridwidth = 4;
        gbc.insets = insets;
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        RTextScrollPane sp = new RTextScrollPane((RTextArea)this._scriptText, true);
        Gutter gutter = sp.getGutter();
        gutter.setBookmarkingEnabled(true);
        ImageIcon icon = RmaImage.getImageIcon((String)"Images/bookmark.gif");
        if (icon != null) {
            gutter.setBookmarkIcon((Icon)icon);
        } else {
            System.out.println("buildDialog:failed to find icon for bookmarks!");
        }
        bottomPanel.add((Component)sp, gbc);
        JSplitPane vSplitter = new JSplitPane(0, topPanel, bottomPanel);
        vSplitter.setBorder(null);
        this._hSplitter = new JSplitPane(1, treeSp, vSplitter);
        this._hSplitter.setDividerLocation(1.0);
        this._hSplitter.setBorder(null);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.insets = new Insets(5, 5, 5, 5);
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        this.getContentPane().add((Component)this._hSplitter, gbc);
        Rectangle bounds = parent.getBounds();
        Rectangle abounds = this.getBounds();
        int ix = bounds.x + (bounds.width - abounds.width) / 2;
        if (ix < 10) {
            ix = 10;
        }
        if ((iy = bounds.y + (bounds.height - abounds.height) / 2) < 10) {
            iy = 10;
        }
        this.setLocation(ix, iy);
        this._buttonPanel = new JPanel();
        this._buttonPanel.setLayout(new GridBagLayout());
        gbc = new GridBagConstraints();
        gbc.gridwidth = 0;
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridwidth = 0;
        gbc.anchor = 14;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this._buttonPanel, gbc);
        String externalEditor = System.getProperty("ScriptEditorExe");
        int buttonOpts = 14;
        if (externalEditor != null) {
            buttonOpts |= 0x100;
        }
        this._testPanel = new ButtonCmdPanel(buttonOpts);
        this._editButton = this._testPanel.getButton(8);
        this._editButton.setText("Edit");
        this._editExternalButton = this._testPanel.getButton(256);
        if (this._editExternalButton != null) {
            this._editExternalButton.setText("Launch Editor");
        }
        this._saveButton = this._testPanel.getButton(2);
        this._saveButton.setText("Save");
        this._testButton = this._testPanel.getButton(4);
        this._testButton.setText("Save and Test");
        gbc = new GridBagConstraints();
        gbc.weightx = 0.0;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 17;
        this._buttonPanel.add((Component)this._testPanel, gbc);
        this._testPanel.addCmdPanelListener(new ButtonCmdPanelListener(){

            public void buttonCmdActionPerformed(ActionEvent e) {
                switch (e.getID()) {
                    case 8: {
                        AbstractScriptEditor.this.editScript(AbstractScriptEditor.this.tree.getSelectionPath());
                        break;
                    }
                    case 256: {
                        AbstractScriptEditor.this.launchExternalEditor(AbstractScriptEditor.this.tree.getSelectionPath());
                        break;
                    }
                    case 2: {
                        AbstractScriptEditor.this.saveScript();
                        break;
                    }
                    case 4: {
                        AbstractScriptEditor.this.saveScript();
                        AbstractScriptEditor.this.testScript();
                    }
                }
            }
        });
        this._okPanel = new ButtonCmdPanel(12);
        gbc = new GridBagConstraints();
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.anchor = 16;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        this._buttonPanel.add((Component)this._okPanel, gbc);
        this._okPanel.addCmdPanelListener(new ButtonCmdPanelListener(){

            public void buttonCmdActionPerformed(ActionEvent event) {
                switch (event.getID()) {
                    case 8: {
                        if (AbstractScriptEditor.this._saveButton.isEnabled()) {
                            AbstractScriptEditor.this.saveScript();
                        }
                        AbstractScriptEditor.this.closeFrame();
                        break;
                    }
                    case 4: {
                        AbstractScriptEditor.this.closeFrame();
                    }
                }
            }
        });
        JPanel statusPanel = new JPanel(new GridBagLayout());
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.insets = new Insets(0, 5, 2, 5);
        gbc.anchor = 16;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        this.getContentPane().add((Component)statusPanel, gbc);
        this._statusLine = new RmaJTextField();
        this._statusLine.setEditable(false);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 2;
        gbc.insets = new Insets(0, 0, 0, 0);
        gbc.anchor = 16;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        statusPanel.add((Component)this._statusLine, gbc);
        this._modifiedField = new RmaJTextField();
        this._modifiedField.setEditable(false);
        gbc = new GridBagConstraints();
        gbc.gridx = 3;
        gbc.gridy = 0;
        gbc.insets = new Insets(0, 0, 0, 0);
        gbc.anchor = 16;
        gbc.fill = 2;
        gbc.weightx = 0.25;
        statusPanel.add((Component)this._modifiedField, gbc);
        this._positionField = new RmaJTextField();
        this._positionField.setHorizontalAlignment(0);
        this._positionField.setEditable(false);
        gbc = new GridBagConstraints();
        gbc.gridx = 4;
        gbc.gridy = 0;
        gbc.insets = new Insets(0, 0, 0, 0);
        gbc.anchor = 16;
        gbc.fill = 2;
        gbc.weightx = 0.2;
        statusPanel.add((Component)this._positionField, gbc);
        this._lockedField = new RmaJTextField();
        this._lockedField.setEditable(false);
        gbc = new GridBagConstraints();
        gbc.gridx = 5;
        gbc.gridy = 0;
        gbc.insets = new Insets(0, 0, 0, 0);
        gbc.anchor = 16;
        gbc.fill = 2;
        gbc.weightx = 0.25;
        statusPanel.add((Component)this._lockedField, gbc);
        this._insertField = new RmaJTextField("Insert");
        this._insertField.setHorizontalAlignment(0);
        this._insertField.setEditable(false);
        gbc = new GridBagConstraints();
        gbc.gridx = 6;
        gbc.gridy = 0;
        gbc.insets = new Insets(0, 0, 0, 0);
        gbc.anchor = 16;
        gbc.fill = 2;
        gbc.weightx = 0.25;
        statusPanel.add((Component)this._insertField, gbc);
        this.fillFolderNodes();
        this.setSize(this.getPreferredSize());
        ActionListener expandAl = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractScriptEditor.this.expandTree(true);
            }
        };
        ActionListener colapseAl = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractScriptEditor.this.expandTree(false);
            }
        };
        this.tree.registerKeyboardAction(expandAl, KeyStroke.getKeyStroke(107, 0, true), 1);
        this.tree.registerKeyboardAction(expandAl, KeyStroke.getKeyStroke(521, 1, true), 1);
        this.tree.registerKeyboardAction(colapseAl, KeyStroke.getKeyStroke(45, 0, true), 1);
        this.tree.registerKeyboardAction(colapseAl, KeyStroke.getKeyStroke(109, 0, true), 1);
        this.tree.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractScriptEditor.this.refreshTree();
            }
        }, KeyStroke.getKeyStroke(116, 0, true), 1);
        this.tree.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractScriptEditor.this.copyTreeNode();
            }
        }, KeyStroke.getKeyStroke(67, 2, true), 1);
        this.tree.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractScriptEditor.this.pasteTreeNode();
            }
        }, KeyStroke.getKeyStroke(86, 2, true), 1);
        this.tree.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractScriptEditor.this.cutTreeNode();
            }
        }, KeyStroke.getKeyStroke(88, 2, true), 1);
        DocumentListener dl = new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                AbstractScriptEditor.this._scriptModified = true;
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                AbstractScriptEditor.this._scriptModified = true;
            }
        };
        this._labelDisplayText.getDocument().addDocumentListener(dl);
        this._labelDisplayText.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                AbstractScriptEditor.this._scriptNameText.setText(AbstractScriptEditor.this._labelDisplayText.getText());
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                AbstractScriptEditor.this._scriptNameText.setText(AbstractScriptEditor.this._labelDisplayText.getText());
            }
        });
        this._fileNameText.getDocument().addDocumentListener(dl);
        this._descriptionText.getDocument().addDocumentListener(dl);
        this._scriptText.getDocument().addDocumentListener(dl);
        this._labelDisplayText.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
            }

            @Override
            public void focusLost(FocusEvent e) {
                AbstractScriptEditor.this.updateFileName();
            }
        });
        this.tree.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
            }

            @Override
            public void focusLost(FocusEvent e) {
                AbstractScriptEditor.this.updateFileName();
            }
        });
        this.tree.addTreeExpansionListener(new TreeExpansionListener(){

            @Override
            public void treeCollapsed(TreeExpansionEvent event) {
            }

            @Override
            public void treeExpanded(TreeExpansionEvent event) {
                TreePath path = event.getPath();
                AbstractScriptEditor.this.getScriptIds(path);
            }
        });
        this.tree.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() >= 2 && SwingUtilities.isLeftMouseButton(e)) {
                    TreePath path = AbstractScriptEditor.this.tree.getPathForLocation(e.getX(), e.getY());
                    if (path == null) {
                        return;
                    }
                    AbstractScriptEditor.this.editScript(path);
                } else if (e.getClickCount() == 1 && (SwingUtilities.isRightMouseButton(e) || e.isPopupTrigger())) {
                    TreePath path = AbstractScriptEditor.this.tree.getPathForLocation(e.getX(), e.getY());
                    if (path == null) {
                        return;
                    }
                    AbstractScriptEditor.this.tree.setSelectionPath(path);
                    TreeNode node = (TreeNode)path.getLastPathComponent();
                    if (!AbstractScriptEditor.this.isScriptableNode(node.toString())) {
                        return;
                    }
                    if (node instanceof FolderNode) {
                        AbstractScriptEditor.this.displayFolderPopup(e, node.toString());
                    } else if (node instanceof DefaultMutableTreeNode) {
                        AbstractScriptEditor.this.displayNodePopup(e, node.toString());
                    }
                }
            }
        });
        this._treeSelectListener = new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent event) {
                int opt;
                TreePath path = event.getPath();
                TreeNode node = (TreeNode)path.getLastPathComponent();
                if (AbstractScriptEditor.this._editScript && !AbstractScriptEditor.this._resetingPath && AbstractScriptEditor.this._scriptModified && (opt = JOptionPane.showConfirmDialog((Component)((Object)AbstractScriptEditor.this), "Changes will be lost to new Script.\nContinue?", "Confirm selection", 0)) == 1) {
                    AbstractScriptEditor.this._resetingPath = true;
                    AbstractScriptEditor.this.tree.setSelectionPath(event.getOldLeadSelectionPath());
                    return;
                }
                if (!AbstractScriptEditor.this._resetingPath) {
                    path = event.getNewLeadSelectionPath();
                    if (path == null) {
                        AbstractScriptEditor.this.setEditScript(false);
                        AbstractScriptEditor.this.clearForm();
                        AbstractScriptEditor.this.setEditPanelEnabled(false);
                        AbstractScriptEditor.this.setMenusState(true);
                        return;
                    }
                    AbstractScriptEditor.this.setEditScript(false);
                    String thepath = path.toString();
                    thepath = thepath.substring(1, thepath.length() - 1);
                    thepath = RMAIO.replace((String)thepath, (String)", ", (String)"/");
                    AbstractScriptEditor.this._statusLine.setText(thepath);
                    if (!node.isLeaf()) {
                        AbstractScriptEditor.this.clearForm();
                        AbstractScriptEditor.this.setEditPanelEnabled(false);
                        AbstractScriptEditor.this.setMenusState(true);
                        boolean scriptable = AbstractScriptEditor.this.isScriptableNode(node.toString());
                        AbstractScriptEditor.this._newMenuItem.setEnabled(scriptable);
                        AbstractScriptEditor.this._importMenuItem.setEnabled(scriptable);
                        return;
                    }
                    AbstractScriptEditor.this.setMenusState(false);
                    AbstractScriptEditor.this.setEditPanelEnabled(false);
                    AbstractScriptEditor.this.loadScript(path);
                }
                AbstractScriptEditor.this._resetingPath = false;
            }
        };
        this.tree.addTreeSelectionListener(this._treeSelectListener);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent we) {
            }

            @Override
            public void windowOpened(WindowEvent we) {
                AbstractScriptEditor.this._hSplitter.setDividerLocation(200);
            }
        });
        this._browseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractScriptEditor.this.selectScript(AbstractScriptEditor.this.tree.getSelectionPath());
            }
        });
        this._groupList.add(0, new ScriptGroup("", ""));
        this.getScriptManager().addConfigChangeListener((ConfigChangeListener)this);
        this.pack();
        this.setMinimumSize(this.getPreferredSize());
        this.setLocation();
    }

    protected void redrawLineNumbers() {
        if (this._lnPanel != null) {
            this._lnPanel.repaint(this._lnPanel.getBounds());
        }
    }

    protected static Color getSelectionMarginColor() {
        return new Color(244, 244, 244);
    }

    public void flushScriptManager() {
    }

    protected void buildMenus() {
        JMenuBar menuBar = new JMenuBar();
        this._fileMenu = new JMenu("File");
        this._fileMenu.setMnemonic('f');
        this._newMenuItem = new JMenuItem("New", 110);
        this._newMenuItem.setAccelerator(KeyStroke.getKeyStroke(78, 2, false));
        this._fileMenu.add(this._newMenuItem);
        this._newMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractScriptEditor.this.newScript();
            }
        });
        this._editMenuItem = new JMenuItem("Open/Edit", 111);
        this._editMenuItem.setAccelerator(KeyStroke.getKeyStroke(79, 2, false));
        this._fileMenu.add(this._editMenuItem);
        this._editMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractScriptEditor.this.editScript(AbstractScriptEditor.this.tree.getSelectionPath());
            }
        });
        this._importMenuItem = new JMenuItem("Import", 73);
        this._fileMenu.add(this._importMenuItem);
        this._importMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractScriptEditor.this.importScript();
            }
        });
        this._saveMenuItem = new JMenuItem("Save", 115);
        this._saveMenuItem.setAccelerator(KeyStroke.getKeyStroke(83, 2, false));
        this._fileMenu.add(this._saveMenuItem);
        this._saveMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractScriptEditor.this.saveScript();
            }
        });
        this._saveAsMenuItem = new JMenuItem("Save As", 97);
        this._fileMenu.add(this._saveAsMenuItem);
        this._saveAsMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractScriptEditor.this.saveScriptAs();
            }
        });
        this._deleteMenuItem = new JMenuItem("Delete", 100);
        this._deleteMenuItem.setAccelerator(KeyStroke.getKeyStroke("DELETE"));
        this._fileMenu.add(this._deleteMenuItem);
        this._deleteMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractScriptEditor.this.deleteScript(true);
            }
        });
        this._fileMenu.addSeparator();
        this._printMenuItem = new JMenuItem("Print", 112);
        this._printMenuItem.setAccelerator(KeyStroke.getKeyStroke(80, 2, false));
        this._fileMenu.add(this._printMenuItem);
        this._printMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractScriptEditor.this.printScript();
            }
        });
        this._fileMenu.addSeparator();
        this._testMenuItem = new JMenuItem("Test", 116);
        this._fileMenu.add(this._testMenuItem);
        this._testMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractScriptEditor.this.testScript();
            }
        });
        this._fileMenu.addSeparator();
        JMenuItem menuItem = new JMenuItem("Close", 99);
        this._fileMenu.add(menuItem);
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractScriptEditor.this.closeFrame();
            }
        });
        menuBar.add(this._fileMenu);
        JMenu menu = new JMenu("Edit");
        this._undoMenuItem = new JMenuItem("Undo", 85);
        menu.add(this._undoMenuItem);
        this._redoMenuItem = new JMenuItem("Redo", 82);
        menu.add(this._redoMenuItem);
        menu.addSeparator();
        this._cutMenuItem = new JMenuItem("Cut", 116);
        this._cutMenuItem.setAccelerator(KeyStroke.getKeyStroke(88, 2, false));
        menu.add(this._cutMenuItem);
        this._copyMenuItem = new JMenuItem("Copy", 67);
        this._copyMenuItem.setAccelerator(KeyStroke.getKeyStroke(67, 2, false));
        menu.add(this._copyMenuItem);
        this._pasteMenuItem = new JMenuItem("Paste", 80);
        this._pasteMenuItem.setAccelerator(KeyStroke.getKeyStroke(86, 2, false));
        menu.add(this._pasteMenuItem);
        menu.addSeparator();
        this._findMenuItem = new JMenuItem("Find...", 70);
        this._findMenuItem.setAccelerator(KeyStroke.getKeyStroke(70, 2, false));
        menu.add(this._findMenuItem);
        this._findMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractScriptEditor.this._scriptText.displayFindDialog();
            }
        });
        this._findNextMenuItem = new JMenuItem("Find Next", 78);
        this._findNextMenuItem.setAccelerator(KeyStroke.getKeyStroke(114, 0, false));
        menu.add(this._findNextMenuItem);
        this._findNextMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractScriptEditor.this._scriptText.searchNext();
            }
        });
        menu.addSeparator();
        this._cutScriptMenuItem = new JMenuItem("Cut Script", 116);
        menu.add(this._cutScriptMenuItem);
        this._cutScriptMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractScriptEditor.this.cutTreeNode();
            }
        });
        this._copyScriptMenuItem = new JMenuItem("Copy Script", 99);
        menu.add(this._copyScriptMenuItem);
        this._copyScriptMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractScriptEditor.this.copyTreeNode();
            }
        });
        this._pasteScriptMenuItem = new JMenuItem("Paste Script", 112);
        menu.add(this._pasteScriptMenuItem);
        this._pasteScriptMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractScriptEditor.this.pasteTreeNode();
            }
        });
        this._newGroupMenu = new JMenuItem("New Script Set", 83);
        this._newGroupMenu.setVisible(false);
        menu.add(this._newGroupMenu);
        this._newGroupMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractScriptEditor.this.newGroupAction();
            }
        });
        this._deleteGroupMenu = new JMenuItem("Delete Script Set", 101);
        this._deleteGroupMenu.setVisible(false);
        menu.add(this._deleteGroupMenu);
        this._deleteGroupMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractScriptEditor.this.deleteGroupAction();
            }
        });
        menuBar.add(menu);
        menu = new JMenu("Options");
        menu.setMnemonic('0');
        menuItem = new JMenuItem("Set Font", 70);
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractScriptEditor.this.selectFont();
            }
        });
        menuItem = new JMenuItem("Set Tab Size", 84);
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractScriptEditor.this.setTabSize();
            }
        });
        menu.add(menuItem);
        this._showWhitespaceMenuItem = new JCheckBoxMenuItem("Show Whitespace");
        this._showWhitespaceMenuItem.setMnemonic('W');
        this._showWhitespaceMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractScriptEditor.this.showWhiteSpaceAction();
            }
        });
        menu.add(this._showWhitespaceMenuItem);
        menuBar.add(menu);
        this.setJMenuBar(menuBar);
    }

    protected void deleteGroupAction() {
        ObjectChooser chooser = new ObjectChooser((Frame)((Object)this), true, 2, 5L);
        chooser.setTitle("Delete Script Set");
        Vector groupList = (Vector)this._groupList.clone();
        groupList.remove(0);
        chooser.setObjectList(groupList);
        chooser.setVisible(true);
        ScriptGroup group2Delete = (ScriptGroup)chooser.getSelectedObject();
        if (group2Delete == null) {
            return;
        }
        this._groupList.remove(group2Delete);
        this._groupCombo.setModel((ComboBoxModel)new RmaListModel(true, this._groupList));
        this._groupCombo.setSelectedIndex(-1);
        this.removeScriptsFromGroup(group2Delete);
        this.fireScriptEvent(null, 4);
    }

    protected void removeScriptsFromGroup(ScriptGroup group2Delete) {
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.tree.getModel().getRoot();
        Enumeration<TreeNode> bfenum = root.breadthFirstEnumeration();
        HashSet groupNames = new HashSet();
        while (bfenum.hasMoreElements()) {
            TreeNode next = bfenum.nextElement();
            if (!(next instanceof FolderNode)) continue;
            FolderNode folder = (FolderNode)next;
            this.removeScriptsFromGroup(group2Delete, folder);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeScriptsFromGroup(ScriptGroup group2Delete, FolderNode folder) {
        int cnt = folder.getChildCount();
        String groupName = group2Delete.getName();
        for (int i = 0; i < cnt; ++i) {
            TreeNode child = folder.getChildAt(i);
            if (child instanceof FolderNode) {
                this.removeScriptsFromGroup(group2Delete, (FolderNode)child);
                continue;
            }
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)child;
            ScriptIdentifier sid = (ScriptIdentifier)node.getUserObject();
            if (!groupName.equals(sid.getGroupName())) continue;
            sid.setGroupName(null);
            sid.setModified(true);
            Script script = this.getScriptManager().getScript(sid);
            if (script == null) continue;
            BufferedReader reader = new BufferedReader(new StringReader(script.getScript()));
            StringBuilder builder = new StringBuilder();
            try {
                String line;
                while ((line = reader.readLine()) != null) {
                    String tmpline;
                    String type;
                    if (line.startsWith("#") && "group".equalsIgnoreCase(type = RMAIO.getType((String)(tmpline = line.substring(1)), (String)"="))) continue;
                    builder.append(line);
                    builder.append("\n");
                }
            }
            catch (IOException iOException) {
            }
            finally {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
            script.setScript(builder.toString());
            this.getScriptManager().saveScript(sid, script);
        }
    }

    protected void newGroupAction() {
        ObjectChooser chooser = new ObjectChooser((Frame)((Object)this), true, 3, 5L);
        chooser.setTitle("New Script Set");
        Vector groupList = (Vector)this._groupList.clone();
        groupList.remove(0);
        chooser.setObjectList(groupList);
        chooser.setVisible(true);
        Identifier id = (Identifier)chooser.getSelectedObject();
        if (id == null) {
            return;
        }
        ScriptGroup sg = new ScriptGroup(id.getName(), id.getDescription());
        this._groupList.add(sg);
        this._groupCombo.setModel((ComboBoxModel)new RmaListModel(true, this._groupList));
        this._groupCombo.setSelectedItem((Object)sg);
    }

    protected void showWhiteSpaceAction() {
        this._scriptText.setWhitespaceVisible(this._showWhitespaceMenuItem.isSelected());
        this._scriptText.repaint();
    }

    protected void editScript(TreePath path) {
        if (path == null) {
            return;
        }
        TreeNode node = (TreeNode)path.getLastPathComponent();
        if (node instanceof FolderNode) {
            this.setEditScript(false);
            return;
        }
        this.treePathSelected(path, null, true);
        if (!this.setEditScript(true)) {
            this.setEditPanelEnabled(false);
        }
    }

    protected void launchExternalEditor(TreePath path) {
        if (path == null) {
            return;
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
        if (node instanceof FolderNode) {
            this.setEditScript(false);
            return;
        }
        this.treePathSelected(path, null, true);
        if (!node.isLeaf()) {
            this.clearForm();
            return;
        }
        Object obj = node.getUserObject();
        if (!(obj instanceof ScriptIdentifier)) {
            return;
        }
        ScriptIdentifier sid = (ScriptIdentifier)obj;
        if (this.launchAndWait(sid)) {
            this.loadScript(path);
        }
    }

    protected boolean launchAndWait(ScriptIdentifier sid) {
        Process proc;
        if (sid == null) {
            return false;
        }
        Identifier id = this.getScriptManager().getIdFromScriptId(sid);
        if (id == null) {
            System.out.println("launchAndWait:failed to get Identifier from " + sid);
            return false;
        }
        String externalEditor = System.getProperty("ScriptEditorExe");
        String[] cmd = new String[]{externalEditor, id.getPath()};
        try {
            proc = Runtime.getRuntime().exec(cmd);
        }
        catch (IOException e) {
            System.out.println("launchAndWait:IOException " + e);
            JOptionPane.showMessageDialog((Component)((Object)this), "Failed to launch " + externalEditor);
            return false;
        }
        try {
            proc.waitFor();
        }
        catch (InterruptedException e) {
            System.out.println("launchAndWait:InterruptedException " + e);
        }
        this.getScriptManager().reloadScript(sid);
        return true;
    }

    protected boolean newScript() {
        this.clearForm();
        TreePath tpath = this.tree.getSelectionPath();
        if (tpath == null) {
            JOptionPane.showMessageDialog((Component)((Object)this), "Please select a folder to add the script to");
            return false;
        }
        TreeNode node = (TreeNode)tpath.getLastPathComponent();
        if (!node.isLeaf()) {
            this.clearForm();
            if (this.isScriptableNode(node.toString())) {
                this._scriptText.setText("from hec.script import Plot\n#from hec.io import TimeSeriesContainer\n#from hec.io import PairedDataContainer\n#from hec.hecmath import TimeSeriesMath\n#from hec.hecmath import PairedDataMath\nfrom hec.heclib.dss import HecDss, DSSPathname\n#import java\n");
                this._scriptText.discardAllEdits();
                this.setEditPanelEnabled(true);
            } else {
                JOptionPane.showMessageDialog((Component)((Object)this), "Scripts are can not be added to " + node.toString());
                return false;
            }
        }
        return this.setEditScript(true);
    }

    protected TreeNode getLastFolderNode() {
        TreePath tpath = this.tree.getSelectionPath();
        if (tpath == null) {
            return null;
        }
        Object[] path = tpath.getPath();
        for (int i = path.length - 1; i >= 0; --i) {
            if (!((TreeNode)path[i]).getAllowsChildren()) continue;
            return (TreeNode)path[i];
        }
        return null;
    }

    protected ScriptIdentifier getSelectedScriptIdentifier() {
        TreePath tpath = this.tree.getSelectionPath();
        return this.getSelectedScriptIdentifier(tpath);
    }

    protected ScriptIdentifier getSelectedScriptIdentifier(TreePath tpath) {
        if (tpath == null) {
            return null;
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)tpath.getLastPathComponent();
        Object obj = node.getUserObject();
        if (obj instanceof ScriptIdentifier) {
            return (ScriptIdentifier)obj;
        }
        return null;
    }

    protected String getModulePath() {
        TreePath tpath = this.tree.getSelectionPath();
        return this.getModulePath(tpath);
    }

    protected String getModulePath(TreePath tpath) {
        TreeNode node;
        int cnt = tpath.getPathCount();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < cnt && (node = (TreeNode)tpath.getPathComponent(i)).getAllowsChildren(); ++i) {
            String s = tpath.getPathComponent(i).toString();
            sb.append(s);
            if (i + 1 == cnt) continue;
            sb.append("/");
        }
        if (sb.charAt(sb.length() - 1) == "/".charAt(0)) {
            sb.setLength(sb.length() - 1);
        }
        this.msgOut("se:modulePath is " + sb);
        return sb.toString();
    }

    protected String getScriptId(TreePath tpath) {
        if (tpath == null) {
            return null;
        }
        String lastPath = tpath.getLastPathComponent().toString();
        if (lastPath.equals("Scripts") || lastPath.equals("All Watersheds") || lastPath.equals("Modules") || lastPath.equals("Current Watershed") || lastPath.equals("Modules")) {
            return lastPath;
        }
        DefaultMutableTreeNode currentWorkspaceNode = ((ScriptTreeModel)this.tree.getModel()).findNode("Current Watershed");
        DefaultMutableTreeNode currentModulesNode = ((ScriptTreeModel)this.tree.getModel()).findNode("Modules", currentWorkspaceNode);
        if (((TreeNode)tpath.getLastPathComponent()).getParent().equals(currentModulesNode)) {
            return "ClientModule:" + lastPath;
        }
        if (((TreeNode)tpath.getLastPathComponent()).getParent().equals(currentWorkspaceNode)) {
            return "Current Watershed:" + lastPath;
        }
        DefaultMutableTreeNode allWorkspaceNode = ((ScriptTreeModel)this.tree.getModel()).findNode("All Watersheds");
        DefaultMutableTreeNode allModulesNode = ((ScriptTreeModel)this.tree.getModel()).findNode("Modules", allWorkspaceNode);
        if (((TreeNode)tpath.getLastPathComponent()).getParent().equals(allModulesNode)) {
            return "ClientModule:" + lastPath;
        }
        if (((TreeNode)tpath.getLastPathComponent()).getParent().equals(allModulesNode)) {
            return "All Watersheds:" + lastPath;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveScript() {
        Object comp = null;
        String msg = null;
        ScriptManager sm = this.getScriptManager();
        if (this._scriptNameText.getText().length() < 1) {
            msg = "Please enter a label for the script";
            comp = this._scriptNameText;
        } else if (this._fileNameText.getText().length() < 1) {
            this.updateFileName();
        } else if (this.tree.getSelectionPath() == null) {
            msg = "Please select a path for the script to be located";
            comp = this.tree;
        } else if (!this._editingExistingScript && !sm.isUniqueScriptName(this._fileNameText.getText())) {
            msg = "Script Name must be unique.";
            comp = this._scriptNameText;
        }
        if (comp != null) {
            JOptionPane.showMessageDialog((Component)((Object)this), msg);
            comp.requestFocus();
            return;
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        Script script = null;
        Object selection = this.tree.getSelectionPath().getLastPathComponent();
        try {
            this.setModified(true);
            int[] headerLines = new int[1];
            script = this.buildScript(headerLines);
            this.msgOut("Script is:\n" + script.getScript());
            ScriptEngine.engine().compile(script, this._scriptNameText.getText(), headerLines[0], (Component)((Object)this));
        }
        catch (Exception e) {
            System.out.println(e);
        }
        try {
            ScriptIdentifier sid;
            if (selection instanceof FolderNode) {
                sid = new ScriptIdentifier(this._labelDisplayText.getText(), this._scriptNameText.getText(), this._descriptionText.getText(), this._fileNameText.getText(), this.getModulePath(), (Object)this.getScriptId(this.tree.getSelectionPath()), this._displayScriptInMenu.isSelected(), this._displayScript.isSelected(), this._displayScriptInSelector.isSelected(), this._overrodeScriptFile);
            } else {
                Color clr;
                sid = (ScriptIdentifier)((DefaultMutableTreeNode)selection).getUserObject();
                sm.deleteScript(sid, true, false);
                sid.setName(this._scriptNameText.getText());
                sid.setFileName(this._fileNameText.getText());
                sid.setDescription(this._descriptionText.getText());
                sid.setDisplayedInMenu(this._displayScriptInMenu.isSelected());
                sid.setDisplayedToUser(this._displayScript.isSelected());
                sid.setDisplayedInSelector(this._displayScriptInSelector.isSelected());
                sid.setUserDisplayedName(this._labelDisplayText.getText());
                sid.setModulePath(this.getModulePath());
                sid.setFileNameOverridden(this._overrodeScriptFile);
                if (this._bgColorBtn.isVisible() && (clr = this._bgColorBtn.getColor()) != null) {
                    sid.setBackgroundColorStr(RmaColor.color2String((Color)clr));
                }
                if (this._groupCombo.isVisible()) {
                    ScriptGroup sg = (ScriptGroup)this._groupCombo.getSelectedItem();
                    String groupName = null;
                    if (sg != null && !"".equals(sg.getName())) {
                        groupName = sg.getName();
                        sid.setGroupName(groupName);
                    }
                }
            }
            if (this._iconCombo.getSelectedIndex() == 0) {
                sid.setIconName(null);
            } else {
                sid.setIconName((String)this._iconCombo.getSelectedItem());
            }
            if (!sm.saveScript(sid, script)) {
                String message = "Unable to save script file: " + sid.getFileName() + "\nPlease check the permissions of this directory and file";
                JOptionPane.showMessageDialog((Component)((Object)this), message, "Error", 0);
                return;
            }
            if (selection instanceof FolderNode) {
                this.clearForm();
                this.setEditPanelEnabled(false);
            }
            if (!this._editingExistingScript) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.getLastFolderNode();
                DefaultMutableTreeNode newNode = new DefaultMutableTreeNode(sid, false);
                node.add(newNode);
                int i = node.getIndex(newNode);
                ((DefaultTreeModel)this.tree.getModel()).nodesWereInserted(node, new int[]{i});
                this.fireScriptAdded(sid);
                this.setSelectedNode(sid);
            } else {
                this.fireScriptChanged(sid);
            }
            this._scriptModified = false;
            this.setModified(false);
            this.setEditScript(false);
            this.setEditPanelEnabled(false);
        }
        catch (Exception e) {
            System.out.println(e);
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveScriptAs() {
        String name = JOptionPane.showInputDialog(null, "Enter Script Name", "Save As", 3);
        if (name == null || name.length() < 1) {
            return;
        }
        RmaJTextField comp = null;
        String msg = null;
        ScriptManager sm = this.getScriptManager();
        this._scriptNameText.setText(name);
        this._labelDisplayText.setText(name);
        this._fileNameText.setText("");
        this._overrodeScriptFile = false;
        this.updateFileName();
        this._editingExistingScript = false;
        this._editScript = false;
        if (!sm.isUniqueScriptName(this._fileNameText.getText())) {
            msg = "Script Name must be unique.";
            comp = this._scriptNameText;
        }
        if (comp != null) {
            JOptionPane.showMessageDialog((Component)((Object)this), msg);
            comp.requestFocus();
            return;
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        try {
            Color clr;
            this.setModified(true);
            int[] headerLines = new int[1];
            Script script = this.buildScript(headerLines);
            Object selection = this.tree.getSelectionPath().getLastPathComponent();
            this.msgOut("Script is:\n" + script.getScript());
            ScriptIdentifier sid = new ScriptIdentifier(this._labelDisplayText.getText(), this._scriptNameText.getText(), this._descriptionText.getText(), this._fileNameText.getText(), this.getModulePath(), (Object)this.getScriptId(this.tree.getSelectionPath()), this._displayScriptInMenu.isSelected(), this._displayScript.isSelected(), this._displayScriptInSelector.isSelected(), this._overrodeScriptFile);
            if (this._bgColorBtn.isVisible() && (clr = this._bgColorBtn.getColor()) != null) {
                sid.setBackgroundColorStr(RmaColor.color2String((Color)clr));
            }
            if (this._groupCombo.isVisible()) {
                ScriptGroup sg = (ScriptGroup)this._groupCombo.getSelectedItem();
                String groupName = null;
                if (sg != null && "".equals(sg.getName())) {
                    groupName = sg.getName();
                    sid.setGroupName(groupName);
                }
            }
            if (this._iconCombo.getSelectedIndex() == 0) {
                sid.setIconName(null);
            } else {
                sid.setIconName((String)this._iconCombo.getSelectedItem());
            }
            if (!sm.saveScript(sid, script)) {
                String message = "Unable to save script file: " + sid.getFileName() + "\nPlease check the permissions of this directory and file";
                JOptionPane.showMessageDialog((Component)((Object)this), message, "Error", 0);
                return;
            }
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.getLastFolderNode();
            DefaultMutableTreeNode newNode = new DefaultMutableTreeNode(sid, false);
            ((DefaultTreeModel)this.tree.getModel()).insertNodeInto(newNode, node, 0);
            this.setSelectedNode(sid);
            this._scriptModified = false;
            this.setModified(false);
            this.setEditPanelEnabled(false);
            JOptionPane.showMessageDialog(null, "Script " + sid.getUserDisplayedName() + " saved in file " + sid.getFileName(), "Save As", 1);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "Error in saving script " + name + "\n" + e.toString(), "Error Saving Script", 2);
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    protected Script buildScript(int[] headLines) {
        ScriptGroup sg;
        Color clr;
        int headerLines = 0;
        Script script = ScriptEngine.getNewScript();
        StringBuffer scriptBuf = new StringBuffer(this._scriptText.getText().length() + 100);
        scriptBuf.append("# ");
        scriptBuf.append("name");
        scriptBuf.append("=");
        scriptBuf.append(this._labelDisplayText.getText());
        scriptBuf.append("\n");
        ++headerLines;
        StringTokenizer tokenizer = new StringTokenizer(this._descriptionText.getText(), "\n");
        while (tokenizer.hasMoreTokens()) {
            scriptBuf.append("# description=" + tokenizer.nextToken());
            scriptBuf.append("\n");
            ++headerLines;
        }
        scriptBuf.append("# ");
        scriptBuf.append("displayinmenu");
        scriptBuf.append("=");
        scriptBuf.append(this._displayScriptInMenu.isSelected());
        scriptBuf.append("\n");
        ++headerLines;
        scriptBuf.append("# ");
        scriptBuf.append("displaytouser");
        scriptBuf.append("=");
        scriptBuf.append(this._displayScript.isSelected());
        scriptBuf.append("\n");
        ++headerLines;
        scriptBuf.append("# ");
        scriptBuf.append("displayinselector");
        scriptBuf.append("=");
        scriptBuf.append(this._displayScriptInSelector.isSelected());
        scriptBuf.append("\n");
        ++headerLines;
        if (!NO_ICON.equals(this._iconCombo.getSelectedItem())) {
            scriptBuf.append("# ");
            scriptBuf.append("iconname");
            scriptBuf.append("=");
            scriptBuf.append(this._iconCombo.getSelectedItem());
            scriptBuf.append("\n");
            ++headerLines;
        }
        if (this._bgColorBtn.isVisible() && (clr = this._bgColorBtn.getColor()) != null) {
            scriptBuf.append("# ");
            scriptBuf.append("backgroundColor");
            scriptBuf.append("=");
            scriptBuf.append(RmaColor.color2String((Color)clr));
            scriptBuf.append("\n");
            ++headerLines;
        }
        if (this._groupCombo.isVisible() && (sg = (ScriptGroup)this._groupCombo.getSelectedItem()) != null && !"".equals(sg.getName())) {
            scriptBuf.append("# ");
            scriptBuf.append("group");
            scriptBuf.append("=");
            scriptBuf.append(sg.getName());
            scriptBuf.append("\n");
        }
        headLines[0] = ++headerLines;
        scriptBuf.append(this._scriptText.getText());
        script.setScript(scriptBuf.toString());
        return script;
    }

    protected void deleteScript(boolean confirm) {
        ScriptIdentifier sid;
        TreePath selectionPath = this.tree.getSelectionPath();
        Object selection = selectionPath.getLastPathComponent();
        if (selection instanceof DefaultMutableTreeNode && !(selection instanceof FolderNode) && this.lockScriptFile(true, (sid = this.getSelectedScriptIdentifier()).getFileName())) {
            int opt = 0;
            if (confirm) {
                opt = JOptionPane.showConfirmDialog((Component)((Object)this), "Confirm deletion of script " + selection, "Confirm Delete", 0);
            }
            if (opt == 1) {
                return;
            }
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)selection;
            sid = (ScriptIdentifier)((DefaultMutableTreeNode)selection).getUserObject();
            ScriptManager sm = this.getScriptManager();
            if (sm.deleteScript(sid)) {
                this.setModified(true);
                this.msgOut("se:deleteScript: removing " + selectionPath);
                DefaultMutableTreeNode parent = (DefaultMutableTreeNode)node.getParent();
                int i = parent.getIndex(node);
                parent.remove(node);
                int[] idx = new int[]{i};
                this.tree.removeTreeSelectionListener(this._treeSelectListener);
                ((DefaultTreeModel)this.tree.getModel()).nodesWereRemoved(parent, idx, new Object[]{node});
                this.tree.addTreeSelectionListener(this._treeSelectListener);
                this.fireScriptDeleted(sid);
            }
        }
    }

    protected void closeFrame() {
        if (this._editScript) {
            int opt = JOptionPane.showConfirmDialog((Component)((Object)this), "Changes will be lost to edited Script.\nContinue?", "Confirm selection", 0);
            if (opt == 1) {
                return;
            }
            this.setEditScript(false);
        }
        this.flushScriptManager();
        this.setVisible(false);
        this.setModified(false);
        this.lockScriptFile(false, this._lockedPath);
    }

    protected abstract void fillFolderNodes();

    protected void addScriptableObjects(FolderNode parentNode, ScriptableObject so) {
        Vector scriptAbleTypes = so.getScriptableTypes();
        if (scriptAbleTypes == null) {
            return;
        }
        for (int t = 0; t < scriptAbleTypes.size(); ++t) {
            String typename = scriptAbleTypes.elementAt(t).toString();
            if (typename == null || typename.length() < 1) continue;
            FolderNode typeNode = new FolderNode(typename);
            parentNode.add(typeNode);
            Vector scriptableObjects = so.getScriptableObjectsForType(typename);
            if (scriptableObjects == null || scriptableObjects.size() < 1) continue;
            for (int i = 0; i < scriptableObjects.size(); ++i) {
                FolderNode soNode;
                String soName = scriptableObjects.elementAt(i).toString();
                if (soName == null || soName.length() < 1) continue;
                ScriptableObject childSo = so.getScriptableObjectByName(soName);
                if (childSo != null) {
                    soNode = new FolderNode(soName);
                    typeNode.add(soNode);
                    this.addScriptableObjects(soNode, childSo);
                    continue;
                }
                soNode = new FolderNode(soName);
                typeNode.add(soNode);
            }
        }
    }

    protected void updateFileName() {
        if (this._overrodeScriptFile) {
            return;
        }
        if (this._scriptNameText.getText().length() > 0) {
            this._fileNameText.setText(this.getFileName(this._scriptNameText.getText()));
        } else {
            this._fileNameText.setText("");
        }
    }

    protected abstract String getFileName(String var1);

    public void clearForm() {
        this._scriptNameText.setText("");
        this._fileNameText.setText("");
        this._descriptionText.setText("");
        this._scriptText.setText("");
        this._scriptText.discardAllEdits();
        this._labelDisplayText.setText("");
        this._editingExistingScript = false;
        this._displayScriptInMenu.setSelected(true);
        this._displayScript.setSelected(true);
        this._displayScriptInSelector.setSelected(true);
        this._scriptModified = false;
        this._overrodeScriptFile = false;
        this._iconCombo.setSelectedItem((Object)NO_ICON);
        this._bgColorBtn.setColor(null);
        this._groupCombo.setSelectedIndex(-1);
    }

    protected void getScriptIds(TreePath path) {
        boolean getIds;
        int i;
        if (path == null) {
            return;
        }
        DefaultMutableTreeNode folderNode = (DefaultMutableTreeNode)path.getLastPathComponent();
        if (!folderNode.getAllowsChildren()) {
            return;
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        int cnt = folderNode.getChildCount();
        Vector<DefaultMutableTreeNode> v = new Vector<DefaultMutableTreeNode>(cnt);
        for (i = 0; i < cnt; ++i) {
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)folderNode.getChildAt(i);
            if (child == null || child instanceof FolderNode) continue;
            v.addElement(child);
        }
        this.msgOut("se:removing " + v.size() + " from " + folderNode);
        if (v.size() > 0) {
            for (i = 0; i < v.size(); ++i) {
                folderNode.remove((DefaultMutableTreeNode)v.elementAt(i));
            }
        }
        if (getIds = true) {
            String pathStr = this.getModulePath(path);
            if (path == null || !this.isScriptableNode(folderNode.toString())) {
                this.setCursor(Cursor.getDefaultCursor());
                return;
            }
            this.getScriptIds(pathStr, folderNode);
        }
        this.setCursor(Cursor.getDefaultCursor());
    }

    protected void getScriptIds(String pathStr, DefaultMutableTreeNode folderNode) {
        int size;
        this.msgOut("se:getScriptIds: looking for scripts for " + pathStr);
        Vector sidList = this.getScriptManager().getScriptIdsForObject(pathStr);
        if (sidList == null || (size = sidList.size()) < 1) {
            return;
        }
        Vector sortedList = new Vector(sidList.size());
        ScriptManagerImpl.buildSortedVector(sidList, sortedList);
        for (int i = 0; i < size; ++i) {
            ScriptIdentifier sid;
            Object obj = sortedList.elementAt(i);
            if (obj == null || !(obj instanceof ScriptIdentifier) || !(sid = (ScriptIdentifier)obj).getModulePath().equals(pathStr)) continue;
            DefaultMutableTreeNode node = new DefaultMutableTreeNode(sid, false);
            this.msgOut("se:getScriptIds:adding " + sid + " to " + folderNode);
            folderNode.add(node);
        }
        if (size > 0) {
            ((DefaultTreeModel)this.tree.getModel()).nodeStructureChanged(folderNode);
        }
        sidList.removeAllElements();
        sortedList.removeAllElements();
    }

    protected void fillGroupCombo() {
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.tree.getModel().getRoot();
        Enumeration<TreeNode> bfenum = root.breadthFirstEnumeration();
        HashSet<String> groupNames = new HashSet<String>();
        while (bfenum.hasMoreElements()) {
            TreeNode next = bfenum.nextElement();
            if (!(next instanceof FolderNode)) continue;
            FolderNode node = (FolderNode)next;
            Object[] pathArr = node.getPath();
            TreePath path = new TreePath(pathArr);
            String pathStr = path.toString();
            Vector scripts = this.getScriptManager().getScriptIdsForObject(pathStr);
            for (int i = 0; i < scripts.size(); ++i) {
                String groupName = ((ScriptIdentifier)scripts.get(i)).getGroupName();
                if (groupName == null || groupName.isEmpty() || groupNames.contains(groupName)) continue;
                groupNames.add(groupName);
            }
        }
        ArrayList<ScriptGroup> groups = new ArrayList<ScriptGroup>();
        Iterator iter = groupNames.iterator();
        while (iter.hasNext()) {
            ScriptGroup sg = new ScriptGroup((String)iter.next(), "");
            groups.add(sg);
        }
        Collections.sort(groups);
        groups.add(0, new ScriptGroup("", ""));
        this._groupCombo.setModel((ComboBoxModel)new RmaListModel(true, groups));
        this._groupList.clear();
        this._groupList.addAll(groups);
    }

    protected void loadScript(TreePath path) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
        if (!node.isLeaf()) {
            this.clearForm();
            return;
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        Object obj = node.getUserObject();
        if (!(obj instanceof ScriptIdentifier)) {
            return;
        }
        ScriptIdentifier sid = (ScriptIdentifier)obj;
        Script script = this.getScriptManager().getScript(sid);
        this._scriptNameText.setText(sid.getName());
        this._fileNameText.setText(sid.getFileName());
        this._displayScriptInMenu.setSelected(sid.isDisplayedInMenu());
        this._displayScript.setSelected(sid.isDisplayedToUser());
        this._displayScriptInSelector.setSelected(sid.isDisplayedInSelector());
        this._labelDisplayText.setText(sid.getUserDisplayedName());
        this._descriptionText.setText(sid.getDescription());
        Color clr = RmaColor.parseColorString((String)sid.getBackgroundColorStr());
        this.selectGroup(sid.getGroupName());
        this._bgColorBtn.setColor(clr);
        this._overrodeScriptFile = true;
        if (sid.getIconName() == null) {
            this._iconCombo.setSelectedItem((Object)NO_ICON);
        } else {
            this._iconCombo.setSelectedItem((Object)sid.getIconName());
        }
        if (script != null) {
            StringTokenizer tokenizer = new StringTokenizer(script.getScript(), "\n", true);
            StringBuffer buf = new StringBuffer(script.getScript().length());
            while (tokenizer.hasMoreTokens()) {
                String tmpline;
                String type;
                String token = tokenizer.nextToken();
                if (token.startsWith("#") && ("name".equalsIgnoreCase(type = RMAIO.getType((String)(tmpline = token.substring(1)), (String)"=")) || "description".equalsIgnoreCase(type) || "displaytouser".equalsIgnoreCase(type) || "displayinmenu".equalsIgnoreCase(type) || "displayinselector".equalsIgnoreCase(type) || "iconname".equalsIgnoreCase(type) || "backgroundColor".equalsIgnoreCase(type) || "group".equalsIgnoreCase(type))) {
                    tokenizer.nextToken();
                    continue;
                }
                buf.append(token);
            }
            int caretPos = this._scriptText.getCaretPosition();
            this._scriptText.setText(buf.toString());
            this._scriptText.discardAllEdits();
            if (caretPos < 0 || caretPos > this._scriptText.getText().length()) {
                caretPos = 0;
            }
            try {
                this._scriptText.setCaretPosition(caretPos);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this._editingExistingScript = true;
        this._scriptModified = false;
        this.setCursor(Cursor.getDefaultCursor());
    }

    private void selectGroup(String groupName) {
        if (groupName == null) {
            this._groupCombo.setSelectedIndex(-1);
            return;
        }
        ComboBoxModel model = this._groupCombo.getModel();
        for (int i = 0; i < model.getSize(); ++i) {
            ScriptGroup sg = (ScriptGroup)model.getElementAt(i);
            if (!groupName.equals(sg.getName())) continue;
            this._groupCombo.setSelectedItem((Object)sg);
            return;
        }
        this._groupCombo.setSelectedIndex(-1);
    }

    public void setSelectedNode(String nodeName, String underNodeName) {
        Object[] pathList;
        DefaultMutableTreeNode leaf;
        if (nodeName == null) {
            return;
        }
        if (underNodeName == null) {
            underNodeName = "Scripts";
        }
        int idx = nodeName.indexOf(58);
        String modeName = null;
        DefaultMutableTreeNode startNode = ((ScriptTreeModel)this.tree.getModel()).findNode(underNodeName);
        if (startNode == null) {
            startNode = (DefaultMutableTreeNode)this.tree.getModel().getRoot();
        }
        this.msgOut("se:setSelectedNode: startNode is " + startNode);
        if (idx > -1) {
            modeName = nodeName.substring(idx + 1);
            if (((ScriptTreeModel)this.tree.getModel()).findNode(nodeName) == null) {
                FolderNode folderNode = new FolderNode(nodeName);
                this.getScriptIds(nodeName, folderNode);
            }
        }
        if ((leaf = ((ScriptTreeModel)this.tree.getModel()).findNode(modeName, startNode)) == null && modeName != null) {
            leaf = ((ScriptTreeModel)this.tree.getModel()).findNode(modeName, startNode);
        }
        if ((pathList = ((DefaultTreeModel)this.tree.getModel()).getPathToRoot(leaf)) == null) {
            return;
        }
        TreePath path = new TreePath(pathList);
        this.msgOut("se:setSelectedNode: path is " + path);
        this.tree.setSelectionPath(path);
        this.tree.makeVisible(path);
        this.tree.scrollPathToVisible(path);
        this.tree.expandPath(path);
    }

    public void setSelectedNode(ScriptIdentifier sid) {
        this.tree.setSelectionRow(-1);
        if (sid == null) {
            return;
        }
        String modulePath = sid.getModulePath();
        if (modulePath == null) {
            return;
        }
        String uniqueNodeName = null;
        this.msgOut("se:setSelectedNode: modulePath is " + modulePath);
        int idx = modulePath.indexOf("Current Watershed");
        if (idx > -1) {
            int idx2 = modulePath.indexOf("/", idx);
            if (idx2 < 0) {
                idx2 = modulePath.length();
            }
            uniqueNodeName = modulePath.substring(idx, idx2);
        } else {
            idx = modulePath.indexOf("All Watersheds");
            if (idx > -1) {
                int idx2 = modulePath.indexOf("/", idx);
                if (idx2 < 0) {
                    idx2 = modulePath.length();
                }
                uniqueNodeName = modulePath.substring(idx, idx2);
            } else {
                int idx2 = modulePath.lastIndexOf("/");
                uniqueNodeName = idx2 < 0 ? modulePath : modulePath.substring(idx2 + 1);
            }
        }
        this.msgOut("se:setSelectedNode: uniqueNodeName is " + uniqueNodeName);
        if (uniqueNodeName == null) {
            return;
        }
        DefaultMutableTreeNode uniqueFolderNode = ((ScriptTreeModel)this.tree.getModel()).findNode(uniqueNodeName);
        if (uniqueFolderNode == null) {
            return;
        }
        idx = modulePath.lastIndexOf("/");
        if (idx < 0) {
            return;
        }
        String lastFolderNodeName = modulePath.substring(idx + 1);
        DefaultMutableTreeNode leaf = ((ScriptTreeModel)this.tree.getModel()).findNode(lastFolderNodeName, uniqueFolderNode);
        if (leaf == null) {
            return;
        }
        Object[] pathList = ((DefaultTreeModel)this.tree.getModel()).getPathToRoot(leaf);
        if (pathList == null) {
            return;
        }
        TreePath path = new TreePath(pathList);
        this.msgOut("se:setSelectedNode: path is " + path);
        this.tree.makeVisible(path);
        this.tree.expandPath(path);
        DefaultMutableTreeNode node = ((ScriptTreeModel)this.tree.getModel()).findNode(sid.toString(), leaf);
        if (node == null) {
            return;
        }
        pathList = ((DefaultTreeModel)this.tree.getModel()).getPathToRoot(node);
        if (pathList == null) {
            return;
        }
        path = new TreePath(pathList);
        this.msgOut("se:setSelectedNode: path to node is " + path);
        this.tree.makeVisible(path);
        this.tree.scrollPathToVisible(path);
        this.tree.setSelectionPath(path);
    }

    public void setVisible(boolean b) {
        if (!b) {
            this.saveSizeAndLocation();
        }
        super.setVisible(b);
    }

    public void finalize() throws Throwable {
        super.finalize();
        this.getScriptManager().removeConfigChangeListener((ConfigChangeListener)this);
    }

    protected abstract ScriptManager getScriptManager();

    protected boolean isScriptableNode(String nodeName) {
        if (nodeName.equals("Scripts") || nodeName.equals("System") || nodeName.equals("User") || nodeName.equals("All Watersheds") || nodeName.equals("Current Watershed")) {
            return false;
        }
        return AppDaddy.getWorkspace() == null || !nodeName.equals(AppDaddy.getWorkspace().getTitleName());
    }

    protected void setEditPanelEnabled(boolean b) {
        this._scriptNameText.setEnabled(b);
        this._descriptionText.setEditable(b);
        this._scriptText.setEditable(b);
        this._displayScriptInMenu.setEnabled(b);
        this._displayScript.setEnabled(b);
        this._displayScriptInSelector.setEnabled(b);
        this._labelDisplayText.setEnabled(b);
        this._saveMenuItem.setEnabled(b);
        this._saveAsMenuItem.setEnabled(b);
        this._saveButton.setEnabled(b);
        this._browseButton.setEnabled(b);
        this._testMenuItem.setEnabled(!b);
        this._printMenuItem.setEnabled(b);
        this._iconCombo.setEnabled(b);
        this._testButton.setEnabled(true);
        this._argumentText.setEnabled(b);
        this._undoMenuItem.setAction((Action)RSyntaxTextArea.getAction((int)6));
        this._redoMenuItem.setAction((Action)RSyntaxTextArea.getAction((int)4));
        this._cutMenuItem.setAction((Action)RSyntaxTextArea.getAction((int)1));
        this._copyMenuItem.setAction((Action)RSyntaxTextArea.getAction((int)0));
        this._pasteMenuItem.setAction((Action)RSyntaxTextArea.getAction((int)3));
        this._groupCombo.setEnabled(b);
        if (!b) {
            this._editScript = b;
        }
    }

    protected void treePathSelected(TreePath path, TreePath oldPath, boolean enable) {
        int opt;
        TreeNode node = (TreeNode)path.getLastPathComponent();
        if (this._editScript && !this._resetingPath && this._scriptModified && (opt = JOptionPane.showConfirmDialog((Component)((Object)this), "Changes will be lost to edited Script.\nContinue?", "Confirm selection", 0)) == 1) {
            this._resetingPath = true;
            if (oldPath != null) {
                this.tree.setSelectionPath(oldPath);
            }
            return;
        }
        if (!this._resetingPath) {
            this.setEditScript(false);
            if (!node.isLeaf()) {
                this.clearForm();
                this.setEditPanelEnabled(false);
                return;
            }
            this.setEditPanelEnabled(enable);
            this.loadScript(path);
        }
        this._resetingPath = false;
    }

    protected boolean setEditScript(boolean edit) {
        if (edit) {
            ScriptIdentifier sid = this.getSelectedScriptIdentifier();
            if (sid == null) {
                System.out.println("setEditScript: no ScriptIdentifier selected");
                return false;
            }
            if (this.lockScriptFile(edit, sid.getFileName())) {
                this._editScript = edit;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        AbstractScriptEditor.this._labelDisplayText.requestFocus();
                        AbstractScriptEditor.this._labelDisplayText.grabFocus();
                    }
                });
                return true;
            }
            System.out.println("setEditScript: failed to lock script");
            return false;
        }
        this._editScript = edit;
        this.setModified(false);
        if (this._lockedPath != null) {
            this.flushScriptManager();
        }
        return this.lockScriptFile(edit, this._lockedPath);
    }

    protected abstract boolean lockScriptFile(boolean var1, String var2);

    protected void expandTree(boolean expand) {
        TreePath path = this.tree.getSelectionPath();
        if (!this.tree.isExpanded(path) && expand) {
            this.tree.expandPath(path);
        } else if (!expand) {
            this.tree.collapsePath(path);
        }
    }

    public void configFileChanged(ConfigFileChangeEvent event) {
        this.msgOut("se:configFileChanged: " + event.getChangeType());
        if (event.getChangeType() == 1 && !this._scriptModified) {
            this.refreshTree();
        }
    }

    public void refreshTree() {
        TreePath path = this.tree.getSelectionPath();
        if (path == null) {
            return;
        }
        this.getScriptIds(path);
    }

    protected void cutTreeNode() {
        if (this.copyTreeNode()) {
            this.deleteScript(false);
        }
    }

    protected boolean copyTreeNode() {
        TreePath path = this.tree.getSelectionPath();
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
        if (node instanceof FolderNode) {
            Toolkit.getDefaultToolkit().beep();
            return false;
        }
        Object obj = node.getUserObject();
        if (!(obj instanceof ScriptIdentifier)) {
            Toolkit.getDefaultToolkit().beep();
            return false;
        }
        Script script = this.getScriptManager().getScript((ScriptIdentifier)obj);
        ScriptIdentifierData data = new ScriptIdentifierData((ScriptIdentifier)obj, script);
        ScriptIdentifierSelection sids = new ScriptIdentifierSelection(data);
        Clipboard cb = this.getToolkit().getSystemClipboard();
        cb.getContents(this);
        cb.setContents((Transferable)sids, this);
        return true;
    }

    protected void pasteTreeNode() {
        TreePath path = this.tree.getSelectionPath();
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
        if (!(node instanceof FolderNode)) {
            Toolkit.getDefaultToolkit().beep();
            return;
        }
        Clipboard cb = this.getToolkit().getSystemClipboard();
        Transferable t = cb.getContents(this);
        if (t == null) {
            this.getToolkit().beep();
            return;
        }
        ScriptIdentifierData sidData = null;
        try {
            sidData = (ScriptIdentifierData)t.getTransferData(ScriptIdentifierSelection.SCRIPTID_FLAVOR);
        }
        catch (Exception e) {
            System.out.println("pasteTreeNode: exception on getTransferData " + e);
            return;
        }
        if (sidData != null) {
            ScriptManager sm = this.getScriptManager();
            ScriptIdentifier s = sidData.getScriptIdentifier();
            if (s == null) {
                return;
            }
            Script script = sidData.getScript();
            if (script == null) {
                return;
            }
            ScriptIdentifier sid = new ScriptIdentifier(s);
            sid.setScriptId(this.getScriptId(this.tree.getSelectionPath()));
            sid.setModulePath(this.getModulePath());
            Hashtable cache = sm.getCache();
            if (cache != null) {
                Object name = sid.getUserDisplayedName();
                String copyOf = "Copy of ";
                while (!sm.isUniqueScriptName((String)name, cache)) {
                    name = copyOf + (String)name;
                }
                sid.setUserDisplayedName((String)name);
                if (!sid.getFileNameOverridden()) {
                    sid.setFileName(this.getFileName((String)name));
                }
            } else {
                System.out.println("se:pasteTreeNode: failed to find cache for " + sid + " module path " + sid.getModulePath());
                return;
            }
            sid.setUserDisplayedName(sid.getUserDisplayedName());
            FolderNode folderNode = (FolderNode)node;
            DefaultMutableTreeNode newNode = new DefaultMutableTreeNode(sid, false);
            folderNode.add(newNode);
            int i = folderNode.getIndex(newNode);
            ((DefaultTreeModel)this.tree.getModel()).nodesWereInserted(folderNode, new int[]{i});
            sm.saveScript(sid, script);
            this.setSelectedNode(sid);
            this.setModified(true);
            if (!this.setEditScript(true)) {
                return;
            }
        }
    }

    protected void msgOut(String msg) {
        ((MarkingClassLogger.Api)SCRIPTING_LOGGER.atFine()).log(msg);
    }

    String createUniqueName(String name, int cnt) {
        return name + cnt;
    }

    protected ScriptIdentifierData getScriptToPaste() {
        Clipboard cb = this.getToolkit().getSystemClipboard();
        Transferable t = cb.getContents(this);
        if (t == null || !t.isDataFlavorSupported(ScriptIdentifierSelection.SCRIPTID_FLAVOR)) {
            return null;
        }
        try {
            return (ScriptIdentifierData)t.getTransferData(ScriptIdentifierSelection.SCRIPTID_FLAVOR);
        }
        catch (Exception e) {
            return null;
        }
    }

    protected void displayFolderPopup(MouseEvent e, String name) {
        boolean pasteEnabled;
        ScriptIdentifierData sid = this.getScriptToPaste();
        boolean bl = pasteEnabled = sid != null;
        if (this._folderPopup == null) {
            ActionListener fpAl = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    JMenuItem menuItem = (JMenuItem)ae.getSource();
                    String text = menuItem.getText();
                    if (text.equals("Paste Script")) {
                        AbstractScriptEditor.this.pasteTreeNode();
                    } else if (text.equals("New Script")) {
                        AbstractScriptEditor.this.newScript();
                    } else if (text.equals("Import Script")) {
                        AbstractScriptEditor.this.importScript();
                    }
                }
            };
            this._folderPopup = new JPopupMenu(name);
            JMenuItem menuitem = new JMenuItem("New Script");
            menuitem.setAccelerator(KeyStroke.getKeyStroke(78, 2, false));
            menuitem.addActionListener(fpAl);
            this._folderPopup.add(menuitem);
            menuitem = new JMenuItem("Import Script");
            menuitem.addActionListener(fpAl);
            this._folderPopup.add(menuitem);
            this._folderPopup.addSeparator();
            menuitem = new JMenuItem("Paste Script");
            menuitem.setAccelerator(KeyStroke.getKeyStroke(86, 2, false));
            menuitem.addActionListener(fpAl);
            this._folderPopup.add(menuitem);
        }
        JMenuItem item = (JMenuItem)this._folderPopup.getComponent(3);
        item.setEnabled(pasteEnabled);
        this._folderPopup.show(this.tree, e.getX(), e.getY());
    }

    protected void displayNodePopup(MouseEvent e, String name) {
        if (this._nodePopup == null) {
            ActionListener npAl = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    JMenuItem menuItem = (JMenuItem)ae.getSource();
                    String text = menuItem.getText();
                    if (text.equals("Cut Script")) {
                        AbstractScriptEditor.this.cutTreeNode();
                    } else if (text.equals("Copy Script")) {
                        AbstractScriptEditor.this.copyTreeNode();
                    } else if (text.equals("Edit Script")) {
                        AbstractScriptEditor.this.editScript(AbstractScriptEditor.this.tree.getSelectionPath());
                    }
                }
            };
            this._nodePopup = new JPopupMenu(name);
            JMenuItem menuitem = new JMenuItem("Cut Script");
            menuitem.addActionListener(npAl);
            menuitem.setAccelerator(KeyStroke.getKeyStroke(88, 2, false));
            this._nodePopup.add(menuitem);
            menuitem = new JMenuItem("Copy Script");
            menuitem.addActionListener(npAl);
            menuitem.setAccelerator(KeyStroke.getKeyStroke(67, 2, false));
            this._nodePopup.add(menuitem);
            this._nodePopup.addSeparator();
            menuitem = new JMenuItem("Edit Script");
            menuitem.addActionListener(npAl);
            menuitem.setAccelerator(KeyStroke.getKeyStroke(79, 2, false));
            this._nodePopup.add(menuitem);
        }
        this._nodePopup.show(this.tree, e.getX(), e.getY());
    }

    public abstract void importScript();

    protected void setMenusState(boolean isFolder) {
        if (isFolder) {
            this._newMenuItem.setEnabled(true);
            this._importMenuItem.setEnabled(true);
            this._deleteMenuItem.setEnabled(false);
            this._editMenuItem.setEnabled(false);
            this._editButton.setEnabled(false);
            this._cutMenuItem.setEnabled(false);
            this._copyMenuItem.setEnabled(false);
            this._pasteMenuItem.setEnabled(false);
            this._saveMenuItem.setEnabled(false);
            this._saveButton.setEnabled(false);
            this._saveAsMenuItem.setEnabled(false);
            this._testMenuItem.setEnabled(false);
            this._testButton.setEnabled(false);
            this._cutScriptMenuItem.setEnabled(false);
            this._copyScriptMenuItem.setEnabled(false);
            this._pasteScriptMenuItem.setEnabled(this.getScriptToPaste() != null);
        } else {
            this._newMenuItem.setEnabled(false);
            this._importMenuItem.setEnabled(false);
            this._deleteMenuItem.setEnabled(true);
            this._editMenuItem.setEnabled(true);
            this._editButton.setEnabled(true);
            this._cutMenuItem.setEnabled(true);
            this._copyMenuItem.setEnabled(true);
            this._pasteMenuItem.setEnabled(true);
            this._saveMenuItem.setEnabled(true);
            this._saveButton.setEnabled(true);
            this._saveAsMenuItem.setEnabled(true);
            this._testMenuItem.setEnabled(true);
            this._testButton.setEnabled(true);
            this._cutScriptMenuItem.setEnabled(true);
            this._copyScriptMenuItem.setEnabled(true);
            this._pasteScriptMenuItem.setEnabled(false);
        }
    }

    protected abstract void selectScript(TreePath var1);

    protected void selectForeground() {
        Color c = JColorChooser.showDialog((Component)((Object)this), "Select Foreground Color", this._scriptText.getForeground());
        if (c == null) {
            return;
        }
        this._scriptText.setForeground(c);
        this._descriptionText.setForeground(c);
        this.saveForegroundColor("" + c.getRGB());
    }

    protected void selectBackground() {
        Color c = JColorChooser.showDialog((Component)((Object)this), "Select Background Color", this._scriptText.getForeground());
        if (c == null) {
            return;
        }
        this._scriptText.setBackground(c);
        this._descriptionText.setBackground(c);
        this.saveBackgroundColor("" + c.getRGB());
    }

    protected void selectFont() {
        FontChooser chooser = new FontChooser((Frame)((Object)this), "Select Font", true, this._scriptText.getFont());
        Font f = chooser.getSelectedFont();
        if (f == null) {
            return;
        }
        this._scriptText.setFont(f);
        this._descriptionText.setFont(f);
        this.saveFont(RMAUtil.getFontString((Font)f));
    }

    protected void setTabSize() {
        InsertDlg insertDlg = new InsertDlg((Frame)((Object)this), true);
        insertDlg.setTitle("Enter Tab Size");
        insertDlg.setRowsToInsert(this._scriptText.getTabSize());
        insertDlg.setLabelText("Enter Tab Size");
        insertDlg.setVisible(true);
        if (insertDlg.isCanceled()) {
            return;
        }
        int tabsize = insertDlg.getRowsToInsert();
        this._scriptText.setTabSize(tabsize);
        this._scriptText.updateUI();
        this.saveTabSize(tabsize);
    }

    protected abstract void saveForegroundColor(String var1);

    protected abstract void saveBackgroundColor(String var1);

    protected abstract void saveFont(String var1);

    protected abstract void saveTabSize(int var1);

    protected abstract void saveSizeAndLocation();

    public void printScript() {
        try {
            this._scriptText.print();
        }
        catch (PrinterException e) {
            JOptionPane.showMessageDialog((Component)((Object)this), e.getMessage(), "Print Error", 0);
        }
    }

    public void testScript() {
        TreePath path = this.tree.getSelectionPath();
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
        if (node instanceof FolderNode) {
            Toolkit.getDefaultToolkit().beep();
            return;
        }
        Object obj = node.getUserObject();
        if (!(obj instanceof ScriptIdentifier)) {
            Toolkit.getDefaultToolkit().beep();
            return;
        }
        ScriptIdentifier id = (ScriptIdentifier)obj;
        String a = this._argumentText.getText();
        if (a != null && a.length() > 0) {
            Vector args = RMAIO.parseStringWithQuotes((String)a);
            Script script = this.getScriptManager().getScript(id);
            if (script == null) {
                return;
            }
            script.setArgs(args);
        }
        this.runScript(id);
    }

    public boolean runScript(ScriptIdentifier id) {
        Script script = this.getScriptManager().getScript(id);
        if (script == null) {
            return false;
        }
        System.out.println("runScript: running :" + id.getFileName());
        int rv = ScriptEngine.engine().execute(script, id.getUserDisplayedName(), id.getName());
        return rv == 0;
    }

    public void setModified(boolean modified) {
        super.setModified(modified);
        this._modifiedField.setText(modified ? "Modified" : "");
    }

    protected Vector createImageList() {
        Vector<String> v = new Vector<String>();
        v.add(NO_ICON);
        String classPath = System.getProperty("java.class.path");
        if (classPath == null) {
            System.out.println("createImageList: got null classpath");
            return v;
        }
        StringTokenizer tokenizer = new StringTokenizer(classPath, File.pathSeparator);
        String token = null;
        boolean found = false;
        while (tokenizer.hasMoreTokens()) {
            token = tokenizer.nextToken();
            if (token.indexOf("images.jar") <= -1) continue;
            found = true;
            break;
        }
        if (!found) {
            System.out.println("createImageList: failed to find Images.jar in " + classPath);
            return v;
        }
        try {
            JarFile imagesJar = new JarFile(token);
            Enumeration<JarEntry> e = imagesJar.entries();
            v.ensureCapacity(imagesJar.size());
            while (e.hasMoreElements()) {
                String name;
                ZipEntry entry = e.nextElement();
                if (!entry.getName().startsWith("Images/Icons") || entry.isDirectory() || !(name = entry.getName()).endsWith(".gif") || name.endsWith("Sel.gif")) continue;
                v.add(name);
            }
        }
        catch (IOException ioe) {
            System.out.println("createImageList: error reading jarfile " + token + " error " + ioe);
            return v;
        }
        v.trimToSize();
        return v;
    }

    protected void fireScriptAdded(ScriptIdentifier sid) {
        this.fireScriptEvent(sid, 0);
    }

    protected void fireScriptDeleted(ScriptIdentifier sid) {
        this.fireScriptEvent(sid, 1);
    }

    protected void fireScriptChanged(ScriptIdentifier sid) {
        this.fireScriptEvent(sid, 2);
    }

    protected void fireScriptEvent(ScriptIdentifier sid, int eventType) {
        Object[] listeners = this._listenerList.getListenerList();
        ScriptEvent e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ScriptEventListener.class) continue;
            if (e == null) {
                e = new ScriptEvent(sid, eventType);
            }
            ((ScriptEventListener)listeners[i + 1]).scriptEventPerformed(e);
        }
    }

    public void addScriptEventListener(ScriptEventListener listener) {
        this._listenerList.add(ScriptEventListener.class, listener);
    }

    public void removeScriptEventListener(ScriptEventListener listener) {
        this._listenerList.remove(ScriptEventListener.class, listener);
    }

    @Override
    public void lostOwnership(Clipboard clipboard, Transferable contents) {
    }

    static {
        if (UIManager.getLookAndFeel().getName().indexOf("Metal") < 0) {
            try {
                Icon icon = UIManager.getIcon("FileView.fileIcon");
                UIManager.put("Tree.leafIcon", icon);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public class ScriptTreeModel
    extends DefaultTreeModel {
        protected DefaultMutableTreeNode root;

        public ScriptTreeModel(boolean addWatershedNodes) {
            super(new DefaultMutableTreeNode("Scripts"), false);
            this.root = (DefaultMutableTreeNode)this.getRoot();
            if (addWatershedNodes) {
                FolderNode sys = new FolderNode("System");
                sys.setAllowsChildren(true);
                this.root.add(sys);
                FolderNode wkspParent = new FolderNode("All Watersheds");
                wkspParent.setAllowsChildren(true);
                sys.add(wkspParent);
                FolderNode parent = new FolderNode("Current Watershed");
                parent.setAllowsChildren(true);
                sys.add(parent);
            }
        }

        public DefaultMutableTreeNode findNode(Object nodeName) {
            return this.findNode(nodeName, this.root);
        }

        public DefaultMutableTreeNode findNode(Object nodeName, DefaultMutableTreeNode start) {
            Enumeration<TreeNode> e = start.depthFirstEnumeration();
            while (e.hasMoreElements()) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)e.nextElement();
                if (!node.toString().equals(nodeName)) continue;
                return node;
            }
            return null;
        }
    }

    public class ScriptTextArea
    extends RSyntaxTextArea
    implements InsertModeChangedListener,
    Modifiable,
    EditableComponent,
    FormManagementListener {
        Color _bg;
        JPopupMenu _popupMenu;
        JMenuItem _copyMenuItem;
        JMenuItem _cutMenuItem;
        JMenuItem _pasteMenuItem;
        JMenuItem _selectAllMenuItem;
        JMenuItem _findMenuItem;
        JMenuItem _findNextMenuItem;
        JMenuItem _findPrevMenuItem;
        JMenuItem _gotoLineMenuItem;
        ReflectMultiListener _listener;
        int _searchDirection;
        String _searchText;
        boolean _matchCase;
        boolean _wrapAround;
        private boolean _modified;
        private boolean _forwardModifiedEvents;
        private boolean _modifiable;

        public ScriptTextArea(int x, int y) {
            super(x, y);
            this._bg = Color.white;
            this._searchText = "";
            this._forwardModifiedEvents = true;
            this._modifiable = true;
            this.addListeners();
            this.setSyntaxEditingStyle("text/python");
            this.setMarkOccurrences(true);
            this.setMarkOccurrencesColor(Color.ORANGE);
            this.setAutoIndentEnabled(true);
            this.setBracketMatchingEnabled(true);
            this.addFocusListener(new FocusAdapter(){

                @Override
                public void focusGained(FocusEvent e) {
                    AbstractScriptEditor.this._insertField.setText(ScriptTextArea.this.getTextMode() == 0 ? "Insert" : "Overwrite");
                }

                @Override
                public void focusLost(FocusEvent e) {
                    AbstractScriptEditor.this._insertField.setText("");
                }
            });
            this.addKeyListener(new KeyListener(){

                @Override
                public void keyTyped(KeyEvent e) {
                }

                @Override
                public void keyPressed(KeyEvent e) {
                }

                @Override
                public void keyReleased(KeyEvent e) {
                    if (e.getKeyCode() == 155) {
                        AbstractScriptEditor.this._insertField.setText(ScriptTextArea.this.getTextMode() == 0 ? "Insert" : "Overwrite");
                    }
                }
            });
            AbstractAction findAction = new AbstractAction("find"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ScriptTextArea.this.displayFindDialog();
                }
            };
            this.getActionMap().put(findAction.getValue("Name"), findAction);
            AbstractAction findNextAction = new AbstractAction("findNext"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ScriptTextArea.this.searchNext();
                }
            };
            this.getActionMap().put(findNextAction.getValue("Name"), findNextAction);
            AbstractAction findPrevAction = new AbstractAction("findPrevious"){

                @Override
                public void actionPerformed(ActionEvent e) {
                }
            };
            this.getActionMap().put(findPrevAction.getValue("Name"), findPrevAction);
            AbstractAction gotoLineAction = new AbstractAction("gotoLineNumber"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ScriptTextArea.this.gotoLineNumber();
                }
            };
            this.getActionMap().put(gotoLineAction.getValue("Name"), gotoLineAction);
            this.getInputMap().put(KeyStroke.getKeyStroke(70, 2), "find");
            this.getInputMap().put(KeyStroke.getKeyStroke(114, 0), "findNext");
            this.getInputMap().put(KeyStroke.getKeyStroke(115, 0), "findPrevious");
            this.getInputMap().put(KeyStroke.getKeyStroke(71, 2), "gotoLineNumber");
        }

        private void addListeners() {
            this.addCaretListener(new CaretListener(){

                @Override
                public void caretUpdate(CaretEvent e) {
                    try {
                        int pos = ScriptTextArea.this.getCaretPosition();
                        int line = ScriptTextArea.this.getLineOfOffset(pos);
                        int col = pos - ScriptTextArea.this.getLineStartOffset(line);
                        AbstractScriptEditor.this._positionField.setText(String.valueOf(line + 1) + ":" + (col + 1));
                    }
                    catch (Exception ee) {
                        System.out.println(ee);
                        AbstractScriptEditor.this._positionField.setText("");
                    }
                }
            });
            this.addKeyListener(new KeyAdapter(){

                @Override
                public void keyReleased(KeyEvent e) {
                    if (RmaJTextField.isCursorKey((int)e.getKeyCode())) {
                        return;
                    }
                    int modifiers = e.getModifiers();
                    if ((modifiers & 8) > 0 || (modifiers & 2) > 0) {
                        return;
                    }
                    ScriptTextArea.this.setModified(true);
                }
            });
        }

        public void insertModeChanged(ToggleInsertDocument doc, boolean isInInsertMode) {
            AbstractScriptEditor.this._insertField.setText(isInInsertMode ? "Insert" : "Overwrite");
        }

        public void setEditable(boolean b) {
            if (!b) {
                this.setBackground(Color.lightGray);
            } else {
                this.setBackground(this._bg);
            }
            super.setEditable(b);
        }

        protected void popupMenu(Point p) {
            if (this._popupMenu == null) {
                this._listener = new ReflectMultiListener();
                this._popupMenu = new JPopupMenu();
                this._cutMenuItem = new JMenuItem("Cut", 116);
                this._cutMenuItem.addActionListener((ActionListener)this._listener.add((Object)this, (Object)this._cutMenuItem, "cut"));
                this._cutMenuItem.setAccelerator(KeyStroke.getKeyStroke(88, 2, false));
                this._popupMenu.add(this._cutMenuItem);
                this._copyMenuItem = new JMenuItem("Copy", 99);
                this._copyMenuItem.addActionListener((ActionListener)this._listener.add((Object)this, (Object)this._copyMenuItem, "copy"));
                this._copyMenuItem.setAccelerator(KeyStroke.getKeyStroke(67, 2, false));
                this._popupMenu.add(this._copyMenuItem);
                this._pasteMenuItem = new JMenuItem("Paste", 112);
                this._pasteMenuItem.addActionListener((ActionListener)this._listener.add((Object)this, (Object)this._pasteMenuItem, "paste"));
                this._pasteMenuItem.setAccelerator(KeyStroke.getKeyStroke(86, 2, false));
                this._popupMenu.add(this._pasteMenuItem);
                this._selectAllMenuItem = new JMenuItem("Select All", 115);
                this._selectAllMenuItem.addActionListener((ActionListener)this._listener.add((Object)this, (Object)this._selectAllMenuItem, "selectAll"));
                this._selectAllMenuItem.setAccelerator(KeyStroke.getKeyStroke(65, 2, false));
                this._popupMenu.add(this._selectAllMenuItem);
                this._findMenuItem = new JMenuItem("Find", 102);
                this._findMenuItem.addActionListener((ActionListener)this._listener.add((Object)this, (Object)this._findMenuItem, "displayFindDialog"));
                this._findMenuItem.setAccelerator(KeyStroke.getKeyStroke(70, 2, false));
                this._popupMenu.addSeparator();
                this._popupMenu.add(this._findMenuItem);
                this._findNextMenuItem = new JMenuItem("Find Next", 110);
                this._findNextMenuItem.addActionListener((ActionListener)this._listener.add((Object)this, (Object)this._findNextMenuItem, "searchNext"));
                this._findNextMenuItem.setAccelerator(KeyStroke.getKeyStroke(114, 0));
                this._popupMenu.add(this._findNextMenuItem);
                this._findPrevMenuItem = new JMenuItem("Find Previous", 112);
                this._findPrevMenuItem.addActionListener((ActionListener)this._listener.add((Object)this, (Object)this._findPrevMenuItem, "searchPrevious"));
                this._findPrevMenuItem.setAccelerator(KeyStroke.getKeyStroke(115, 0));
                this._popupMenu.add(this._findPrevMenuItem);
                this._gotoLineMenuItem = new JMenuItem("Goto Line", 103);
                this._gotoLineMenuItem.addActionListener((ActionListener)this._listener.add((Object)this, (Object)this._gotoLineMenuItem, "gotoLineNumber"));
                this._gotoLineMenuItem.setAccelerator(KeyStroke.getKeyStroke(71, 2, false));
                this._popupMenu.addSeparator();
                this._popupMenu.add(this._gotoLineMenuItem);
            }
            boolean enabled = this.getSelectedText() != null;
            this._copyMenuItem.setEnabled(enabled);
            this._cutMenuItem.setEnabled(enabled);
            enabled = this.isEditable();
            if (!enabled) {
                this._cutMenuItem.setEnabled(false);
                this._pasteMenuItem.setEnabled(false);
            }
            this._popupMenu.show((Component)((Object)this), p.x, p.y);
        }

        public boolean isModified() {
            return this._modified;
        }

        public void setModified(boolean b) {
            this._modified = b;
            if (b && this.forwardModifiedEvents()) {
                RMAUtil.setParentModified((Component)((Object)this));
            }
        }

        public boolean forwardModifiedEvents() {
            return this._forwardModifiedEvents;
        }

        public void setFowardModifiedEvents(boolean b) {
            this._forwardModifiedEvents = b;
        }

        public void setIsEditable(boolean b) {
            if (this._modifiable) {
                this.setEditable(b);
            }
        }

        public void setModifiable(boolean b) {
            this._modifiable = b;
        }

        public boolean isModifiable() {
            return this._modifiable;
        }

        public void clearPerformed() {
            this.setText("");
        }

        public void displayFindDialog() {
            Window w = SwingUtilities.windowForComponent((Component)((Object)this));
            FindListener fl = new FindListener(){

                public boolean selectFirstRecord(String match, boolean wrap, boolean wholeWord, boolean caseSensitive) {
                    SearchContext context = new SearchContext(match);
                    context.setMatchCase(caseSensitive);
                    context.setWholeWord(wholeWord);
                    context.setSearchForward(true);
                    SearchResult result = SearchEngine.find((JTextArea)((Object)AbstractScriptEditor.this._scriptText), (SearchContext)context);
                    if (!result.wasFound() && wrap) {
                        AbstractScriptEditor.this._scriptText.setCaretPosition(0);
                        result = SearchEngine.find((JTextArea)((Object)AbstractScriptEditor.this._scriptText), (SearchContext)context);
                    }
                    return result.wasFound();
                }

                public boolean selectLastRecord(String match, boolean wholeWord, boolean caseSensitive) {
                    SearchContext context = new SearchContext(match);
                    context.setMatchCase(caseSensitive);
                    context.setWholeWord(wholeWord);
                    context.setSearchForward(false);
                    SearchResult result = SearchEngine.find((JTextArea)((Object)AbstractScriptEditor.this._scriptText), (SearchContext)context);
                    return result.wasFound();
                }
            };
            if (w instanceof JDialog) {
                AbstractScriptEditor.this._findDlg = new FindDialog((Dialog)((JDialog)w), fl);
            } else if (w instanceof Frame) {
                AbstractScriptEditor.this._findDlg = new FindDialog((Frame)((JFrame)w), fl);
            } else {
                return;
            }
            AbstractScriptEditor.this._findDlg.setSearchText(AbstractScriptEditor.this._scriptText.getSelectedText());
            AbstractScriptEditor.this._findDlg.pack();
            AbstractScriptEditor.this._findDlg.setLocationRelativeTo((Component)((Object)AbstractScriptEditor.this._scriptText));
            AbstractScriptEditor.this._findDlg.setVisible(true);
        }

        public void searchNext() {
            if (AbstractScriptEditor.this._findDlg == null) {
                JOptionPane.showMessageDialog((Component)((Object)this), "Nothing to find");
                return;
            }
            String match = AbstractScriptEditor.this._findDlg.getSearchText();
            boolean caseSensitive = AbstractScriptEditor.this._findDlg.isCaseSensitiveSearch();
            boolean wholeWord = AbstractScriptEditor.this._findDlg.isWholeWordSearch();
            SearchContext context = new SearchContext(match);
            context.setMatchCase(caseSensitive);
            context.setWholeWord(wholeWord);
            context.setSearchForward(true);
            SearchResult result = SearchEngine.find((JTextArea)((Object)AbstractScriptEditor.this._scriptText), (SearchContext)context);
        }

        public void searchPrevious() {
            if (AbstractScriptEditor.this._findDlg == null) {
                return;
            }
            String match = AbstractScriptEditor.this._findDlg.getSearchText();
            boolean caseSensitive = AbstractScriptEditor.this._findDlg.isCaseSensitiveSearch();
            boolean wholeWord = AbstractScriptEditor.this._findDlg.isWholeWordSearch();
            SearchContext context = new SearchContext(match);
            context.setMatchCase(caseSensitive);
            context.setWholeWord(wholeWord);
            context.setSearchForward(true);
            SearchResult result = SearchEngine.find((JTextArea)((Object)AbstractScriptEditor.this._scriptText), (SearchContext)context);
        }

        public void gotoLineNumber() {
            int lineNumber = 0;
            try {
                lineNumber = Integer.parseInt(JOptionPane.showInputDialog("Enter line number"));
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.gotoLineNumber(lineNumber);
        }

        public void gotoLineNumber(int lineNumber) {
            try {
                int startOffs = this.getLineStartOffset(lineNumber);
                this.setCaretPosition(startOffs);
            }
            catch (BadLocationException e1) {
                JOptionPane.showMessageDialog((Component)((Object)AbstractScriptEditor.this), "Line number must be in range of 1 .. " + this.getLineCount(), "Invalid Line Number", 0);
            }
        }
    }

    public class FolderNode
    extends DefaultMutableTreeNode {
        public FolderNode(Object obj) {
            super(obj, true);
        }

        @Override
        public boolean isLeaf() {
            return false;
        }
    }

    public class TabFixTextAreaUI
    extends BasicTextAreaUI {
        @Override
        protected void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals("tabSize")) {
                this.modelChanged();
            } else {
                super.propertyChange(evt);
            }
        }
    }

    protected static class DummyGutter
    extends JPanel
    implements ChangeListener {
        protected JTextArea _textArea;

        public DummyGutter(JTextArea textArea) {
            this._textArea = textArea;
        }

        @Override
        public void stateChanged(ChangeEvent changeevent) {
            this.getPreferredSize();
            int i = this._textArea.getHeight();
            this.setPreferredSize(new Dimension(35, i));
            this.revalidate();
        }
    }
}

