/*
 * Decompiled with CFR 0.152.
 */
package hec.clientapp.script;

import hec.clientapp.client.ClientApp;
import hec.clientapp.client.ClientWorkspace;
import hec.lang.Action;
import hec.lang.ClientAppCheck;
import hec.script.ScriptIdentifier;
import hec.script.ScriptManager;

public class ScriptAction
implements Action {
    public static final int SCRIPT_UPDATED_ACTION = 0;
    public static final int SCRIPT_ADDED_ACTION = 1;
    public static final int SCRIPT_DELETED_ACTION = 2;
    private static final int FIRST_ACTION = 0;
    private static final int LAST_ACTION = 2;
    private int _action;
    private String _wkspPath;

    public ScriptAction(int actionType, String wkspPath) {
        if (this._action < 0 || this._action > 2) {
            throw new IllegalArgumentException("ScriptAction: unknown Action type " + actionType);
        }
        if (wkspPath == null) {
            throw new NullPointerException("Watershed path can not be null");
        }
        this._wkspPath = wkspPath;
        this._action = actionType;
    }

    public void performAction(Object arg) {
        if (!(arg instanceof ScriptIdentifier)) {
            return;
        }
        if (!ClientAppCheck.haveClientApp()) {
            return;
        }
        ClientApp.app();
        ClientWorkspace wksp = ClientApp.Workspace();
        if (wksp == null) {
            return;
        }
        if (!this._wkspPath.equals(wksp.getWorkspacePath())) {
            return;
        }
        ScriptIdentifier sid = (ScriptIdentifier)arg;
        ScriptManager sm = wksp.getScriptManager();
        if (sm == null) {
            return;
        }
        switch (this._action) {
            case 0: {
                sm.reloadScript(sid);
                break;
            }
            case 1: {
                sm.scriptAdded(sid);
                break;
            }
            case 2: {
                sm.deleteScript(sid, false);
            }
        }
    }
}

