/*
 * Decompiled with CFR 0.152.
 */
package hec.clientapp.script;

import hec.clientapp.client.ClientApp;
import hec.clientapp.client.ClientMode;
import hec.clientapp.client.HecClientFrame;
import hec.clientapp.client.RemoteFileChooser;
import hec.clientapp.properties.HECGlobalProperties;
import hec.clientapp.script.AbstractScriptEditor;
import hec.event.ConfigChangeListener;
import hec.io.HecFile;
import hec.io.Identifier;
import hec.script.ScriptConstants;
import hec.script.ScriptIdentifier;
import hec.script.ScriptManager;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.io.BufferedReader;
import java.io.IOException;
import javax.swing.JOptionPane;
import javax.swing.UIManager;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import mil.army.usace.hec.rmi.client.RmiFileDialog;
import rma.swing.event.ReflectMultiListener;
import rma.util.RMAIO;

public class ScriptEditorDialog
extends AbstractScriptEditor
implements ScriptConstants,
ConfigChangeListener {
    private ReflectMultiListener _listener;

    public ScriptEditorDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this._scriptText.setUI(new AbstractScriptEditor.TabFixTextAreaUI());
        this.init();
    }

    private void init() {
        int tabSize;
        String tabSizeStr;
        String windowSize;
        int y;
        int x;
        String backColorProp;
        Font f;
        Color backColor = null;
        Color foreColor = null;
        Font textFont = null;
        HECGlobalProperties props = ClientApp.app().getGlobalProperties();
        String fontProp = props.getProp("scriptEditor.font");
        textFont = UIManager.getFont("TextField.font");
        if (fontProp != null && (f = Font.decode(fontProp)) != null) {
            textFont = f;
        }
        backColor = (backColorProp = props.getProp("scriptEditor.background")) == null ? Color.white : new Color(RMAIO.parseInt((String)backColorProp));
        String foreColorProp = props.getProp("scriptEditor.foreground");
        foreColor = foreColorProp == null ? UIManager.getColor("TextArea.foreground") : new Color(RMAIO.parseInt((String)foreColorProp));
        if (backColor != null) {
            this._scriptText.setBackground(backColor);
            this._descriptionText.setBackground(backColor);
        }
        if (foreColor != null) {
            this._scriptText.setForeground(foreColor);
            this._descriptionText.setForeground(foreColor);
        }
        if (textFont != null) {
            this._scriptText.setFont(textFont);
            this._descriptionText.setFont(textFont);
        }
        Dimension size = Toolkit.getDefaultToolkit().getScreenSize();
        Rectangle screenSize = new Rectangle(size);
        String loc = props.getProp("scriptEditor.position");
        if (loc != null && screenSize.contains(x = RMAIO.parseInt((String)RMAIO.getType((String)loc, (String)","), (int)0), y = RMAIO.parseInt((String)RMAIO.getParam((String)loc, (String)","), (int)0))) {
            this.setLocation(x, y);
        }
        if ((windowSize = props.getProp("scriptEditor.size")) != null) {
            int height;
            int width = (int)RMAIO.parseDouble((String)RMAIO.getType((String)windowSize, (String)","), (double)-1.0);
            if (!screenSize.contains(new Rectangle(width, height = (int)RMAIO.parseDouble((String)RMAIO.getParam((String)windowSize, (String)","), (double)-1.0)))) {
                return;
            }
            if (width > -1 && height > -1) {
                this.setSize(width, height);
            }
        }
        if ((tabSizeStr = props.getProp("scriptEditor.tabsize")) != null && (tabSize = RMAIO.parseInt((String)tabSizeStr, (int)-1)) != -1) {
            this._scriptText.setTabSize(tabSize);
            this._scriptText.updateUI();
        }
    }

    @Override
    protected void saveForegroundColor(String color) {
        HECGlobalProperties props = ClientApp.app().getGlobalProperties();
        props.setProp("scriptEditor.foreground", color);
    }

    @Override
    protected void saveBackgroundColor(String color) {
        HECGlobalProperties props = ClientApp.app().getGlobalProperties();
        props.setProp("scriptEditor.background", color);
    }

    @Override
    protected void saveFont(String font) {
        HECGlobalProperties props = ClientApp.app().getGlobalProperties();
        props.setProp("scriptEditor.font", font);
    }

    @Override
    protected void saveTabSize(int tabsize) {
        HECGlobalProperties props = ClientApp.app().getGlobalProperties();
        props.setProp("scriptEditor.tabsize", String.valueOf(tabsize));
    }

    @Override
    protected void saveSizeAndLocation() {
        Point p = this.getLocation();
        Dimension d = this.getSize();
        HECGlobalProperties props = ClientApp.app().getGlobalProperties();
        props.setProp("scriptEditor.position", p.x + "," + p.y);
        props.setProp("scriptEditor.size", d.getWidth() + "," + d.getHeight());
    }

    @Override
    protected void fillFolderNodes() {
        ClientApp.app();
        String wkspName = ClientApp.Workspace().getTitleName();
        AbstractScriptEditor.FolderNode wkspnode = new AbstractScriptEditor.FolderNode(wkspName);
        System.out.println(wkspnode.toString());
        AbstractScriptEditor.FolderNode allModuleNode = new AbstractScriptEditor.FolderNode("Modules");
        wkspnode.add(allModuleNode);
        AbstractScriptEditor.FolderNode globalAllModuleNode = new AbstractScriptEditor.FolderNode("Modules");
        ClientApp.app();
        HecClientFrame frame = ClientApp.frame();
        String[] modeNames = frame.getModeNames();
        for (int i = 0; i < modeNames.length; ++i) {
            AbstractScriptEditor.FolderNode modeNode = new AbstractScriptEditor.FolderNode(modeNames[i]);
            globalAllModuleNode.add(modeNode);
            modeNode = new AbstractScriptEditor.FolderNode(modeNames[i]);
            allModuleNode.add(modeNode);
            ClientMode clientMode = frame.getModeByName(modeNames[i]);
            if (clientMode == null) continue;
            this.addScriptableObjects(modeNode, clientMode);
        }
        DefaultMutableTreeNode parentNode = ((AbstractScriptEditor.ScriptTreeModel)this.tree.getModel()).findNode("Current Watershed");
        parentNode.add(wkspnode);
        parentNode = ((AbstractScriptEditor.ScriptTreeModel)this.tree.getModel()).findNode("All Watersheds");
        parentNode.add(globalAllModuleNode);
    }

    @Override
    protected String getFileName(String name) {
        if (this._overrodeScriptFile) {
            return this._fileNameText.getText();
        }
        ClientApp.app();
        String path = ClientApp.Workspace().getScriptManager().getPathFromTreePath(this.getModulePath());
        path = path.concat(RMAIO.userNameToFileName((String)name));
        if (!path.endsWith(".py")) {
            path = path.concat(".py");
        }
        return path;
    }

    @Override
    protected ScriptManager getScriptManager() {
        ClientApp.app();
        return ClientApp.Workspace().getScriptManager();
    }

    @Override
    protected boolean lockScriptFile(boolean lock, String path) {
        ScriptManager sm = this.getScriptManager();
        if (this._lockedPath != null || !lock) {
            sm.lockScriptFile(false, this._lockedPath);
            this._lockedPath = null;
        }
        if (lock) {
            if (this._lockedPath != null && this._lockedPath.equals(path)) {
                return true;
            }
            if (sm.lockScriptFile(lock, path)) {
                this._lockedPath = path;
                this._lockedField.setText(lock ? "Locked" : "");
                return true;
            }
            String lockedBy = sm.checkLockedBy(path);
            this.msgOut("se: script " + path + " locked by " + lockedBy);
            if (lockedBy != null && !lockedBy.equals("") && !lockedBy.equals("Unknown")) {
                if (lockedBy.equals(ClientApp.app().getUser())) {
                    this._lockedField.setText(lock ? "Locked" : "");
                    return true;
                }
                JOptionPane.showMessageDialog((Component)((Object)this), "The script file is currently locked by " + lockedBy);
                this._lockedField.setText("");
                return false;
            }
        }
        this._lockedField.setText(lock ? "Locked" : "");
        return true;
    }

    @Override
    public void importScript() {
        TreePath tpath = this.tree.getSelectionPath();
        if (tpath == null) {
            JOptionPane.showMessageDialog((Component)((Object)this), "Please select a location to import to", "No Location", 1);
            return;
        }
        RmiFileDialog fd = new RmiFileDialog((Frame)((Object)this), true);
        fd.setVisible(true);
        this.repaint();
        if (fd.isCanceled()) {
            return;
        }
        Identifier id = fd.getIdentifier();
        if (id == null) {
            return;
        }
        ClientApp.app();
        Identifier openedId = ClientApp.Workspace().openRemoteFileID(id);
        if (openedId == null) {
            System.out.println("se:importScript: failed to open " + id.getPath());
            return;
        }
        String name = RMAIO.getFileNameNoExtension((String)openedId.getPath());
        String fileName = this.getFileName(name);
        ScriptIdentifier sid = new ScriptIdentifier(name, name, "Imported File", fileName, this.getModulePath(tpath), null, true, false);
        Identifier newScriptFileId = new Identifier(fileName);
        ClientApp.app();
        Identifier id2 = ClientApp.Workspace().openRemoteFileID(newScriptFileId);
        if (id2 != null) {
            JOptionPane.showMessageDialog((Component)((Object)this), "<html>The Script <br><font=+0 color=blue>" + id2.getPath() + "</font><br> already exists</html>", "Duplicate Script", 2);
            return;
        }
        ClientApp.app();
        id2 = ClientApp.Workspace().newRemoteFileID(newScriptFileId);
        if (id2 == null) {
            JOptionPane.showMessageDialog((Component)((Object)this), "<html>Failed to create file <br><font=+0 color=blue>" + newScriptFileId.getPath() + "</font></html>", "Create Script Failed", 0);
            return;
        }
        DefaultMutableTreeNode newNode = new DefaultMutableTreeNode(sid, false);
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)tpath.getLastPathComponent();
        node.add(newNode);
        int i = node.getIndex(newNode);
        ((DefaultTreeModel)this.tree.getModel()).nodesWereInserted(node, new int[]{i});
        TreePath path = new TreePath(newNode.getPath());
        this.tree.setSelectionPath(path);
        if (!this.setEditScript(true)) {
            System.out.println("se:importScript: newScript failed");
            return;
        }
        HecFile file = openedId.getFile();
        if (file == null) {
            System.out.println("se:importScript: no file attached to opened identifier");
            return;
        }
        try {
            BufferedReader reader = file.getBufferedReader();
            this._scriptText.read(reader, null);
            reader.close();
            name = openedId.getName();
            this._scriptNameText.setText(name);
            this._fileNameText.setText(sid.getFileName());
            this._labelDisplayText.setText(name);
            this._scriptNameText.requestFocus();
        }
        catch (IOException ioe) {
            System.out.println("se:importScript: IO Error reading " + openedId.getPath() + " error:" + ioe);
        }
        this.setEditPanelEnabled(true);
    }

    @Override
    protected void selectScript(TreePath path) {
        Identifier id;
        HecFile file;
        Object directory;
        String modulePath;
        if (this._browseDialog == null) {
            this._browseDialog = new RemoteFileChooser((Frame)((Object)this));
        }
        if ((modulePath = this.getModulePath(path)).indexOf("All Watersheds") > -1) {
            directory = ClientApp.app().getAppStartDir();
        } else {
            ClientApp.app();
            directory = ClientApp.Workspace().getWorkspacePath();
        }
        directory = (String)directory + "/scripts";
        ClientApp.app();
        this._browseDialog.setWorkspace(ClientApp.Workspace());
        this._browseDialog.setMode(0);
        this._browseDialog.setTitle("Open Script File");
        this._browseDialog.setFile("*.py");
        this._browseDialog.setPath((String)directory);
        this._browseDialog.setVisible(true);
        if (this._browseDialog.ok() && (file = (id = this._browseDialog.getIdentifier()).getFile()) != null) {
            try {
                BufferedReader reader = file.getBufferedReader();
                this._scriptText.read(reader, null);
                this._overrodeScriptFile = true;
                this._fileNameText.setText(file.getName());
                reader.close();
            }
            catch (IOException ioe) {
                System.out.println("se:selectScript: io error reading " + id.getPath() + " error " + ioe);
                return;
            }
        }
    }
}

