/*
 * Decompiled with CFR 0.152.
 */
package hec.clientapp.script;

import hec.clientapp.client.ClientApp;
import hec.clientapp.client.ClientMode;
import hec.clientapp.script.ScriptEditorDialog;
import hec.clientapp.script.ScriptJobStatusJFrame;
import hec.clientapp.script.ScriptManagerImpl;
import hec.clientapp.script.ScriptSchedulerJDialog;
import hec.script.Script;
import hec.script.ScriptEngine;
import hec.script.ScriptIdentifier;
import hec.script.ScriptJButton;
import hec.script.ScriptManager;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import rma.swing.RmaInsets;
import rma.util.RMAIO;

public class ScriptJPanel
extends JPanel {
    protected ActionListener _buttonAl;
    protected MouseAdapter _buttonMl;
    protected int _maxButtonsPerColumn = RMAIO.parseInt((String)System.getProperty("scriptFrame.buttonsPerColumn", "10"), (int)10);
    protected boolean _popupEnabled = true;
    protected ScriptSchedulerJDialog _scheduleDialog;
    protected ScriptJobStatusJFrame _statusFrame;
    protected ScriptEditorDialog _editorFrame;
    protected JScrollPane _scrollPane = null;
    protected Border _border = null;

    public ScriptJPanel() {
        super(new GridBagLayout());
        this._buttonAl = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object obj = e.getSource();
                if (!(obj instanceof ScriptJButton)) {
                    return;
                }
                ScriptIdentifier id = ((ScriptJButton)obj).getScriptIdentifier();
                if (id == null) {
                    System.out.println("sb:Null ScriptIdentifier for button labeled " + ((ScriptJButton)obj).getText());
                    return;
                }
                Script s = ScriptJPanel.this.getScriptManager().getScript(id);
                if (s == null) {
                    return;
                }
                ScriptEngine.engine().execute(s, id.getUserDisplayedName(), id.getName());
            }
        };
        this._buttonMl = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.isPopupTrigger() || SwingUtilities.isRightMouseButton(e)) {
                    Component c = e.getComponent();
                    if (!(c instanceof JButton)) {
                        return;
                    }
                    JButton button = (JButton)c;
                    ScriptJPanel.this.getRootPane().setDefaultButton(button);
                    JPopupMenu menu = new JPopupMenu();
                    JMenuItem item = new JMenuItem("Edit");
                    menu.add(item);
                    item.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            ScriptJPanel.this.editScript();
                        }
                    });
                    item = new JMenuItem("Delete");
                    item.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            ScriptJPanel.this.deleteScript();
                        }
                    });
                    menu.add(item);
                    menu.addSeparator();
                    item = new JMenuItem("Schedule Script Job...");
                    item.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            ScriptJPanel.this.scheduleJob(true);
                        }
                    });
                    menu.add(item);
                    if (ScriptManagerImpl.debug()) {
                        item = new JMenuItem("Info");
                        item.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                ScriptJPanel.this.scriptInfo();
                            }
                        });
                        menu.add(item);
                    }
                    menu.show(button, e.getX(), e.getY());
                }
            }
        };
    }

    ScriptManager getScriptManager() {
        ClientApp.app();
        return ClientApp.Workspace().getScriptManager();
    }

    public void setPopupMenuEnabled(boolean b) {
        this._popupEnabled = b;
    }

    public void setMaxButtonsPerColumn(int max) {
        this._maxButtonsPerColumn = max;
    }

    public void setScriptIdentifiers(Vector scriptIds) {
        this.updateScriptButtons(scriptIds);
    }

    public void updateScriptButtons(Vector v) {
        int size;
        this.setCursor(Cursor.getPredefinedCursor(3));
        Component[] comps = this.getComponents();
        for (int i = 0; i < comps.length; ++i) {
            if (!(comps[i] instanceof ScriptJButton)) continue;
            ((ScriptJButton)comps[i]).removeActionListener(this._buttonAl);
            ((ScriptJButton)comps[i]).removeMouseListener((MouseListener)this._buttonMl);
        }
        this.removeAll();
        this.revalidate();
        this.repaint();
        if (v == null || (size = v.size()) < 1) {
            this.setCursor(Cursor.getDefaultCursor());
            return;
        }
        int row = 0;
        int col = 0;
        Insets insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)0);
        for (int i = 0; i < size; ++i) {
            ScriptIdentifier sid;
            if (v.elementAt(i) == null || !(sid = (ScriptIdentifier)v.elementAt(i)).isDisplayedInSelector()) continue;
            ScriptJButton button = new ScriptJButton(sid);
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = col;
            gbc.gridy = -1;
            ++row;
            gbc.insets = insets;
            gbc.anchor = 10;
            gbc.fill = 2;
            gbc.weighty = 1.0;
            if (i == size - 1) {
                gbc.weighty = 1.0;
            }
            this.add((Component)button, gbc);
            button.addActionListener(this._buttonAl);
            if (this._popupEnabled) {
                button.addMouseListener((MouseListener)this._buttonMl);
            }
            if (row < this._maxButtonsPerColumn) continue;
            ++col;
            row = 0;
        }
        this.setActiveBorder();
        this.revalidate();
        this.setCursor(Cursor.getDefaultCursor());
        this.invalidate();
        this.validate();
        this.repaint();
    }

    public JScrollPane getScrollPane() {
        if (this._scrollPane == null) {
            this._scrollPane = new JScrollPane(this);
            this._scrollPane.setBorder(null);
        }
        return this._scrollPane;
    }

    protected void setActiveBorder() {
        if (this._border != null) {
            if (this._scrollPane != null) {
                this._scrollPane.setBorder(this._border);
            } else {
                super.setBorder(this._border);
            }
        }
    }

    protected void scriptInfo() {
        ScriptJButton button = (ScriptJButton)this.getRootPane().getDefaultButton();
        if (button == null) {
            return;
        }
        ScriptIdentifier sid = button.getScriptIdentifier();
        if (sid == null) {
            return;
        }
        System.out.println("Info for button for " + sid.getUserDisplayedName());
        System.out.println("\tname=" + sid.getName());
        System.out.println("\tDescription=" + sid.getDescription());
        System.out.println("\tscriptID=" + sid.getScriptId());
        System.out.println("\tfileName=" + sid.getFileName());
        System.out.println("\tfileName overridden=" + sid.getFileNameOverridden());
        System.out.println("\tmodulePath=" + sid.getModulePath());
    }

    public void setBorderWhenActive(Border border) {
        this._border = border;
    }

    public void scheduleJob(boolean fromButton) {
        JButton button;
        if (this._scheduleDialog == null) {
            this._scheduleDialog = new ScriptSchedulerJDialog(this.getFrame(), true);
        }
        this._scheduleDialog.fillForm();
        if (fromButton && (button = this.getRootPane().getDefaultButton()) != null) {
            ScriptJButton sb = (ScriptJButton)button;
            ScriptIdentifier si = sb.getScriptIdentifier();
            this._scheduleDialog.setSelectedScript(si);
        }
        this._scheduleDialog.setVisible(true);
        this.repaint();
    }

    private void deleteScript() {
        ScriptJButton button = (ScriptJButton)this.getRootPane().getDefaultButton();
        if (button == null || !(button instanceof ScriptJButton)) {
            return;
        }
        int ok = JOptionPane.showConfirmDialog(this, "Ok to delete button " + button.getText());
        if (ok == 0) {
            ScriptManager sm = this.getScriptManager();
            if (sm.deleteScript(button.getScriptIdentifier())) {
                this.remove((Component)button);
                this.revalidate();
            }
        } else {
            this.repaint();
        }
    }

    private void editScript() {
        ClientMode mode;
        JButton button = this.getRootPane().getDefaultButton();
        if (button == null || !(button instanceof ScriptJButton)) {
            return;
        }
        ScriptJButton sb = (ScriptJButton)button;
        ScriptIdentifier si = sb.getScriptIdentifier();
        if (this._editorFrame == null) {
            this._editorFrame = new ScriptEditorDialog(this.getFrame(), true);
        }
        this._editorFrame.clearForm();
        if (si != null) {
            ClientApp.app();
            mode = ClientApp.frame().getCurrentMode();
            this._editorFrame.setSelectedNode(si);
        }
        this._editorFrame.setVisible(true);
        this.repaint();
        ClientApp.app();
        mode = ClientApp.frame().getCurrentMode();
        String s = mode.getScriptableName();
        Vector v = this.getScriptManager().getScriptIdsForMode(s);
        this.updateScriptButtons(v);
    }

    public void jobStatus() {
        if (this._statusFrame == null) {
            this._statusFrame = new ScriptJobStatusJFrame();
        }
        this._statusFrame.setNetworked(ClientApp.app().networked);
        this._statusFrame.fillForm();
        this._statusFrame.setVisible(true);
        this.repaint();
    }

    private Frame getFrame() {
        Window w = SwingUtilities.windowForComponent(this);
        ClientApp.app();
        Object f = ClientApp.frame();
        if (w instanceof Frame) {
            f = (Frame)w;
        }
        return f;
    }
}

