/*
 * Decompiled with CFR 0.152.
 */
package hec.clientapp.script;

import hec.clientapp.client.ClientApp;
import hec.clientapp.client.ClientScheduler;
import hec.clientapp.client.RemoteFileChooser;
import hec.clientapp.client.RmiTextFileReaderJDialog;
import hec.io.Identifier;
import hec.model.JobTask;
import hec.script.ScriptJob;
import hec.script.ScriptTaskInfoJDialog;
import hec.script.ServerScriptJobTask;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.rmi.RemoteException;
import java.util.Date;
import java.util.Vector;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import mil.army.usace.hec.rmi.csinterface.RMIScheduler;
import rma.swing.RmaInsets;
import rma.swing.RmaJFrame;
import rma.swing.RmaJTable;

public class ScriptJobStatusJFrame
extends RmaJFrame {
    public static final String TITLE = "Script Job Status";
    public static final String NA = "N/A";
    private Vector _jobs = null;
    private ScriptTaskInfoJDialog _infoDialog = null;
    private RMIScheduler _rmiScheduler = null;
    private boolean _networked = false;
    RmaJTable statusTable;
    JMenuItem serverLogMenuItem;
    JMenuItem deleteMenuItem;
    JMenuItem clearMenuItem;

    public ScriptJobStatusJFrame() {
        this.buildControls();
    }

    private void buildControls() {
        this.setTitle(TITLE);
        this.getContentPane().setLayout(new GridBagLayout());
        Object[] headers = new String[]{"Job\nName", "Script", "User", "Status", "Interval", "Location", "Date/\nTime"};
        this.statusTable = new RmaJTable((Component)((Object)this), headers);
        this.statusTable.setMlHeaderRenderer();
        this.statusTable.setColumnSelectionAllowed(false);
        this.statusTable.setCellSelectionEnabled(false);
        this.statusTable.setRowSelectionAllowed(true);
        this.statusTable.setEnabled(false);
        this.statusTable.setAddRemoveEnabled(false);
        this.statusTable.setSelectionMode(0);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)5, (int)5);
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        this.getContentPane().add((Component)this.statusTable.getScrollPane(), gbc);
        JMenuBar menuBar = new JMenuBar();
        JMenu menu = new JMenu("Status");
        menu.setMnemonic('s');
        JMenuItem menuItem = new JMenuItem("Close", 99);
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ScriptJobStatusJFrame.this.setVisible(false);
            }
        });
        menu.add(menuItem);
        menuBar.add(menu);
        menu = new JMenu("Job");
        menu.setMnemonic('j');
        this.deleteMenuItem = new JMenuItem("Delete", 100);
        this.deleteMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ScriptJobStatusJFrame.this.deleteJob();
            }
        });
        menu.add(this.deleteMenuItem);
        this.deleteMenuItem.setEnabled(false);
        menuBar.add(menu);
        this.clearMenuItem = new JMenuItem("Clear", 99);
        this.clearMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ScriptJobStatusJFrame.this.deleteJob();
            }
        });
        menu.add(this.clearMenuItem);
        this.clearMenuItem.setEnabled(false);
        menuBar.add(menu);
        menu = new JMenu("View");
        menu.setMnemonic('v');
        menuItem = new JMenuItem("Refresh", 114);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(116, 0, false));
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ScriptJobStatusJFrame.this.fillForm();
            }
        });
        menu.add(menuItem);
        menu.addSeparator();
        if (ClientApp.app() != null) {
            JMenu subMenu = new JMenu("LogFiles");
            subMenu.setMnemonic('l');
            menu.add(subMenu);
            menuItem = new JMenuItem("Client", 99);
            menuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ScriptJobStatusJFrame.this.viewLogs(false);
                }
            });
            subMenu.add(menuItem);
            this.serverLogMenuItem = new JMenuItem("Server", 115);
            this.serverLogMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ScriptJobStatusJFrame.this.viewLogs(true);
                }
            });
            this.serverLogMenuItem.setEnabled(false);
            subMenu.add(this.serverLogMenuItem);
        }
        menuBar.add(menu);
        this.setJMenuBar(menuBar);
        this.setSize(450, 250);
        this.setLocation();
        this.statusTable.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    ScriptJobStatusJFrame.this.displayInfoDialog();
                }
            }
        });
        this.statusTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                int row = ScriptJobStatusJFrame.this.statusTable.getSelectedRow();
                if (row < 0) {
                    ScriptJobStatusJFrame.this.deleteMenuItem.setEnabled(false);
                    ScriptJobStatusJFrame.this.clearMenuItem.setEnabled(false);
                    return;
                }
                String status = ScriptJobStatusJFrame.this.statusTable.getCell(row, 4).toString();
                String dateTime = ScriptJobStatusJFrame.this.statusTable.getCell(row, 6).toString();
                if (status.equals("SINGLE") & dateTime.equals(ScriptJobStatusJFrame.NA)) {
                    ScriptJobStatusJFrame.this.deleteMenuItem.setEnabled(false);
                    ScriptJobStatusJFrame.this.clearMenuItem.setEnabled(true);
                } else {
                    ScriptJobStatusJFrame.this.deleteMenuItem.setEnabled(true);
                    ScriptJobStatusJFrame.this.clearMenuItem.setEnabled(false);
                }
            }
        });
    }

    public void setNetworked(boolean b) {
        this._networked = b;
        this.serverLogMenuItem.setEnabled(b);
    }

    public void fillForm() {
        this.deleteMenuItem.setEnabled(false);
        this.clearMenuItem.setEnabled(false);
        if (this._rmiScheduler == null) {
            this.fillForm(ClientApp.app().getScheduler());
        } else {
            this.fillForm(this._rmiScheduler);
        }
    }

    protected void fillForm(RMIScheduler scheduler) {
        Vector jobs = null;
        try {
            jobs = scheduler.jobsStatus();
        }
        catch (RemoteException re) {
            System.out.println("Failed to get jobs from RMIScheduler " + re);
            return;
        }
        this.fillForm(jobs);
    }

    protected void fillForm(ClientScheduler scheduler) {
        Vector jobs = scheduler.jobsStatus();
        this.fillForm(jobs);
    }

    private void fillForm(Vector jobs) {
        this.clearForm();
        this._jobs = jobs;
        if (jobs == null) {
            return;
        }
        int size = jobs.size();
        this.statusTable.deleteCells();
        for (int i = 0; i < size; ++i) {
            JobTask task;
            Object obj = jobs.elementAt(i);
            if (!(obj instanceof JobTask) || !((task = (JobTask)obj).getJob() instanceof ScriptJob)) continue;
            ScriptJob job = (ScriptJob)task.getJob();
            Vector<String> row = new Vector<String>(7);
            row.addElement(task.getName());
            row.addElement(job.getScriptName());
            row.addElement(job.getUser());
            row.addElement(task.getStatus());
            row.addElement(job.getIntervalString());
            if (task instanceof ServerScriptJobTask) {
                row.addElement("Server");
            } else {
                row.addElement("Client");
            }
            if (job.getIntervalString().equals("SINGLE") && task.getLastRunTime() > 0L) {
                row.addElement(NA);
            } else if (task.getLastRunTime() <= 0L) {
                Date dt = job.getStartDate();
                if (dt != null) {
                    row.addElement(new Date(dt.getTime()).toString());
                } else {
                    row.addElement("Unknown");
                }
            } else {
                row.addElement(new Date(task.getLastRunTime() + job.getPeriod()).toString());
            }
            this.statusTable.appendRow(row);
        }
    }

    public void deleteJob() {
        int row = this.statusTable.getSelectedRow();
        if (row < 0) {
            return;
        }
        String jobName = this.statusTable.getCell(row, 0).toString();
        int opt = JOptionPane.showConfirmDialog((Component)((Object)this), "Confirm deletion of Script Job " + jobName, "Confirm delete", 0);
        if (opt != 0) {
            return;
        }
        System.out.println("deleteJob: asked to remove jobName " + jobName);
        if (this._rmiScheduler != null) {
            try {
                if (this._rmiScheduler.deleteJob(jobName)) {
                    JOptionPane.showMessageDialog((Component)((Object)this), "Job " + jobName + " removed.", "Removal Successful", 1);
                    this.fillForm();
                } else {
                    JOptionPane.showMessageDialog((Component)((Object)this), "Failed to remove Job " + jobName, "Error", 0);
                }
            }
            catch (RemoteException re) {
                System.out.println("deleteJob: RMI Error removing job " + jobName + " error " + re);
                JOptionPane.showMessageDialog((Component)((Object)this), "Error removing Job " + jobName, "Error", 0);
            }
            return;
        }
        ClientScheduler scheduler = ClientApp.app().getScheduler();
        if (scheduler.deleteJob(jobName)) {
            JOptionPane.showMessageDialog((Component)((Object)this), "Job " + jobName + " deleted.", "Delete Successful", 1);
            this.fillForm();
        } else {
            JOptionPane.showMessageDialog((Component)((Object)this), "Failed to delete Job " + jobName, "Error", 0);
        }
    }

    public void displayInfoDialog() {
        int row = this.statusTable.getSelectedRow();
        if (row < 0) {
            return;
        }
        if (this._jobs == null || row >= this._jobs.size()) {
            return;
        }
        if (this._infoDialog == null) {
            this._infoDialog = new ScriptTaskInfoJDialog((Frame)((Object)this), true);
        }
        this._infoDialog.fillForm((JobTask)this._jobs.elementAt(row));
        this._infoDialog.setVisible(true);
    }

    public void viewLogs(boolean viewServer) {
        ClientScheduler scheduler = ClientApp.app().getScheduler();
        String name = null;
        String logDir = null;
        if (viewServer) {
            RMIScheduler rmiScheduler = scheduler.getRMIScheduler();
            name = "RMIScheduler";
            try {
                logDir = rmiScheduler.getLogDirectory();
            }
            catch (Exception e) {
                System.out.println("viewLogs: failed to get RMIScheduler's log directory " + e);
                return;
            }
        } else {
            name = scheduler.getName();
            logDir = scheduler.getLogDirectory();
        }
        System.out.println("viewLogs: log directory is " + logDir);
        RemoteFileChooser chooser = new RemoteFileChooser((Frame)((Object)this), true);
        chooser.setTitle("Open Scheduler Log");
        ClientApp.app();
        chooser.setWorkspace(ClientApp.Workspace());
        chooser.setMode(0);
        chooser.setPath(logDir);
        chooser.setFile(name + ".*");
        chooser.setIsRemote(viewServer);
        chooser.fillDialog();
        chooser.setVisible(true);
        this.repaint();
        if (chooser.ok()) {
            Identifier id = chooser.getIdentifier();
            if (id == null) {
                return;
            }
            RmiTextFileReaderJDialog logDisplayDialog = new RmiTextFileReaderJDialog((Frame)((Object)this), false, id.getName());
            logDisplayDialog.fillForm(id, viewServer);
            logDisplayDialog.setVisible(true);
            this.repaint();
        }
    }

    public void setRMIScheduler(RMIScheduler rmiScheduler) {
        this._rmiScheduler = rmiScheduler;
    }
}

