/*
 * Decompiled with CFR 0.152.
 */
package hec.clientapp.script;

import hec.clientapp.client.ClientApp;
import hec.clientapp.client.ClientWorkspace;
import hec.clientapp.client.HecClientFrame;
import hec.clientapp.rmi.csinterface.RmiApp;
import hec.event.ConfigChangeListener;
import hec.event.ConfigFileChangeEvent;
import hec.io.FileLock;
import hec.io.HecFile;
import hec.io.Identifier;
import hec.lang.ClientAppCheck;
import hec.lang.UserId;
import hec.script.Script;
import hec.script.ScriptConstants;
import hec.script.ScriptEngine;
import hec.script.ScriptIdentifier;
import hec.script.ScriptManager;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.rmi.RemoteException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.swing.SwingUtilities;
import mil.army.usace.hec.rmi.csinterface.RmiFileManager;
import mil.army.usace.hec.rmi.io.HecAsciiDeserializer;
import mil.army.usace.hec.rmi.io.HecAsciiSerializer;
import mil.army.usace.hec.rmi.model.PreferencesManager;
import mil.army.usace.hec.rmi.server.RmiFileManagerImpl;
import rma.util.RMAIO;
import rma.util.logging.MarkingClassLogger;
import rma.util.logging.marking.ScriptingLoggingMarker;

public class ScriptManagerImpl
implements ScriptManager,
ScriptConstants {
    private static final MarkingClassLogger SCRIPTING_LOGGER = MarkingClassLogger.forMarkingClass(ScriptingLoggingMarker.class);
    public static final String GLOBAL = "global";
    public static final String WORKSPACE = "wksp";
    HecClientFrame frame = ClientApp.frame();
    Hashtable _cache = new Hashtable();
    ClientWorkspace _wksp = null;
    RmiFileManager _fileManager;
    private Vector _listenerList = new Vector(2);
    Object _cacheDummy = new Object();
    String _localCacheDir = null;

    public static boolean debug() {
        return ((MarkingClassLogger.Api)SCRIPTING_LOGGER.atFine()).isEnabled();
    }

    public ScriptManagerImpl(ClientWorkspace wksp) {
        if (wksp == null) {
            throw new NullPointerException("ScriptManager: ClientWorkspace can not be null");
        }
        this._wksp = wksp;
        this.setFileManager();
        if (this.frame != null) {
            this.frame.getModeNames();
        }
    }

    public Script getScript(ScriptIdentifier sid) {
        Identifier fileId;
        if (sid == null) {
            throw new IllegalArgumentException("getScript: Null ScriptIdentifier");
        }
        Object obj = this._cache.get(sid);
        if (obj != null && obj != this._cacheDummy) {
            return (Script)obj;
        }
        if (this._fileManager == null) {
            this.setFileManager();
        }
        Identifier newId = this.getIdFromScriptId(sid);
        try {
            fileId = this._fileManager.openFile(ClientApp.app().getUser(), newId);
            if (fileId == null) {
                System.out.println("sm:getScript: can't find file " + newId.getFile() + " for script " + sid.getUserDisplayedName());
                return null;
            }
        }
        catch (RemoteException re) {
            System.out.println("sm:getScript: rmi error opening file with FileManager" + re);
            return null;
        }
        Script newScript = null;
        try {
            newScript = ScriptEngine.getNewScript();
        }
        catch (NoClassDefFoundError nfe) {
            System.out.println("*******************");
            System.out.println("ScriptManager: ERROR " + nfe);
            String cp = System.getProperty("java.class.path");
            if (cp.indexOf("jpython") < 0) {
                System.out.println("ERROR: No jpython.jar in classpath [" + cp + "]");
            }
            if (ScriptManagerImpl.debug()) {
                nfe.printStackTrace();
            }
            System.out.println("*******************");
        }
        if (this.loadScript(newScript, fileId)) {
            this._cache.put(sid, newScript);
            return newScript;
        }
        return null;
    }

    protected boolean loadScript(Script newScript, Identifier id, ScriptIdentifier sid) {
        if (newScript == null || id == null) {
            return false;
        }
        HecFile file = null;
        try {
            ZipEntry entry;
            file = id.getFile();
            if (file == null) {
                System.out.println("sm:loadScript: no file for id " + id.getName());
                return false;
            }
            ZipInputStream zipIn = new ZipInputStream(file.getDataInputStream());
            StringBuffer text = null;
            while ((entry = zipIn.getNextEntry()) != null) {
                String line;
                if (entry.isDirectory() || !entry.getName().equals(sid.getFileName())) continue;
                text = entry.getSize() > -1L ? new StringBuffer((int)entry.getSize()) : new StringBuffer();
                BufferedReader reader = new BufferedReader(new InputStreamReader(zipIn));
                while ((line = reader.readLine()) != null) {
                    text.append(line);
                    text.append("\n");
                }
                reader.close();
                break;
            }
            zipIn.closeEntry();
            zipIn.close();
            if (text == null) {
                System.out.println("sm:loadScript: failed to find script for " + sid.getFileName());
                return false;
            }
            newScript.setScript(text.toString());
            this.msgOut("sm:loadScript:script for " + file.getName() + " is " + newScript.getScript());
        }
        catch (IOException ioe) {
            System.out.println("sm:loadScript: IOException reading file " + file.getName());
            return false;
        }
        return true;
    }

    protected boolean loadScript(Script newScript, Identifier id) {
        if (newScript == null || id == null) {
            return false;
        }
        HecFile file = null;
        try {
            String line;
            file = id.getFile();
            if (file == null) {
                System.out.println("sm:loadScript: no file for id " + id.getName());
                return false;
            }
            BufferedReader reader = file.getBufferedReader();
            StringBuffer text = new StringBuffer((int)id.length());
            this.msgOut("Loading script " + id.getPath());
            while ((line = reader.readLine()) != null) {
                text.append(line);
                text.append("\n");
            }
            reader.close();
            newScript.setScript(text.toString());
            this.msgOut("sm:script for " + file.getName() + " is " + newScript.getScript());
        }
        catch (IOException ioe) {
            System.out.println("sm:loadScript: IOException reading file " + file.getName());
            return false;
        }
        return true;
    }

    public boolean saveScript(ScriptIdentifier sid, Script script) {
        if (sid == null) {
            throw new IllegalArgumentException("Null ScriptIdentifier");
        }
        if (script == null) {
            throw new IllegalArgumentException("Null Script");
        }
        if (this._fileManager == null) {
            this.setFileManager();
        }
        Identifier fileId = null;
        try {
            Identifier newId = this.getIdFromScriptId(sid);
            this.msgOut("sm:saveScript: saving to file " + newId.getPath());
            fileId = this._fileManager.openFile(ClientApp.app().getUser(), newId);
            if (fileId == null && (fileId = this._fileManager.newFile(ClientApp.app().getUser(), newId)) == null) {
                System.out.println("sm:saveScript: failed to get a file for " + newId.getName());
                return false;
            }
        }
        catch (RemoteException re) {
            System.out.println("sm:saveScript: rmi error talking to FileManager " + re);
            return false;
        }
        HecFile file = null;
        try {
            String line;
            file = fileId.getFile();
            if (file == null) {
                System.out.println("sm:saveScript: failed to get file from id " + sid.getName());
                return false;
            }
            this.msgOut("Saving script : " + fileId.getPath() + " contents:\n" + script.getScript());
            BufferedWriter writer = file.getBufferedWriter();
            BufferedReader reader = new BufferedReader(new StringReader(script.getScript()));
            while ((line = reader.readLine()) != null) {
                this.msgOut("writing:" + line);
                writer.write(line);
                writer.newLine();
            }
            writer.flush();
            writer.close();
            reader.close();
        }
        catch (IOException ioe) {
            System.out.println("sm:saveScript: IOException saving script to file " + file.getName());
            return false;
        }
        if (this._cache.remove(sid) == null) {
            this.msgOut("sm:saveScript: failed to remove " + sid);
        }
        this._cache.put(sid, script);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean saveScriptIds(Vector list, Identifier fileId) {
        if (fileId == null) {
            return false;
        }
        Identifier identifier = fileId;
        synchronized (identifier) {
            HecFile file = null;
            try {
                file = fileId.getFile();
                if (file == null) {
                    System.out.println("sm:saveScriptId: failed to get file from id " + fileId.getName());
                    return false;
                }
                BufferedWriter writer = file.getBufferedWriter();
                HecAsciiSerializer as = new HecAsciiSerializer(writer);
                as.serializeObject((Object)list);
                writer.close();
            }
            catch (IOException ioe) {
                System.out.println("sm:saveScriptId: IOException saving script to file " + file.getName());
                return false;
            }
        }
        return true;
    }

    public boolean flushIds() {
        return true;
    }

    private boolean flushIds(ScriptHashtable cache) {
        if (!cache.isModified()) {
            return true;
        }
        Identifier cacheId = cache.getIdentifier();
        if (cacheId == null) {
            System.out.println("sm:flushIds: null identifier for cache " + cache.getName());
            return false;
        }
        this.msgOut("sm:flushIds: writing cache " + cache.getName() + " to " + cacheId.getPath());
        Enumeration e = cache.keys();
        Vector list = new Vector(cache.size());
        while (e.hasMoreElements()) {
            Object obj = e.nextElement();
            list.addElement(obj);
        }
        cache.setReloadOk(false);
        if (this.saveScriptIds(list, cacheId)) {
            cache.setModified(false);
        }
        cache.setReloadOk(true);
        return true;
    }

    public Identifier getIdFromScriptId(ScriptIdentifier sid) {
        Object s;
        if (sid == null) {
            return null;
        }
        if (sid.getFileName() == null) {
            s = this.getPathFromTreePath(sid.getModulePath());
            s = (String)s + sid.getFileName();
        } else {
            s = sid.getFileName();
        }
        int idx = ((String)s).indexOf(" ");
        if (idx > 0 && !((String)s).startsWith("\"")) {
            s = "\"" + (String)s + "\"";
        }
        return new Identifier((String)s);
    }

    private Identifier getIdentifier(String path, String scriptIdPath) {
        if (path == null || scriptIdPath == null) {
            return null;
        }
        path = path.replace('\\', '/');
        return this.getIdentifierWithFile(new Identifier(path));
    }

    private Identifier getIdentifierWithFile(Identifier newId) {
        Identifier fileId = null;
        try {
            this.msgOut("sm:getIdentifierWithFile: file " + newId.getPath());
            fileId = this._fileManager.openFile(ClientApp.app().getUser(), newId);
            if (fileId == null && (fileId = this._fileManager.newFile(ClientApp.app().getUser(), newId)) == null) {
                System.out.println("sm:getIdentifierWithFile: failed to get a file for " + newId.getName());
                return null;
            }
        }
        catch (RemoteException re) {
            System.out.println("sm:getIdentifierWithFile: rmi error talking to FileManager " + re);
            return null;
        }
        return fileId;
    }

    public String getPathFromTreePath(String treePath) {
        if (treePath == null) {
            return null;
        }
        StringBuffer filePath = new StringBuffer();
        if (treePath.indexOf("All Watersheds") > -1) {
            filePath.append(PreferencesManager.getFileName((int)3, (String)"scripts", (boolean)false));
        } else if (treePath.indexOf("Current Watershed") > -1) {
            filePath.append(PreferencesManager.getFileName((int)2, (String)"scripts", (boolean)false));
        } else if (treePath.startsWith("ClientModule:")) {
            filePath.append(PreferencesManager.getFileName((int)3, (String)"scripts", (boolean)false));
            int idx = treePath.indexOf(":");
            if (idx > -1) {
                filePath.append("/");
                filePath.append(treePath.substring(idx + 1));
            }
        }
        if (treePath.indexOf("Modules") > -1) {
            filePath.append("/");
            filePath.append("Modules");
            if (!treePath.endsWith("Modules")) {
                filePath.append("/");
                filePath.append(RMAIO.userNameToFileName((String)RMAIO.getFileFromPath((String)treePath)));
            }
        }
        filePath.append("/");
        return filePath.toString();
    }

    public Vector getScriptIdsForMode(String moduleName) {
        StringBuffer path = new StringBuffer("Scripts");
        path.append("/");
        path.append("System");
        path.append("/");
        path.append("Current Watershed");
        path.append("/");
        path.append("Modules");
        Vector v = this.getScriptIdsForObject(path.toString());
        path.append("/");
        path.append(moduleName);
        v.addAll(this.getScriptIdsForObject(path.toString()));
        path = new StringBuffer("Scripts");
        path.append("/");
        path.append("System");
        path.append("/");
        path.append("All Watersheds");
        path.append("/");
        path.append("Modules");
        v.addAll(this.getScriptIdsForObject(path.toString()));
        path.append("/");
        path.append(moduleName);
        v.addAll(this.getScriptIdsForObject(path.toString()));
        Vector retVec = new Vector(v.size());
        this.msgOut("sm:getScriptIdsForMode: found " + v.size() + " scripts ");
        ScriptManagerImpl.buildSortedVector(v, retVec);
        this.msgOut("sm:getScriptIdsForMode: returning " + retVec.size() + " scripts ");
        return retVec;
    }

    public Vector getScriptIds(Vector paths) {
        Vector v = new Vector();
        if (paths == null || paths.size() < 1) {
            return v;
        }
        int size = paths.size();
        for (int i = 0; i < size; ++i) {
            Vector ids = this.getScriptIdsForObject(paths.elementAt(i).toString());
            if (ids == null) continue;
            v.addAll(ids);
        }
        return v;
    }

    public Vector getScriptIdsForObject(String scriptIdPath) {
        Vector v = new Vector();
        if (scriptIdPath == null) {
            return v;
        }
        String newPath = null;
        newPath = this.getPath(scriptIdPath);
        Identifier id = this.getIdentifier(newPath, scriptIdPath);
        this.loadScripts(v, id, scriptIdPath);
        return v;
    }

    private String getPath(String scriptIdPath) {
        String path = this.getPathFromTreePath(scriptIdPath);
        if (path == null) {
            System.out.println("sm:getPath: can't determine path to directory for " + scriptIdPath);
        }
        return path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean loadScripts(Vector v, Identifier dirId, String scriptTreePath) {
        if (dirId == null) {
            return false;
        }
        this.msgOut("sm:loadScriptIds: reading directory " + dirId.getPath());
        Identifier identifier = dirId;
        synchronized (identifier) {
            Vector scripts;
            HecFile file = null;
            try {
                file = dirId.getFile();
                if (file == null) {
                    System.out.println("sm:loadScriptIds: failed to get directory from id " + dirId.getName());
                    return false;
                }
                if (!file.exists() || !file.isDirectory()) {
                    return false;
                }
                scripts = this._fileManager.getRemoteFileIDList(UserId.getUserId(), dirId.getPath(), "*.py");
            }
            catch (RemoteException re) {
                System.out.println("sm:loadScriptIds: RemoteException retrieving list of scripts for " + dirId.getPath() + " Error:" + re);
                return false;
            }
            for (int i = 0; i < scripts.size(); ++i) {
                Identifier id = (Identifier)scripts.get(i);
                ScriptIdentifier sid = this.getScriptId(id);
                if (sid == null) continue;
                sid.setModulePath(scriptTreePath);
                v.add(sid);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ScriptIdentifier getScriptId(Identifier id) {
        if (id == null || id.isDirectory()) {
            return null;
        }
        HecFile file = id.getFile();
        if (file == null) {
            id = this.getIdentifierWithFile(id);
        }
        if ((file = id.getFile()) == null) {
            return null;
        }
        BufferedReader reader = null;
        ScriptIdentifier sid = null;
        try {
            String line;
            reader = file.getBufferedReader();
            sid = new ScriptIdentifier();
            sid.setFileName(id.getPath());
            StringBuffer description = new StringBuffer();
            while ((line = reader.readLine()) != null) {
                if (line.startsWith("#")) {
                    if ((line = line.substring(1)).indexOf("=") == -1) continue;
                    String type = RMAIO.getType((String)line, (String)"=");
                    String param = RMAIO.getParam((String)line, (String)"=");
                    if ("name".equalsIgnoreCase(type)) {
                        sid.setUserDisplayedName(param);
                        sid.setName(param);
                        continue;
                    }
                    if ("description".equalsIgnoreCase(type)) {
                        if (description.length() > 0) {
                            description = description.append("\n");
                        }
                        description.append(param);
                        continue;
                    }
                    if ("displayinmenu".equalsIgnoreCase(type)) {
                        sid.setDisplayedInMenu("true".equalsIgnoreCase(param));
                        continue;
                    }
                    if ("displaytouser".equalsIgnoreCase(type)) {
                        sid.setDisplayedToUser("true".equalsIgnoreCase(param));
                        continue;
                    }
                    if ("displayinselector".equalsIgnoreCase(type)) {
                        sid.setDisplayedInSelector("true".equalsIgnoreCase(param));
                        continue;
                    }
                    if (!"iconname".equalsIgnoreCase(type)) continue;
                    sid.setIconName(param);
                    continue;
                }
                if (line.length() == 0 || line.startsWith(" ")) continue;
            }
            if (sid.getUserDisplayedName() == null) {
                sid.setUserDisplayedName(RMAIO.getFileNameNoExtension((String)id.getPath()));
            }
            sid.setDescription(description.toString());
        }
        catch (IOException ioe) {
            System.out.println("IOError reading " + file.getPath() + " Error:" + ioe);
            ScriptIdentifier scriptIdentifier = null;
            return scriptIdentifier;
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException iOException) {}
        }
        return sid;
    }

    public boolean deleteScript(ScriptIdentifier sid) {
        return this.deleteScript(sid, true);
    }

    public boolean deleteScript(ScriptIdentifier sid, boolean notify) {
        return this.deleteScript(sid, notify, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteScript(ScriptIdentifier sid, boolean notify, boolean warnUser) {
        if (sid == null) {
            return false;
        }
        boolean removed = false;
        if (notify) {
            boolean lockedForDelete = false;
            String fileName = ClientApp.Workspace().makeAbsolutePath(sid.getFileName());
            Identifier fileIdentifier = new Identifier(fileName);
            FileLock writeLock = new FileLock(UserId.getUserId(), 4);
            FileLock writeUnLock = new FileLock(UserId.getUserId(), 5);
            try {
                System.out.println("deleteScript:deleting " + fileName);
                try {
                    lockedForDelete = this._fileManager.lockFile(fileIdentifier, writeLock);
                }
                catch (RemoteException re) {
                    System.out.println("deleteScript: Communications error with RmiFileManager locking script" + fileName + " Error:" + re);
                }
                if (!lockedForDelete && warnUser) {
                    ClientApp.app().postError("Failed to lock script " + sid.getUserDisplayedName(), "Delete Failed");
                    boolean re = false;
                    return re;
                }
                this.msgOut("sm:deleteScript: removing " + sid);
                this.msgOut("sm:deleteScript: removal of " + sid + " " + (removed ? "successful" : "failed"));
                try {
                    removed = this._fileManager.deleteFile(fileName);
                }
                catch (RemoteException re) {
                    System.out.println("deleteScript: Communications Error with RmiFileManager deleting script " + fileName + " Error:" + re);
                }
            }
            finally {
                if (lockedForDelete) {
                    try {
                        this._fileManager.unlockFile(fileIdentifier, writeUnLock);
                    }
                    catch (RemoteException re) {
                        System.out.println("deleteScript: Communications error with RmiFileManager unlocking script" + fileName + " Error:" + re);
                    }
                }
            }
            if (removed) {
                removed = this._cache.remove(sid) != null;
            }
            this.msgOut("sm: got deleteScript:" + sid);
        } else {
            removed = this._cache.remove(sid) != null;
        }
        return removed;
    }

    public boolean isUniqueScriptName(String s) {
        if (s == null) {
            return false;
        }
        return this.isUniqueScriptName(s, this._cache);
    }

    public boolean isUniqueScriptName(String s, Hashtable cache) {
        Enumeration e = cache.keys();
        while (e.hasMoreElements()) {
            ScriptIdentifier sid;
            Object obj = e.nextElement();
            if (!(obj instanceof ScriptIdentifier) || !(sid = (ScriptIdentifier)obj).getName().equals(s)) continue;
            return false;
        }
        return true;
    }

    public boolean downLoadModule(String moduleName) {
        String path;
        if (moduleName == null || moduleName.length() < 1) {
            return false;
        }
        if (!RMAIO.isFullPath((String)moduleName)) {
            RmiApp rmiApp = ClientApp.app().getAppServer();
            if (rmiApp == null) {
                System.out.println("getScriptModule: ERROR can't find RmiApp");
                return false;
            }
            String cwmsHome = null;
            try {
                cwmsHome = rmiApp.getServerProperty("CWMS_HOME");
            }
            catch (RemoteException re) {
                System.out.println("downLoadModule: Communications error with RmiApp getting CWMS_HOME " + re);
                return false;
            }
            if (cwmsHome == null) {
                System.out.println("downLoadModule: failed to get CWMS_HOME from RmiApp");
                cwmsHome = System.getProperty("CWMS_HOME");
            }
            if (cwmsHome == null) {
                System.out.println("downLoadModule: no CWMS_HOME defined");
                return false;
            }
            path = cwmsHome.concat("/").concat("users/").concat(moduleName);
        } else {
            path = moduleName;
        }
        boolean addedExtension = false;
        if (!path.endsWith(".py")) {
            path = path.concat(".py");
            addedExtension = true;
        }
        this.setLocalCacheDir();
        if (this._localCacheDir == null) {
            this._localCacheDir = ScriptEngine.getCacheDirectory();
        }
        if (this._localCacheDir == null) {
            System.out.println("sm:downLoadModule:ERROR can't find property python.path not attempting to download");
            return false;
        }
        Identifier id = new Identifier(path);
        HecFile remoteFile = this.checkFile(id);
        if (remoteFile == null) {
            System.out.println("sm:downLoadModule: can't find module " + path);
            return false;
        }
        boolean missingPythonCache = this._localCacheDir.indexOf("pythonCache") == -1;
        Object localPath = this._localCacheDir;
        if (missingPythonCache) {
            localPath = (String)localPath + File.separatorChar + "pythonCache";
        }
        localPath = (String)localPath + File.separatorChar + moduleName + (addedExtension ? ".py" : "");
        File localFile = new File((String)localPath);
        boolean download = false;
        if (localFile.exists()) {
            long localCRC = RMAIO.getCheckSum((File)localFile);
            long remoteCRC = remoteFile.getCheckSum();
            this.msgOut("sm:downloadModule: localCRC=" + localCRC + " remoteCRC=" + remoteCRC);
            if (localCRC != remoteCRC) {
                download = true;
            }
        } else {
            localFile.getParentFile().mkdirs();
            download = true;
        }
        if (download) {
            try {
                String line;
                this.msgOut("sm:downLoadModule: downloading module " + id.getPath() + " to " + localFile.getAbsolutePath());
                BufferedReader reader = remoteFile.getBufferedReader();
                BufferedWriter writer = new BufferedWriter(new FileWriter(localFile));
                while ((line = reader.readLine()) != null) {
                    writer.write(line);
                    writer.newLine();
                }
                reader.close();
                writer.flush();
                writer.close();
            }
            catch (IOException ioe) {
                System.out.println("sm:downLoadModule: IOException transfering file " + ioe);
                return false;
            }
        } else {
            this.msgOut("sm:downLoadModule: module " + id.getPath() + " already downloaded to " + localFile.getAbsolutePath());
        }
        String curPath = RMAIO.getDirectoryFromPath((String)localFile.getAbsolutePath().replace('\\', '/'));
        String stopPath = this._localCacheDir.replace('\\', '/');
        System.out.println("Current PATH " + curPath);
        System.out.println("Current CACHEDIR " + stopPath);
        while (!curPath.equals(stopPath)) {
            String newPath;
            String initFile = curPath + "/__init__.py";
            File fInitFile = new File(initFile);
            if (!fInitFile.exists()) {
                try {
                    BufferedWriter writer = new BufferedWriter(new FileWriter(initFile));
                    writer.newLine();
                    writer.flush();
                    writer.close();
                }
                catch (IOException ioe) {
                    System.out.println("downLoadModule:error creating " + initFile + " Error:" + ioe);
                }
            }
            if ((newPath = RMAIO.getDirectoryFromPath((String)curPath)).equals(curPath)) {
                return true;
            }
            curPath = newPath;
            System.out.println("Current PATH " + curPath);
        }
        return true;
    }

    private HecFile checkFile(Identifier path) {
        Identifier fileId;
        try {
            this.msgOut("sm:checkFile: checking for  file " + path.getPath());
            fileId = this._fileManager.openFile(ClientApp.app().getUser(), path);
            if (fileId == null) {
                return null;
            }
        }
        catch (RemoteException re) {
            System.out.println("sm:checkFile: rmi error talking to FileManager " + re);
            return null;
        }
        return fileId.getFile();
    }

    private void setLocalCacheDir() {
        if (this._localCacheDir == null) {
            ScriptEngine.init(null);
            String s = ScriptEngine.getCacheDirectory();
            if (s == null) {
                System.out.println("sm:setLocalCacheDir: python.path not defined. Can't download module");
                System.out.println("\tuse '-Dpython.path=<local dir>' in script that started application.");
                return;
            }
            int idx = s.indexOf(File.pathSeparatorChar);
            if (idx > -1) {
                this._localCacheDir = s = s.substring(0, idx);
                this.msgOut("sm:python cache dir set to " + this._localCacheDir);
            }
        }
    }

    private void reloadScriptIds(Identifier fileId, ScriptHashtable cache) {
        if (fileId == null || cache == null) {
            System.out.println("sm:reloadScriptIds: reload failed.");
            return;
        }
        if (!cache.isReloadOk()) {
            return;
        }
        Vector reloadedIds = new Vector();
        HecFile file = null;
        try {
            this.msgOut("sm:reloadScriptIds: reading file " + fileId.getPath());
            file = fileId.getFile();
            if (file == null) {
                System.out.println("sm:reloadScriptIds: failed to get file from id " + fileId.getName());
                return;
            }
            BufferedReader reader = file.getBufferedReader();
            HecAsciiDeserializer deser = new HecAsciiDeserializer(reader);
            deser.deserializeObject(reloadedIds);
            reader.close();
        }
        catch (IOException ioe) {
            System.out.println("rm:reloadScriptIds: IOException saving script to file " + file.getName());
            return;
        }
        if (!cache.isModified()) {
            cache.clear();
            for (int i = 0; i < reloadedIds.size(); ++i) {
                cache.put(reloadedIds.elementAt(i), this._cacheDummy);
            }
            cache.setModified(false);
        }
    }

    public boolean lockScriptFile(boolean lock, String scriptPath) {
        if (scriptPath == null) {
            return false;
        }
        Identifier id = new Identifier(scriptPath);
        this.msgOut("sm:lockScriptFile: path is " + scriptPath + " lock it=" + lock);
        if (this._fileManager == null) {
            this.setFileManager();
        }
        try {
            String user = ClientApp.app().getUser();
            if (lock) {
                FileLock fLock = new FileLock(user, 6);
                return this._fileManager.lockFile(id, fLock);
            }
            FileLock fLock = new FileLock(user, 7);
            return this._fileManager.unlockFile(id, fLock);
        }
        catch (RemoteException re) {
            System.out.println("sm:lockScriptFile: rmi error talking with FileManager " + re);
            return false;
        }
    }

    public String checkLockedBy(String scriptPath) {
        if (scriptPath == null) {
            return null;
        }
        Identifier id = new Identifier(scriptPath);
        if (this._fileManager == null) {
            this.setFileManager();
        }
        String lockedBy = null;
        try {
            lockedBy = this._fileManager.getEditLockedBy(id);
        }
        catch (RemoteException re) {
            System.out.println("sm:checkLockedBy: rmi error talking with Filemanager " + re);
            return null;
        }
        return lockedBy;
    }

    public void addConfigChangeListener(ConfigChangeListener listener) {
        if (this._listenerList.contains(listener)) {
            return;
        }
        this._listenerList.addElement(listener);
    }

    public void removeConfigChangeListener(ConfigChangeListener listener) {
        this._listenerList.removeElement(listener);
    }

    public void notifyListeners(String file, int changeType, String otherInfo) {
        if (file == null || changeType < 0) {
            return;
        }
        if (this._listenerList.size() == 0) {
            return;
        }
        final int chgType = changeType;
        final String chgFile = file;
        final String oInfo = otherInfo;
        Runnable sendEvent = new Runnable(){

            @Override
            public void run() {
                ConfigFileChangeEvent event = new ConfigFileChangeEvent(chgFile, chgType, oInfo);
                for (int i = ScriptManagerImpl.this._listenerList.size() - 1; i >= 0; --i) {
                    ConfigChangeListener listener = (ConfigChangeListener)ScriptManagerImpl.this._listenerList.elementAt(i);
                    listener.configFileChanged(event);
                }
            }
        };
        SwingUtilities.invokeLater(sendEvent);
    }

    private int getMessageType(String message) {
        if (message.indexOf("Modified") > -1) {
            return 1;
        }
        if (message.indexOf("Locked") > -1) {
            return 2;
        }
        if (message.indexOf("Unlocked") > -1) {
            return 3;
        }
        return -1;
    }

    public void close() {
    }

    private void msgOut(String msg) {
        if (ScriptManagerImpl.debug()) {
            System.out.println(msg);
        }
    }

    public static void buildSortedVector(Vector src, Vector dest) {
        if (src == null || src.size() == 0) {
            return;
        }
        dest.addAll(src);
        Collections.sort(dest);
    }

    public void setFileManager() {
        if (ClientAppCheck.haveClientApp()) {
            this._fileManager = (RmiFileManager)ClientApp.app().getFileManager().getRemote();
        } else {
            try {
                this._fileManager = new RmiFileManagerImpl(8089);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
    }

    public void scriptAdded(ScriptIdentifier sid) {
        if (sid == null) {
            return;
        }
        Script script = (Script)this._cache.get(sid);
        if (script == null) {
            return;
        }
        script = this.getScript(sid);
        if (script == null) {
            return;
        }
        this._cache.put(sid, script);
        this.msgOut("sm: got scriptAdded:" + sid);
    }

    public void reloadScript(ScriptIdentifier sid) {
        if (sid == null) {
            return;
        }
        Script script = (Script)this._cache.get(sid);
        if (script == null) {
            return;
        }
        script = this.getScript(sid);
        if (script == null) {
            return;
        }
        this._cache.put(sid, script);
        this.msgOut("sm: got reloadScript:" + sid);
    }

    public Hashtable getCache() {
        return this._cache;
    }

    public class ScriptHashtable
    extends Hashtable {
        private boolean _modified = false;
        private String _name = "";
        private Identifier _id = null;
        boolean _reloadOk = true;

        public ScriptHashtable(String name) {
            this._name = name;
        }

        @Override
        public Object put(Object key, Object value) {
            this._modified = true;
            return super.put(key, value);
        }

        @Override
        public Object remove(Object key) {
            this._modified = true;
            return super.remove(key);
        }

        @Override
        public void clear() {
            this._modified = true;
            super.clear();
        }

        public boolean isModified() {
            return this._modified;
        }

        public void setModified(boolean b) {
            this._modified = b;
        }

        public String getName() {
            return this._name;
        }

        public Identifier getIdentifier() {
            return this._id;
        }

        public void setIdentifier(Identifier id) {
            this._id = id;
        }

        public void setReloadOk(boolean b) {
            this._reloadOk = b;
        }

        public boolean isReloadOk() {
            return this._reloadOk;
        }
    }
}

