/*
 * Decompiled with CFR 0.152.
 */
package hec.clientapp.script;

import hec.clientapp.client.ClientApp;
import hec.clientapp.client.ClientMode;
import hec.clientapp.script.ScriptJobStatusJFrame;
import hec.io.Identifier;
import hec.lang.NamedType;
import hec.model.SchedulableJob;
import hec.script.ScriptIdentifier;
import hec.script.ScriptJob;
import hec.script.ScriptManager;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.rmi.RemoteException;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.InputVerifier;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.border.TitledBorder;
import javax.swing.plaf.basic.BasicComboBoxRenderer;
import mil.army.usace.hec.rmi.security.HecSecurityManager;
import rma.swing.ButtonCmdPanel;
import rma.swing.ButtonCmdPanelListener;
import rma.swing.RmaInsets;
import rma.swing.RmaJ24HourTimeField;
import rma.swing.RmaJCalendarField;
import rma.swing.RmaJComboBox;
import rma.swing.RmaJDialog;
import rma.swing.RmaJFrame;
import rma.swing.RmaJIntegerField;
import rma.swing.RmaJRadioButton;
import rma.swing.RmaJTextField;
import rma.util.RMAIO;

public class ScriptSchedulerJDialog
extends RmaJDialog {
    private boolean _canceled = false;
    ItemListener _scriptNameIL;
    private boolean _useDefaultName = true;
    private KeyListener _dateTimeKL;
    private RmaJTextField _jobName;
    private RmaJComboBox _scriptName;
    private RmaJRadioButton _singleJobCB;
    private RmaJRadioButton _recurringJobCB;
    private RmaJCalendarField _startDate;
    private RmaJ24HourTimeField _startTime;
    private RmaJIntegerField _recurranceAmt;
    private RmaJComboBox _recurranceInterval;
    private ButtonCmdPanel _buttonCmdPanel;
    private RmaJRadioButton _clientSideRB;
    private RmaJRadioButton _serverSideRB;
    private JLabel _tzLabel;

    public ScriptSchedulerJDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.buildControls();
    }

    private void buildControls() {
        this.setTitle("Schedule Script Job");
        Insets insets5500 = RmaInsets.insets((int)5, (int)5, (int)0, (int)0);
        Insets insets5505 = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        this.getContentPane().setLayout(new GridBagLayout());
        JPanel namePanel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.insets = insets5500;
        gbc.weightx = 1.0;
        this.getContentPane().add((Component)namePanel, gbc);
        JLabel label = new JLabel("Job Name:");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = insets5500;
        namePanel.add((Component)label, gbc);
        this._jobName = new RmaJTextField(){

            public Dimension getPreferredSize() {
                Dimension d = super.getPreferredSize();
                d.width = 200;
                return d;
            }
        };
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = insets5500;
        gbc.weightx = 1.0;
        namePanel.add((Component)this._jobName, gbc);
        label = new JLabel("Script Name:");
        label.setDisplayedMnemonic('s');
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = insets5500;
        namePanel.add((Component)label, gbc);
        this._scriptName = new RmaJComboBox();
        this._scriptName.setRenderer((ListCellRenderer)new ToolTipComboBoxRenderer());
        label.setLabelFor((Component)this._scriptName);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = insets5500;
        gbc.weightx = 1.0;
        namePanel.add((Component)this._scriptName, gbc);
        JPanel locationPanel = new JPanel(new GridBagLayout());
        locationPanel.setBorder(new TitledBorder("Location"));
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.anchor = 10;
        gbc.fill = 0;
        gbc.insets = insets5500;
        gbc.weightx = 1.0;
        this.getContentPane().add((Component)locationPanel, gbc);
        this._clientSideRB = new RmaJRadioButton("Run on Client");
        this._clientSideRB.setMnemonic('c');
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = insets5500;
        locationPanel.add((Component)this._clientSideRB, gbc);
        this._serverSideRB = new RmaJRadioButton("Run on Server");
        this._serverSideRB.setMnemonic('s');
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = insets5500;
        gbc.weighty = 1.0;
        locationPanel.add((Component)this._serverSideRB, gbc);
        JPanel jobPanel = new JPanel(new GridBagLayout());
        jobPanel.setBorder(new TitledBorder(""));
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridwidth = 2;
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.insets = insets5505;
        gbc.weightx = 1.0;
        this.getContentPane().add((Component)jobPanel, gbc);
        this._singleJobCB = new RmaJRadioButton("Single Job");
        this._singleJobCB.setMnemonic('j');
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = insets5500;
        jobPanel.add((Component)this._singleJobCB, gbc);
        label = new JLabel("Start Date:");
        label.setDisplayedMnemonic('d');
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.anchor = 12;
        gbc.fill = 0;
        gbc.insets = insets5500;
        jobPanel.add((Component)label, gbc);
        this._startDate = new RmaJCalendarField("DDMMMYYYY", "");
        label.setLabelFor((Component)this._startDate);
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 0;
        gbc.gridheight = 1;
        gbc.gridwidth = 2;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = insets5500;
        gbc.weightx = 1.0;
        jobPanel.add((Component)this._startDate, gbc);
        label = new JLabel("Start Time:");
        label.setDisplayedMnemonic('T');
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.anchor = 12;
        gbc.fill = 0;
        gbc.insets = insets5500;
        jobPanel.add((Component)label, gbc);
        this._startTime = new RmaJ24HourTimeField();
        label.setLabelFor((Component)this._startTime);
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 1;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = insets5500;
        gbc.weightx = 1.0;
        jobPanel.add((Component)this._startTime, gbc);
        TimeZone tz = TimeZone.getDefault();
        Date dt = new Date();
        boolean inDayLightSavings = tz.inDaylightTime(dt);
        this._tzLabel = new JLabel(tz.getDisplayName(inDayLightSavings, 0, Locale.getDefault()));
        gbc = new GridBagConstraints();
        gbc.gridx = 3;
        gbc.gridy = 1;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = insets5500;
        jobPanel.add((Component)this._tzLabel, gbc);
        this._recurringJobCB = new RmaJRadioButton("Recurring Job");
        this._recurringJobCB.setMnemonic('r');
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = insets5500;
        jobPanel.add((Component)this._recurringJobCB, gbc);
        JPanel recurrencePanel = new JPanel(new GridBagLayout());
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.gridwidth = 2;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = insets5500;
        gbc.weightx = 1.0;
        jobPanel.add((Component)recurrencePanel, gbc);
        label = new JLabel("Recurrence Interval:");
        label.setDisplayedMnemonic('i');
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.anchor = 12;
        gbc.fill = 0;
        gbc.insets = insets5500;
        recurrencePanel.add((Component)label, gbc);
        this._recurranceAmt = new RmaJIntegerField(){

            public Dimension getPreferredSize() {
                Dimension d = super.getPreferredSize();
                if (d.width < 50) {
                    d.width = 50;
                }
                return d;
            }
        };
        this._recurranceAmt.setMinValue(0);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 2;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = insets5500;
        gbc.weightx = 1.0;
        recurrencePanel.add((Component)this._recurranceAmt, gbc);
        Vector<String> v = new Vector<String>();
        v.addElement("Minute(s)");
        v.addElement("Hour(s)");
        v.addElement("Day(s)");
        this._recurranceInterval = new RmaJComboBox(v);
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 2;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = insets5500;
        gbc.weightx = 1.0;
        recurrencePanel.add((Component)this._recurranceInterval, gbc);
        this._buttonCmdPanel = new ButtonCmdPanel(14);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.gridwidth = 2;
        gbc.anchor = 12;
        gbc.fill = 2;
        gbc.insets = insets5500;
        gbc.weightx = 1.0;
        this.getContentPane().add((Component)this._buttonCmdPanel, gbc);
        ButtonGroup bg = new ButtonGroup();
        bg.add((AbstractButton)this._singleJobCB);
        bg.add((AbstractButton)this._recurringJobCB);
        bg = new ButtonGroup();
        bg.add((AbstractButton)this._clientSideRB);
        bg.add((AbstractButton)this._serverSideRB);
        ActionListener locationAL = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ScriptSchedulerJDialog.this._clientSideRB.isSelected()) {
                    ScriptSchedulerJDialog.this.setTimeZoneLabel(TimeZone.getDefault());
                } else {
                    try {
                        TimeZone tz = ClientApp.app().getAppServer().getTimeZone();
                        ScriptSchedulerJDialog.this.setTimeZoneLabel(tz);
                    }
                    catch (RemoteException re) {
                        System.out.println("buildControls:error getting timezone from server " + re);
                        ScriptSchedulerJDialog.this.setTimeZoneLabel(null);
                    }
                }
            }
        };
        this._clientSideRB.addActionListener(locationAL);
        this._serverSideRB.addActionListener(locationAL);
        ActionListener jobAL = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean enabled = false;
                if (e.getSource() == ScriptSchedulerJDialog.this._recurringJobCB) {
                    enabled = true;
                }
                ScriptSchedulerJDialog.this._recurranceAmt.setEnabled(enabled);
                ScriptSchedulerJDialog.this._recurranceInterval.setEnabled(enabled);
            }
        };
        this._singleJobCB.addActionListener(jobAL);
        this._recurringJobCB.addActionListener(jobAL);
        this._dateTimeKL = new KeyAdapter(){

            public void focusGained(FocusEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                JComponent c = (JComponent)e.getComponent();
                InputVerifier iv = null;
                if (c != null) {
                    iv = c.getInputVerifier();
                    c.setInputVerifier(null);
                }
                ScriptSchedulerJDialog.this.updateName();
                if (c != null) {
                    c.setInputVerifier(iv);
                }
            }
        };
        this._jobName.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                ScriptSchedulerJDialog.this._useDefaultName = ScriptSchedulerJDialog.this._jobName.getText().trim().length() == 0;
            }
        });
        this._startDate.addKeyListener(this._dateTimeKL);
        this._startTime.addKeyListener(this._dateTimeKL);
        this._buttonCmdPanel.addCmdPanelListener(new ButtonCmdPanelListener(){

            public void buttonCmdActionPerformed(ActionEvent e) {
                switch (e.getID()) {
                    case 8: {
                        ScriptSchedulerJDialog.this._canceled = true;
                        if (ScriptSchedulerJDialog.this.isModified() && !ScriptSchedulerJDialog.this.apply()) {
                            return;
                        }
                        ScriptSchedulerJDialog.this.setVisible(false);
                        break;
                    }
                    case 2: {
                        ScriptSchedulerJDialog.this.apply();
                        break;
                    }
                    case 4: {
                        ScriptSchedulerJDialog.this._canceled = true;
                        ScriptSchedulerJDialog.this.setVisible(false);
                    }
                }
            }
        });
        this._scriptNameIL = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 2) {
                    return;
                }
                ScriptSchedulerJDialog.this.updateName();
            }
        };
        this._scriptName.addItemListener(this._scriptNameIL);
        this.pack();
        this.setLocation();
        this.registerEnterKey(true);
        this.registerEscapeKey(true);
        this._singleJobCB.doClick();
        this._clientSideRB.doClick();
        if (!ClientApp.app().networked) {
            this._clientSideRB.setEnabled(false);
            this._serverSideRB.setEnabled(false);
        }
        ClientMode mode = ClientApp.frame().getCurrentMode();
        String permissionStr = "Scripting.ServerSide";
        int permission = HecSecurityManager.getSecurityManager().getActionForPermission(permissionStr);
        if (permission < 3) {
            this._serverSideRB.setEnabled(false);
        }
    }

    protected void setTimeZoneLabel(TimeZone tz) {
        if (tz == null) {
            this._tzLabel.setText("???");
            return;
        }
        Date dt = new Date();
        boolean inDayLightSavings = tz.inDaylightTime(dt);
        this._tzLabel.setText(tz.getDisplayName(inDayLightSavings, 0, Locale.getDefault()));
    }

    private void updateName() {
        if (this._useDefaultName || this._jobName.getText().trim().length() == 0) {
            Object script = this._scriptName.getSelectedItem();
            if (script == null) {
                script = "";
            }
            this._jobName.setText(script.toString() + this._startDate.getText() + "-" + this._startTime.getText());
        }
    }

    public boolean apply() {
        if (!this.validForm()) {
            return false;
        }
        if (ClientApp.app().getScheduler().scheduleJob((SchedulableJob)this.getScriptJob(), this._serverSideRB.isSelected())) {
            JOptionPane.showMessageDialog((Component)((Object)this), "Script Job " + this._jobName.getText() + " has been scheduled.", "Confirmation", 1);
            this._useDefaultName = true;
            this.setModified(false);
            RmaJFrame frame = RmaJFrame.getWindow((String)"Script Job Status");
            if (frame instanceof ScriptJobStatusJFrame) {
                ((ScriptJobStatusJFrame)frame).fillForm();
            }
        } else {
            JOptionPane.showMessageDialog((Component)((Object)this), "Failed to Schedule script Job " + this._jobName.getText(), "Error", 0);
        }
        return true;
    }

    public boolean isCanceled() {
        return this._canceled;
    }

    public boolean validForm() {
        this.updateName();
        if (this._recurringJobCB.isSelected() && (this._recurranceAmt.getText().length() < 1 || this._recurranceAmt.getValue() < 1)) {
            JOptionPane.showMessageDialog((Component)((Object)this), "Recurrance amount can not be empty or less than 1", "Error", 0);
            return false;
        }
        if (this._startDate.getText().length() < 1) {
            JOptionPane.showMessageDialog((Component)((Object)this), "Start Date can not be empty", "Error", 0);
            return false;
        }
        if (this._startTime.getText().length() < 1) {
            JOptionPane.showMessageDialog((Component)((Object)this), "Start time can not be empty", "Error", 0);
            return false;
        }
        Object startingDate = null;
        if (ClientApp.app().getScheduler().getJob(this._jobName.getText()) != null) {
            JOptionPane.showMessageDialog((Component)((Object)this), "Job Name must be unique.\nThere is currently a job already scheduled with the name " + this._jobName.getText());
            return false;
        }
        return true;
    }

    public void fillForm() {
        this.clearForm();
        this._useDefaultName = true;
        ScriptManager sm = ClientApp.Workspace().getScriptManager();
        String[] modeNames = ClientApp.frame().getModeNames();
        Vector scriptIds = new Vector();
        for (int i = 0; i < modeNames.length; ++i) {
            Vector modeIds = sm.getScriptIdsForMode(modeNames[i]);
            if (modeIds == null) continue;
            for (int j = 0; j < modeIds.size(); ++j) {
                Object obj = modeIds.get(j);
                if (scriptIds.contains(obj)) continue;
                scriptIds.add(obj);
            }
        }
        this._scriptName.removeItemListener(this._scriptNameIL);
        this._scriptName.setModel(new DefaultComboBoxModel(scriptIds));
        this._scriptName.addItemListener(this._scriptNameIL);
        this.updateName();
        this.setModified(false);
    }

    public void setSelectedScript(ScriptIdentifier id) {
        this._scriptName.setSelectedItem((Object)id);
    }

    public ScriptJob getScriptJob() {
        ScriptManager sm = ClientApp.Workspace().getScriptManager();
        ScriptJob scriptJob = new ScriptJob(this._jobName.getText());
        ScriptIdentifier scriptId = (ScriptIdentifier)this._scriptName.getSelectedItem();
        Identifier id = sm.getIdFromScriptId(scriptId);
        scriptJob.setScriptPath(id.getPath());
        scriptJob.setRecurring(this._recurringJobCB.isSelected());
        scriptJob.setStartDate(this._startDate.getText() + "," + this._startTime.getText() + " " + this._tzLabel.getText());
        String username = RMAIO.userNameFromUserId((String)ClientApp.app().getUser());
        scriptJob.setUser(username);
        scriptJob.setPassword(ClientApp.app().getPassword());
        scriptJob.setScriptName(scriptId.toString());
        scriptJob.setWorkspacePath(ClientApp.Workspace().getWorkspaceConfigFile(""));
        scriptJob.setTimezoneOffset(TimeZone.getDefault().getRawOffset() / 3600000);
        if (scriptJob.isRecurring()) {
            scriptJob.setRecurringAmount(this._recurranceAmt.getValue());
            scriptJob.setRecurringInterval((String)this._recurranceInterval.getSelectedItem());
        }
        return scriptJob;
    }

    public void setVisible(boolean b) {
        if (b) {
            this.getRootPane().setDefaultButton(this._buttonCmdPanel.getButton("OK"));
        }
        super.setVisible(b);
    }

    public class ToolTipComboBoxRenderer
    extends BasicComboBoxRenderer
    implements ListCellRenderer<Object> {
        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (isSelected) {
                if (-1 < index && value instanceof NamedType) {
                    Object desc = ((NamedType)value).getDescription();
                    if (value instanceof ScriptIdentifier) {
                        if (desc != null && ((String)desc).length() > 0) {
                            desc = (String)desc + "\n";
                            desc = (String)desc + ((ScriptIdentifier)value).getFileName();
                        } else {
                            desc = ((ScriptIdentifier)value).getFileName();
                        }
                    }
                    list.setToolTipText(RMAIO.toHtmlString((String)desc));
                } else {
                    list.setToolTipText(null);
                }
            }
            return super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
        }
    }
}

