/*
 * Decompiled with CFR 0.152.
 */
package hec.clientapp.server;

import com.google.common.flogger.FluentLogger;
import com.google.common.flogger.LazyArgs;
import hec.clientapp.model.Manager;
import hec.clientapp.model.ManagerProxy;
import hec.clientapp.model.ManagerProxyListContainer;
import hec.clientapp.model.ModelAlt;
import hec.clientapp.rmi.csinterface.HecRmiWorkspace;
import hec.clientapp.rmi.csinterface.RmiDataListContainer;
import hec.clientapp.rmi.csinterface.RmiWkspCallBack;
import hec.clientapp.rmi.csinterface.RmiWorkspace;
import hec.clientapp.server.RmiWorkspaceImpl;
import hec.data.Units;
import hec.io.HecFile;
import hec.io.Identifier;
import hec.lang.ModelReference;
import hec.lang.UserId;
import hec.lang.WorkspaceNameFactory;
import hec.map.GlyphDataRecord;
import hec.map.GlyphDataRecordSerializable;
import hec.map.MapIdentifier;
import hec.map.MapPosition;
import hec.map.WorldRect;
import hec.map.transform.CoordinateInfo;
import hec.map.transform.XYCoordinateInfo;
import hec.model.AltItem;
import hec.model.WkspExportOptions;
import hec.server.AppVersion;
import hec.util.ExportResults;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Proxy;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Level;
import mil.army.usace.hec.rmi.csinterface.DSSManager;
import mil.army.usace.hec.rmi.csinterface.Naming;
import mil.army.usace.hec.rmi.csinterface.RmiFileManager;
import mil.army.usace.hec.rmi.proxy.NotifyUserProxy;
import mil.army.usace.hec.rmi.server.ControllableServerImpl;
import mil.army.usace.hec.rmi.server.DSSFileManager;
import mil.army.usace.hec.rmi.server.PortableRmiObject;
import mil.army.usace.hec.rmi.server.RemoteWrapper;
import rma.util.RMAIO;
import rma.util.logging.MarkingClassLogger;
import rma.util.logging.marking.RmiWorkspacePropLoggingMarker;

public class HecRmiWorkspaceImpl
extends RmiWorkspaceImpl
implements HecRmiWorkspace {
    private static final FluentLogger LOGGER = FluentLogger.forEnclosingClass();
    private static final MarkingClassLogger RMI_WORKSPACE_PROP_LOGGER = MarkingClassLogger.forMarkingClass(RmiWorkspacePropLoggingMarker.class);
    private static int VERSION = 1001;
    private RmiWorkspace _baseWorkspace;
    private static Object _studyLock = new Object();
    private int _nextIndex = 0;
    private int _unitSystemId = Integer.MIN_VALUE;
    private int _gmtOffset = Integer.MIN_VALUE;
    protected long _modifiedTime = Long.MIN_VALUE;
    private int _version = 1000;
    private String _aclFilename;
    protected RemoteWrapper _dssFileManager;
    private Object _dssFileManagerLock = new Object();
    private DSSManager _dssfm;
    private String _wkspVersion;
    private String _streamAlignmentUnits;

    public HecRmiWorkspaceImpl(int port) throws RemoteException {
        super(port);
        this._typeOfWorkspace = "";
        this.setWorkspaceExt("wksp");
    }

    public HecRmiWorkspaceImpl(Integer port) throws RemoteException {
        this((int)port);
    }

    @Override
    public RmiWorkspace getBaseWorkspace() {
        if (this._baseWorkspace == null) {
            return this;
        }
        return this._baseWorkspace;
    }

    @Override
    public void setBaseWorkspace(RmiWorkspace wksp) {
        this._baseWorkspace = wksp;
    }

    @Override
    public int getUnitSystem() {
        if (this._unitSystemId == Integer.MIN_VALUE) {
            System.out.println("WARNING: <HecRmiWorkspaceImpl.getUnitSystem()> Unit System is not Defined Yet! Defaulting To English Units");
            this.setUnitSystem(1);
        }
        return this._unitSystemId;
    }

    @Override
    public void setUnitSystem(int unitSystem) {
        if (this._unitSystemId != Integer.MIN_VALUE) {
            System.out.println("WARNING: <HecRmiWorkspaceImpl.setUnitSystem()> Trying to set an already Defined Unit System!");
            return;
        }
        if (!Units.isValidUnitsSystem((int)unitSystem)) {
            throw new IllegalArgumentException("ERROR: <RmiWorkspaceImpl.setUnitSystem()> Invalid Unit System ID" + unitSystem);
        }
        this._unitSystemId = unitSystem;
    }

    @Override
    public void setGmtOffset(int gmtOffset) {
        if (this._gmtOffset != Integer.MIN_VALUE) {
            System.out.println("WARNING: <HecRmiWorkspaceImpl.setGmtOffset()> Trying to set an already defined GMT Offset!");
            return;
        }
        this._gmtOffset = gmtOffset;
    }

    @Override
    public int getGmtOffset() {
        if (this._gmtOffset == Integer.MIN_VALUE) {
            System.out.println("WARNING: <HecRmiWorkspaceImpl.getGmtOffset()> GMT Offset is not Defined Yet! Defaulting to 00:00 hours offset");
            this.setGmtOffset(0);
        }
        return this._gmtOffset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RemoteWrapper getDSSFileManager() throws RemoteException {
        Object object = this._dssFileManagerLock;
        synchronized (object) {
            if (this._dssFileManager == null || this._dssFileManager.getRemote() == null) {
                this.setDSSFileManager();
            }
            if (!this.getLocal()) {
                try {
                    ((DSSManager)this._dssFileManager.getRemote()).isAlive();
                }
                catch (Exception e) {
                    this.setDSSFileManager();
                }
            }
            return this._dssFileManager;
        }
    }

    private void setDSSFileManager() throws RemoteException {
        if (Boolean.getBoolean("UseUniqueWatershedDssFileManager")) {
            if (this._dssFileManager != null) {
                this.removeRemoteWrapper(this._dssFileManager);
                this._dssfm = null;
            }
            this._dssFileManager = new RemoteWrapper();
            try {
                this._dssfm = this.createDSSFileManager();
                ((PortableRmiObject)this._dssfm).setName("DssFileManager-" + this.getName());
                System.out.println("DssFileManager url set to " + this.getUrl() + ((PortableRmiObject)this._dssfm).getName());
            }
            catch (Exception e) {
                System.out.println("setDSSFileManager error " + e);
                e.printStackTrace(System.out);
            }
            if (this.getNetworked()) {
                try {
                    ((PortableRmiObject)this._dssfm).rebindServer(this.getUrl());
                }
                catch (Exception e) {
                    System.out.println("Exception getting server name " + e);
                    e.printStackTrace(System.out);
                }
            }
            this._dssFileManager.setRemote((Remote)this._dssfm);
        } else {
            this._dssFileManager = new RemoteWrapper();
            if (this.getLocal()) {
                try {
                    this._dssfm = this.createDSSFileManager();
                    ((PortableRmiObject)this._dssfm).setName("DssFileManager-" + this.getName());
                    System.out.println("DssFileManager url set to " + this.getUrl() + ((PortableRmiObject)this._dssfm).getName());
                    this._dssFileManager.setRemote((Remote)this._dssfm);
                }
                catch (Exception e) {
                    System.out.println("setDSSFileManager error " + e);
                    e.printStackTrace(System.out);
                }
            } else {
                String stringUrl = "rmi://localhost:" + this.getRmiPort() + "/DssFileManager";
                try {
                    DSSManager dssMgr = (DSSManager)Naming.lookup((String)stringUrl);
                    this._dssFileManager.setRemote((Remote)dssMgr);
                    this._dssFileManager.setExported(true);
                    System.out.println("DssFileManager url set to " + stringUrl);
                }
                catch (Exception e) {
                    System.out.println("RmiWorkspaceImpl():Can't find Dss file manager at " + stringUrl + " exception is " + e);
                }
            }
        }
    }

    private DSSManager createDSSFileManager() {
        Class<?> dssFileMgrClass = null;
        try {
            dssFileMgrClass = Class.forName(DSSFileManager.class.getName());
        }
        catch (Exception e) {
            ((FluentLogger.Api)((FluentLogger.Api)LOGGER.atSevere()).withCause((Throwable)e)).log("ERROR failed to find class for %s", (Object)DSSFileManager.class.getName());
            return null;
        }
        try {
            Class[] ctorCls = new Class[]{String.class};
            Constructor<?> ctor = dssFileMgrClass.getConstructor(ctorCls);
            Object[] ctorArgs = new Object[]{this._WorkspacePath};
            DSSManager dssMgr = (DSSManager)ctor.newInstance(ctorArgs);
            ((ControllableServerImpl)dssMgr).setFileManager(this._fmWrapper);
            return dssMgr;
        }
        catch (InvocationTargetException ite) {
            ((FluentLogger.Api)((FluentLogger.Api)LOGGER.atSevere()).withCause(ite.getTargetException())).log("ERROR failed to create DSSFileManager");
            return null;
        }
        catch (Exception e) {
            ((FluentLogger.Api)((FluentLogger.Api)LOGGER.atSevere()).withCause((Throwable)e)).log("Error during creation of DSSFileManager");
            return null;
        }
    }

    public long readWorkspaceTime() {
        HecFile file = this.identifier.getFile();
        if (file == null) {
            return Long.MIN_VALUE;
        }
        return this.getWorkspaceTime(file);
    }

    @Override
    public boolean load() {
        HecFile file = this.identifier.getFile();
        if (file == null) {
            return false;
        }
        this.readConfiguration(file);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized AltItem copyModelAltTo(String modelName, String className, String copyToWkspPath, AltItem altItem, String modelId) throws IllegalArgumentException, RemoteException {
        long t1 = System.currentTimeMillis();
        Manager mfa = null;
        Manager newMfa = null;
        ManagerProxyListContainer copyToContainer = null;
        try {
            if (copyToWkspPath == null || altItem == null) {
                System.out.println("copyModelAltTo: invalid arguments recieved wkspPath=" + copyToWkspPath + " altItem=" + altItem);
                throw new IllegalArgumentException("Invalid arguments recievied wkspPath=" + copyToWkspPath + " altItem=" + altItem);
            }
            RmiWorkspace copyToWksp = null;
            try {
                copyToWksp = this._rmiApp.getRmiWkspByPath(copyToWkspPath);
            }
            catch (RemoteException re) {
                System.out.println("------------------------------------------------");
                System.out.println("copyModelAltTo: RMI Error getting workspace named " + copyToWkspPath + " Error " + re);
                System.out.println("------------------------------------------------");
                AltItem altItem2 = null;
                if (newMfa != null) {
                    copyToContainer.unloadManager(modelName, newMfa.getIdentifier());
                }
                if (mfa != null) {
                    this.unloadManager(modelName, mfa.getIdentifier());
                }
                long t2 = System.currentTimeMillis();
                System.out.println("copyModelAltTo took : " + (t2 - t1) + " ms.");
                return altItem2;
            }
            if (copyToWksp == null) {
                System.out.println("------------------------------------------------");
                System.out.println("copyModelAltTo: failed to find RmiWorkspace named " + copyToWkspPath);
                System.out.println("------------------------------------------------");
                AltItem re = null;
                return re;
            }
            if (!(copyToWksp instanceof RmiWorkspaceImpl)) {
                System.out.println("------------------------------------------------");
                System.out.println("copyModelAltTo: failed to get RmiWorkspaceImpl for " + copyToWkspPath);
                System.out.println("------------------------------------------------");
                AltItem re = null;
                return re;
            }
            RmiWorkspaceImpl copyToWkspImpl = (RmiWorkspaceImpl)copyToWksp;
            copyToContainer = copyToWkspImpl;
            String dir = copyToWkspImpl.getWorkspacePath();
            AltItem newAltItem = (AltItem)altItem.clone();
            if (altItem.getAltIndex() == -1) {
                AltItem altItem3 = newAltItem;
                return altItem3;
            }
            String program = altItem.getProgram();
            if ((program = WorkspaceNameFactory.getWorkspaceName((String)program, (boolean)true)) == null) {
                program = "supplemental";
            }
            altItem.getAltIndex();
            mfa = (ModelAlt)this.openManager(modelName, className, altItem.getAltIndex());
            if (mfa == null) {
                System.out.println("------------------------------------------------");
                System.out.println("copyModelAltTo: failed to find ModelForecastAlt " + altItem.getAltName());
                System.out.println("copyModelAltTo: model=" + modelName + " class=" + className + " Index=" + altItem.getAltIndex());
                System.out.println("------------------------------------------------");
                AltItem altItem4 = null;
                return altItem4;
            }
            System.out.println("Creating Model Forecast Alt for " + mfa.getName());
            newMfa = (ModelAlt)mfa.saveManagerAs(dir + "/" + modelName, modelId, copyToContainer);
            if (newMfa == null) {
                System.out.println("------------------------------------------------");
                System.out.println("copyModelAltTo: failed to create new ModelForecastAlt for " + mfa.getName());
                System.out.println("------------------------------------------------");
                AltItem altItem5 = null;
                return altItem5;
            }
            newAltItem.setAltIndex(newMfa.getIndex());
            ModelReference ref = ((ModelAlt)mfa).getModelRef();
            if (ref == null) {
                System.out.println("------------------------------------------------");
                System.out.println("copyModelAltTo: ModelForecastAlt " + mfa.getName() + " missing ModelReference");
                System.out.println("copyModelAltTo: ModelAlt Path =" + mfa.getIdentifier().getPath());
                System.out.println("------------------------------------------------");
                newMfa.getProxyList().saveManagerAs(UserId.getUserId(), newMfa, newMfa.getIdentifier());
                AltItem altItem6 = null;
                return altItem6;
            }
            Manager mgr = ((ModelAlt)mfa).getManager();
            if (mgr == null) {
                System.out.println("------------------------------------------------");
                System.out.println("copyModelAltTo: failed to find Model manager " + ref);
                System.out.println("copyModelAltTo: ModelAlt Path =" + mfa.getIdentifier().getPath());
                System.out.println("------------------------------------------------");
                newMfa.getProxyList().saveManagerAs(UserId.getUserId(), newMfa, newMfa.getIdentifier());
                AltItem altItem7 = null;
                return altItem7;
            }
            System.out.println("Copying files for " + mgr.getName());
            Manager newMgr = mgr.saveManagerAs(dir + "/" + program, modelId, copyToContainer);
            if (newMgr == null) {
                System.out.println("------------------------------------------------");
                System.out.println("copyModelAltTo: failed to create new Manager for " + mgr.getName());
                System.out.println("copyModelAltTo: ModelAlt Path =" + mfa.getIdentifier().getPath());
                System.out.println("------------------------------------------------");
                newMfa.getProxyList().saveManagerAs(UserId.getUserId(), newMfa, newMfa.getIdentifier());
                AltItem altItem8 = null;
                return altItem8;
            }
            ((ModelAlt)newMfa).setModelRef(new ModelReference(ref.newId, newMgr.getIndex(), ((Object)((Object)newMgr)).getClass().getName(), program));
            ((ModelAlt)newMfa).writeFile(newMfa.getIdentifier());
            AltItem altItem9 = newAltItem;
            return altItem9;
        }
        catch (Exception e) {
            System.out.println("------------------------------------------------");
            System.out.println("copyModelAltTo: error " + e);
            System.out.println("------------------------------------------------");
            e.printStackTrace(System.out);
        }
        finally {
            if (newMfa != null) {
                copyToContainer.unloadManager(modelName, newMfa.getIdentifier());
            }
            if (mfa != null) {
                this.unloadManager(modelName, mfa.getIdentifier());
            }
            long t2 = System.currentTimeMillis();
            System.out.println("copyModelAltTo took : " + (t2 - t1) + " ms.");
        }
        return null;
    }

    @Override
    public synchronized void saveWorkspace(String user) throws RemoteException {
        HecFile file = this.identifier.getFile();
        if (file != null) {
            System.out.println("Save the Workspace " + this.getTitleName());
            this.writeConfiguration(file);
        } else {
            System.out.println("Workspace " + this.getName() + " not Saved.");
        }
        Enumeration e = this._childWorkspaceTable.elements();
        while (e.hasMoreElements()) {
            RmiWorkspace wksp = (RmiWorkspace)e.nextElement();
            if (wksp != null) {
                wksp.saveWorkspace(user);
                continue;
            }
            System.out.println("SaveWorkspace():Null child workspace.");
        }
    }

    @Override
    public synchronized void closeWorkspace(String user) throws RemoteException {
        System.out.println("Close the RmiWorkspace " + this.getName());
        this.removeUser(user);
        if (this._listOfUsers.size() < 1) {
            this.closeWorkspace();
            Enumeration e = this._childWorkspaceTable.elements();
            while (e.hasMoreElements()) {
                RmiWorkspaceImpl child = (RmiWorkspaceImpl)e.nextElement();
                child.closeWorkspace();
                if (!this.getNetworked()) continue;
                try {
                    PortableRmiObject.unexportObject((Remote)child, (boolean)true);
                }
                catch (Exception ee) {
                    ((MarkingClassLogger.Api)((MarkingClassLogger.Api)RMI_WORKSPACE_PROP_LOGGER.atFine()).withCause((Throwable)ee)).log("WARNING exception unexporting child %s", (Object)child.getName());
                }
            }
            if (this._rmiApp != null) {
                try {
                    this._rmiApp.removeWorkspace(this.getWorkspacePath());
                }
                catch (RemoteException re) {
                    System.out.println("closeWorkspace(): failed to remove myself from my RmiApp " + re);
                }
            } else {
                System.out.println("closeWorkspace():Null rmiApp");
            }
            if (this.getNetworked()) {
                try {
                    this.unbindServer();
                }
                catch (Exception re) {
                    // empty catch block
                }
                try {
                    PortableRmiObject.unexportObject((Remote)this, (boolean)true);
                }
                catch (Exception ee) {
                    ((MarkingClassLogger.Api)((MarkingClassLogger.Api)RMI_WORKSPACE_PROP_LOGGER.atFine()).withCause((Throwable)ee)).log("WARNING exception unexporting workspace %s", (Object)LazyArgs.lazy(() -> this.getName()));
                }
            }
            System.gc();
            System.gc();
        }
    }

    protected synchronized long getWorkspaceTime(HecFile file) {
        BufferedReader input = file.getBufferedReader();
        try {
            input.mark(2000);
            for (int i = 0; i < 8; ++i) {
                String line = input.readLine();
                if (line == null || line.indexOf("ModifiedTime") <= -1) continue;
                input.reset();
                String param = RMAIO.getParam((String)line, (String)"=");
                long modifiedTime = RMAIO.parseLong((String)param);
                return modifiedTime;
            }
            input.reset();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return Long.MIN_VALUE;
    }

    protected synchronized void readConfiguration(HecFile file) {
        BufferedReader input = file.getBufferedReader();
        try {
            String line = input.readLine();
            while (line != null) {
                line = line.trim();
                ((MarkingClassLogger.Api)RMI_WORKSPACE_PROP_LOGGER.atFine()).log(line);
                if (line.indexOf("MapBegin") > -1) {
                    this.readMap(input);
                } else if (line.indexOf("ManagerProxyBegin") > -1) {
                    this.readManagerProxy(input);
                } else {
                    String type = RMAIO.getType((String)line, (String)"=");
                    String param = RMAIO.getParam((String)line, (String)"=");
                    if (type.compareTo("WorkspaceName") == 0) {
                        this.setName(param);
                        this.identifier.setName(param);
                    } else if (type.compareTo("WorkspaceDescription") == 0) {
                        this.identifier.setDescription(param);
                    } else if (type.compareTo("Version") == 0) {
                        this._version = RMAIO.parseInt((String)param);
                    } else if (type.compareTo("AppVersion") == 0) {
                        this._wkspVersion = param;
                        String msg = HecRmiWorkspaceImpl.checkAppVersion(param, this.getName());
                        if (msg != null) {
                            throw new RuntimeException(msg);
                        }
                    } else if (type.compareTo("ModifiedTime") == 0) {
                        this._modifiedTime = RMAIO.parseLong((String)param);
                    } else if (type.compareTo("UnitSystemID") == 0) {
                        this._unitSystemId = RMAIO.parseInt((String)param);
                    } else if (type.compareTo("GmtOffset") == 0) {
                        this._gmtOffset = RMAIO.parseInt((String)param);
                    } else if (type.compareTo("Extents") == 0) {
                        StringTokenizer st = new StringTokenizer(param, ",");
                        String west = st.nextToken();
                        String east = st.nextToken();
                        String south = st.nextToken();
                        String north = st.nextToken();
                        double w = new Double(west);
                        double e = new Double(east);
                        double s = new Double(south);
                        double n = new Double(north);
                        this._extents = new WorldRect(w, n, e, s);
                    } else if (type.equals("Coordinate System")) {
                        if (param.equalsIgnoreCase("X-Y")) {
                            this._coordinateSystem = new XYCoordinateInfo();
                        }
                    } else if (type.equals("CoordinateInfoBegin")) {
                        this._coordinateSystem = CoordinateInfo.readObject((BufferedReader)input);
                    } else if (type.equals("Grow Extents")) {
                        this._growToExtents = param.equals("true");
                    } else if (type.compareTo("IconQualityInformation") == 0) {
                        this._iconQualityInformation = param;
                    } else if (type.equals("ManagerPosition")) {
                        if (this._managerOrderList == null) {
                            this._managerOrderList = new Vector();
                        }
                        this._managerOrderList.add(new MapPosition(param));
                    } else if (type.equals("ManagerIndex")) {
                        this.setManagerIndex(RMAIO.parseInt((String)param));
                    } else if (type.equals("StreamAlignmentUnits")) {
                        this._streamAlignmentUnits = param;
                    }
                }
                line = input.readLine();
            }
            input.close();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            ((MarkingClassLogger.Api)((MarkingClassLogger.Api)RMI_WORKSPACE_PROP_LOGGER.atWarning()).withCause((Throwable)e)).log("Error reading in Workspace data file");
        }
        if (this._version < 1001 && this._unitSystemId == 0) {
            this._unitSystemId = 2;
        }
        if (this._parentWorkspace == null) {
            this.createDefaultDataLists(this.getDataListContainer());
        }
    }

    private static String checkAppVersion(String wkspVersion, String wkspName) {
        String msg = AppVersion.checkAppVersion((String)wkspVersion, (String)wkspName);
        return msg;
    }

    protected synchronized void writeConfiguration(HecFile file) {
        this._version = VERSION;
        try {
            int ii;
            long modifiedTime = System.currentTimeMillis();
            BufferedWriter out = file.getBufferedWriter();
            this.lineWrite(out, "WorkspaceName=" + this.identifier.getName());
            this.lineWrite(out, "WorkspaceDescription=" + this.identifier.getDescription());
            this.lineWrite(out, "Version=" + this._version);
            if (AppVersion.shouldCheckAppVersion()) {
                String fullVersion = AppVersion.getAppVersion();
                if (fullVersion != null && !fullVersion.isEmpty()) {
                    this.lineWrite(out, "AppVersion=" + fullVersion);
                }
            } else if (this._wkspVersion != null) {
                this.lineWrite(out, "AppVersion=" + this._wkspVersion);
            }
            this.lineWrite(out, "ModifiedTime=" + modifiedTime);
            this.lineWrite(out, "UnitSystemID=" + this._unitSystemId);
            this.lineWrite(out, "GmtOffset=" + this._gmtOffset);
            if (this._streamAlignmentUnits != null && !this._streamAlignmentUnits.isEmpty()) {
                this.lineWrite(out, "StreamAlignmentUnits=" + this._streamAlignmentUnits);
            }
            String west = Double.toString(this._extents.w);
            String east = Double.toString(this._extents.e);
            String south = Double.toString(this._extents.s);
            String north = Double.toString(this._extents.n);
            if (!(west.equalsIgnoreCase("-infinity") && east.equalsIgnoreCase("-infinity") && south.equalsIgnoreCase("-infinity") && north.equalsIgnoreCase("-infinity"))) {
                String extents = "Extents=" + west + "," + east + "," + south + "," + north;
                this.lineWrite(out, extents);
            }
            if (this._coordinateSystem != null) {
                this._coordinateSystem.writeObject(out);
            }
            String growstr = this._growToExtents ? "true" : "false";
            this.lineWrite(out, "Grow Extents=" + growstr);
            if (this._iconQualityInformation != null) {
                this.lineWrite(out, "IconQualityInformation=" + this._iconQualityInformation);
            }
            this.lineWrite(out, "ManagerIndex=" + this.getManagerIndex());
            for (ii = 0; ii < this._mapIdentifiers.size(); ++ii) {
                MapIdentifier mapId = (MapIdentifier)this._mapIdentifiers.elementAt(ii);
                this.lineWrite(out, "");
                this.lineWrite(out, "MapBegin");
                this.lineWrite(out, "Name=" + mapId.getName());
                this.lineWrite(out, "Description=" + mapId.getDescription());
                this.writePath(out, mapId.getPath(), "Path=");
                this.lineWrite(out, "Shown=" + mapId.getMapShown());
                this.lineWrite(out, "Class=" + mapId.getClassName());
                this.lineWrite(out, "MaxScaleValue=" + mapId.getMaximumScale());
                this.lineWrite(out, "MinScaleValue=" + mapId.getMinimumScale());
                long modified = mapId.getModifiedTime();
                if (modified == Long.MIN_VALUE) {
                    modified = modifiedTime;
                }
                this.lineWrite(out, "ModifiedTime=" + modified);
                GlyphDataRecord rec = mapId.getGlyphDataRecord();
                if (rec != null) {
                    if (rec instanceof GlyphDataRecordSerializable) {
                        String mapsDirectory = RmiWorkspaceImpl.MAPS_DIR_TEMPLATE.format(new String[]{this.getWorkspacePath()});
                        Object asciiSerializedFilePath = mapsDirectory;
                        asciiSerializedFilePath = (String)asciiSerializedFilePath + "/" + RMAIO.getFileNameNoExtension((String)mapId.getPath());
                        asciiSerializedFilePath = (String)asciiSerializedFilePath + ".gdr";
                        if (rec.isModified()) {
                            Identifier asciiSerializedFileIdRequest = new Identifier((String)asciiSerializedFilePath);
                            Identifier asciiSerializedFileId = this.openFile(UserId.getUserId(), asciiSerializedFileIdRequest);
                            if (asciiSerializedFileId == null) {
                                asciiSerializedFileId = this.newFile(UserId.getUserId(), asciiSerializedFileIdRequest);
                            }
                            if (asciiSerializedFileId == null) {
                                System.out.println("writeConfiguration: failed to open or create file " + (String)asciiSerializedFilePath);
                                this.lineWrite(out, "MapEnd");
                                continue;
                            }
                            try {
                                HecFile hecFile = asciiSerializedFileId.getFile();
                                if (hecFile == null) {
                                    System.out.println("writeConfiguration: failed to open or create file " + asciiSerializedFileId.getPath());
                                    this.lineWrite(out, "MapEnd");
                                    continue;
                                }
                                BufferedWriter bw = hecFile.getBufferedWriter();
                                if (bw == null) {
                                    Vector lockers = this.getFileManager().getLockers(asciiSerializedFileIdRequest);
                                    StringBuffer lockedBy = null;
                                    if (lockers != null && lockers.size() > 0) {
                                        lockedBy = new StringBuffer();
                                        int jj = 0;
                                        while (ii < lockers.size()) {
                                            Object o = lockers.get(jj);
                                            if (o != null) {
                                                lockedBy.append(o);
                                                lockedBy.append(", ");
                                            }
                                            ++jj;
                                        }
                                        if (lockedBy.length() >= 2) {
                                            lockedBy.setLength(lockedBy.length() - 2);
                                        }
                                    }
                                    StringBuffer sb = new StringBuffer("writeConfiguration: failed to lock file ");
                                    sb.append(asciiSerializedFileId.getPath());
                                    if (lockedBy != null) {
                                        sb.append("locked by: ");
                                        sb.append(lockedBy);
                                    }
                                    System.out.println(sb.toString());
                                    this.lineWrite(out, "MapEnd");
                                    continue;
                                }
                                ((GlyphDataRecordSerializable)rec).serialize(bw);
                                bw.close();
                            }
                            catch (Exception iioe) {
                                System.out.println("writeConfiguration: Error writing " + asciiSerializedFileId.getPath() + " Error:" + iioe);
                                this.lineWrite(out, "MapEnd");
                                continue;
                            }
                            this.writePath(out, (String)asciiSerializedFilePath, "GlyphDataRecordSerialized=" + rec.getClass().getName() + ",");
                        } else {
                            this.writePath(out, (String)asciiSerializedFilePath, "GlyphDataRecordSerialized=" + rec.getClass().getName() + ",");
                        }
                    } else {
                        this.lineWrite(out, "GlyphDataRecordBegin");
                        rec.write(out);
                        this.lineWrite(out, "GlyphDataRecordEnd");
                    }
                }
                this.lineWrite(out, "MapEnd");
            }
            for (ii = 0; ii < this._managerProxys.size(); ++ii) {
                ManagerProxy proxy = (ManagerProxy)this._managerProxys.elementAt(ii);
                proxy.write(out);
            }
            if (this._managerOrderList != null) {
                out.newLine();
                for (ii = 0; ii < this._managerOrderList.size(); ++ii) {
                    this.lineWrite(out, "ManagerPosition=" + this._managerOrderList.get(ii));
                }
                out.newLine();
            }
            out.flush();
            out.close();
            file.save();
        }
        catch (Exception e) {
            System.out.println("Exception trying to write configuration " + file.getPath());
            System.out.println(e.getMessage() + "...." + e.toString());
            e.printStackTrace(System.out);
        }
    }

    @Override
    public void createDefaultDataLists() {
        this.createDefaultDataLists(this.getDataListContainer());
    }

    @Override
    public void createDefaultDataLists(RmiDataListContainer dataListContainer) {
        String[] defaultLists = new String[]{"hec.watershed.model.Study", "hec.watershed.model.Reservoir", "hec.watershed.model.Levee", "hec.watershed.model.ChannelMod", "hec.watershed.model.OtherProject", "hec.watershed.model.StoragePool", "hec.watershed.model.ImpactArea", "hec.watershed.model.ComputationPoint", "hec.watershed.model.ComputationPointLayer", "hec.watershed.model.Condition", "hec.watershed.model.Diversion", "hec.watershed.model.StationSet", "hec.model.ModifiedTime"};
        this.createDefaultDataLists(dataListContainer, defaultLists);
    }

    @Override
    public synchronized int getNextManagerIndex() {
        return ++this._nextIndex;
    }

    protected int getManagerIndex() {
        return this._nextIndex;
    }

    protected void setManagerIndex(int idx) {
        this._nextIndex = idx;
    }

    @Override
    public Vector getManagerProxyList(String model, String className) {
        if (model.equals("") || model.equalsIgnoreCase("main")) {
            int size = this._managerProxys.size();
            Vector<ManagerProxy> proxyList = new Vector<ManagerProxy>(size);
            for (int i = 0; i < size; ++i) {
                ManagerProxy proxy = (ManagerProxy)this._managerProxys.get(i);
                if (proxy == null || proxy.getId() == null || !proxy.getClassName().equals(className)) continue;
                proxyList.add(new ManagerProxy(proxy));
            }
            proxyList.trimToSize();
            return proxyList;
        }
        RmiWorkspaceImpl childWksp = (RmiWorkspaceImpl)this.getChildWorkspace(model);
        return childWksp.getManagerProxyList(model, className);
    }

    @Override
    public void removeCallBack(RmiWkspCallBack callBack) throws RemoteException {
        if (this._callBackObjects.removeElement(callBack)) {
            // empty if block
        }
        Enumeration e = this._childWorkspaceTable.elements();
        while (e.hasMoreElements()) {
            RmiWorkspace child = (RmiWorkspace)e.nextElement();
            if (child == null) continue;
            child.removeCallBack(callBack);
        }
    }

    @Override
    public boolean addUser(String user) {
        if (super.addUser(user)) {
            this.fireUserChange(user, "opened");
            return true;
        }
        return false;
    }

    @Override
    public void removeUser(String user) throws RemoteException {
        super.removeUser(user);
        this.fireUserChange(user, "closed");
    }

    protected void fireUserChange(final String user, final String changeType) {
        Thread t = new Thread("User Change Notification"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Vector vector = HecRmiWorkspaceImpl.this._callBackObjects;
                synchronized (vector) {
                    System.out.println("fireUserChange: user=" + user + " change=" + changeType + " Callback count=" + HecRmiWorkspaceImpl.this._callBackObjects.size());
                    for (int ii = HecRmiWorkspaceImpl.this._callBackObjects.size() - 1; ii >= 0; --ii) {
                        RmiWkspCallBack callBack = (RmiWkspCallBack)HecRmiWorkspaceImpl.this._callBackObjects.elementAt(ii);
                        try {
                            callBack.userChanged(user, changeType);
                            continue;
                        }
                        catch (RemoteException re) {
                            System.out.println("fireUserChange rmi Exception " + re);
                            HecRmiWorkspaceImpl.this._callBackObjects.remove(ii);
                        }
                    }
                }
            }
        };
        t.start();
    }

    protected Remote getClientSideProxies(Remote server) {
        server = super.getClientSideProxies(server);
        server = (RmiWorkspace)Proxy.newProxyInstance(RmiWorkspace.class.getClassLoader(), new Class[]{RmiWorkspace.class}, (InvocationHandler)new NotifyUserProxy((Object)server, "Unable to communicate with Watershed " + this.getTitleName()));
        return server;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ExportResults export(WkspExportOptions options) {
        Identifier openId;
        RmiFileManager fm;
        ExportResults results = new ExportResults();
        String newDirectory = options.getWkspDirectory();
        String wkspName = options.getWkspName();
        String newWkspFileName = RMAIO.userNameToFileName((String)wkspName) + "." + this.getWorkspaceExt();
        String newWkspFile = newDirectory + "/" + newWkspFileName;
        try {
            fm = this.getFileManager();
        }
        catch (RemoteException e2) {
            System.out.println("export:failed to getRmiFileManager " + e2);
            results.setSuccessful(false);
            results.addMessage("Error getting RmiFileManager " + e2);
            return results;
        }
        Identifier id = new Identifier(newWkspFile);
        try {
            openId = fm.newFile(UserId.getUserId(), id);
        }
        catch (RemoteException e) {
            System.out.println("saveAs:********* Exception creating new wksp directory " + e);
            results.addMessage("Exception creating new Watershed " + newWkspFile + " Error:" + e);
            results.setSuccessful(false);
            return results;
        }
        if (openId == null && !options.isExistingOk()) {
            results.addMessage("Watershed file " + newWkspFile + " already exists");
            results.setSuccessful(false);
            return results;
        }
        boolean copyOk = true;
        if (options.shouldCopyStudyDirectory() && !this.saveStudyDir(options, newDirectory, fm)) {
            results.addMessage("Failed to copy Study directory");
            results.setSuccessful(false);
        }
        if (!this.saveWkspDir("shared", newDirectory, fm)) {
            results.addMessage("Failed to copy shared directory");
            results.setSuccessful(false);
        }
        if (!this.saveWkspDir("maps", newDirectory, fm)) {
            results.addMessage("Failed to copy maps directory");
            results.setSuccessful(false);
        }
        if (!this.saveWkspDir("scripts", newDirectory, fm)) {
            results.addMessage("Failed to copy scripts directory");
            results.setSuccessful(false);
        }
        String wkspDir = this.getWorkspacePath();
        Identifier wkspId = new Identifier(wkspDir);
        Identifier newWkspId = new Identifier(newDirectory);
        try {
            if (!fm.copyDirectory(wkspId, newWkspId, false)) {
                results.addMessage("Failed to copy watershed directory " + wkspDir);
                results.setSuccessful(false);
            }
        }
        catch (RemoteException e1) {
            System.out.println("RemoteException " + e1);
            e1.printStackTrace();
            results.setSuccessful(false);
        }
        String wkspFile = this.getWorkspaceFile();
        String wkspFileName = RMAIO.getFileFromPath((String)wkspFile);
        String copiedWkspFile = newDirectory + "/" + wkspFileName;
        Identifier oldId = new Identifier(copiedWkspFile);
        Identifier newId = new Identifier(newWkspFile);
        boolean rv = false;
        try {
            rv = fm.copyFile(oldId, newId);
        }
        catch (RemoteException e1) {
            System.out.println("RemoteException " + e1);
            e1.printStackTrace();
            results.setSuccessful(false);
        }
        if (!rv) {
            results.addMessage("Failed to copy new watershed file. src=" + oldId.getPath() + " dest=" + newId.getPath());
            results.setSuccessful(false);
        } else {
            try {
                openId = fm.openFile(UserId.getUserId(), newId);
            }
            catch (RemoteException e1) {
                System.out.println("RemoteException " + e1);
                e1.printStackTrace();
                results.setSuccessful(false);
            }
            if (openId == null) {
                results.addMessage("Failed to update watershed file");
                results.setSuccessful(false);
            } else {
                ArrayList<String> lines = new ArrayList<String>();
                BufferedReader reader = openId.getFile().getBufferedReader();
                try {
                    Object line;
                    while ((line = reader.readLine()) != null) {
                        if (((String)line).startsWith("WorkspaceName")) {
                            line = "WorkspaceName=" + wkspName;
                        }
                        lines.add((String)line);
                    }
                }
                catch (IOException e) {
                    System.out.println("IOException " + e);
                    e.printStackTrace();
                    results.setSuccessful(false);
                }
                finally {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (IOException e) {}
                    }
                }
                BufferedWriter writer = openId.getFile().getBufferedWriter();
                try {
                    for (int i = 0; i < lines.size(); ++i) {
                        writer.write((String)lines.get(i));
                        writer.newLine();
                    }
                }
                catch (IOException e) {
                    System.out.println("IOException " + e);
                    e.printStackTrace();
                    results.setSuccessful(false);
                }
                finally {
                    try {
                        if (writer != null) {
                            writer.close();
                        }
                    }
                    catch (IOException e) {}
                }
            }
        }
        Set<String> keys = RmiWorkspaceImpl._childWorkspaceClasses.keySet();
        for (String wkspType : keys) {
            RmiWorkspace wksp = this.getChildWorkspace(wkspType);
            if (wksp == null || !options.shouldCopyChildWorkspace(wkspType)) continue;
            try {
                ExportResults sar = wksp.export(options);
                results.combine(sar);
            }
            catch (RemoteException e) {
                System.out.println("saveAs:******Exception saving child wksp" + wkspType + " Error:" + e);
                copyOk = false;
            }
        }
        return results;
    }

    private boolean saveStudyDir(WkspExportOptions options, String newDirectory, RmiFileManager fm) {
        List excludedProjects = options.getExcludedProjects();
        if (excludedProjects == null || excludedProjects.size() == 0) {
            return this.saveWkspDir("study", newDirectory, fm);
        }
        String wkspPath = this.getWorkspacePath();
        String studySubDir = wkspPath + "/study";
        String newSubDir = newDirectory + "/study";
        boolean allOk = true;
        try {
            Vector fileIds = fm.getRemoteFileIDList(UserId.getUserId(), studySubDir, (String)null);
            if (fileIds == null) {
                return true;
            }
            for (int i = 0; i < fileIds.size(); ++i) {
                String newFilename;
                Identifier dest;
                Identifier id = (Identifier)fileIds.get(i);
                this.name = RMAIO.getFileNameNoExtension((String)id.getPath());
                if (excludedProjects.contains(this.name) || new File(id.getPath()).isDirectory() || fm.copyFile(id, dest = new Identifier(newFilename = newSubDir.concat("/").concat(id.getName())))) continue;
                System.out.println("saveStudyDir:failed to copy file " + id.getPath() + " to " + dest.getPath());
                allOk = false;
            }
        }
        catch (RemoteException e) {
            System.out.println("saveStudyDir:RMI Exception saving the study directory " + studySubDir + " Error:" + e);
            return false;
        }
        return allOk;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invokeManagerCallBack(int type, ManagerProxy proxy, String model) {
        Vector vector = this._callBackObjects;
        synchronized (vector) {
            ManagerProxy proxyCopy = null;
            for (int ii = this._callBackObjects.size() - 1; ii >= 0; --ii) {
                if (proxyCopy == null) {
                    proxyCopy = new ManagerProxy(proxy);
                    proxyCopy.setProxyList(null);
                }
                RmiWkspCallBack callBack = (RmiWkspCallBack)this._callBackObjects.elementAt(ii);
                try {
                    callBack.managerChanged(type, proxyCopy, model);
                    continue;
                }
                catch (RemoteException re) {
                    this._callBackObjects.remove(ii);
                }
            }
        }
    }

    @Override
    public String getStreamAlignmentUnits() {
        String retVal = this._streamAlignmentUnits;
        if (this._baseWorkspace != null) {
            try {
                retVal = this._baseWorkspace.getStreamAlignmentUnits();
            }
            catch (RemoteException e) {
                ((MarkingClassLogger.Api)RMI_WORKSPACE_PROP_LOGGER.at(Level.SEVERE).withCause((Throwable)e)).log("Error getting stream alignment units");
            }
        }
        return retVal;
    }

    @Override
    public void setStreamAlignmentUnits(String units) {
        this._streamAlignmentUnits = units;
    }

    @Override
    public String getWorkspaceVersion() {
        return this._wkspVersion;
    }
}

