/*
 * Decompiled with CFR 0.152.
 */
package hec.clientapp.server;

import hec.clientapp.rmi.csinterface.RmiApp;
import hec.clientapp.server.RmiAppImpl;
import hec.io.HecFile;
import hec.io.Identifier;
import hec.io.LogPrintStream;
import hec.model.JobTask;
import hec.model.SchedulableJob;
import hec.model.Scheduler;
import hec.script.ScriptJob;
import hec.script.ServerScriptJobTask;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.OutputStream;
import java.io.PrintStream;
import java.rmi.Naming;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.SimpleTimeZone;
import java.util.TimeZone;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import mil.army.usace.hec.rmi.csinterface.RMIScheduler;
import mil.army.usace.hec.rmi.csinterface.RmiFileManager;
import mil.army.usace.hec.rmi.io.HecAsciiDeserializer;
import mil.army.usace.hec.rmi.io.HecAsciiSerializer;
import mil.army.usace.hec.rmi.server.PortableRmiObject;
import rma.util.RMAIO;

public class RMISchedulerImpl
extends PortableRmiObject
implements RMIScheduler,
Scheduler {
    private String _name = "RMIScheduler";
    private Vector _listenerList = new Vector();
    private LogPrintStream _logFileStream;
    private PrintStream _log;
    private Date _date = new Date();
    private Timer _timer = new Timer(true);
    private Vector _currentTasks = new Vector();
    private Identifier _stateId = null;
    private String _serverUrl = null;
    private boolean _isModified = false;
    private String _logdir = null;
    private int _tzOffset;

    public RMISchedulerImpl(int port) throws RemoteException {
        super(port);
        String url = this.getUrl();
        this.setName(this._name);
        this.openLog();
        TimeZone tz = TimeZone.getDefault();
        this.logMessage("init: system TimeZone offset is " + this._tzOffset + " hours");
        this.logMessage(this.getName() + " started. " + tz.getDisplayName(tz.useDaylightTime(), 0, Locale.getDefault()));
        this.logMessage(System.getProperty("user.timezone"));
        this._tzOffset = tz.getRawOffset() / 3600000;
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                RMISchedulerImpl.this.writeJobs(RMISchedulerImpl.this._stateId);
            }
        });
        try {
            Remote remote;
            this._serverUrl = url;
            this.logMessage("My's URL is " + this._serverUrl);
            if (url.endsWith("/")) {
                url = url.concat("FileManager");
            }
            if ((remote = Naming.lookup(url)) instanceof RmiFileManager) {
                RmiFileManager fm = (RmiFileManager)remote;
                String cwmsHome = System.getProperty("CWMS_HOME");
                Object path = cwmsHome == null ? System.getProperty("user.dir") : cwmsHome;
                String dir = System.getProperty("schedulerEntries.directory", "dated/scheduler/");
                path = (String)path + "/" + dir + this.name + ".entries";
                Identifier id = new Identifier((String)path);
                this._stateId = fm.openFile(this._name, id);
                if (this._stateId == null) {
                    this._stateId = fm.newFile(this._name, id);
                } else {
                    this.readJobs(this._stateId);
                }
            } else {
                this.logMessage("init:failed to find RmiFileManager ");
            }
        }
        catch (Exception e) {
            this.logMessage("init:Exception during startup " + e);
        }
    }

    public RMISchedulerImpl(RmiApp app) throws RemoteException {
        this.setName(this._name);
        this.openLog();
        TimeZone tz = TimeZone.getDefault();
        this.logMessage("init: system TimeZone offset is " + this._tzOffset + " hours");
        this.logMessage(this.getName() + " started. " + tz.getDisplayName(tz.useDaylightTime(), 0, Locale.getDefault()));
        this.logMessage(System.getProperty("user.timezone"));
        this._tzOffset = tz.getRawOffset() / 3600000;
        if (app == null) {
            this.logMessage("ERROR:Null RmiApp");
            throw new IllegalArgumentException("Null RmiApp");
        }
        if (RMAIO.getJavaVersion() >= 2) {
            try {
                Runtime.getRuntime().addShutdownHook(new Thread(){

                    @Override
                    public void run() {
                        RMISchedulerImpl.this.writeJobs(RMISchedulerImpl.this._stateId);
                    }
                });
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
        try {
            this._serverUrl = ((RmiAppImpl)app).getUrl() + ((RmiAppImpl)app).getName();
            this.logMessage("RmiApp's URL is " + this._serverUrl);
            RmiFileManager fm = app.getFileManager();
            String cwmsHome = System.getProperty("CWMS_HOME");
            Object path = cwmsHome == null ? System.getProperty("user.dir") : cwmsHome;
            String dir = System.getProperty("schedulerEntries.directory", "dated/scheduler/");
            path = (String)path + "/" + dir + this.name + ".entries";
            Identifier id = new Identifier((String)path);
            this._stateId = fm.openFile(this._name, id);
            if (this._stateId == null) {
                this._stateId = fm.newFile(this._name, id);
            } else {
                this.readJobs(this._stateId);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public RMISchedulerImpl() throws RemoteException {
        String url = this.getUrl();
        this.setName(this._name);
        this.openLog();
        TimeZone tz = TimeZone.getDefault();
        this.logMessage("init: system TimeZone offset is " + this._tzOffset + " hours");
        this.logMessage(this.getName() + " started. " + tz.getDisplayName(tz.useDaylightTime(), 0, Locale.getDefault()));
        this.logMessage(System.getProperty("user.timezone"));
        this._tzOffset = tz.getRawOffset() / 3600000;
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                RMISchedulerImpl.this.writeJobs(RMISchedulerImpl.this._stateId);
            }
        });
        try {
            this._serverUrl = url;
            this.logMessage("My's URL is " + this._serverUrl);
            Remote remote = Naming.lookup(this._serverUrl);
            if (remote instanceof RmiFileManager) {
                RmiFileManager fm = (RmiFileManager)remote;
                String cwmsHome = System.getProperty("CWMS_HOME");
                Object path = cwmsHome == null ? System.getProperty("user.dir") : cwmsHome;
                String dir = System.getProperty("schedulerEntries.directory", "dated/scheduler/");
                path = (String)path + "/" + dir + this.name + ".entries";
                Identifier id = new Identifier((String)path);
                this._stateId = fm.openFile(this._name, id);
                if (this._stateId == null) {
                    this._stateId = fm.newFile(this._name, id);
                } else {
                    this.readJobs(this._stateId);
                }
            } else {
                this.logMessage("init:failed to find RmiFileManager at " + this._serverUrl);
            }
        }
        catch (Exception e) {
            this.logMessage("init:Exception during startup " + e);
        }
    }

    protected boolean scheduleTask(JobTask task, long startMillis) {
        boolean added = false;
        if (task == null || task.getJob() == null) {
            return added;
        }
        SchedulableJob job = task.getJob();
        if (job == null) {
            return added;
        }
        added = true;
        Date startDate = new Date(startMillis);
        task.setParent((Scheduler)this);
        if (job.isRecurring()) {
            this._timer.scheduleAtFixedRate((TimerTask)task, startDate, job.getPeriod());
            this.logMessage("scheduleTask: scheduled recurring job " + task.getName() + " for " + startDate + " interval " + job.getIntervalString() + "(" + job.getPeriod() + " ms)");
        } else {
            this._timer.schedule((TimerTask)task, startDate);
            this.logMessage("scheduleTask: scheduled job " + task.getName() + " for " + startDate);
        }
        return added;
    }

    protected boolean scheduleTask(JobTask task) {
        boolean added = false;
        if (task == null) {
            this.logMessage("scheculeTask:  Null task received.");
        } else {
            SchedulableJob job = task.getJob();
            if (job == null) {
                this.logMessage("scheculeTask:  Task with null job received.");
            } else {
                int tzOffset = job.getTimezoneOffset();
                int tzDiff = tzOffset - this._tzOffset;
                this.logMessage("scheduleTask: " + task.getName() + " tzoffset=" + tzOffset);
                this.logMessage("scheduleTask: job tzoffset=" + tzOffset + " my tzOffset=" + this._tzOffset);
                this.logMessage("scheduleTask: job start=" + job.getStartDate() + " start date string=" + job.getStartDateString());
                long startMillis = job.getStartDate().getTime();
                SimpleTimeZone tz = new SimpleTimeZone(tzDiff * 3600000, "foo");
                Date startDate = new Date(startMillis += (long)(tzDiff * 3600000));
                if (tzDiff != 0) {
                    GregorianCalendar cal = new GregorianCalendar(tz);
                    cal.setTime(startDate);
                    cal.setTimeZone(tz);
                    startDate = cal.getTime();
                } else {
                    SimpleDateFormat sdf = new SimpleDateFormat();
                    String startDateString = job.getStartDateString();
                    try {
                        if (startDateString.length() == 18) {
                            sdf.applyPattern("ddMMMyyyy,HHmm zzz");
                            startDate = sdf.parse(startDateString);
                        } else {
                            sdf.applyPattern("ddMMMyyyy,HHmm");
                            startDate = sdf.parse(startDateString);
                        }
                    }
                    catch (Exception e) {
                        System.out.println("scheduleTask:exception parsing date " + startDateString + " error:" + e);
                        return false;
                    }
                }
                this.logMessage("scheduleTask: scheduling " + job.getName() + " for " + startDate);
                if (startDate != null) {
                    added = true;
                    task.setParent((Scheduler)this);
                    if (job.isRecurring()) {
                        this._timer.scheduleAtFixedRate((TimerTask)task, startDate, job.getPeriod());
                        this.logMessage("scheduleTask: scheduled recurring job " + task.getName() + " for " + startDate + " interval " + job.getIntervalString() + "(" + job.getPeriod() + " ms)");
                    } else {
                        this._timer.schedule((TimerTask)task, startDate);
                        this.logMessage("scheduleTask: scheduled job " + task.getName() + " for " + startDate);
                    }
                } else {
                    this.logMessage("scheduleTask: no start date for " + task.getName());
                }
            }
        }
        return added;
    }

    public boolean scheduleJob(SchedulableJob job) {
        boolean added = false;
        if (job == null) {
            this.logMessage("scheduleJob: recieved null job");
            return added;
        }
        this.logMessage("scheduleJob: recieved job " + job.getName() + " to run at " + job.getStartDate());
        ServerScriptJobTask task = null;
        if (job instanceof ScriptJob) {
            task = new ServerScriptJobTask((ScriptJob)job, this._serverUrl);
            added = this.scheduleTask((JobTask)task);
        } else {
            this.logMessage("scheduleJob: received job of unsupported type " + job.getClass());
        }
        if (added) {
            this._currentTasks.addElement(task);
            this.writeJobs(this._stateId);
        }
        return added;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteJob(String jobName) {
        boolean deleted = false;
        if (jobName == null || jobName.length() < 1) {
            this.logMessage("deleteJob: recieved null or empty jobname to delete");
            return deleted;
        }
        this.logMessage("deleteJob: asked to delete " + jobName);
        Vector vector = this._currentTasks;
        synchronized (vector) {
            int size = this._currentTasks.size();
            for (int i = 0; i < size; ++i) {
                JobTask jobTask = (JobTask)this._currentTasks.elementAt(i);
                if (!jobTask.getName().equals(jobName)) continue;
                jobTask.cancel();
                this._currentTasks.remove(jobTask);
                this.logMessage("deleteJob: removed job " + jobName);
                deleted = true;
                break;
            }
        }
        if (deleted) {
            this.writeJobs(this._stateId);
        }
        return deleted;
    }

    public Vector jobsStatus() {
        return (Vector)this._currentTasks.clone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setJobPaused(String jobName, boolean paused) {
        Object job = null;
        if (jobName == null || jobName.length() < 1) {
            this.logMessage("pauseJob: recieved null or empty jobname");
            return false;
        }
        this.logMessage("setJobPaused: job=" + jobName + " paused=" + paused);
        JobTask jobTask = null;
        Vector vector = this._currentTasks;
        synchronized (vector) {
            int size = this._currentTasks.size();
            for (int i = 0; i < size; ++i) {
                jobTask = (JobTask)this._currentTasks.elementAt(i);
                if (!jobTask.getName().equals(jobName)) continue;
                jobTask.setPaused(paused);
                break;
            }
        }
        return jobTask != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SchedulableJob getJob(String jobName) throws RemoteException {
        SchedulableJob job = null;
        if (jobName == null || jobName.length() < 1) {
            this.logMessage("getJob: recieved null or empty jobname");
            return job;
        }
        this.logMessage("getJob:jobName=" + jobName);
        Vector vector = this._currentTasks;
        synchronized (vector) {
            int size = this._currentTasks.size();
            for (int i = 0; i < size; ++i) {
                JobTask jobTask = (JobTask)this._currentTasks.elementAt(i);
                if (!jobTask.getName().equals(jobName)) continue;
                job = jobTask.getJob();
                break;
            }
        }
        return job;
    }

    private void openLog() {
        try {
            this._logdir = System.getProperty("logfile.directory", ".");
            this._logdir = RMAIO.parsePathName((String)this._logdir);
            String logName = this._name;
            try {
                String name = this.getName();
                logName = System.getProperty("logfile.schedulerFileName", name);
            }
            catch (Exception name) {
                // empty catch block
            }
            String logTimeCycle = System.getProperty("logfile.timeCycle", "dy");
            boolean useUTC = Boolean.getBoolean("logfile.useUTC");
            System.out.println("setupLogfile(): dir=" + this._logdir + " name=" + logName + " cycle=" + logTimeCycle);
            this._logFileStream = new LogPrintStream(this._logdir, logName, logTimeCycle, !useUTC, false);
            this._log = new PrintStream((OutputStream)this._logFileStream);
        }
        catch (Exception ioe) {
            System.out.println("RMISchedulerImpl: failed to open logfile " + ioe);
        }
    }

    public void logException(Throwable t) {
        if (t == null) {
            return;
        }
        t.printStackTrace(this._log);
    }

    public void logMessage(String msg) {
        if (this._log == null) {
            System.out.println(this.name + ":" + msg);
            return;
        }
        try {
            if (this._date == null) {
                this._date = new Date();
            }
            this._date.setTime(System.currentTimeMillis());
            this._log.println(this._date.toString() + ":" + msg);
        }
        catch (Exception ioe) {
            System.out.println(this.name + ":Error writing to log " + ioe);
            System.out.println(this.name + ":" + msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void readJobs(Identifier id) {
        if (id == null) {
            return;
        }
        HecFile file = id.getFile();
        if (file == null) {
            return;
        }
        try {
            this.logMessage("readJobs: reading from " + file.getPath());
            BufferedReader reader = file.getBufferedReader();
            HecAsciiDeserializer serializer = new HecAsciiDeserializer(reader);
            serializer.deserializeObject((Object)this._currentTasks);
            reader.close();
        }
        catch (Exception e) {
            this.logMessage("readJobs: error reading jobs " + e);
        }
        this.logMessage("readJobs: read in " + this._currentTasks.size() + " jobs");
        Vector vector = this._currentTasks;
        synchronized (vector) {
            long timeNow = System.currentTimeMillis();
            int size = this._currentTasks.size();
            for (int i = 0; i < size; ++i) {
                Object obj = this._currentTasks.elementAt(i);
                JobTask task = (JobTask)obj;
                SchedulableJob job = task.getJob();
                if (job == null) continue;
                if (task instanceof ServerScriptJobTask) {
                    ((ServerScriptJobTask)task).setServerUrl(this._serverUrl);
                }
                if (job.getStartDate().getTime() < timeNow && !job.isRecurring()) {
                    this.logMessage("readJobs: dropped non recurring task " + job.getName() + " scheduled to start before now");
                    task.setJobStatus("", "Client not logged in");
                    continue;
                }
                if (!job.isRecurring() && task.getLastRunTime() > 0L) continue;
                if (job.isRecurring() && job.getStartDate().getTime() < timeNow) {
                    long millis;
                    for (millis = job.getStartDate().getTime() + job.getPeriod(); millis < timeNow; millis += job.getPeriod()) {
                    }
                    this.scheduleTask(task, millis);
                    continue;
                }
                this.scheduleTask(task);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeJobs(Identifier id) {
        if (id == null) {
            return;
        }
        HecFile file = id.getFile();
        if (file == null) {
            return;
        }
        BufferedWriter writer = file.getBufferedWriter();
        if (writer == null) {
            this.logMessage("writeJobs: WARNING. failed to get writer for " + file.getPath());
        }
        try {
            this.logMessage("writeJobs: saving to " + file.getPath());
            HecAsciiSerializer serializer = new HecAsciiSerializer(writer);
            if (serializer.serializeObject((Object)this._currentTasks)) {
                this._isModified = false;
            }
        }
        catch (Exception e) {
            this.logMessage("writeJobs: error writing jobs to " + id.getPath() + " error " + e);
            e.printStackTrace(this._log);
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public void setModified(boolean b) {
        this._isModified = b;
    }

    public boolean isModified() {
        return this._isModified;
    }

    public String getLogDirectory() throws RemoteException {
        return this._logdir;
    }

    public boolean isAlive() throws RemoteException {
        return true;
    }
}

