/*
 * Decompiled with CFR 0.152.
 */
package hec.clientapp.server;

import hec.clientapp.properties.HECGlobalProperties;
import hec.clientapp.rmi.admin.RmiAppStatus;
import hec.clientapp.rmi.csinterface.RmiApp;
import hec.clientapp.rmi.csinterface.RmiWorkspace;
import hec.clientapp.server.HecRmiWorkspaceImpl;
import hec.clientapp.server.RMISchedulerImpl;
import hec.clientapp.server.RmiWorkspaceImpl;
import hec.heclib.dss.HecDSSFileAccess;
import hec.heclib.util.HecDouble;
import hec.io.HecFile;
import hec.io.Identifier;
import hec.io.StatusObject;
import hec.lang.UserId;
import hec.lang.WorkspaceExistsException;
import hec.model.WatershedLocation;
import hec.properties.RmiAppProperties;
import hec.server.AppVersion;
import java.io.BufferedReader;
import java.io.File;
import java.io.FilenameFilter;
import java.lang.reflect.Constructor;
import java.rmi.Naming;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.TimeZone;
import java.util.Vector;
import mil.army.usace.hec.rmi.csinterface.RMIScheduler;
import mil.army.usace.hec.rmi.csinterface.RmiFileManager;
import mil.army.usace.hec.rmi.csinterface.RmiProgress;
import mil.army.usace.hec.rmi.msgsystem.Msg;
import mil.army.usace.hec.rmi.server.RemoteWrapper;
import mil.army.usace.hec.rmi.server.StatusReportingServer;
import rma.util.PlugInLoader;
import rma.util.PluginFileNameComparator;
import rma.util.RMAIO;
import rma.util.WildCardFileFilter;
import rma.util.logging.MarkingClassLogger;

public class RmiAppImpl
extends StatusReportingServer
implements RmiApp {
    private static final MarkingClassLogger MARKING_CLASS_LOGGER = MarkingClassLogger.forMarkingClass(StatusReportingServer.class);
    private static RmiAppImpl _app;
    protected RemoteWrapper _fileManager;
    protected Hashtable _rmiAppHashtable = new Hashtable();
    protected Hashtable _rmiWorkspaces = new Hashtable();
    protected String _rmiAppType = "";
    protected String _rmiWorkspaceClassString = HecRmiWorkspaceImpl.class.getName();
    protected String _workspaceExt = "wksp";
    protected String _error = "";
    protected String _defaultWorkspaceDescriptionDefinition = "WorkspaceDescription";
    protected String _defaultWorkspaceNameDefinition = "WorkspaceName";
    RemoteWrapper _rmiSchedulerWrapper = null;
    protected Vector _watershedLocations = new Vector();
    private boolean _propsLoaded = false;

    public RmiAppImpl(int port) throws RemoteException {
        super(port);
        this.setName("RmiAppImpl");
        _app = this;
        this.loadPlugins();
    }

    public RmiAppImpl(String name) throws RemoteException {
        this(8089);
        this.setName(name);
        _app = this;
        this.loadPlugins();
    }

    public RmiAppImpl(int port, String name) throws RemoteException {
        super(port);
        this.setName(name);
        _app = this;
        this.loadPlugins();
    }

    public void setAppVersion(String appVersion) {
        AppVersion.setAppVersion((String)appVersion);
    }

    protected void echo(String string) {
        System.out.println(string);
    }

    @Override
    public void setServer(String url, String type) throws RemoteException {
        try {
            RmiApp rmiApp = (RmiApp)((Object)Naming.lookup(url));
            this._rmiAppHashtable.put(type, rmiApp);
            System.out.println("Created RMI Object: " + url);
        }
        catch (Exception e) {
            System.out.println("Could not create RMI Object: " + url);
        }
    }

    @Override
    public RmiApp getServer(String type) {
        RmiApp rmiApp = (RmiApp)this._rmiAppHashtable.get(type);
        return rmiApp;
    }

    @Override
    public Class getClass(String name) {
        try {
            return Class.forName(name);
        }
        catch (ClassNotFoundException cnfe) {
            System.out.println("Error: class " + name + " not found.");
            System.out.println("Exception: " + cnfe.toString());
        }
        catch (Exception ex) {
            System.out.println("Exception: " + ex.toString());
        }
        return null;
    }

    protected void setWorkspaceExt(String ext) {
        this._workspaceExt = ext;
    }

    protected String getWorkspaceExt() {
        return this._workspaceExt;
    }

    protected void setWorkspaceClass(String type) {
        this._rmiWorkspaceClassString = type;
    }

    protected String getWorkspaceClass() {
        return this._rmiWorkspaceClassString;
    }

    protected void setRmiAppType(String type) {
        this._rmiAppType = type;
    }

    protected String getRmiAppType() {
        return this._rmiAppType;
    }

    protected String getDefaultWorkspaceNameDefinition() {
        return this._defaultWorkspaceNameDefinition;
    }

    protected void setDefaultWorkspaceNameDefinition(String def) {
        this._defaultWorkspaceNameDefinition = def;
    }

    protected String getDefaultWorkspaceDescriptionDefinition() {
        return this._defaultWorkspaceDescriptionDefinition;
    }

    protected void setDefaultWorkspaceDescriptionDefinition(String def) {
        this._defaultWorkspaceDescriptionDefinition = def;
    }

    public void errMsg(Msg msg) {
        System.out.println(msg.toString());
    }

    @Override
    public Vector getWorkspaces(String user, String baseDir) throws RemoteException {
        String wsExt = this.getWorkspaceExt();
        Vector<File> confFiles = new Vector<File>();
        Vector<Identifier> ids = new Vector<Identifier>();
        String topPath = baseDir;
        System.out.println("Getting workspaces from " + topPath);
        String[] list = new File(topPath).list();
        if (list == null) {
            System.out.println("Can't get a listing from " + topPath);
            return confFiles;
        }
        for (int ii = 0; ii < list.length; ++ii) {
            File workspacePath = new File(topPath, list[ii]);
            if (workspacePath == null || !workspacePath.isDirectory()) continue;
            WildCardFileFilter ff = new WildCardFileFilter("*." + wsExt);
            ff.setAcceptDirectories(false);
            String[] confList = workspacePath.list((FilenameFilter)ff);
            if (confList == null) continue;
            for (int jj = 0; jj < confList.length; ++jj) {
                File confFile;
                if (confList[jj].indexOf("." + wsExt) < 0 || (confFile = new File(workspacePath, confList[jj])) == null || confFile.isDirectory()) continue;
                confFiles.addElement(confFile);
            }
        }
        RmiFileManager fileManager = this.getFileManager();
        for (int ii = 0; ii < confFiles.size(); ++ii) {
            File confFile = (File)confFiles.elementAt(ii);
            String path = confFile.getPath();
            Identifier pathId = new Identifier(path = path.replace('\\', '/'));
            Identifier fileId = fileManager.openFile(user, pathId);
            if (fileId != null) {
                HecFile file = fileId.getFile();
                BufferedReader input = file.getBufferedReader();
                try {
                    String line = input.readLine();
                    int itemsFound = 0;
                    while (line != null) {
                        line = line.trim();
                        String type = RMAIO.getType((String)line, (String)"=");
                        String param = RMAIO.getParam((String)line, (String)"=");
                        if (type.compareTo(this.getDefaultWorkspaceNameDefinition()) == 0) {
                            fileId.setName(param);
                            ++itemsFound;
                        } else if (type.compareTo(this.getDefaultWorkspaceDescriptionDefinition()) == 0) {
                            fileId.setDescription(param);
                            ++itemsFound;
                        }
                        line = input.readLine();
                        if (itemsFound < 2) continue;
                    }
                    input.close();
                }
                catch (Exception e) {
                    System.out.println("Error Reading File  " + e);
                    e.printStackTrace();
                }
                ids.addElement(fileId);
                continue;
            }
            System.out.println("Error Opening ID " + pathId.getPath());
        }
        return ids;
    }

    @Override
    public String[] getBindingSites() throws RemoteException {
        String[] bindingSites = new String[3];
        bindingSites[0] = this.stringUrl;
        bindingSites[1] = "//207.214.198.108:" + this.port + "/";
        return bindingSites;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Vector getWatershedLocations(boolean convertPropsInDir) throws RemoteException {
        Vector vector = this._watershedLocations;
        synchronized (vector) {
            if (!this._propsLoaded) {
                this.loadProperties();
            }
            if (!convertPropsInDir) {
                return this._watershedLocations;
            }
            int size = this._watershedLocations.size();
            Vector<WatershedLocation> v = new Vector<WatershedLocation>(size);
            for (int i = 0; i < size; ++i) {
                WatershedLocation wl = (WatershedLocation)this._watershedLocations.get(i);
                WatershedLocation newWl = (WatershedLocation)wl.clone();
                if (newWl == null) continue;
                newWl.setDirectory(RMAIO.parsePathName((String)newWl.getDirectory()));
                v.add(newWl);
            }
            return v;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setWatershedLocations(Vector dirs) throws RemoteException {
        Vector vector = this._watershedLocations;
        synchronized (vector) {
            this._watershedLocations.clear();
            if (dirs != null) {
                for (int i = 0; i < dirs.size(); ++i) {
                    Object obj = dirs.get(i);
                    if (!(obj instanceof WatershedLocation)) continue;
                    this._watershedLocations.add(obj);
                }
            }
            this.saveProperties();
            return true;
        }
    }

    private void saveProperties() {
        HECGlobalProperties props = this.getNetworked() ? new RmiAppProperties(this.getRmiAppType()) : new HECGlobalProperties();
        int cnt = this._watershedLocations.size();
        for (int i = 0; i < cnt; ++i) {
            WatershedLocation nt = (WatershedLocation)this._watershedLocations.get(i);
            props.setProp("watershed.directory" + i, nt.getDescription());
            props.setProp("watershed.directory" + i + ".name", nt.getName());
        }
        props.setProp("watershed.directory.count", "" + cnt);
    }

    private void loadProperties() {
        HECGlobalProperties props = this.getNetworked() ? new RmiAppProperties(this.getRmiAppType()) : new HECGlobalProperties();
        props.loadProperties();
        int cnt = RMAIO.parseInt((String)props.getProp("watershed.directory.count", "0"));
        for (int i = 0; i < cnt; ++i) {
            String dirPropName;
            String dirProp = props.getProp("watershed.directory" + i);
            if (dirProp == null || dirProp.length() < 1 || (dirPropName = props.getProp("watershed.directory" + i + ".name")) == null || dirPropName.length() < 1) continue;
            WatershedLocation wl = new WatershedLocation(dirPropName, dirProp);
            this._watershedLocations.add(wl);
        }
        this._propsLoaded = true;
    }

    @Override
    public String getError() throws RemoteException {
        return this._error;
    }

    @Override
    public void setError(String str) throws RemoteException {
        this._error = "";
    }

    @Override
    public String checkServerWarnings() throws RemoteException {
        double precent;
        double free;
        StringBuffer message = new StringBuffer();
        String homeDir = this.getServerProperty("CWMS_HOME");
        File file = new File(homeDir);
        long total = file.getTotalSpace();
        long usable = file.getUsableSpace();
        if (total > 0L && usable > 0L && (free = (double)usable / (double)total) < 1.0 && (precent = free * 100.0) < 5.0) {
            HecDouble p = new HecDouble(precent, 1);
            message.append("Caution - low disk space on server\nOnly ");
            message.append(p.toString());
            message.append("% free");
        }
        return message.toString();
    }

    @Override
    @Deprecated
    public RemoteWrapper newWorkspace(String user, Identifier id, String baseDir, RemoteWrapper wrap, int unitSystemId, int gmtOffset) throws RemoteException {
        wrap.setRemote((Remote)this.newWorkspace(user, id, baseDir, unitSystemId, gmtOffset));
        wrap.export();
        return wrap;
    }

    @Override
    public boolean workspaceExists(Identifier id, String baseDir) {
        Object wkspPath;
        String fname;
        if (id == null || baseDir == null) {
            return false;
        }
        if (id.getPath() == null || id.getPath().length() == 0) {
            fname = RMAIO.userNameToFileName((String)id.getName());
            wkspPath = baseDir + "/" + fname;
        } else {
            wkspPath = id.getPath();
            fname = RMAIO.userNameToFileName((String)id.getName());
        }
        System.out.println("workspaceExists: checking path=" + (String)wkspPath);
        int idx = fname.lastIndexOf("." + this._workspaceExt);
        if (idx >= 0) {
            fname = fname.substring(0, idx);
        }
        id.setPath(baseDir + "/" + fname + "/" + fname + "." + this._workspaceExt);
        try {
            RmiFileManager fm = this.getFileManager();
            if (fm.fileExists(id.getPath())) {
                System.out.println("workspaceExists: workspace " + id.getName() + " already exists.");
                return true;
            }
        }
        catch (RemoteException re) {
            System.out.println("workspaceExists(" + id.getName() + ") error checking if workspace exists " + re);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RmiWorkspace newWorkspace(String user, Identifier id, String baseDir, int unitSystemId, int gmtOffset) throws RemoteException, WorkspaceExistsException {
        Object wkspPath;
        String fname;
        if (this._paused) {
            System.out.println("newWorkspace(): I'm paused");
            throw new IllegalStateException("Server is currently paused. Can't create new workspace " + id.getName());
        }
        if (id.getPath() == null || id.getPath().length() == 0) {
            fname = RMAIO.userNameToFileName((String)id.getName());
            wkspPath = baseDir + "/" + fname;
            int idx = fname.lastIndexOf("." + this._workspaceExt);
            if (idx >= 0) {
                fname = fname.substring(0, idx);
            }
            id.setPath(baseDir + "/" + fname + "/" + fname + "." + this._workspaceExt);
        } else {
            wkspPath = id.getPath();
            fname = RMAIO.userNameToFileName((String)id.getName());
        }
        System.out.println("newWorkspace: path=" + (String)wkspPath + " user=" + user + " wkspName=" + fname);
        Hashtable hashtable = this._rmiWorkspaces;
        synchronized (hashtable) {
            if (this.workspaceExists(id, baseDir)) {
                throw new WorkspaceExistsException(id.getName(), (String)wkspPath);
            }
            System.out.println("newWorkspace:Creating New Workspace :" + id.getName());
            Class cl = this.getClass(this.getWorkspaceClass());
            Object obj = null;
            try {
                Object[] args = new Object[]{new Integer(this.port)};
                Constructor<?>[] cc = cl.getConstructors();
                obj = cc[1].newInstance(args);
            }
            catch (Exception e) {
                System.out.println("newWorkspace:Error instantiating RmiWorkspace " + id.getPath() + " Error:" + e);
                e.printStackTrace();
            }
            if (obj instanceof RmiWorkspaceImpl) {
                RmiWorkspaceImpl ws = obj;
                ws.setUnitSystem(unitSystemId);
                ws.setGmtOffset(gmtOffset);
                ws.setBindPort(this.getBindPort());
                ws.addUser(user);
                ws.setRmiApp(this);
                ws.setFileManager(this._fmWrapper);
                if (this.getNetworked()) {
                    ws.setLocal(false);
                } else {
                    ws.setLocal(true);
                }
                ws.setWorkspaceExt(this._workspaceExt);
                ws.setWorkspacePath(baseDir + "/" + fname);
                ws.setIdentifier(user, id);
                ws.createSharedDir();
                ws.createMapDir();
                if (this.getNetworked()) {
                    RemoteWrapper wrap = new RemoteWrapper((Remote)ws);
                    this.addRemoteWrapper(wrap);
                    ws.exportServer();
                }
                ws.createDataListContainer();
                ws.createDefaultDataLists();
                System.out.println("newWorkspace: created workspace " + ws.getWorkspacePath());
                this._rmiWorkspaces.put(ws.getWorkspacePath(), ws);
                return ws;
            }
            return null;
        }
    }

    public RmiWorkspace openWorkspace(String user, Identifier id) throws RemoteException {
        return this.openWorkspace(user, id, (String)null, (RemoteWrapper)null);
    }

    @Override
    public RmiWorkspace openWorkspace(String user, Identifier id, String remoteRegistry, RemoteWrapper clientProgress) throws RemoteException {
        System.out.println("openWorkspace: user " + user + " workspace " + id.getName() + " path " + id.getPath());
        RmiProgress progress = null;
        try {
            if (clientProgress != null) {
                progress = (RmiProgress)clientProgress.getRemote();
            }
        }
        catch (Exception e) {
            System.out.println("openWorkspace:exception connecting to client progress object  for user " + user + " workspace " + id.getPath() + " Error:" + e);
            throw new RuntimeException("Can't connect to client progress object.\n\tCheck java.rmi.hostname. Server Error is:\n\t" + e);
        }
        return this.openWorkspace(user, id, remoteRegistry, progress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private RmiWorkspace openWorkspace(String user, Identifier id, String remoteRegistry, RmiProgress progress) throws RemoteException {
        if (this._paused) {
            System.out.println("openWorkspace: I'm paused");
            if (progress != null) {
                progress.printStatus(this.getName() + " is currently not accepting requests to open workspaces");
            }
            return null;
        }
        Hashtable hashtable = this._rmiWorkspaces;
        synchronized (hashtable) {
            try {
                if (progress != null) {
                    progress.printStatus("Loading Workspace");
                }
            }
            catch (Exception e) {
                System.out.println("openWorkspace:exception connecting to client progress object " + e);
                e.printStackTrace();
                throw new RuntimeException("Can't connect to client progress object.\n\tCheck java.rmi.hostname. Server Error is:\n\t" + e, e);
            }
            try {
                if (!this.getFileManager().fileExists(id.getPath())) {
                    System.out.println("openWorkspace: workspace " + id.getPath() + " doesn't exist");
                    if (progress != null) {
                        progress.printErrorMessage("Watershed " + id.getName() + " doesn't exist");
                    }
                    return null;
                }
            }
            catch (RemoteException re) {
                System.out.println("openWorkspace: RMI error check if workspace " + id.getPath() + " exists. " + re);
            }
            String wkspPath = RMAIO.getDirectoryFromPath((String)id.getPath());
            if (remoteRegistry == null || remoteRegistry.isEmpty()) {
                RmiWorkspace clientInterface = (RmiWorkspace)this._rmiWorkspaces.get(wkspPath);
                if (clientInterface != null) {
                    System.out.println("Found existing Watershed...");
                    return clientInterface;
                }
                if (progress != null) {
                    progress.printMessage("Creating Client-Local Watershed :" + id.getName() + "\n");
                }
                System.out.println("openWorkspace:Creating Client-Local Workspace :" + id.getName());
                Class cl = this.getClass(this.getWorkspaceClass());
                Object obj = null;
                try {
                    Object[] args = new Object[]{new Integer(this.port)};
                    Constructor<?>[] cc = cl.getConstructors();
                    obj = cc[1].newInstance(args);
                }
                catch (Exception e) {
                    System.out.println("openWorkspace: Error instantiating RmiWorkspace " + this.getWorkspaceClass() + " for " + id.getPath() + " Error:" + e);
                    e.printStackTrace();
                }
                if (!(obj instanceof RmiWorkspaceImpl)) {
                    return null;
                }
                RmiWorkspaceImpl ws = obj;
                ws.addUser(user);
                int idx = id.getPath().lastIndexOf("/");
                ws.setWorkspacePath(id.getPath().substring(0, idx));
                ws.setLocal(true);
                ws.setFileManager(this._fmWrapper);
                ws.setIdentifier(user, id);
                ws.setRmiApp(this);
                if (progress != null) {
                    progress.printMessage("Reading watershed file : " + id.getFile().getName() + "\n");
                }
                ws.load();
                if (progress != null) {
                    progress.setProgress(10);
                }
                this._rmiWorkspaces.put(ws.getWorkspacePath(), ws);
                return ws;
            }
            System.out.println("openWorkspace: checking for existing workspace " + wkspPath);
            RmiWorkspace clientInterface = (RmiWorkspace)this._rmiWorkspaces.get(wkspPath);
            if (clientInterface == null) {
                System.out.println("openWorkspace:Creating Remote Workspace :" + id.getName());
                if (progress != null) {
                    progress.printMessage("Creating Remote Watershed :" + id.getName() + "\n");
                }
                Class cl = this.getClass(this.getWorkspaceClass());
                Object obj = null;
                try {
                    Object[] args = new Object[]{new Integer(this.port)};
                    Constructor<?>[] cc = cl.getConstructors();
                    obj = cc[1].newInstance(args);
                }
                catch (Exception e) {
                    System.out.println("openWorkspace: Error instantiating RmiWorkspace " + id.getPath() + " Error:" + e);
                    e.printStackTrace();
                }
                if (obj instanceof RmiWorkspaceImpl) {
                    RmiWorkspaceImpl ws = obj;
                    ws.addUser(user);
                    int idx = id.getPath().lastIndexOf("/");
                    ws.setWorkspacePath(id.getPath().substring(0, idx));
                    ws.setIdentifier(user, id);
                    ws.setLocal(false);
                    ws.setBindPort(this.getBindPort());
                    ws.setNetworked(true);
                    ws.setRmiApp(this);
                    if (progress != null) {
                        progress.printMessage("Reading watershed file : " + id.getFile().getName() + "\n");
                    }
                    ws.load();
                    if (progress != null) {
                        progress.setProgress(10);
                    }
                    ws.setName(id.getName() + id.getPath().hashCode());
                    RemoteWrapper wrap = new RemoteWrapper((Remote)ws);
                    this._remoteObjects.addElement(wrap);
                    if (remoteRegistry.equals(this.stringUrl)) {
                        ws.exportServer();
                    }
                    ws.createDataListContainer();
                    clientInterface = ws;
                    System.out.println("openWorkspace: created workspace " + ws.getWorkspacePath());
                    this._rmiWorkspaces.put(ws.getWorkspacePath(), ws);
                }
            } else {
                boolean ok;
                System.out.println("openWorkspace: Opening Remote Workspace :" + id.getName() + " at :" + remoteRegistry);
                if (progress != null) {
                    progress.printMessage("Opening Remote Watershed :" + id.getName() + "\n");
                }
                if (!(ok = clientInterface.addUser(user))) {
                    String error = clientInterface.getError();
                    System.out.println(error);
                    if (progress != null) {
                        progress.printErrorMessage(error);
                    }
                    return null;
                }
            }
            return clientInterface;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeWorkspace(String wkspPath) throws RemoteException {
        if (wkspPath == null) {
            return;
        }
        System.out.println("removeWorkspace:removing workspace " + wkspPath);
        boolean removed = false;
        Hashtable hashtable = this._rmiWorkspaces;
        synchronized (hashtable) {
            if (this._rmiWorkspaces.remove(wkspPath) == null) {
                System.out.println("removeWorkspace:WARNING failed to remove workspace " + wkspPath + " from internal list.");
            }
            for (int i = 0; i < this._remoteObjects.size(); ++i) {
                RmiWorkspace wksp;
                Remote r;
                Object obj = this._remoteObjects.elementAt(i);
                if (!(obj instanceof RemoteWrapper) || !((r = ((RemoteWrapper)obj).getRemote()) instanceof RmiWorkspace) || !(wksp = (RmiWorkspace)r).getWorkspacePath().equals(wkspPath)) continue;
                this._remoteObjects.removeElementAt(i);
                removed = true;
                System.out.println("removeWorkspace:Removed workspace " + wkspPath);
                System.gc();
            }
            if (!removed) {
                System.out.println("removeWorkspace:WARNING failed to find workspace for " + wkspPath);
            }
            if (this._shuttingDown && this.getWorkspaceList().size() < 1) {
                this.shutdown(0);
            }
        }
    }

    @Override
    public RmiWorkspace getRmiWkspByPath(String wkspPath) throws RemoteException {
        if (wkspPath == null) {
            return null;
        }
        wkspPath = wkspPath.replace('\\', '/');
        return (RmiWorkspace)this._rmiWorkspaces.get(wkspPath);
    }

    @Override
    public RmiFileManager getFileManager() {
        try {
            if (super.getFileManager() == null) {
                this.setFileManager();
            }
        }
        catch (RemoteException re) {
            System.out.println("getFileManager:getFileManager: RMI Exception " + re);
        }
        if (this.getNetworked() && this._fileManager != null) {
            try {
                ((RmiFileManager)this._fileManager.getRemote()).isAlive();
            }
            catch (Exception e) {
                this.setFileManager();
            }
            return (RmiFileManager)this._fileManager.getRemote();
        }
        try {
            return super.getFileManager();
        }
        catch (RemoteException re) {
            System.out.println("getFileManager: RMI Exception " + re);
            return null;
        }
    }

    public void setFileManager() {
        String rmiUrlString = "rmi://localhost:" + this.port + "/FileManager";
        try {
            RmiFileManager fmi = (RmiFileManager)Naming.lookup(rmiUrlString);
            this._fileManager = new RemoteWrapper((Remote)fmi);
            this._fileManager.setExported(true);
            this.setFileManager(this._fileManager);
        }
        catch (Exception e) {
            System.out.println("RmiAppImpl():Can't find file manager at " + rmiUrlString + " exception is " + e);
        }
    }

    public synchronized boolean shutdown(int shutDownType, int waitSeconds, String userId) {
        String host = userId;
        System.out.println(this.getName() + " told to shutDown in " + waitSeconds + " seconds from host " + host + " user " + UserId.getUserId());
        if (shutDownType == 0) {
            this.shutdown(waitSeconds);
        } else {
            System.out.println(this.getName() + " shutting down when I can");
            Vector v = this.getWorkspaceList();
            if (v == null || v.size() < 1) {
                this.shutdown(waitSeconds);
            }
            this._shuttingDown = true;
            this._paused = true;
            super.shutdownInitiated();
        }
        HecDSSFileAccess.closeAllFiles();
        return true;
    }

    protected MarkingClassLogger getStatusLogger() {
        return MARKING_CLASS_LOGGER;
    }

    public StringBuilder getStatus(StringBuilder sb) {
        try {
            StatusObject status = this.getStatusObject(0);
            String statusString = status.toString();
            statusString = statusString.replace(':', '=');
            sb.append(statusString.replace('\n', ';'));
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return sb;
    }

    public String getStatusString(int statusType) throws RemoteException {
        if (this._shuttingDown) {
            return "Shutting Down";
        }
        Vector v = this.getWorkspaceList();
        int size = v.size();
        if (size < 1) {
            return "OK";
        }
        String wkspStr = " Watersheds";
        if (size == 1) {
            wkspStr = " Watershed";
        }
        return size + wkspStr;
    }

    public StatusObject getStatusObject(int statusType) throws RemoteException {
        RmiAppStatus lss = new RmiAppStatus();
        lss.setWkspList(this.getWorkspaceList());
        lss.setStartTime(this.getControllableServerStartTime());
        lss.setRmiApp(this);
        return lss;
    }

    public boolean setPaused(boolean paused) throws RemoteException {
        if (this._shuttingDown) {
            return false;
        }
        this._paused = paused;
        if (paused) {
            super.firePauseEvent();
        } else {
            super.fireResumeEvent();
        }
        return true;
    }

    public boolean isPaused() {
        return this._paused;
    }

    @Override
    public Vector getWorkspaceList() {
        Vector wkspList = new Vector(this._rmiWorkspaces.size());
        Enumeration e = this._rmiWorkspaces.elements();
        while (e.hasMoreElements()) {
            Object obj = e.nextElement();
            if (!(obj instanceof RmiWorkspace)) continue;
            wkspList.addElement(obj);
        }
        return wkspList;
    }

    @Override
    public RMIScheduler getScheduler() throws RemoteException {
        if (this._rmiSchedulerWrapper != null) {
            return (RMIScheduler)this._rmiSchedulerWrapper.getRemote();
        }
        return null;
    }

    public void rebindServer(String url) {
        super.rebindServer(url);
        if (this.getNetworked()) {
            try {
                RMISchedulerImpl rmiScheduler = new RMISchedulerImpl(this);
                this._rmiSchedulerWrapper = new RemoteWrapper((Remote)((Object)rmiScheduler));
                rmiScheduler.setNetworked(true);
                int portNumber = this.getBindPort();
                rmiScheduler.setBindPort(portNumber);
                System.out.println("binding scheduler to " + this.stringUrl + " port " + portNumber);
                rmiScheduler.rebindServer(this.stringUrl);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
    }

    @Override
    public void userLoggedOut(String userId) {
        System.out.println("userLoggedOut: removing user " + userId + " from all open watersheds");
        Vector wkspList = this.getWorkspaceList();
        for (int i = 0; i < wkspList.size(); ++i) {
            RmiWorkspace wksp = (RmiWorkspace)wkspList.get(i);
            try {
                Vector users = wksp.getUsers();
                if (!users.contains(userId)) continue;
                wksp.closeWorkspace(userId);
                continue;
            }
            catch (RemoteException re) {
                System.out.println("userLoggedOut: RMI Error removing user from watershed " + re);
            }
        }
    }

    @Override
    public String parsePathName(String path) {
        return RMAIO.parsePathName((String)path);
    }

    protected void loadPlugins() {
        PlugInLoader.loadPlugIns((String)"ServerMainClass", (Object[])new Object[]{"server"}, (Comparator)new PluginFileNameComparator());
    }

    @Override
    public boolean hasChildWorkspaceType(String type) {
        return RmiWorkspaceImpl._childWorkspaceClasses.get(type) != null;
    }

    public static RmiAppImpl getApp() {
        return _app;
    }

    @Override
    public TimeZone getTimeZone() {
        return TimeZone.getDefault();
    }
}

