/*
 * Decompiled with CFR 0.152.
 */
package hec.clientapp.server;

import hec.clientapp.rmi.csinterface.RmiDataList;
import hec.clientapp.rmi.csinterface.RmiDataListContainer;
import hec.clientapp.rmi.csinterface.RmiWorkspace;
import hec.clientapp.server.RmiWorkspaceImpl;
import hec.map.streamAlignment.StreamAlignmentIfc;
import hec.model.CommonDataList;
import hec.model.CommonDataListContainer;
import hec.model.DataObject;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.Vector;
import mil.army.usace.hec.rmi.server.PortableRmiObject;
import mil.army.usace.hec.rmi.server.RemoteWrapper;

public class RmiDataListContainerImpl
extends PortableRmiObject
implements RmiDataListContainer,
CommonDataListContainer {
    Vector _dataLists = new Vector();
    RmiWorkspaceImpl _workspace = null;

    public RmiDataListContainerImpl(RmiWorkspaceImpl parent) throws RemoteException {
        this._workspace = parent;
        this.name = "RmiDataListContainer";
    }

    public boolean addDataList(RmiDataList rdl) {
        PortableRmiObject pro = (PortableRmiObject)rdl;
        RemoteWrapper wrapper = new RemoteWrapper((Remote)pro);
        pro.setBindPort(this.getBindPort());
        if (this.networked) {
            pro.exportServer();
            wrapper.setExported(true);
        }
        wrapper.setRemote((Remote)rdl);
        this._dataLists.addElement(rdl);
        return true;
    }

    public int getUnitSystem() {
        return this._workspace.getUnitSystem();
    }

    @Override
    public int getGmtOffset() {
        return this._workspace.getGmtOffset();
    }

    public StreamAlignmentIfc getStreamAlignment() {
        throw new RuntimeException("Method not implemented yet!");
    }

    public CommonDataList getCommonDataList(String className) {
        if (className == null) {
            return null;
        }
        for (int i = 0; i < this._dataLists.size(); ++i) {
            try {
                if (!((RmiDataList)this._dataLists.elementAt(i)).getDataListType().equals(className)) continue;
                return (CommonDataList)this._dataLists.elementAt(i);
            }
            catch (Exception e) {
                System.out.println("Error getting data list type. " + e.toString());
            }
        }
        return null;
    }

    public CommonDataList getCommonDataList(String className, String modelName) {
        if (this._workspace.getName().equals(modelName)) {
            return this.getCommonDataList(className);
        }
        return this._workspace.getCommonDataList(className, modelName);
    }

    public RmiDataList getDataList(String className) throws RemoteException {
        if (className == null) {
            return null;
        }
        for (int i = 0; i < this._dataLists.size(); ++i) {
            if (!((RmiDataList)this._dataLists.elementAt(i)).getDataListType().equals(className)) continue;
            return (RmiDataList)this._dataLists.elementAt(i);
        }
        return null;
    }

    public RmiDataList getDataListByClass(String dataListClass) {
        Class<?> c;
        Enumeration e = this._dataLists.elements();
        try {
            c = Class.forName(dataListClass);
        }
        catch (ClassNotFoundException cfe) {
            System.out.println("getDataListByClass: class " + dataListClass + " not found " + cfe);
            return null;
        }
        while (e.hasMoreElements()) {
            RmiDataList dl = (RmiDataList)e.nextElement();
            if (!dl.getClass().equals(c)) continue;
            return dl;
        }
        return null;
    }

    @Override
    public RmiDataList[] getDataLists() throws RemoteException {
        Object[] rmiDataLists = new RmiDataList[this._dataLists.size()];
        this._dataLists.copyInto(rmiDataLists);
        return rmiDataLists;
    }

    @Override
    public boolean checkUser(String user) throws RemoteException {
        return true;
    }

    @Override
    public RmiWorkspace getWorkspace() throws RemoteException {
        return this._workspace;
    }

    public void workspaceClosing() throws RemoteException {
        for (int i = 0; i < this._dataLists.size(); ++i) {
            ((RmiDataList)this._dataLists.elementAt(i)).workspaceClosing();
        }
    }

    public DataObject findObjectById(long id, String objClass) {
        Enumeration e = this._dataLists.elements();
        while (e.hasMoreElements()) {
            RmiDataList rdl = (RmiDataList)e.nextElement();
            try {
                if (!rdl.getDataListType().equals(objClass)) continue;
                return rdl.getObject(id);
            }
            catch (Exception ex) {
                System.out.println("Error in RmiDataListContainerImpl:findObjectById");
                System.out.println(ex);
            }
        }
        return null;
    }

    public CommonDataListContainer getProxyListContainer() {
        return this;
    }
}

