/*
 * Decompiled with CFR 0.152.
 */
package hec.clientapp.server;

import hec.clientapp.rmi.csinterface.RmiDataList;
import hec.clientapp.rmi.csinterface.RmiDataListContainer;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Hashtable;
import rma.util.logging.MarkingClassLogger;

public class RmiDataListFactory {
    private static MarkingClassLogger _logger = MarkingClassLogger.forMarkingClass(RmiDataListFactory.class);
    static Hashtable<String, String> _datalistTypes = new Hashtable();

    public static RmiDataList getDataList(RmiDataListContainer container, String stringClass) {
        if (container == null || stringClass == null) {
            return null;
        }
        String dataListClassName = _datalistTypes.get(stringClass);
        if (dataListClassName == null) {
            ((MarkingClassLogger.Api)_logger.atInfo()).log("ERROR : No DataList defined for object " + stringClass);
            return null;
        }
        RmiDataList dataList = null;
        try {
            Class<?> datalistClass = Class.forName(dataListClassName);
            Constructor<?>[] ctors = datalistClass.getDeclaredConstructors();
            Object[] args = new Object[]{container, stringClass};
            for (int i = 0; i < ctors.length; ++i) {
                Class<?>[] c = ctors[i].getParameterTypes();
                if (c.length != 2) continue;
                dataList = (RmiDataList)ctors[i].newInstance(args);
                return dataList;
            }
            ((MarkingClassLogger.Api)_logger.atInfo()).log("ERROR : Failed to find DataList Contructor for " + dataListClassName);
        }
        catch (ClassNotFoundException cfe) {
            ((MarkingClassLogger.Api)((MarkingClassLogger.Api)_logger.atInfo()).withCause((Throwable)cfe)).log("ERROR : Failed to find DataList class " + dataListClassName + " " + cfe);
            return null;
        }
        catch (SecurityException se) {
            ((MarkingClassLogger.Api)((MarkingClassLogger.Api)_logger.atInfo()).withCause((Throwable)se)).log("ERROR:Security Exception on 'getDeclaredConstructors()'. Please update your java.policy file. " + se);
            return null;
        }
        catch (InvocationTargetException e) {
            ((MarkingClassLogger.Api)((MarkingClassLogger.Api)_logger.atInfo()).withCause(e.getTargetException())).log("ERROR : Invocation Target Exception Occurred when creating datalist for " + dataListClassName + " " + e.getTargetException().getMessage());
            return null;
        }
        catch (Throwable e) {
            ((MarkingClassLogger.Api)((MarkingClassLogger.Api)_logger.atInfo()).withCause(e)).log("ERROR : Failed to create DataList " + dataListClassName + " " + e + " " + e.getMessage());
            return null;
        }
        return dataList;
    }

    static {
        _datalistTypes.put("hec.fdajni.model.FdaRatingCurve", "hec.fdajni.server.FdaRmiDataListImpl");
        _datalistTypes.put("hec.fdajni.model.FdaWsp", "hec.fdajni.server.FdaRmiDataListImpl");
        _datalistTypes.put("hec.fdajni.model.FdaLevee", "hec.fdajni.server.FdaRmiDataListImpl");
        _datalistTypes.put("hec.fdajni.model.FdaFreqFunction", "hec.fdajni.server.FdaRmiDataListImpl");
        _datalistTypes.put("hec.fdajni.model.FdaDamageFunction", "hec.fdajni.server.FdaRmiDataListImpl");
        _datalistTypes.put("hec.fdajni.model.FdaAggDmgFunction", "hec.fdajni.server.FdaRmiDataListImpl");
        _datalistTypes.put("hec.fdajni.FdaPlan", "hec.fdajni.server.FdaRmiDataListImpl");
        _datalistTypes.put("hec.fdajni.FdaStream", "hec.fdajni.server.FdaRmiDataListImpl");
        _datalistTypes.put("hec.fdajni.FdaReach", "hec.fdajni.server.FdaRmiDataListImpl");
        _datalistTypes.put("hec.fdajni.FdaDamageCategory", "hec.fdajni.server.FdaRmiDataListImpl");
        _datalistTypes.put("hec.fdajni.FdaModule", "hec.fdajni.server.FdaRmiDataListImpl");
        _datalistTypes.put("hec.fdajni.model.FdaStructure", "hec.fdajni.server.FdaRmiStructureDataListImpl");
        _datalistTypes.put("hec.sid.model.SidDamageAreaData", "hec.sid.server.SidRmiDataListImpl");
        _datalistTypes.put("hec.sid.model.SidLeveeData", "hec.sid.server.SidRmiDataListImpl");
        _datalistTypes.put("hec.sid.model.SidCostFunction", "hec.sid.server.SidRmiDataListImpl");
        _datalistTypes.put("hec.sid.model.CostOutputData", "hec.sid.server.SidRmiDataListImpl");
        _datalistTypes.put("hec.sid.model.SidPlanData", "hec.sid.server.SidRmiDataListImpl");
        _datalistTypes.put("hec.fdajni.model.StreamAlignmentDataList", "hec.server.StreamAlignmentRmiDataList");
        _datalistTypes.put("hec.rss.model.ReservoirOp", "hec.rss.server.ResOpRmiDataList");
        _datalistTypes.put("hec.rss.model.ReservoirSysOp", "hec.rss.server.ResSysOpRmiDataList");
        _datalistTypes.put("hec.watershed.model.Study", "hec.watershed.server.StudyRmiDataList");
        _datalistTypes.put("hec.watershed.model.Reservoir", "hec.watershed.server.WatershedRmiDataListImpl");
        _datalistTypes.put("hec.watershed.model.Levee", "hec.watershed.server.WatershedRmiDataListImpl");
        _datalistTypes.put("hec.watershed.model.ChannelMod", "hec.watershed.server.WatershedRmiDataListImpl");
        _datalistTypes.put("hec.watershed.model.OtherProject", "hec.watershed.server.WatershedRmiDataListImpl");
        _datalistTypes.put("hec.watershed.model.StoragePool", "hec.watershed.server.WatershedRmiDataListImpl");
        _datalistTypes.put("hec.watershed.model.ImpactArea", "hec.watershed.server.WatershedRmiDataListImpl");
        _datalistTypes.put("hec.watershed.model.ComputationPoint", "hec.watershed.server.WatershedRmiDataListImpl");
        _datalistTypes.put("hec.watershed.model.ComputationPointLayer", "hec.watershed.server.WatershedRmiDataListImpl");
        _datalistTypes.put("hec.watershed.model.Condition", "hec.watershed.server.WatershedRmiDataListImpl");
        _datalistTypes.put("hec.watershed.model.Diversion", "hec.watershed.server.WatershedRmiDataListImpl");
        _datalistTypes.put("hec.watershed.model.StationSet", "hec.watershed.server.StationSetRmiDataListImpl");
        _datalistTypes.put("hec.fda.model.StructureGroup", "hec.fda.server.StructureGroupRmiDataListImpl");
        _datalistTypes.put("hec.fda.model.OccupancyType", "hec.fda.server.OccupancyTypeRmiDataListImpl");
        _datalistTypes.put("hec.fda.model.LandUseMapping", "hec.fda.server.FdaRmiDataListImpl");
        _datalistTypes.put("hec.fda.model.CensusMapping", "hec.fda.server.FdaRmiDataListImpl");
        _datalistTypes.put("hec.fda.model.Inventory", "hec.fda.server.InventoryRmiDataListImpl");
        _datalistTypes.put("hec.fda.model.Structure", "hec.fda.server.StructureRmiDataListImpl");
        _datalistTypes.put("hec.fda.model.ConstructionType", "hec.fda.server.ConstructionTypeRmiDataListImpl");
        _datalistTypes.put("hec.fda.model.ExteriorWallType", "hec.fda.server.ExteriorWallTypeRmiDataListImpl");
        _datalistTypes.put("hec.fda.model.FoundationType", "hec.fda.server.FoundationTypeRmiDataListImpl");
        _datalistTypes.put("hec.fda.model.HeatingCoolingType", "hec.fda.server.HeatingCoolingTypeRmiDataListImpl");
        _datalistTypes.put("hec.fda.model.RoofType", "hec.fda.server.RoofTypeRmiDataListImpl");
        _datalistTypes.put("hec.fda.model.StyleType", "hec.fda.server.StyleTypeRmiDataListImpl");
        _datalistTypes.put("hec.fda.model.FloorType", "hec.fda.server.FloorTypeRmiDataListImpl");
        _datalistTypes.put("hec.fda.model.ProbabilityFunction", "hec.fda.server.FdaRmiDataListImpl");
        _datalistTypes.put("hec.fda.model.Levee", "hec.fda.server.FdaRmiDataListImpl");
        _datalistTypes.put("hec.fda.model.RatingCurve", "hec.fda.server.FdaRmiDataListImpl");
        _datalistTypes.put("hec.fda.model.StageDamage", "hec.fda.server.FdaRmiDataListImpl");
        _datalistTypes.put("hec.fda.model.DamageCategory", "hec.fda.server.FdaRmiDataListImpl");
        _datalistTypes.put("hec.fda.model.ExpectedAnnualDamage", "hec.fda.server.FdaRmiDataListImpl");
        _datalistTypes.put("hec.fda.model.Crop", "hec.fda.server.FdaRmiDataListImpl");
        _datalistTypes.put("hec.fda.model.FdaStudy", "hec.fda.server.FdaRmiDataListImpl");
        _datalistTypes.put("hec.fda.model.FdaStream", "hec.fda.server.FdaRmiDataListImpl");
        _datalistTypes.put("hec.fda.model.FdaConfig", "hec.fda.server.FdaRmiDataListImpl");
        _datalistTypes.put("hec.fda.model.FdaImpactArea", "hec.fda.server.FdaRmiDataListImpl");
        _datalistTypes.put("hec.fda.model.FdaComputationPoint", "hec.fda.server.FdaRmiDataListImpl");
        _datalistTypes.put("hec.fda.model.FdaProjectType", "hec.fda.server.FdaRmiDataListImpl");
        _datalistTypes.put("hec.fda.model.FdaProject", "hec.fda.server.FdaRmiDataListImpl");
        _datalistTypes.put("hec.fda.model.DamageCategory", "hec.fda.server.FdaRmiDataListImpl");
        _datalistTypes.put("hec.fda.model.structDamComp.StructDamage", "hec.fda.server.StructDamageRmiDataListImpl");
        _datalistTypes.put("hec.fda.model.boundary.Community", "hec.fda.server.FdaRmiDataListImpl");
        _datalistTypes.put("hec.fda.model.boundary.CongressionalDistrict", "hec.fda.server.FdaRmiDataListImpl");
        _datalistTypes.put("hec.fda.model.boundary.CorpsDistrict", "hec.fda.server.FdaRmiDataListImpl");
        _datalistTypes.put("hec.fda.model.boundary.CorpsDivision", "hec.fda.server.FdaRmiDataListImpl");
        _datalistTypes.put("hec.fda.model.boundary.County", "hec.fda.server.FdaRmiDataListImpl");
        _datalistTypes.put("hec.fda.model.boundary.FloodControlDistrict", "hec.fda.server.FdaRmiDataListImpl");
        _datalistTypes.put("hec.fda.model.boundary.State", "hec.fda.server.FdaRmiDataListImpl");
        _datalistTypes.put("hec.fda.model.boundary.Subbasin", "hec.fda.server.FdaRmiDataListImpl");
        _datalistTypes.put("hec.fda.model.boundary.Township", "hec.fda.server.FdaRmiDataListImpl");
        _datalistTypes.put("hec.fda.model.boundary.Watershed", "hec.fda.server.FdaRmiDataListImpl");
        _datalistTypes.put("hec.model.ModifiedTime", "hec.rss.server.ModifiedRmiDataListImpl");
    }
}

