/*
 * Decompiled with CFR 0.152.
 */
package hec.clientapp.server;

import hec.clientapp.client.ClientApp;
import hec.clientapp.client.WkspCallBack;
import hec.clientapp.model.ManagerProxy;
import hec.clientapp.rmi.csinterface.RmiApp;
import hec.clientapp.rmi.csinterface.RmiWkspCallBack;
import hec.map.MapIdentifier;
import java.lang.ref.WeakReference;
import java.rmi.RemoteException;
import java.rmi.server.Unreferenced;
import java.util.Date;
import javax.swing.SwingUtilities;
import mil.army.usace.hec.rmi.csinterface.RmiFileCallBack;
import mil.army.usace.hec.rmi.server.PortableRmiObject;

public class RmiWkspCallBackImpl
extends PortableRmiObject
implements RmiWkspCallBack,
Unreferenced {
    protected WeakReference _callMeBackRef;

    public RmiWkspCallBackImpl(WkspCallBack callMeBack) throws RemoteException {
        this._callMeBackRef = new WeakReference<WkspCallBack>(callMeBack);
    }

    @Override
    public void dataChanged() throws RemoteException {
        WkspCallBack callMeBack = this.getCallBack();
        if (callMeBack == null) {
            return;
        }
        if (callMeBack != null) {
            callMeBack.dataChanged();
        }
    }

    @Override
    public void managerChanged(int type, ManagerProxy proxy, String model) throws RemoteException {
        WkspCallBack callMeBack = this.getCallBack();
        if (callMeBack == null) {
            return;
        }
        if (callMeBack != null) {
            callMeBack.managerChanged(type, proxy, model);
        }
    }

    @Override
    public void userChanged(String user, String changeType) throws RemoteException {
        WkspCallBack callMeBack = this.getCallBack();
        if (callMeBack == null) {
            return;
        }
        if (callMeBack != null) {
            callMeBack.userChanged(user, changeType);
        }
    }

    @Override
    public void mapAdded(MapIdentifier mapId) throws RemoteException {
        WkspCallBack callMeBack = this.getCallBack();
        if (callMeBack == null) {
            return;
        }
        if (callMeBack != null) {
            callMeBack.mapAdded(mapId);
        }
    }

    @Override
    public void mapRemoved(MapIdentifier mapId) throws RemoteException {
        WkspCallBack callMeBack = this.getCallBack();
        if (callMeBack == null) {
            return;
        }
        if (callMeBack != null) {
            callMeBack.mapRemoved(mapId);
        }
    }

    public void removeCallbackInterface() throws RemoteException {
        this._callMeBackRef = null;
    }

    public int getCBHashCode() throws RemoteException {
        WkspCallBack callMeBack = this.getCallBack();
        if (callMeBack == null) {
            return this.hashCode();
        }
        return callMeBack.hashCode();
    }

    public boolean equals(RmiFileCallBack cb) throws RemoteException {
        WkspCallBack callMeBack = this.getCallBack();
        if (callMeBack == null) {
            return false;
        }
        return cb.getCBHashCode() == callMeBack.hashCode();
    }

    @Override
    public void unreferenced() {
        System.out.println("unreferenced called:" + new Date());
        Runnable run = new Runnable(){

            @Override
            public void run() {
                ClientApp.app();
                if (ClientApp.Workspace() == null) {
                    System.out.println("unreferenced: No watershed. Exiting application");
                    System.exit(1);
                }
                RmiApp rmiApp = ClientApp.app().getAppServer();
                try {
                    rmiApp.getStatusString(0);
                    return;
                }
                catch (Exception e) {
                    System.out.println("unreferenced: caught exception on getting status from Server " + e);
                    System.out.println("unreferenced: no Application Server. Shutting down");
                    ClientApp.app().postError("Application Server appears to be down.  Shutting down.", "Communications Error");
                    System.exit(2);
                    return;
                }
            }
        };
        if (!ClientApp.app().isCommandLine()) {
            SwingUtilities.invokeLater(run);
        } else {
            run.run();
        }
    }

    public WkspCallBack getCallBack() {
        if (this._callMeBackRef == null) {
            return null;
        }
        return (WkspCallBack)this._callMeBackRef.get();
    }
}

