/*
 * Decompiled with CFR 0.152.
 */
package hec.clientapp.server;

import hec.appInterface.FileOpener;
import hec.clientapp.model.Manager;
import hec.clientapp.model.ManagerProxy;
import hec.clientapp.model.ManagerProxyList;
import hec.clientapp.model.ManagerProxyListContainer;
import hec.clientapp.rmi.csinterface.HecRmiWorkspace;
import hec.clientapp.rmi.csinterface.RmiApp;
import hec.clientapp.rmi.csinterface.RmiDataList;
import hec.clientapp.rmi.csinterface.RmiDataListContainer;
import hec.clientapp.rmi.csinterface.RmiWkspCallBack;
import hec.clientapp.rmi.csinterface.RmiWorkspace;
import hec.clientapp.server.HecRmiWorkspaceImpl;
import hec.clientapp.server.RmiAppImpl;
import hec.clientapp.server.RmiDataListContainerImpl;
import hec.clientapp.server.RmiDataListFactory;
import hec.io.FileLock;
import hec.io.HecFile;
import hec.io.Identifier;
import hec.lang.DSSPathString;
import hec.lang.UserId;
import hec.lang.WorkspaceNameFactory;
import hec.map.GlyphDataRecord;
import hec.map.GlyphDataRecordSerializable;
import hec.map.MapIdentifier;
import hec.map.WorldRect;
import hec.map.transform.CoordinateInfo;
import hec.map.transform.XYCoordinateInfo;
import hec.model.AltItem;
import hec.model.ClassNameMapper;
import hec.model.CommonDataList;
import hec.model.ComputeCanceledCallback;
import hec.model.ManagerMappingFactory;
import hec.model.WkspExportOptions;
import hec.server.ServerDataList;
import hec.util.ExportResults;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Serializable;
import java.lang.invoke.CallSite;
import java.lang.reflect.Constructor;
import java.rmi.Naming;
import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.SimpleTimeZone;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.Vector;
import mil.army.usace.hec.rmi.csinterface.ClientSideCallBackInterface;
import mil.army.usace.hec.rmi.csinterface.RMIComputeCanceledCallback;
import mil.army.usace.hec.rmi.csinterface.RmiFileManager;
import mil.army.usace.hec.rmi.csinterface.RmiLogin;
import mil.army.usace.hec.rmi.csinterface.RmiProgress;
import mil.army.usace.hec.rmi.io.HecAsciiDeserializer;
import mil.army.usace.hec.rmi.server.PortableRmiObject;
import mil.army.usace.hec.rmi.server.RMIComputeCanceledCallbackImpl;
import mil.army.usace.hec.rmi.server.RemoteWrapper;
import rma.util.RMAIO;
import rma.util.logging.MarkingClassLogger;
import rma.util.logging.marking.RmiWorkspacePropLoggingMarker;

public abstract class RmiWorkspaceImpl
extends PortableRmiObject
implements Serializable,
RmiWorkspace,
ManagerProxyListContainer,
FileOpener {
    private static final MarkingClassLogger RMI_WORKSPACE_PROP_LOGGER = MarkingClassLogger.forMarkingClass(RmiWorkspacePropLoggingMarker.class);
    protected static final Class[] INT_CLASS_ARGS = new Class[]{Integer.class};
    @Deprecated
    RmiApp _appServer = null;
    public Identifier identifier;
    public static String sep = "/";
    protected String _wsExt = "wksp";
    protected RemoteWrapper _fileManager = null;
    protected String _WorkspacePath = "";
    protected CoordinateInfo _coordinateSystem = new XYCoordinateInfo();
    protected boolean _growToExtents = true;
    protected String _typeOfWorkspace = "";
    protected String _typeOfWorkspacePath = "";
    protected WorldRect _extents;
    protected Vector _mapIdentifiers = new Vector();
    protected ManagerProxyList _managerProxys = new ManagerProxyList(this);
    protected Vector _callBackObjects;
    protected Vector _listOfUsers;
    protected String _lockedBy = "UNLOCKED";
    protected String _error = "";
    protected boolean _local = false;
    protected Hashtable<String, RmiWorkspace> _childWorkspaceTable = new Hashtable();
    protected RmiWorkspaceImpl _parentWorkspace = null;
    protected RmiApp _rmiApp = null;
    protected RemoteWrapper _dataListContainer = null;
    private boolean _modified = false;
    protected String _iconQualityInformation = null;
    protected TimeZone _timezone = null;
    protected List _managerOrderList = null;
    protected boolean _loaded = false;
    String gmtFormat = "GMT{0}{1}:00";
    private boolean _loading;
    protected static Hashtable<String, String> _childWorkspaceClasses = new Hashtable();
    protected static final MessageFormat MAPS_DIR_TEMPLATE;

    public static void addChildWorkspaceMapping(String wkspName, String wkspClassname) {
        if (wkspName == null || wkspClassname == null) {
            return;
        }
        String stdWkspName = WorkspaceNameFactory.getWorkspaceName((String)wkspName);
        _childWorkspaceClasses.put(stdWkspName, wkspClassname);
    }

    public RmiWorkspaceImpl(int port) throws RemoteException {
        super(port);
        this.identifier = new Identifier();
        this._callBackObjects = new Vector();
        this._listOfUsers = new Vector();
        this._extents = new WorldRect(-1000.0, 1000.0, 1000.0, -1000.0);
        this._managerProxys.setManagerProxyListContainer(this);
    }

    public RmiWorkspaceImpl(Integer port) throws RemoteException {
        this((int)port);
    }

    @Override
    public int getUnitSystem() {
        if (this._parentWorkspace != null) {
            return this._parentWorkspace.getUnitSystem();
        }
        Class<?> cl = this.getClass();
        cl.getName();
        throw new IllegalAccessError("ERROR: <" + cl.getName() + ".getUnitSystem()> No Parent Workspace Defined to get the Unit System");
    }

    public void setUnitSystem(int unitSystem) {
        if (this._parentWorkspace != null) {
            this._parentWorkspace.setUnitSystem(unitSystem);
            return;
        }
        Class<?> cl = this.getClass();
        throw new IllegalAccessError("ERROR: <" + cl.getName() + ".getUnitSystem()> No Parent Workspace Defined to set the Unit System");
    }

    @Override
    public int getGmtOffset() {
        if (this._parentWorkspace != null) {
            return this._parentWorkspace.getGmtOffset();
        }
        Class<?> cl = this.getClass();
        throw new IllegalAccessError("ERROR: <" + cl.getName() + ".getGmtOffset()> No Parent workspace defined to get the GMT offset");
    }

    public void setGmtOffset(int offset) {
        if (this._parentWorkspace != null) {
            this._parentWorkspace.setGmtOffset(offset);
            return;
        }
        Class<?> cl = this.getClass();
        throw new IllegalAccessError("ERROR: <" + cl.getName() + ".getGmtOffset()> No Parent workspace defined to set the GMT offset");
    }

    @Override
    public CoordinateInfo getCoordSys() throws RemoteException {
        if (this._coordinateSystem != null && this._coordinateSystem.getUnits() == null) {
            if (this.getUnitSystem() == 2) {
                this._coordinateSystem.setUnits("Meters");
            } else {
                this._coordinateSystem.setUnits("U.S. Feet");
            }
        }
        return this._coordinateSystem;
    }

    @Override
    public boolean getGrowToExtents() throws RemoteException {
        return this._growToExtents;
    }

    @Override
    public synchronized boolean setCoordSys(String user, CoordinateInfo coordSys) throws RemoteException {
        this._coordinateSystem = coordSys;
        return true;
    }

    @Override
    public synchronized boolean setGrowToExtents(String user, boolean growToEx) throws RemoteException {
        this._growToExtents = growToEx;
        return true;
    }

    public void setServer(RmiApp app) {
        this._appServer = app;
    }

    @Override
    public abstract void saveWorkspace(String var1) throws RemoteException;

    @Override
    public synchronized void closeWorkspace(String user) throws RemoteException {
        System.out.println("Close the RmiWorkspace " + this.getName());
        this.removeUser(user);
        if (this._listOfUsers.size() < 1) {
            this.closeWorkspace();
            Enumeration<RmiWorkspace> e = this._childWorkspaceTable.elements();
            RmiAppImpl appImpl = null;
            if (this._rmiApp instanceof RmiAppImpl) {
                appImpl = (RmiAppImpl)this._rmiApp;
            }
            while (e.hasMoreElements()) {
                RmiWorkspaceImpl child = (RmiWorkspaceImpl)e.nextElement();
                child.closeWorkspace();
            }
            if (this.getNetworked()) {
                if (this._rmiApp != null) {
                    try {
                        this._rmiApp.removeWorkspace(this.getWorkspacePath());
                    }
                    catch (RemoteException re) {
                        System.out.println("closeWorkspace: failed to remove myself from my RmiApp " + re);
                    }
                } else {
                    System.out.println("closeWorkspace:Null rmiApp");
                }
                try {
                    this.unbindServer();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                System.gc();
                System.gc();
            }
        }
    }

    protected void closeWorkspace() {
        RmiDataListContainerImpl rdlc = this.getDataListContainer();
        try {
            rdlc.workspaceClosing();
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        if (this.getNetworked()) {
            try {
                RmiWorkspaceImpl.unexportObject((Remote)rdlc, (boolean)false);
            }
            catch (NoSuchObjectException e) {
                ((MarkingClassLogger.Api)((MarkingClassLogger.Api)RMI_WORKSPACE_PROP_LOGGER.atFine()).withCause((Throwable)e)).log("Exception unexporting RmiDataListContainer");
            }
            try {
                RmiWorkspaceImpl.unexportObject((Remote)this, (boolean)false);
            }
            catch (Exception e) {
                ((MarkingClassLogger.Api)((MarkingClassLogger.Api)RMI_WORKSPACE_PROP_LOGGER.atFine()).withCause((Throwable)e)).log("Error unbinding");
            }
        }
        this._dataListContainer = null;
    }

    public void setParentWorkspace(RmiWorkspaceImpl p) {
        this._parentWorkspace = p;
        RemoteWrapper rw = new RemoteWrapper();
        try {
            rw.setRemote((Remote)p.getFileManager());
            this.setFileManager(rw);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        this._managerProxys.setManagerProxyListContainer(p);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RmiWorkspace getChildWorkspace(String type) {
        Hashtable<String, RmiWorkspace> hashtable = this._childWorkspaceTable;
        synchronized (hashtable) {
            if (this._parentWorkspace != null) {
                return this._parentWorkspace.getChildWorkspace(type);
            }
            ((MarkingClassLogger.Api)RMI_WORKSPACE_PROP_LOGGER.atFine()).log("looking for child workspace %s", (Object)type);
            RmiWorkspace rmiwksp = null;
            String stdModelName = WorkspaceNameFactory.getWorkspaceName((String)type);
            rmiwksp = this._childWorkspaceTable.get(stdModelName);
            if (rmiwksp != null) {
                ((MarkingClassLogger.Api)RMI_WORKSPACE_PROP_LOGGER.atFine()).log("already created %s workspace", (Object)type);
                return rmiwksp;
            }
            if ("".equals(stdModelName) || "main".equalsIgnoreCase(stdModelName) || stdModelName == null) {
                return this;
            }
            try {
                RmiWorkspaceImpl ws = null;
                Class<?> wkspCls = null;
                String wkspClsName = null;
                try {
                    wkspClsName = _childWorkspaceClasses.get(stdModelName);
                    if (wkspClsName == null) {
                        Throwable t = new Throwable("getChildWorkspace(" + stdModelName + ")");
                        ((MarkingClassLogger.Api)((MarkingClassLogger.Api)RMI_WORKSPACE_PROP_LOGGER.atWarning()).withCause(t)).log("getChildWorkspace: failed to find workspace class for " + type);
                        wkspClsName = this.getClass().getName();
                    }
                    ((MarkingClassLogger.Api)RMI_WORKSPACE_PROP_LOGGER.atInfo()).log("got class %s for workspace %s", (Object)wkspClsName, (Object)stdModelName);
                    wkspCls = Class.forName(wkspClsName);
                }
                catch (ClassNotFoundException cfe) {
                    ((MarkingClassLogger.Api)RMI_WORKSPACE_PROP_LOGGER.atWarning()).log("getChildWorkspace: Child workspace class not found. Probably missing " + stdModelName + ".jar" + cfe);
                    return null;
                }
                Constructor<?> c = wkspCls.getDeclaredConstructor(INT_CLASS_ARGS);
                ws = (RmiWorkspaceImpl)c.newInstance(new Integer(this.port));
                ws.setBindPort(this.getBindPort());
                ws.setParentWorkspace(this);
                String wkpath = this.getWorkspacePath();
                String path = wkpath + "/" + stdModelName + "/" + type + ".conf";
                String titlename = this.getTitleName().toLowerCase();
                titlename = titlename.replace(' ', '_');
                Identifier id = new Identifier(path);
                id.setName(stdModelName);
                id.setDescription("child of " + this.getTitleName());
                String user = UserId.getUserId();
                boolean existingWksp = true;
                Identifier ckid = this.openFile(user, id);
                if (ckid == null) {
                    ckid = this.newFile(user, id);
                    existingWksp = false;
                }
                ws.addUser(user);
                int idx = id.getPath().lastIndexOf("/");
                ws.setWorkspaceExt("conf");
                ws.setWorkspacePath(wkpath);
                if (!this.getNetworked()) {
                    ws.setLocal(true);
                } else {
                    ws.setLocal(false);
                }
                ws.setIdentifier(user, id);
                RemoteWrapper wsRw = new RemoteWrapper();
                ws.setNetworked(this.networked);
                if (this.getLocal() && this.getNetworked()) {
                    ws.exportServer();
                    wsRw.setExported(true);
                }
                wsRw.setRemote((Remote)ws);
                this.addRemoteWrapper(wsRw);
                if (existingWksp) {
                    ((MarkingClassLogger.Api)RMI_WORKSPACE_PROP_LOGGER.atInfo()).log("loading %s workspace file", (Object)type);
                    if (!ws.loaded()) {
                        ws.setLoading(true);
                        try {
                            boolean loaded = ws.load();
                            ws.setLoaded(loaded);
                        }
                        finally {
                            ws.setLoading(false);
                        }
                    }
                } else {
                    ws.saveWorkspace(user);
                    ws.createDefaultDataLists();
                }
                this._childWorkspaceTable.put(stdModelName, ws);
                return ws;
            }
            catch (Exception e) {
                ((MarkingClassLogger.Api)((MarkingClassLogger.Api)RMI_WORKSPACE_PROP_LOGGER.atWarning()).withCause((Throwable)e)).log("Error opening child workspace " + stdModelName);
                return null;
            }
        }
    }

    protected void setLoading(boolean loading) {
        this._loading = loading;
    }

    protected boolean isLoading() {
        return this._loading;
    }

    public abstract boolean load();

    public boolean loaded() {
        return this._loaded;
    }

    public void setLoaded(boolean loaded) {
        this._loaded = loaded;
    }

    @Override
    public String[] list(String dir) throws RemoteException {
        return this.getFileManager().list(dir);
    }

    @Override
    public String[] list(String dir, String filter) throws RemoteException {
        return this.getFileManager().list(dir, filter);
    }

    @Override
    public Identifier openFile(String user, String path) throws RemoteException {
        Identifier id = this.getFileManager().openFile(user, new Identifier(path));
        return id;
    }

    public Identifier openFile(Identifier id, boolean useCache) {
        try {
            return this.openFile(UserId.getUserId(), id);
        }
        catch (RemoteException re) {
            System.out.println("openFile: RMI Error opening file " + re);
            return null;
        }
    }

    @Override
    public Identifier openFile(String user, Identifier openFileId) throws RemoteException {
        Identifier id = this.getFileManager().openFile(user, openFileId);
        return id;
    }

    public Identifier createFile(Identifier id) {
        try {
            return this.newFile(UserId.getUserId(), id);
        }
        catch (RemoteException re) {
            System.out.println("createFile: RMI error creating file " + re);
            return null;
        }
    }

    @Override
    public Identifier newFile(String user, Identifier newFileId) throws RemoteException {
        Identifier id = this.getFileManager().newFile(user, newFileId);
        return id;
    }

    @Override
    public boolean copyFile(String user, Identifier oldPathId, Identifier newPathId) throws RemoteException {
        return this.getFileManager().copyFile(oldPathId, newPathId);
    }

    @Override
    public boolean deleteFile(String user, Identifier deleteFileId) throws RemoteException {
        if (user == null || deleteFileId == null) {
            return false;
        }
        return this.getFileManager().deleteFile(deleteFileId.getPath());
    }

    public List getFileList(String dirName, String filter) {
        try {
            RmiFileManager fmi = this.getFileManager();
            Vector vec = fmi.getRemoteFileIDList(UserId.getUserId(), dirName, filter);
            return vec;
        }
        catch (RemoteException re) {
            System.out.println("getFileList: RMI Error getting file list " + re);
            return null;
        }
    }

    @Override
    public Vector getRemoteFileIDList(String user, String dirName, String filter) throws RemoteException {
        Vector vec = null;
        RmiFileManager fmi = this.getFileManager();
        vec = fmi.getRemoteFileIDList(user, dirName, filter);
        return vec;
    }

    public void setLocal(boolean local) {
        this._local = local;
    }

    public boolean getLocal() {
        return this._local;
    }

    public void setWorkspacePath(String wspath) {
        this._WorkspacePath = wspath = wspath.replace('\\', '/');
    }

    @Override
    public String getWorkspacePath() {
        return this._WorkspacePath;
    }

    @Override
    public String getWorkspaceType() throws RemoteException {
        return this._typeOfWorkspace;
    }

    public void setRmiApp(RmiApp app) {
        this._rmiApp = app;
    }

    public RmiApp getRmiApp() {
        if (this._parentWorkspace != null) {
            return this._parentWorkspace.getRmiApp();
        }
        return this._rmiApp;
    }

    @Override
    public void setIconQualityInformation(String iconQualityInformation) {
        this._iconQualityInformation = new String(iconQualityInformation);
    }

    @Override
    public String getIconQualityInformation() {
        return this._iconQualityInformation;
    }

    public void createSharedDir() {
        try {
            Identifier id = new Identifier(this.getWorkspacePath() + "/shared/");
            this.newFile(UserId.getUserId(), id);
        }
        catch (Exception e) {
            System.out.println("Error in creating the shared directory" + e);
        }
    }

    public void createMapDir() {
        try {
            Identifier id = new Identifier(MAPS_DIR_TEMPLATE.format(new String[]{this.getWorkspacePath()}));
            id._directory = true;
            this.newFile(UserId.getUserId(), id);
        }
        catch (Exception e) {
            System.out.println("Error in creating the maps directory" + e);
        }
    }

    public void createTemplateDir() {
        try {
            Identifier id = new Identifier(this.getWorkspacePath() + "/templates/");
            this.newFile(UserId.getUserId(), id);
        }
        catch (Exception e) {
            System.out.println("Error in creating the shared directory" + e);
        }
    }

    @Override
    public void setIdentifier(String user, Identifier id) {
        this.identifier = id;
        try {
            String uniqueName = this.identifier.getName() + this.identifier.getPath().hashCode();
            super.setName(uniqueName);
        }
        catch (Exception e) {
            System.out.println("Error setting Workspace Name " + e);
            e.printStackTrace(System.out);
        }
        Object path = this.identifier.getPath();
        this.setPath((String)path);
        Class<?> c = null;
        try {
            c = Class.forName("hec.clientapp.server.HecRmiWorkspaceImpl");
        }
        catch (ClassNotFoundException cne) {
            System.out.println("setIdentifier:failed to find HecRmiWorkspaceImpl class " + cne);
        }
        if (c != null && c.isAssignableFrom(this.getClass())) {
            this._managerProxys.setModel("main");
        } else {
            this._managerProxys.setModel(id.getName());
        }
        if (path != null && ((String)path).length() > 0) {
            HecFile file;
            if (((String)path).toLowerCase().lastIndexOf(this.getWorkspaceExt().toLowerCase()) == -1) {
                path = (String)path + "." + this.getWorkspaceExt();
            }
            if ((file = this.identifier.getFile()) == null || file.getPath().lastIndexOf((String)path) == -1) {
                this.identifier.setPath((String)path);
                Identifier fileId = null;
                RmiFileManager fm = null;
                try {
                    fm = this.getFileManager();
                }
                catch (Exception re) {
                    System.out.println("setIdentifer: RMI Error getting FileManager" + re);
                    return;
                }
                try {
                    fileId = fm.openFile(user, this.identifier);
                    if (fileId == null) {
                        fileId = fm.newFile(user, this.identifier);
                    }
                }
                catch (RemoteException re) {
                    System.out.println("setIdentifier: RMI Error opening file" + this.identifier.getPath() + " with FileManager. Error " + re);
                }
                if (fileId != null) {
                    this.identifier.copy(fileId);
                } else {
                    System.out.println("Error in RmiWorkspaceImpl.setIdentifier");
                    System.out.println("Failed to get file identifier from file manager for path " + (String)path);
                }
            }
        }
    }

    @Override
    public Identifier getIdentifier() {
        return this.identifier;
    }

    @Override
    public RemoteWrapper getDSSFileManager() throws RemoteException {
        return this._parentWorkspace.getDSSFileManager();
    }

    public void setWorkspaceExt(String ext) {
        this._wsExt = ext;
    }

    public String getWorkspaceExt() {
        return this._wsExt;
    }

    @Override
    public String getDescription() {
        return this.identifier.getDescription();
    }

    @Override
    public synchronized void setDescription(String user, String description) {
        this.identifier.setDescription(description);
    }

    protected void setFileManager() {
        if (this.getLocal()) {
            try {
                this._fileManager = new RemoteWrapper();
                RmiFileManager fm = (RmiFileManager)Class.forName("hec.server.RmiFileManagerImpl").newInstance();
                if (this.getLocal() && this.getNetworked()) {
                    ((PortableRmiObject)fm).exportServer();
                    this._fileManager.setExported(true);
                }
                this._fileManager.setRemote((Remote)fm);
                this.addRemoteWrapper(this._fileManager);
                super.setFileManager(this._fileManager);
            }
            catch (Exception e) {
                System.out.println("setFileManager: Error creating RmiFileManager " + e);
                e.printStackTrace(System.out);
            }
        } else {
            String rmiUrlString = "rmi://localhost:" + this.getRmiPort() + "/FileManager";
            try {
                RmiFileManager fmi = (RmiFileManager)Naming.lookup(rmiUrlString);
                this._fileManager = new RemoteWrapper((Remote)fmi);
                this._fileManager.setExported(true);
                super.setFileManager(this._fileManager);
            }
            catch (Exception e) {
                System.out.println("RmiWorkspaceImpl():Can't find file manager at " + rmiUrlString + " exception is " + e);
            }
        }
    }

    @Override
    public RmiFileManager getFileManager() throws RemoteException {
        if (super.getFileManager() == null) {
            this.setFileManager();
        }
        if (!this.getLocal()) {
            try {
                ((RmiFileManager)this._fileManager.getRemote()).isAlive();
            }
            catch (Exception e) {
                this.setFileManager();
            }
            return (RmiFileManager)this._fileManager.getRemote();
        }
        return super.getFileManager();
    }

    protected void setPath(String path) {
        if (this._WorkspacePath == null && path != null) {
            int stripAt = path.lastIndexOf(sep) + 1;
            int stripTo = path.lastIndexOf(".");
            if (stripAt > 0) {
                path = stripTo > 0 ? path.substring(stripAt, stripTo) : path.substring(stripAt);
            }
            this._WorkspacePath = "workspace" + sep + path;
            this._typeOfWorkspacePath = this._WorkspacePath + sep + this._typeOfWorkspace;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addManager(String user, ManagerProxy proxy) {
        RmiWorkspaceImpl rmiWorkspaceImpl = this;
        synchronized (rmiWorkspaceImpl) {
            proxy.setWorkspace(this.getRemoteReference());
            proxy.setProxyList(this._managerProxys);
            if (!this._managerProxys.contains(proxy)) {
                this._managerProxys.addElement(proxy);
            }
        }
        if (!this._loading) {
            this.invokeManagerCallBack(0, proxy);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeManager(String user, Identifier id) throws RemoteException {
        if (id == null || user == null) {
            return false;
        }
        RmiWorkspaceImpl rmiWorkspaceImpl = this;
        synchronized (rmiWorkspaceImpl) {
            for (int i = 0; i < this._managerProxys.size(); ++i) {
                ManagerProxy proxy = (ManagerProxy)this._managerProxys.elementAt(i);
                if (!proxy.getId().getPath().equals(id.getPath())) continue;
                proxy.deleteManager();
                if (!this._managerProxys.removeElement(proxy)) continue;
                this.invokeManagerCallBack(1, proxy);
                this.saveWorkspace(user);
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeManager(String user, ManagerProxy manager) throws RemoteException {
        if (manager != null && user != null) {
            RmiWorkspaceImpl rmiWorkspaceImpl = this;
            synchronized (rmiWorkspaceImpl) {
                manager.deleteManager();
                this._managerProxys.removeElement(manager);
                this.invokeManagerCallBack(1, manager);
                this.saveWorkspace(user);
            }
        }
    }

    @Override
    public synchronized boolean renameManager(String user, String model, String className, int index, Identifier renameToId) throws RemoteException {
        Identifier renamedId;
        if (renameToId == null || index < 0) {
            return false;
        }
        if (this._parentWorkspace != null) {
            return this._parentWorkspace.renameManager(user, model, className, index, renameToId);
        }
        ManagerProxyList proxyList = this.getManagerProxyList(model);
        if (proxyList == null) {
            return false;
        }
        ManagerProxy proxy = proxyList.getManagerProxy(className, index);
        if (proxy != null && this.getFileManager().copyFile(proxy.getId(), renameToId) && (renamedId = this.getFileManager().openFile(user, renameToId)) != null) {
            proxy.renameManager(renamedId);
            this.saveWorkspace(user);
            this.invokeManagerCallBack(2, proxy);
            return true;
        }
        return false;
    }

    @Override
    public Manager getManager(String classname, Identifier id) throws RemoteException {
        return this._managerProxys.loadManager(classname, id);
    }

    @Override
    public Vector getManagerProxyList(String model, String className) {
        if (model == null || className == null) {
            return null;
        }
        if (this.identifier.getName().equals(model)) {
            int size = this._managerProxys.size();
            Vector<ManagerProxy> proxyList = new Vector<ManagerProxy>(size);
            for (int i = 0; i < size; ++i) {
                ManagerProxy proxy = (ManagerProxy)this._managerProxys.get(i);
                if (proxy == null || proxy.getId() == null || !proxy.getClassName().equals(className)) continue;
                ManagerProxy newProxy = new ManagerProxy(proxy);
                newProxy.setProxyList(this._managerProxys);
                proxyList.add(newProxy);
            }
            proxyList.trimToSize();
            return proxyList;
        }
        if (this._parentWorkspace != null) {
            return this._parentWorkspace.getManagerProxyList(model, className);
        }
        return null;
    }

    @Override
    public ManagerProxyList getManagers() {
        ManagerProxyList proxyVec = new ManagerProxyList(this);
        proxyVec.setModel(this._managerProxys.getModel());
        for (int i = 0; i < this._managerProxys.size(); ++i) {
            ManagerProxy proxy = (ManagerProxy)this._managerProxys.elementAt(i);
            if (proxy == null) continue;
            ManagerProxy proxycopy = new ManagerProxy(proxy);
            proxycopy.setClassName(ManagerMappingFactory.getMapping((String)proxy.getClassName()));
            proxycopy.setProxyList(proxyVec);
            proxyVec.addElement(proxycopy);
        }
        proxyVec.setWorkspace(this._managerProxys.getWorkspace());
        return proxyVec;
    }

    @Override
    public synchronized void setManagers(String user, ManagerProxyList managers) throws RemoteException {
        this._managerProxys = managers;
        this.invokeCallBack();
    }

    @Override
    public void unloadManager(String modelname, Identifier id) {
        if (modelname == null || id == null || modelname.equals("")) {
            return;
        }
        ManagerProxyList list = this.getManagerProxyList(modelname);
        if (list == null) {
            return;
        }
        list.unloadManager(id);
    }

    @Override
    public boolean addMap(String user, MapIdentifier map) throws RemoteException {
        this._mapIdentifiers.addElement(map);
        this.invokeAddMapCallBack(map);
        return true;
    }

    @Override
    public boolean removeMap(String user, MapIdentifier map) throws RemoteException {
        this._mapIdentifiers.removeElement(map);
        this.invokeRemoveMapCallBack(map);
        return true;
    }

    @Override
    public Vector getMaps() throws RemoteException {
        if (this._mapIdentifiers != null && this.getNetworked()) {
            for (int i = 0; i < this._mapIdentifiers.size(); ++i) {
                MapIdentifier map;
                Object obj = this._mapIdentifiers.elementAt(i);
                if (!(obj instanceof MapIdentifier) || (map = (MapIdentifier)obj).getFile() == null || map.getFile().isNetworked()) continue;
                map.setFile(null);
            }
        }
        return this._mapIdentifiers;
    }

    @Override
    public synchronized boolean setMaps(String user, Vector maps) throws RemoteException {
        this._mapIdentifiers = maps;
        return true;
    }

    @Override
    public WorldRect getExtents() throws RemoteException {
        return this._extents;
    }

    @Override
    public synchronized boolean setExtents(String user, WorldRect extents) throws RemoteException {
        this._extents = extents;
        return true;
    }

    @Override
    public void addCallBack(RmiWkspCallBack callBack) throws RemoteException {
        this._callBackObjects.addElement(callBack);
    }

    @Override
    public void removeCallBack(RmiWkspCallBack callBack) throws RemoteException {
        if (this._callBackObjects.removeElement(callBack)) {
            // empty if block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invokeAddMapCallBack(MapIdentifier mapId) {
        Vector vector = this._callBackObjects;
        synchronized (vector) {
            for (int ii = this._callBackObjects.size() - 1; ii >= 0; --ii) {
                RmiWkspCallBack callBack = (RmiWkspCallBack)this._callBackObjects.elementAt(ii);
                if (callBack == null) {
                    return;
                }
                try {
                    callBack.mapAdded(mapId);
                    continue;
                }
                catch (RemoteException re) {
                    this._callBackObjects.remove(ii);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invokeRemoveMapCallBack(MapIdentifier mapId) {
        Vector vector = this._callBackObjects;
        synchronized (vector) {
            for (int ii = this._callBackObjects.size() - 1; ii >= 0; --ii) {
                RmiWkspCallBack callBack = (RmiWkspCallBack)this._callBackObjects.elementAt(ii);
                if (callBack == null) {
                    return;
                }
                try {
                    callBack.mapRemoved(mapId);
                    continue;
                }
                catch (RemoteException re) {
                    this._callBackObjects.remove(ii);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invokeManagerCallBack(int type, ManagerProxy proxy) {
        String model = proxy.getProxyList().getModel();
        if (this._parentWorkspace instanceof HecRmiWorkspaceImpl) {
            ((HecRmiWorkspaceImpl)this._parentWorkspace).invokeManagerCallBack(type, proxy, model);
            return;
        }
        Vector vector = this._callBackObjects;
        synchronized (vector) {
            ManagerProxy proxyCopy = null;
            for (int ii = this._callBackObjects.size() - 1; ii >= 0; --ii) {
                if (proxyCopy == null) {
                    proxyCopy = new ManagerProxy(proxy);
                    proxyCopy.setProxyList(null);
                }
                RmiWkspCallBack callBack = (RmiWkspCallBack)this._callBackObjects.elementAt(ii);
                try {
                    callBack.managerChanged(type, proxyCopy, model);
                    continue;
                }
                catch (RemoteException re) {
                    this._callBackObjects.remove(ii);
                }
            }
        }
    }

    public void invokeCallBack() throws RemoteException {
        for (int ii = 0; ii < this._callBackObjects.size(); ++ii) {
            ClientSideCallBackInterface callBack = (ClientSideCallBackInterface)this._callBackObjects.elementAt(ii);
            callBack.dataChanged();
        }
    }

    @Override
    public synchronized void changeName(String user, String name) throws RemoteException {
        super.setName(name);
    }

    @Override
    public boolean checkUser(String user) throws RemoteException {
        if (this._lockedBy.equals("UNLOCKED")) {
            this.setLockedBy(user);
        } else {
            if (this._lockedBy.equals(user)) {
                return true;
            }
            System.out.println("Checking user " + this._lockedBy);
            if (this.checkUserLoggedIn(this._lockedBy)) {
                System.out.println(this.getName() + " Locked by " + this._lockedBy + " not " + user);
                return false;
            }
            System.out.println(this.getName() + " User " + this._lockedBy + " no longer logged in");
            this.setLockedBy(user);
        }
        return true;
    }

    protected boolean checkUserLoggedIn(String user) {
        this.stringUrl = "rmi://localhost:" + this.getRmiPort() + "/";
        try {
            RmiLogin rl = (RmiLogin)Naming.lookup(this.stringUrl + "LoginServer");
            RemoteWrapper _rlWrapper = new RemoteWrapper((Remote)rl);
            _rlWrapper.setExported(true);
            return ((RmiLogin)_rlWrapper.getRemote()).isLoggedIn(user);
        }
        catch (Exception e) {
            System.out.println("Can't find LoginServer at " + this.stringUrl + "LoginServer");
            System.out.println("Exception is " + e);
            return true;
        }
    }

    private void setLockedBy(String user) throws RemoteException {
        this._lockedBy = user;
        System.out.println(this.getName() + " Now locked by: " + this._lockedBy);
    }

    @Override
    public boolean addUser(String user) {
        boolean alreadyThere = false;
        for (int ii = 0; ii < this._listOfUsers.size(); ++ii) {
            String str = (String)this._listOfUsers.elementAt(ii);
            if (!str.equals(user)) continue;
            alreadyThere = true;
        }
        if (alreadyThere) {
            this._error = "Warning: User is already using this Workspace :" + user;
            return true;
        }
        this._listOfUsers.addElement(user);
        return true;
    }

    @Override
    public void removeUser(String user) throws RemoteException {
        this._listOfUsers.removeElement(user);
        if (this._lockedBy.equals(user)) {
            this._lockedBy = "UNLOCKED";
        }
    }

    @Override
    public Vector getUsers() throws RemoteException {
        return this._listOfUsers;
    }

    @Override
    public String getError() throws RemoteException {
        return this._error;
    }

    @Override
    public void setError(String user, String str) throws RemoteException {
        this._error = str;
    }

    protected void readMap(BufferedReader input) throws IOException {
        String line;
        String mapName = null;
        String description = null;
        Object path = null;
        String stringClass = null;
        int maxScaleValue = Integer.MAX_VALUE;
        int minScaleValue = Integer.MIN_VALUE;
        long modifiedTime = Long.MIN_VALUE;
        boolean shown = false;
        GlyphDataRecord rec = null;
        while ((line = input.readLine()) != null) {
            ((MarkingClassLogger.Api)RMI_WORKSPACE_PROP_LOGGER.atFine()).log(line);
            if (line.indexOf("MapEnd") > -1) break;
            if (line.indexOf("GlyphDataRecordBegin") > -1) {
                rec = this.readGlyphDataRecord(input);
                continue;
            }
            String type = RMAIO.getType((String)line, (String)"=");
            String param = RMAIO.getParam((String)line, (String)"=");
            if (type.compareTo("Name") == 0) {
                mapName = param;
                continue;
            }
            if (type.compareTo("GlyphDataRecordSerialized") == 0 || type.compareTo("GlyphDataRecordAsciiSerialized") == 0) {
                Object filepath = RMAIO.getParam((String)param, (String)",");
                if (!this.isFullPath((String)filepath)) {
                    int idx = ((String)filepath).indexOf("maps");
                    filepath = idx > -1 ? this.getWorkspacePath() + "/" + ((String)filepath).substring(idx, ((String)filepath).length()) : this.getWorkspacePath() + "/" + (String)filepath;
                }
                String gdrClassString = RMAIO.getType((String)param, (String)",");
                Identifier fileRequest = new Identifier((String)filepath);
                Identifier asciiSerializedId = this.openFile(UserId.getUserId(), fileRequest);
                if (asciiSerializedId == null) continue;
                try {
                    rec = (GlyphDataRecord)Class.forName(gdrClassString).newInstance();
                }
                catch (Exception e) {
                    System.out.println("readMap: failed to find GlyphDataRecord class " + gdrClassString + " Error:" + e);
                    e.printStackTrace();
                    rec = null;
                    continue;
                }
                BufferedReader in = asciiSerializedId.getFile().getBufferedReader();
                if (type.compareTo("GlyphDataRecordSerialized") == 0) {
                    try {
                        ((GlyphDataRecordSerializable)rec).deserialize(in);
                    }
                    catch (Exception e) {
                        System.out.println("Exception Occurred while reading map properties file: " + (String)filepath);
                        e.printStackTrace();
                    }
                } else {
                    HecAsciiDeserializer ad = new HecAsciiDeserializer(in);
                    ad.deserializeObject((Object)rec);
                }
                in.close();
                continue;
            }
            if (type.compareTo("Description") == 0) {
                description = param;
                continue;
            }
            if (type.compareTo("Path") == 0) {
                if (this.isFullPath(param)) {
                    path = param;
                    continue;
                }
                int idx = param.indexOf("maps");
                if (idx > -1) {
                    path = this.getWorkspacePath() + "/" + param.substring(idx, param.length());
                    continue;
                }
                path = this.getWorkspacePath() + "/" + param;
                continue;
            }
            if (type.compareTo("Shown") == 0) {
                shown = Boolean.valueOf(param);
                continue;
            }
            if (type.compareTo("Class") == 0) {
                stringClass = param;
                if (stringClass.equals("hec.map.DLGMap")) {
                    stringClass = "hec.map.dlg.DlgMap";
                    continue;
                }
                if (stringClass.equals("hec.map.TinMap")) {
                    stringClass = "hec.map.tin.TinMap";
                    continue;
                }
                if (stringClass.equals("hec.map.DxfMap")) {
                    stringClass = "hec.map.dxf.DxfMap";
                    continue;
                }
                if (!stringClass.equals("hec.map.ImageMap")) continue;
                stringClass = "hec.map.image.ImageMap";
                continue;
            }
            if (type.compareTo("MaxScaleValue") == 0) {
                maxScaleValue = RMAIO.parseInt((String)param);
                continue;
            }
            if (type.compareTo("MinScaleValue") != 0) continue;
            minScaleValue = RMAIO.parseInt((String)param);
        }
        Identifier fileId = new Identifier(path);
        try {
            fileId = this.getFileManager().openFile(UserId.getUserId(), fileId);
        }
        catch (RemoteException re) {
            System.out.println("Error retrieving the map data file  " + re);
            re.printStackTrace(System.out);
        }
        if (fileId != null) {
            MapIdentifier mapId = new MapIdentifier(fileId);
            mapId.setName(mapName);
            mapId.setDescription(description);
            mapId.setMapShown(shown);
            mapId.setGlyphDataRecord(rec);
            mapId.setClassName(stringClass);
            mapId.setMaximumScale(maxScaleValue);
            mapId.setMinimumScale(minScaleValue);
            mapId.setModifiedTime(modifiedTime);
            this._mapIdentifiers.addElement(mapId);
        }
    }

    protected GlyphDataRecord readGlyphDataRecord(BufferedReader input) throws IOException {
        String stringClass = null;
        String line = input.readLine();
        while (line.indexOf("GlyphDataRecordEnd") < 0) {
            String type = RMAIO.getType((String)line, (String)"=");
            String param = RMAIO.getParam((String)line, (String)"=");
            if (type.compareTo("Class") == 0) {
                stringClass = param;
                if (stringClass.equals("hec.map.DLGGlyphDataRecord")) {
                    stringClass = "hec.map.dlg.DlgGlyphDataRecord";
                }
                if (stringClass.equals("hec.map.TinGlyphDataRecord")) {
                    stringClass = "hec.map.tin.TinGlyphDataRecord";
                }
                if (stringClass.equals("hec.map.DxfGlyphDataRecord")) {
                    stringClass = "hec.map.dxf.DxfGlyphDataRecord";
                }
                if (!stringClass.equals("hec.map.ImageGlyphDataRecord")) break;
                stringClass = "hec.map.image.ImageGlyphDataRecord";
                break;
            }
            line = input.readLine();
        }
        try {
            Class<?> recClass = Class.forName(stringClass);
            Object obj = recClass.newInstance();
            if (obj instanceof GlyphDataRecord) {
                GlyphDataRecord rec = (GlyphDataRecord)obj;
                rec.read(input);
                return rec;
            }
        }
        catch (ClassNotFoundException cnfe) {
            System.out.println("Class Not Found " + stringClass + "  " + cnfe);
            cnfe.printStackTrace(System.out);
        }
        catch (InstantiationException ie) {
            System.out.println("Instantiation Exception with GlyphDataRecord " + stringClass + "  " + ie);
            ie.printStackTrace(System.out);
        }
        catch (IllegalAccessException iae) {
            System.out.println("IllegalAccess Exception with " + stringClass + "  " + iae);
            iae.printStackTrace(System.out);
        }
        return null;
    }

    protected void readManagerProxy(BufferedReader input) throws IOException {
        String managerProxyName = null;
        String description = null;
        String path = null;
        String stringClass = null;
        long modTime = Long.MAX_VALUE;
        int index = -1;
        String line = input.readLine();
        while (line.indexOf("ManagerProxyEnd") < 0) {
            String type = RMAIO.getType((String)line, (String)"=");
            String param = RMAIO.getParam((String)line, (String)"=");
            if (type.compareTo("Name") == 0) {
                managerProxyName = param;
            } else if (type.compareTo("Path") == 0) {
                path = param;
            } else if (type.compareTo("Description") == 0) {
                description = description == null ? param : description.concat("\n").concat(param);
            } else if (type.compareTo("Class") == 0) {
                stringClass = ClassNameMapper.getNewClassMapping((String)param);
            } else if (type.compareTo("ModifiedTime") == 0) {
                modTime = RMAIO.parseLong((String)param);
            } else if (type.equals("Index")) {
                index = RMAIO.parseInt((String)param);
            }
            line = input.readLine();
        }
        Identifier proxyId = !this.isFullPath(path) ? new Identifier(this.getWorkspacePath() + "/" + path) : new Identifier(path);
        Identifier newProxyId = null;
        try {
            newProxyId = this.getFileManager().openFile(UserId.getUserId(), proxyId);
        }
        catch (RemoteException re) {
            System.out.println("Error retrieving the Manager Proxy data file  " + re);
            re.printStackTrace(System.out);
        }
        if (newProxyId != null) {
            newProxyId.setName(managerProxyName);
            newProxyId.setDescription(description);
            if (this._managerProxys.getManagerProxy(stringClass, index) == null) {
                ManagerProxy proxy = new ManagerProxy(stringClass, newProxyId);
                proxy.setWorkspace(this.getRemoteReference());
                proxy.setProxyList(this._managerProxys);
                proxy.setLastModifiedTime(modTime);
                if (index == -1) {
                    proxy.setIndex(this.getNextManagerIndex());
                } else {
                    proxy.setIndex(index);
                }
                this._managerProxys.addElement(proxy);
            }
        } else {
            System.out.println("readManagerProxy: failed to find file " + proxyId.getPath() + " for ManagerProxy " + managerProxyName + "(" + index + ")");
        }
    }

    @Override
    public int getNextManagerIndex() {
        if (this._parentWorkspace != null) {
            return this._parentWorkspace.getNextManagerIndex();
        }
        return -1;
    }

    protected void readDataList(BufferedReader input) throws IOException {
        String stringClass = null;
        boolean isShown = false;
        if (this._dataListContainer == null) {
            this.createDataListContainer();
        }
        String line = input.readLine();
        while (line.indexOf("RmiDataListEnd") < 0) {
            String type = RMAIO.getType((String)line, (String)"=");
            String param = RMAIO.getParam((String)line, (String)"=");
            if (type.equals("Class")) {
                stringClass = param;
            } else if (type.equals("Shown")) {
                isShown = Boolean.valueOf(param);
            }
            line = input.readLine();
        }
        RmiDataList rdl = RmiDataListFactory.getDataList((RmiDataListContainer)this._dataListContainer.getRemote(), stringClass);
        rdl.setIsShown(isShown);
        if (rdl != null) {
            ((RmiDataListContainerImpl)this._dataListContainer.getRemote()).addDataList(rdl);
        }
    }

    protected void writeDataLists(BufferedWriter output) throws IOException {
        long modTime = Long.MAX_VALUE;
        if (this._dataListContainer == null) {
            return;
        }
        RmiDataList[] rdlArray = ((RmiDataListContainer)this._dataListContainer.getRemote()).getDataLists();
        for (int i = 0; i < rdlArray.length; ++i) {
            RmiDataList rdl = rdlArray[i];
            this.lineWrite(output, "RmiDataListBegin");
            this.lineWrite(output, "Class=" + rdl.getDataListType());
            this.lineWrite(output, "Shown=" + rdl.isShown());
            this.lineWrite(output, "RmiDataListEnd\n");
        }
    }

    @Override
    public String getLockedBy() throws RemoteException {
        return this._lockedBy;
    }

    @Override
    public ManagerProxyList getManagerProxyList(String modelname) {
        RmiWorkspace childwksp = this.getChildWorkspace(modelname);
        ManagerProxyList list = ((RmiWorkspaceImpl)childwksp)._managerProxys;
        return list;
    }

    @Override
    public Manager openManager(Identifier id) {
        return this._managerProxys.openManager(id);
    }

    public Manager openManager(String relpath) {
        return this._managerProxys.openManager(relpath);
    }

    @Override
    public Manager openManagerByName(String modelname, String classname, String name) {
        ManagerProxyList list = null;
        list = modelname == null || modelname.equals("main") ? this._managerProxys : this.getManagerProxyList(modelname);
        if (list == null) {
            return null;
        }
        try {
            return list.loadManagerByName(classname, name);
        }
        catch (Exception e) {
            System.out.println("error opening manager " + name + " error " + e);
            return null;
        }
    }

    @Override
    public Manager newManager(String modelname, String classname) {
        ManagerProxyList list = this.getManagerProxyList(modelname);
        if (list == null) {
            return null;
        }
        this.setModified(true);
        return list.newManager(classname);
    }

    @Override
    public boolean saveManager(String modelname, Manager mgr) {
        ManagerProxyList list = this.getManagerProxyList(modelname);
        if (list == null) {
            return false;
        }
        return list.saveManager(UserId.getUserId(), mgr);
    }

    @Override
    public boolean saveManagerAs(String modelname, Manager mgr, Identifier id) {
        if (this.getWorkspacePath() == null) {
            System.out.println("saveManagerAs: Error workspace path is null");
            return false;
        }
        ManagerProxyList list = this.getManagerProxyList(modelname);
        if (list == null) {
            System.out.println("saveManagerAs: no managerProxyList for " + modelname);
            return false;
        }
        return list.saveManagerAs(UserId.getUserId(), mgr, id);
    }

    @Override
    public Manager openManager(String modelname, Identifier id) {
        if (modelname == null || modelname.equals("main")) {
            return this.openManager(id);
        }
        ManagerProxyList list = this.getManagerProxyList(modelname);
        if (list == null) {
            return null;
        }
        return list.openManager(id);
    }

    @Override
    public Manager openManager(String modelname, String className, int index) {
        if (modelname == null || modelname.equals("main")) {
            return this._managerProxys.openManager(className, index);
        }
        ManagerProxyList list = this.getManagerProxyList(modelname);
        if (list == null) {
            return null;
        }
        return list.openManager(className, index);
    }

    @Override
    public Vector getManagerIDList(String modelname, String className) {
        ManagerProxyList list = this.getManagerProxyList(modelname);
        if (list == null) {
            return null;
        }
        return list.getManagerIDList(className);
    }

    @Override
    public ManagerProxy getManagerProxy(String modelname, Identifier id) {
        ManagerProxyList list = this.getManagerProxyList(modelname);
        if (list == null) {
            return null;
        }
        return list.getManager(id);
    }

    @Override
    public ManagerProxy getManagerProxy(String modelname, String className, int index) {
        if (modelname == null || modelname.equals("main")) {
            return this._managerProxys.getManagerProxy(className, index);
        }
        ManagerProxyList list = this.getManagerProxyList(modelname);
        if (list == null) {
            return null;
        }
        return list.getManagerProxy(className, index);
    }

    @Override
    public Manager openManager(String modelname, String relpath) {
        if (modelname == null || modelname.equals("main")) {
            return this.openManager(relpath);
        }
        ManagerProxyList list = this.getManagerProxyList(modelname);
        if (list == null) {
            return null;
        }
        return list.openManager(relpath);
    }

    @Override
    public String makeAbsolutePath(String relPath) {
        if (relPath == null || relPath.equals("")) {
            return relPath;
        }
        if (this.isFullPath(relPath)) {
            return relPath;
        }
        relPath = relPath.replace('\\', '/');
        String absPath = this.getWorkspacePath() + (relPath.charAt(0) == "/".charAt(0) ? "" : "/") + relPath;
        return absPath;
    }

    @Override
    public boolean isFullPath(String path) {
        if (path == null || path.equals("")) {
            return true;
        }
        return (path = path.replace('\\', '/')).substring(0, 1).equals("/") || path.charAt(1) == ':' && path.substring(2, 3).equals("/");
    }

    @Override
    public String getRelativePath(String path) throws RemoteException {
        return RMAIO.getRelativePath((String)this.getWorkspacePath(), (String)path);
    }

    @Override
    public String getTitleName() {
        return this.identifier.getName();
    }

    @Override
    public String getParentTitleName() throws RemoteException {
        if (this._parentWorkspace != null) {
            return this._parentWorkspace.getTitleName();
        }
        return this.getTitleName();
    }

    public void lineWrite(BufferedWriter out, String str) {
        try {
            out.write(str);
            out.newLine();
        }
        catch (Exception e) {
            System.out.println("Error with BufferedWriter " + e);
            e.printStackTrace(System.out);
        }
    }

    public void writePath(BufferedWriter out, String path, String tag) {
        String outTag = tag == null || tag.equals("") ? "Path=" : tag;
        try {
            if (this.isFullPath(path)) {
                String relativePath = this.getRelativePath(path);
                this.lineWrite(out, outTag + relativePath);
            } else {
                this.lineWrite(out, outTag + path);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    @Override
    public Vector getModelInputPathnames(String altName) throws RemoteException {
        String wkpath = this.getWorkspacePath();
        String ftype = "modelinput";
        String path = wkpath + "/" + this.getWorkspaceType() + "/" + ftype + ".txt";
        Identifier pathId = new Identifier(path);
        pathId.setName(ftype);
        Vector vec = null;
        try {
            vec = this.readPathnames(pathId, altName);
        }
        catch (IOException ioe) {
            String error = "Error reading Model Input Pathnames File";
            System.out.println(error + "  " + ioe);
            throw new RemoteException(error, ioe);
        }
        return vec;
    }

    public Vector readPathnames(Identifier pathId, String altName) throws IOException {
        Vector<CallSite> pathnameList = new Vector<CallSite>();
        Identifier fileId = null;
        try {
            fileId = this.getFileManager().openFile(UserId.getUserId(), pathId);
        }
        catch (RemoteException re) {
            System.out.println("Error openning file  " + fileId);
        }
        if (fileId == null) {
            return pathnameList;
        }
        BufferedReader input = fileId.getFile().getBufferedReader();
        String pathnamePlus = null;
        String dssPathname = null;
        String units = null;
        String type = null;
        String line = input.readLine();
        while (line != null) {
            StringTokenizer st = new StringTokenizer(line, ";");
            dssPathname = st.nextToken();
            units = st.nextToken();
            type = st.nextToken();
            DSSPathString dssPathString = new DSSPathString(dssPathname);
            String oldFPart = dssPathString.getFPart();
            if (!oldFPart.equalsIgnoreCase("OBS")) {
                String newPath;
                dssPathString.setFPart(altName);
                dssPathname = newPath = dssPathString.getPathname();
            }
            if (pathnameList.indexOf(pathnamePlus = dssPathname + ";Units=" + units + ";Type=" + type) < 0) {
                pathnameList.addElement((CallSite)((Object)pathnamePlus));
            }
            line = input.readLine();
        }
        input.close();
        pathnameList.trimToSize();
        return pathnameList;
    }

    @Override
    public String lnSeparator() {
        return System.getProperty("line.separator");
    }

    @Override
    public long getCurrentTime() throws RemoteException {
        return System.currentTimeMillis();
    }

    @Override
    public boolean setManagersModifiedTime(String user, Identifier id, long lastModifiedTime) throws RemoteException {
        if (id == null || id.getPath() == null) {
            return false;
        }
        for (int i = 0; i < this._managerProxys.size(); ++i) {
            ManagerProxy proxy = (ManagerProxy)this._managerProxys.elementAt(i);
            Identifier proxyId = proxy.getId();
            if (proxyId == null || proxyId.getPath() == null || !id.equals((Object)proxyId) && proxyId.getPath().indexOf(id.getPath()) <= -1) continue;
            proxy.setLastModifiedTime(lastModifiedTime);
            return true;
        }
        System.out.println(this._typeOfWorkspace + "RmiWorkspace:Failed to update proxy " + id.getPath() + " modified time");
        return false;
    }

    @Override
    public long getManagersModifiedTime(Identifier id) throws RemoteException {
        if (id == null) {
            return Long.MAX_VALUE;
        }
        for (int i = 0; i < this._managerProxys.size(); ++i) {
            Identifier proxyId;
            ManagerProxy proxy = (ManagerProxy)this._managerProxys.elementAt(i);
            if (proxy == null || (proxyId = proxy.getId()) == null || !RMAIO.pathsEqual((String)proxyId.getPath(), (String)id.getPath())) continue;
            return proxy.getRmiLastModifiedTime();
        }
        System.out.println("Failed to find proxy " + id.getPath() + " last modified time");
        return Long.MAX_VALUE;
    }

    @Override
    public String getUrl() throws RemoteException {
        return super.getUrl();
    }

    @Override
    public String getProperty(String prop) throws RemoteException {
        if (prop == null) {
            return null;
        }
        return System.getProperty(prop);
    }

    @Override
    public TimeZone getTimeZone() throws RemoteException {
        int offset = this.getGmtOffset();
        Object[] args = new Object[2];
        args[0] = offset < 0 ? "-" : "+";
        int tempOffset = Math.abs(offset);
        args[1] = Integer.toString(tempOffset).length() > 1 ? new Integer(tempOffset) : "0" + tempOffset;
        return new SimpleTimeZone(offset * 60 * 60 * 1000, MessageFormat.format(this.gmtFormat, args));
    }

    @Override
    public synchronized RmiDataListContainer createDataListContainer() {
        if (this._dataListContainer == null) {
            try {
                RmiDataListContainerImpl dataListContainer = new RmiDataListContainerImpl(this);
                this._dataListContainer = dataListContainer.getRemoteReference();
                dataListContainer.setBindPort(this.getBindPort());
                dataListContainer.setNetworked(this.networked);
                if (this.networked) {
                    dataListContainer.exportServer();
                    this._dataListContainer.setExported(true);
                }
                this._dataListContainer.setRemote((Remote)dataListContainer);
            }
            catch (Exception e) {
                System.out.println("RmiWorkspaceImpl : error creating datalistContainer " + e);
            }
        }
        return (RmiDataListContainer)this._dataListContainer.getRemote();
    }

    @Override
    public RmiDataListContainer getDataList() throws RemoteException {
        return this.createDataListContainer();
    }

    public RmiDataListContainerImpl getDataListContainer() {
        this.createDataListContainer();
        return (RmiDataListContainerImpl)this._dataListContainer.getRemote();
    }

    public void createDefaultDataLists(RmiDataListContainer rdlc) {
    }

    public void createDefaultDataLists() {
    }

    @Override
    public CommonDataList getCommonDataList(String theDataObjectClass, String theModel) {
        if (!this._typeOfWorkspace.equals(theModel)) {
            RmiWorkspaceImpl rmiwksp = (RmiWorkspaceImpl)this.getChildWorkspace(theModel);
            if (rmiwksp != null) {
                return rmiwksp.getCommonDataList(theDataObjectClass, theModel);
            }
            if (this._parentWorkspace != null) {
                return this._parentWorkspace.getCommonDataList(theDataObjectClass, theModel);
            }
            System.out.println("Error retrieving DataList in RmiWorkspaceImpl.getCommonDataList");
            System.out.println("Cannot find requested model workspace: " + theModel);
            System.out.println("DataObjectClass: " + theDataObjectClass);
            return null;
        }
        if (this._dataListContainer == null || this._dataListContainer.getRemote() == null) {
            System.out.println("Error retrieving DataList in RmiWorkspaceImpl.getCommonDataList");
            System.out.println("DataListContainer is not available");
            System.out.println("DataObjectClass: " + theDataObjectClass);
            return null;
        }
        try {
            RmiDataListContainerImpl dlc = (RmiDataListContainerImpl)this._dataListContainer.getRemote();
            return (CommonDataList)dlc.getDataList(theDataObjectClass);
        }
        catch (Exception e) {
            System.out.println("Error retrieving DataList in RmiWorkspaceImpl.getCommonDataList");
            System.out.println("Remote exception getting data list");
            System.out.println("DataObjectClass: " + theDataObjectClass);
            return null;
        }
    }

    protected void createDefaultDataLists(RmiDataListContainer dataListContainer, String[] defaultLists) {
        if (dataListContainer == null) {
            return;
        }
        RmiDataList[] rdlArray = null;
        try {
            rdlArray = dataListContainer.getDataLists();
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        for (int i = 0; i < defaultLists.length; ++i) {
            RmiDataList rdl;
            boolean found = false;
            for (int j = 0; j < rdlArray.length; ++j) {
                ServerDataList sdl = (ServerDataList)rdlArray[j];
                if (!defaultLists[i].equals(sdl.getObjectClass())) continue;
                found = true;
                break;
            }
            if (found || (rdl = RmiDataListFactory.getDataList(dataListContainer, defaultLists[i])) == null) continue;
            ((MarkingClassLogger.Api)RMI_WORKSPACE_PROP_LOGGER.atFine()).log("creating datalist for %s", (Object)defaultLists[i]);
            try {
                rdl.setUnitSystem(this.getUnitSystem());
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
            this.getDataListContainer().addDataList(rdl);
        }
    }

    @Override
    public void setModified(boolean b) {
        this._modified = b;
    }

    @Override
    public boolean isModified() {
        return this._modified;
    }

    @Override
    public Vector getOpenChildWorkspaces() throws RemoteException {
        Vector<String> childWorkspaceTypes = new Vector<String>();
        if (this._childWorkspaceTable.size() < 1) {
            return childWorkspaceTypes;
        }
        Enumeration<String> e = this._childWorkspaceTable.keys();
        boolean idx = false;
        while (e.hasMoreElements()) {
            childWorkspaceTypes.addElement(e.nextElement());
        }
        return childWorkspaceTypes;
    }

    @Override
    public synchronized boolean setManagerOrder(String user, List managerOrderList) throws RemoteException {
        this._managerOrderList = managerOrderList;
        return true;
    }

    @Override
    public List getManagerOrder() throws RemoteException {
        return this._managerOrderList;
    }

    protected void printMessage(RemoteWrapper uiWrapper, String msg) {
        RmiProgress progress = this.getRmiProgress(uiWrapper);
        if (progress == null) {
            System.out.println(this._typeOfWorkspace + ":" + msg);
            return;
        }
        try {
            progress.printMessage(msg);
        }
        catch (RemoteException re) {
            System.out.println(this._typeOfWorkspace + ":" + msg);
        }
    }

    protected void setProgress(RemoteWrapper uiWrapper, int progress) {
        RmiProgress rmiprogress = this.getRmiProgress(uiWrapper);
        if (rmiprogress == null) {
            System.out.println(this._typeOfWorkspace + ":%" + progress);
            return;
        }
        try {
            rmiprogress.setProgress(progress);
        }
        catch (RemoteException re) {
            System.out.println(this._typeOfWorkspace + ":%" + progress);
        }
    }

    protected void setTaskNumber(RemoteWrapper uiWrapper, int taskNum) {
        RmiProgress rmiprogress = this.getRmiProgress(uiWrapper);
        if (rmiprogress == null) {
            System.out.println(this._typeOfWorkspace + ":%" + taskNum);
            return;
        }
        try {
            rmiprogress.setTaskNumber(taskNum);
        }
        catch (RemoteException re) {
            System.out.println(this._typeOfWorkspace + ":%" + taskNum);
        }
    }

    protected void printWarningMessage(RemoteWrapper uiWrapper, String msg) {
        RmiProgress progress = this.getRmiProgress(uiWrapper);
        if (progress == null) {
            System.out.println(this._typeOfWorkspace + " WARNING:" + msg);
            return;
        }
        try {
            progress.printWarningMessage(msg);
        }
        catch (RemoteException re) {
            System.out.println(this._typeOfWorkspace + " WARNING:" + msg);
        }
    }

    protected void printErrorMessage(RemoteWrapper uiWrapper, String msg) {
        RmiProgress progress = this.getRmiProgress(uiWrapper);
        if (progress == null) {
            System.out.println(this._typeOfWorkspace + " ERROR:" + msg);
            return;
        }
        try {
            progress.printErrorMessage(msg);
        }
        catch (RemoteException re) {
            System.out.println(this._typeOfWorkspace + " ERROR:" + msg);
        }
    }

    protected RmiProgress getRmiProgress(RemoteWrapper uiWrapper) {
        if (uiWrapper == null || uiWrapper.getRemote() == null || !(uiWrapper.getRemote() instanceof RmiProgress)) {
            System.out.println(this._typeOfWorkspace + "getRmiProgress: ERROR can't get RmiProgress. RemoteWrapper holds wrong object or null");
            return null;
        }
        return (RmiProgress)uiWrapper.getRemote();
    }

    protected void removeComputeCanceler(RemoteWrapper uiWrapper, RMIComputeCanceledCallbackImpl computeCanceler) {
        if (computeCanceler == null) {
            return;
        }
        RmiProgress progress = this.getRmiProgress(uiWrapper);
        if (progress == null) {
            return;
        }
        try {
            progress.setComputeCanceledCallback(null);
        }
        catch (RemoteException re) {
            System.out.println("removeComputeCanceler: RMI Error removing compute canceler " + re);
        }
    }

    protected void setCanceledComputeHasCompleted(RemoteWrapper uiWrapper) {
        RmiProgress progress = this.getRmiProgress(uiWrapper);
        if (progress == null) {
            System.out.println("setCanceledComputeHasCompleted:failed to find RmiProgress to setCanceledComputeHasFinished.");
            return;
        }
        try {
            progress.setCanceledComputeFinished(true);
        }
        catch (RemoteException re) {
            System.out.println(this._typeOfWorkspace + " RMI ERROR setting computecallback " + re);
            return;
        }
    }

    protected RMIComputeCanceledCallbackImpl setComputeCanceler(RemoteWrapper uiWrapper, ComputeCanceledCallback mgr) {
        Object retval = null;
        RmiProgress progress = this.getRmiProgress(uiWrapper);
        return this.setComputeCanceler(progress, mgr);
    }

    public RMIComputeCanceledCallbackImpl setComputeCanceler(RmiProgress progress, ComputeCanceledCallback mgr) {
        RMIComputeCanceledCallbackImpl retval = null;
        if (progress != null) {
            try {
                RMIComputeCanceledCallbackImpl computeCanceler = new RMIComputeCanceledCallbackImpl(mgr);
                if (this.getNetworked()) {
                    computeCanceler.exportServer();
                }
                try {
                    progress.setComputeCanceledCallback((RMIComputeCanceledCallback)computeCanceler);
                    retval = computeCanceler;
                }
                catch (RemoteException re) {
                    System.out.println(this._typeOfWorkspace + " RMI ERROR setting computecallback " + re);
                }
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
        return retval;
    }

    protected void printLogMessage(RemoteWrapper uiWrapper, String msg) {
        RmiProgress progress = this.getRmiProgress(uiWrapper);
        if (progress == null) {
            System.out.println(this._typeOfWorkspace + " LOG:" + msg);
            return;
        }
        try {
            progress.printLogMessage(msg);
        }
        catch (RemoteException re) {
            System.out.println(this._typeOfWorkspace + " LOG:" + msg);
        }
    }

    protected void printStatus(RemoteWrapper uiWrapper, String msg) {
        RmiProgress progress = this.getRmiProgress(uiWrapper);
        if (progress == null) {
            System.out.println(this._typeOfWorkspace + " STATUS:" + msg);
            return;
        }
        try {
            progress.printStatus(msg);
        }
        catch (RemoteException re) {
            System.out.println(this._typeOfWorkspace + " STATUS:" + msg);
        }
    }

    @Override
    public AltItem copyModelAltTo(String modelName, String className, String copyToWkspPath, AltItem altItem, String modelId) throws IllegalArgumentException, RemoteException {
        return this._parentWorkspace.copyModelAltTo(modelName, className, copyToWkspPath, altItem, modelId);
    }

    @Override
    public RmiWorkspace openWorkspace(Identifier id, String remoteRegistry) throws RemoteException {
        RmiApp app = this.getRmiApp();
        if (app == null) {
            System.out.println("openWorkspace: failed to get RmiApp");
            return null;
        }
        String user = UserId.getUserId();
        RmiWorkspace wksp = app.openWorkspace(user, id, remoteRegistry, null);
        if (wksp instanceof HecRmiWorkspace) {
            HecRmiWorkspace hecwksp = (HecRmiWorkspace)((Object)wksp);
            if (this._parentWorkspace == null) {
                hecwksp.setBaseWorkspace(this);
            } else {
                hecwksp.setBaseWorkspace(this._parentWorkspace);
            }
        }
        return wksp;
    }

    @Override
    public RmiWorkspace newWorkspace(Identifier id, String baseDir) throws RemoteException {
        RmiApp app = this.getRmiApp();
        if (app == null) {
            System.out.println("newWorkspace: failed to get RmiApp");
            return null;
        }
        String user = UserId.getUserId();
        RmiWorkspace wksp = app.newWorkspace(user, id, baseDir, this.getUnitSystem(), this.getGmtOffset());
        if (wksp instanceof HecRmiWorkspace) {
            HecRmiWorkspace hecwksp = (HecRmiWorkspace)((Object)wksp);
            if (this._parentWorkspace == null) {
                hecwksp.setBaseWorkspace(this);
            } else {
                hecwksp.setBaseWorkspace(this._parentWorkspace);
            }
        }
        return wksp;
    }

    @Override
    public String getWorkspaceFile() {
        return this.identifier.getPath();
    }

    public boolean unlockFile(Identifier id, FileLock flock) {
        try {
            RmiFileManager rfm = this.getFileManager();
            return rfm.unlockFile(id, flock);
        }
        catch (RemoteException re) {
            System.out.println("unlockFile: RMI Error unlocking file " + re);
            return false;
        }
    }

    public boolean lockFile(Identifier id, FileLock flock) {
        try {
            RmiFileManager rfm = this.getFileManager();
            return rfm.lockFile(id, flock);
        }
        catch (RemoteException re) {
            System.out.println("lockFile: RMI Error unlocking file " + re);
            return false;
        }
    }

    public List getDriveList() {
        try {
            RmiFileManager rfm = this.getFileManager();
            return rfm.getRemoteDriveIDList(UserId.getUserId());
        }
        catch (RemoteException re) {
            System.out.println("getDriveList: RMI Error getting drive list " + re);
            return null;
        }
    }

    public void setAclFilename(String fileName) {
        if (this._parentWorkspace != null) {
            this._parentWorkspace.setAclFilename(fileName);
        }
    }

    @Override
    public void addWorkspaceMapping(String wkspName, String wkspClass) {
        if (wkspName == null || wkspClass == null) {
            return;
        }
        String stdWkspName = WorkspaceNameFactory.getWorkspaceName((String)wkspName);
        _childWorkspaceClasses.put(stdWkspName, wkspClass);
    }

    @Override
    public ExportResults export(WkspExportOptions options) {
        RmiFileManager fm;
        ExportResults results = new ExportResults();
        if (options == null) {
            results.setSuccessful(false);
            results.addMessage("No Export Options supplied");
            return results;
        }
        try {
            fm = this.getFileManager();
        }
        catch (RemoteException e) {
            System.out.println("export:failed to get FileManager " + e);
            e.printStackTrace();
            results.addMessage("Failed to get RmiFileManager " + e);
            results.setSuccessful(false);
            return results;
        }
        if (!this.saveWkspDir(this._typeOfWorkspace, options.getWkspDirectory(), fm)) {
            results.setSuccessful(false);
            results.addMessage("Failed to copy subdirectory " + this.getTitleName());
            return results;
        }
        results.setSuccessful(true);
        return results;
    }

    protected boolean saveWkspDir(String subDir, String newDirectory, RmiFileManager fm) {
        String wkspPath = this.getWorkspacePath();
        String ourSubDir = wkspPath + "/" + subDir;
        String newSubDir = newDirectory + "/" + subDir;
        Identifier ourId = new Identifier(ourSubDir);
        Identifier newId = new Identifier(newSubDir);
        try {
            if (!fm.fileExists(ourId)) {
                System.out.println("saveWkspDir: directory " + ourSubDir + " doesn't exist");
                return true;
            }
            if (!fm.copyDirectory(ourId, newId)) {
                System.out.println("saveWkspDir:***** Failed to copy directory " + ourSubDir + " to " + newSubDir);
                return false;
            }
        }
        catch (RemoteException e) {
            System.out.println("saveWkspDir:******** Exception copying study directory " + e);
            return false;
        }
        return true;
    }

    public int getNextPortOffset() {
        return 50;
    }

    @Override
    public String getStreamAlignmentUnits() {
        if (this._parentWorkspace != null) {
            return this._parentWorkspace.getStreamAlignmentUnits();
        }
        return null;
    }

    @Override
    public void setStreamAlignmentUnits(String units) {
        if (this._parentWorkspace != null) {
            this._parentWorkspace.setStreamAlignmentUnits(units);
        }
    }

    @Override
    public String getWorkspaceVersion() {
        if (this._parentWorkspace != null) {
            return this._parentWorkspace.getWorkspaceVersion();
        }
        return null;
    }

    static {
        RmiWorkspaceImpl.addChildWorkspaceMapping("cavi", "wcds.cavi.server.CaviRmiWorkspaceImpl");
        RmiWorkspaceImpl.addChildWorkspaceMapping("rss", "hec.rss.server.RssRmiWorkspaceImpl");
        RmiWorkspaceImpl.addChildWorkspaceMapping("ras", "hec.ras.server.RasRmiWorkspaceImpl");
        RmiWorkspaceImpl.addChildWorkspaceMapping("fia", "hec.fia.server.FiaRmiWorkspaceImpl");
        RmiWorkspaceImpl.addChildWorkspaceMapping("dssmapgui", "hec.dssmapgui.server.HecDssMapVueRmiWorkspaceImpl");
        RmiWorkspaceImpl.addChildWorkspaceMapping("gridUtil", "hec.gridUtil.server.GridUtilRmiWorkspaceImpl");
        RmiWorkspaceImpl.addChildWorkspaceMapping("supplemental", "hec.rss.supplemental.server.SupplementalRmiWorkspaceImpl");
        RmiWorkspaceImpl.addChildWorkspaceMapping("greatlakes", "hec.glm.server.GlmRmiWorkspaceImpl");
        RmiWorkspaceImpl.addChildWorkspaceMapping("resprm", "hec.resprm.server.ResPrmRmiWorkspaceImpl");
        MAPS_DIR_TEMPLATE = new MessageFormat("{0}/maps");
    }
}

