/*
 * Decompiled with CFR 0.152.
 */
package hec.clientapp.supplemental.client;

import hec.clientapp.client.ClientApp;
import hec.clientapp.supplemental.SupplementalRmiWorkspace;
import hec.io.Identifier;
import hec.supplemental.model.ProgramOrderItem;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.rmi.RemoteException;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import mil.army.usace.hec.rmi.client.RmiFileDialog;
import rma.swing.ButtonCmdPanel;
import rma.swing.ButtonCmdPanelListener;
import rma.swing.RmaInsets;
import rma.swing.RmaJDialog;
import rma.swing.RmaJTextArea;
import rma.swing.RmaJTextField;
import rma.util.RMAIO;

public class DefineSupplementalModelDialog
extends RmaJDialog {
    private RmaJTextField modelName;
    private RmaJTextArea modelDescription;
    private RmaJTextField modelScript;
    private ButtonCmdPanel cmdPanel;
    private boolean _isCanceled = false;
    Vector _models;

    public DefineSupplementalModelDialog(JDialog parent, boolean modal) {
        super((Dialog)parent, modal);
        this.getContentPane().setLayout(new GridBagLayout());
        this.setSize(400, 200);
        this.setLocation();
        this.setTitle("Define Supplemental Program");
        JLabel label = new JLabel("Name:");
        label.setDisplayedMnemonic('n');
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.fill = 0;
        gbc.anchor = 18;
        gbc.insets = RmaInsets.insets((int)10, (int)5, (int)0, (int)0);
        this.getContentPane().add((Component)label, gbc);
        this.modelName = new RmaJTextField();
        label.setLabelFor((Component)this.modelName);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.gridwidth = 2;
        gbc.fill = 2;
        gbc.anchor = 18;
        gbc.insets = RmaInsets.insets((int)10, (int)5, (int)0, (int)10);
        gbc.weightx = 1.0;
        this.getContentPane().add((Component)this.modelName, gbc);
        label = new JLabel("Description:");
        label.setDisplayedMnemonic('d');
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.fill = 0;
        gbc.anchor = 18;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)0);
        this.getContentPane().add((Component)label, gbc);
        this.modelDescription = new RmaJTextArea();
        label.setLabelFor((Component)this.modelDescription);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.gridwidth = 2;
        gbc.fill = 1;
        gbc.anchor = 18;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)10);
        gbc.weightx = 1.0;
        gbc.weighty = 3.0;
        this.getContentPane().add((Component)new JScrollPane((Component)this.modelDescription), gbc);
        label = new JLabel("Executable:");
        label.setDisplayedMnemonic('e');
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.fill = 0;
        gbc.anchor = 18;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)0);
        this.getContentPane().add((Component)label, gbc);
        this.modelScript = new RmaJTextField();
        label.setLabelFor((Component)this.modelScript);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 2;
        gbc.fill = 2;
        gbc.anchor = 18;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)10);
        gbc.weightx = 1.0;
        this.getContentPane().add((Component)this.modelScript, gbc);
        JButton browseButton = new JButton("Browse");
        browseButton.setMnemonic('b');
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 2;
        gbc.fill = 0;
        gbc.anchor = 18;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)10);
        this.getContentPane().add((Component)browseButton, gbc);
        this.cmdPanel = new ButtonCmdPanel(12);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.fill = 2;
        gbc.gridwidth = 3;
        gbc.anchor = 14;
        gbc.insets = RmaInsets.insets((int)5, (int)0, (int)10, (int)10);
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        this.getContentPane().add((Component)this.cmdPanel, gbc);
        this.cmdPanel.addCmdPanelListener(new ButtonCmdPanelListener(){

            public void buttonCmdActionPerformed(ActionEvent e) {
                if (e.getID() == 8) {
                    DefineSupplementalModelDialog.this.okAction();
                } else if (e.getID() == 4) {
                    DefineSupplementalModelDialog.this.cancelAction();
                }
            }
        });
        browseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DefineSupplementalModelDialog.this.browseAction();
            }
        });
        this.registerEnterKey(true);
        this.registerEscapeKey(true);
    }

    public void okAction() {
        Object msg = null;
        RmaJTextField c = null;
        if (this.modelName.getText().length() < 1) {
            msg = "Name cannot be empty";
            c = this.modelName;
        } else if (this.modelScript.getText().length() < 1) {
            msg = "Script cannot be empty";
            c = this.modelScript;
        } else if (this._models != null && this._models.contains(this.getModel())) {
            msg = "Duplicate model. " + this.modelName.getText() + " already defined.";
            c = this.modelName;
        }
        if (msg != null) {
            JOptionPane.showMessageDialog((Component)((Object)this), msg);
            c.requestFocus();
            return;
        }
        this.setVisible(false);
        this._isCanceled = false;
    }

    public void cancelAction() {
        this.setVisible(false);
        this._isCanceled = true;
    }

    public boolean isCanceled() {
        return this._isCanceled;
    }

    public ProgramOrderItem getModel() {
        ProgramOrderItem poi = new ProgramOrderItem(this.modelName.getText(), false);
        poi.setDescription(this.modelDescription.getText());
        poi.setScript(this.modelScript.getText());
        ClientApp.app();
        SupplementalRmiWorkspace smwksp = (SupplementalRmiWorkspace)ClientApp.Workspace().getChildWorkspace("supplemental");
        if (smwksp == null) {
            return null;
        }
        try {
            if (smwksp.addProgram(ClientApp.app().getAppType(), poi)) {
                ClientApp.app();
                ClientApp.Workspace().setModified(true);
                return poi;
            }
        }
        catch (RemoteException re) {
            System.out.println("getModel: RMI Error adding new model " + poi.paramString() + " Error:" + re);
            JOptionPane.showMessageDialog((Component)((Object)this), "RMI Error adding new model " + poi.paramString() + "\nError:" + re, "Error", 0);
        }
        return null;
    }

    public void setModels(Vector models) {
        this._models = models;
    }

    public void setVisible(boolean b) {
        if (b) {
            this.clearForm();
        }
        super.setVisible(b);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void browseAction() {
        RmiFileDialog chooser;
        Vector<String> v = new Vector<String>();
        v.addElement("*.*");
        try {
            this.setCursor(Cursor.getPredefinedCursor(3));
            String directory = this.modelScript.getText().length() > 0 ? RMAIO.getDirectoryFromPath((String)this.modelScript.getText()) : ClientApp.app().getAppStartDir();
            chooser = new RmiFileDialog((Dialog)((Object)this), true, directory, v);
            chooser.setOpenTitle();
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
        chooser.setVisible(true);
        if (chooser.isCanceled()) {
            return;
        }
        Identifier id = chooser.getIdentifier();
        if (id == null) {
            return;
        }
        this.modelScript.setText(id.getPath());
    }
}

