/*
 * Decompiled with CFR 0.152.
 */
package hec.clientapp.supplemental.client;

import hec.clientapp.client.ClientApp;
import hec.clientapp.supplemental.SupplementalRmiWorkspace;
import hec.supplemental.model.ProgramOrderItem;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.rmi.RemoteException;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.swing.table.TableModel;
import rma.swing.ButtonCmdPanel;
import rma.swing.ButtonCmdPanelListener;
import rma.swing.RmaInsets;
import rma.swing.RmaJDialog;
import rma.swing.RmaJTable;
import rma.swing.table.AbstractRmaTableModel;

public class DeleteSupplementProgramDialog
extends RmaJDialog {
    private RmaJTable _programTable;
    private ButtonCmdPanel _cmdPanel;
    private ProgramModel _model;
    private boolean _canceled;

    public DeleteSupplementProgramDialog(Dialog parent, boolean modal) {
        super(parent, modal);
        this.buildControls();
    }

    protected void buildControls() {
        this.setTitle("Delete Supplemental Program");
        this.getContentPane().setLayout(new GridBagLayout());
        this._model = new ProgramModel();
        this._programTable = new RmaJTable((Component)((Object)this)){

            public Dimension getPreferredScrollableViewportSize() {
                Dimension d = super.getPreferredScrollableViewportSize();
                d.height = 100;
                return d;
            }
        };
        this._programTable.setModel((TableModel)((Object)this._model));
        this._programTable.setCellSelectionEnabled(false);
        this._programTable.setColumnSelectionAllowed(false);
        this._programTable.setRowSelectionAllowed(true);
        this._programTable.setEditable(false);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.anchor = 11;
        gbc.fill = 1;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        this.getContentPane().add((Component)this._programTable.getScrollPane(), gbc);
        this._cmdPanel = new ButtonCmdPanel(12);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridwidth = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.anchor = 15;
        gbc.fill = 2;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        this.getContentPane().add((Component)this._cmdPanel, gbc);
        this._cmdPanel.addCmdPanelListener(new ButtonCmdPanelListener(){

            public void buttonCmdActionPerformed(ActionEvent e) {
                switch (e.getID()) {
                    case 8: {
                        if (!DeleteSupplementProgramDialog.this.saveForm()) break;
                        DeleteSupplementProgramDialog.this._canceled = false;
                        DeleteSupplementProgramDialog.this.setVisible(false);
                        break;
                    }
                    case 4: {
                        DeleteSupplementProgramDialog.this._canceled = true;
                        DeleteSupplementProgramDialog.this.setVisible(false);
                    }
                }
            }
        });
        this.pack();
        this.setLocation();
        this.setSize(this.getPreferredSize());
    }

    public boolean saveForm() {
        int[] rows = this._programTable.getSelectedRows();
        if (rows == null || rows.length == 0) {
            return true;
        }
        StringBuffer buf = new StringBuffer();
        buf.append("\n");
        for (int i = 0; i < rows.length; ++i) {
            buf.append("  ");
            buf.append(this._programTable.getCell(rows[i], 0));
            buf.append("\n");
        }
        int opt = JOptionPane.showConfirmDialog((Component)((Object)this), "Confirm Deletion of selected Program" + (rows.length == 1 ? "" : "s") + ":" + buf.toString() + "These programs will no longer be available to be used\nin the Program Sequence", "Confirm Deletion", 0);
        if (opt == 1) {
            return false;
        }
        ClientApp.app();
        SupplementalRmiWorkspace smwksp = (SupplementalRmiWorkspace)ClientApp.Workspace().getChildWorkspace("supplemental");
        if (smwksp == null) {
            System.out.println("saveForm: Failed to get supplementalRmiWorkspace");
            return false;
        }
        String key = ClientApp.app().getAppType();
        boolean deletionMade = false;
        for (int i = 0; i < rows.length; ++i) {
            ProgramOrderItem poi = this._model.get(rows[i]);
            try {
                if (!smwksp.deleteProgram(key, poi)) continue;
                deletionMade = true;
                continue;
            }
            catch (RemoteException re) {
                System.out.println("saveForm: RMI Error deleting program " + re);
            }
        }
        if (deletionMade) {
            ClientApp.app();
            ClientApp.Workspace().setModified(true);
        }
        return true;
    }

    public boolean fillForm(Vector allModels, Vector usedModels) {
        this._model.clearAll();
        for (int i = 0; i < allModels.size(); ++i) {
            ProgramOrderItem poi = (ProgramOrderItem)allModels.get(i);
            if (poi == null || usedModels.contains(poi) || poi.isStandardModel()) continue;
            this._model.add(poi);
        }
        this._model.update();
        return this._model.getRowCount() > 0;
    }

    public class ProgramModel
    extends AbstractRmaTableModel {
        Vector _programs = new Vector();

        public ProgramModel() {
            this.m_columnNames = new String[]{"Name", "Description", "Executable"};
        }

        public void add(ProgramOrderItem poi) {
            if (poi == null) {
                return;
            }
            this._programs.add(poi);
        }

        public void update() {
            this.fireTableDataChanged();
        }

        public int getRowCount() {
            return this._programs.size();
        }

        public ProgramOrderItem get(int row) {
            return (ProgramOrderItem)this._programs.get(row);
        }

        public void clearAll() {
            this._programs.clear();
            this.fireTableDataChanged();
        }

        public Object getValueAt(int row, int col) {
            if (row > this._programs.size() || row < 0) {
                return null;
            }
            ProgramOrderItem poi = (ProgramOrderItem)this._programs.get(row);
            if (poi == null) {
                return null;
            }
            switch (col) {
                case 0: {
                    return poi.getName();
                }
                case 1: {
                    return poi.getDescription();
                }
                case 2: {
                    return poi.getScript();
                }
            }
            return null;
        }

        public boolean isCellEditable(int row, int col) {
            return false;
        }
    }
}

