/*
 * Decompiled with CFR 0.152.
 */
package hec.clientapp.supplemental.client;

import hec.clientapp.client.ClientApp;
import hec.clientapp.client.ClientWorkspace;
import hec.clientapp.model.Manager;
import hec.clientapp.supplemental.SupplementalRmiWorkspace;
import hec.clientapp.supplemental.client.DefineSupplementalModelDialog;
import hec.clientapp.supplemental.client.DeleteSupplementProgramDialog;
import hec.clientapp.supplemental.client.SupplementalAltArgsJDialog;
import hec.clientapp.supplemental.model.SupplementalProgramAlt;
import hec.io.Identifier;
import hec.model.ModelConstants;
import hec.server.NameDialog;
import hec.supplemental.model.ProgramOrderItem;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.rmi.RemoteException;
import java.util.Vector;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JDialog;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import mil.army.usace.hec.rmi.client.SelectSupplementalModelDialog;
import rma.swing.RmaInsets;
import rma.swing.RmaJDialog;
import rma.swing.RmaJTable;
import rma.swing.event.ReflectMultiListener;
import rma.swing.table.RmaTableModel;
import rma.util.RMAIO;

public class ProgramOrderJDialog
extends RmaJDialog
implements ModelConstants {
    private static final int DATA_COLUMN = 1;
    private static final int INPUT_COLUMN = 2;
    private static final String NO_INPUT = "";
    RmaJTable modelOrder;
    JCheckBoxMenuItem debugMenuItem;
    JMenuItem saveMenuItem;
    JMenuItem appendMenuItem;
    JMenuItem insertMenuItem;
    JMenuItem deleteMenuItem;
    JMenuItem newAltMenuItem;
    JMenuItem editAltMenuItem;
    JMenu altSubMenu;
    DefineSupplementalModelDialog _defineDialog;
    DeleteSupplementProgramDialog _deleteDialog;
    Vector _inputList = new Vector();
    Vector _models = new Vector();

    public ProgramOrderJDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.setDefaultCloseOperation(0);
        this.setTitle("Program Sequence");
        this.getContentPane().setLayout(new GridBagLayout());
        this.setSize(300, 300);
        this.setLocation();
        Object[] headers = new String[]{" ", "Programs", "Default Input"};
        this.modelOrder = new RmaJTable((Component)((Object)this), headers){

            public String getToolTipText(MouseEvent e) {
                int row;
                ProgramOrderItem poi;
                int col;
                if (ProgramOrderJDialog.this.debugMenuItem.isSelected() && (col = ProgramOrderJDialog.this.modelOrder.columnAtPoint(e.getPoint())) == 1 && (poi = (ProgramOrderItem)ProgramOrderJDialog.this.modelOrder.getValueAt(row = ProgramOrderJDialog.this.modelOrder.rowAtPoint(e.getPoint()), col)) != null) {
                    return poi.paramString();
                }
                return super.getToolTipText(e);
            }
        };
        this.modelOrder.setComboBoxEditor(2, this._inputList).addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProgramOrderJDialog.this.setModified(true);
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                if (ProgramOrderJDialog.this.isModified()) {
                    int opt = JOptionPane.showConfirmDialog((Component)((Object)ProgramOrderJDialog.this), "Changing the Program Order once it has been set can effect existing setup.  Save Changes?", "Confirm Close", 1);
                    switch (opt) {
                        case 0: {
                            ProgramOrderJDialog.this.saveForm(false);
                            ProgramOrderJDialog.this.setVisible(false);
                            break;
                        }
                        case 1: {
                            ProgramOrderJDialog.this.setVisible(false);
                            break;
                        }
                    }
                } else {
                    ProgramOrderJDialog.this.setVisible(false);
                }
            }
        });
        this.modelOrder.setColumnEnabled(false, 1);
        this.modelOrder.setHorizontalAlignment(2, 1);
        this.modelOrder.setHorizontalAlignment(2, 2);
        this.modelOrder.setSelectionMode(0);
        this.modelOrder.setAutoRowHeaders(true, 1);
        this.modelOrder.setColumnWidth(0, -1);
        this.modelOrder.setTabToEditCell(true);
        this.modelOrder.setPopupMenuEnabled(false);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.fill = 1;
        gbc.anchor = 18;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)5, (int)5);
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        this.modelOrder.setCellSelectionEnabled(false);
        this.modelOrder.setColumnSelectionAllowed(false);
        this.modelOrder.setRowSelectionAllowed(true);
        this.getContentPane().add((Component)this.modelOrder.getScrollPane(), gbc);
        this.modelOrder.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent lse) {
                if (lse.getValueIsAdjusting()) {
                    return;
                }
                ProgramOrderJDialog.this.setComponentState();
                int row = ProgramOrderJDialog.this.modelOrder.getSelectedRow();
                if (row < 0) {
                    return;
                }
                ProgramOrderItem poi = (ProgramOrderItem)ProgramOrderJDialog.this.modelOrder.getCell(row, 1);
                boolean enabled = true;
                if (poi == null) {
                    enabled = false;
                }
                ProgramOrderJDialog.this.deleteMenuItem.setEnabled(enabled);
                ProgramOrderJDialog.this.appendMenuItem.setEnabled(enabled);
                ProgramOrderJDialog.this.altSubMenu.setEnabled(!poi.isStandardModel());
            }
        });
        ReflectMultiListener _listener = new ReflectMultiListener();
        JMenuBar mb = new JMenuBar();
        JMenu menu = new JMenu("Programs");
        menu.setMnemonic('p');
        JMenuItem menuItem = new JMenuItem("Define", 100);
        menuItem.addActionListener((ActionListener)_listener.add((Object)this, (Object)menuItem, "defineModel"));
        menu.add(menuItem);
        menuItem = new JMenuItem("Delete", 101);
        menuItem.addActionListener((ActionListener)_listener.add((Object)this, (Object)menuItem, "deleteModel"));
        menu.add(menuItem);
        this.saveMenuItem = new JMenuItem("Save", 115);
        this.saveMenuItem.setEnabled(false);
        this.saveMenuItem.addActionListener((ActionListener)_listener.add((Object)this, (Object)this.saveMenuItem, "saveForm"));
        menu.add(this.saveMenuItem);
        menu.addSeparator();
        menuItem = new JMenuItem("Close", 99);
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ProgramOrderJDialog.this.isModified()) {
                    int opt = JOptionPane.showConfirmDialog((Component)((Object)ProgramOrderJDialog.this), "Save Changes?", "Confirm close", 1);
                    switch (opt) {
                        case 0: {
                            ProgramOrderJDialog.this.saveForm(true);
                            ProgramOrderJDialog.this.setVisible(false);
                            break;
                        }
                        case 1: {
                            ProgramOrderJDialog.this.setVisible(false);
                        }
                    }
                } else {
                    ProgramOrderJDialog.this.setVisible(false);
                }
            }
        });
        menu.add(menuItem);
        mb.add(menu);
        menu = new JMenu("Edit");
        menu.setMnemonic('E');
        this.insertMenuItem = new JMenuItem("Insert Before", 73);
        this.insertMenuItem.addActionListener((ActionListener)_listener.add((Object)this, (Object)this.insertMenuItem, "insertModel"));
        menu.add(this.insertMenuItem);
        this.appendMenuItem = new JMenuItem("Insert After", 65);
        this.appendMenuItem.setEnabled(false);
        this.appendMenuItem.addActionListener((ActionListener)_listener.add((Object)this, (Object)this.appendMenuItem, "appendModel"));
        menu.add(this.appendMenuItem);
        menu.addSeparator();
        this.deleteMenuItem = new JMenuItem("Remove Program", 82);
        this.deleteMenuItem.setEnabled(false);
        this.deleteMenuItem.addActionListener((ActionListener)_listener.add((Object)this, (Object)this.deleteMenuItem, "removeModelFromList"));
        menu.add(this.deleteMenuItem);
        this.altSubMenu = new JMenu("Alternative");
        this.altSubMenu.setMnemonic('A');
        this.altSubMenu.setEnabled(false);
        menu.add(this.altSubMenu);
        this.newAltMenuItem = new JMenuItem("New", 78);
        this.newAltMenuItem.addActionListener((ActionListener)_listener.add((Object)this, (Object)this.newAltMenuItem, "newAlternative"));
        this.altSubMenu.add(this.newAltMenuItem);
        this.editAltMenuItem = new JMenuItem("Edit", 69);
        this.editAltMenuItem.addActionListener((ActionListener)_listener.add((Object)this, (Object)this.editAltMenuItem, "editAlternatives"));
        this.altSubMenu.add(this.editAltMenuItem);
        mb.add(menu);
        this.debugMenuItem = new JCheckBoxMenuItem("Debug");
        this.debugMenuItem.setVisible(false);
        this.debugMenuItem.setAccelerator(KeyStroke.getKeyStroke(68, 2, false));
        this.altSubMenu.add(this.debugMenuItem);
        this.setJMenuBar(mb);
    }

    public void defineModel() {
        if (this._defineDialog == null) {
            this._defineDialog = new DefineSupplementalModelDialog((JDialog)((Object)this), true);
        }
        Vector<Object> v = new Vector<Object>();
        int rows = this.modelOrder.getNumRows();
        for (int i = 0; i < rows; ++i) {
            v.addElement(this.modelOrder.getCell(i, 1));
        }
        this._defineDialog.setModels(v);
        this._defineDialog.setVisible(true);
        this.repaint();
        if (this._defineDialog.isCanceled()) {
            return;
        }
        ProgramOrderItem moi = this._defineDialog.getModel();
        if (moi == null) {
            return;
        }
        ClientApp.app();
        SupplementalRmiWorkspace smWksp = (SupplementalRmiWorkspace)ClientApp.Workspace().getChildWorkspace("supplemental");
        if (smWksp == null) {
            return;
        }
        try {
            moi.setIndex(smWksp.getNextModelIndex(ClientApp.app().getAppType()));
        }
        catch (RemoteException re) {
            System.out.println("defineModel: RMI Error getting next model index from RmiWorkspace " + re);
            return;
        }
        this._models.add(moi);
    }

    public void appendModel() {
        int row = this.modelOrder.getSelectedRow();
        if (row < 0) {
            return;
        }
        ProgramOrderItem moi = this.getUserSelectedModel();
        if (moi == null) {
            return;
        }
        Vector<String> v = new Vector<String>(2);
        v.addElement(NO_INPUT);
        v.addElement((String)moi);
        v.addElement(NO_INPUT);
        ((RmaTableModel)this.modelOrder.getModel()).insertRow(row + 1, v);
        this.setModified(true);
        this.reorderModels();
        this.setComponentState();
        this.setInputList();
        this.setInputModels();
    }

    public void insertModel() {
        ProgramOrderItem moi;
        int row = this.modelOrder.getSelectedRow();
        if (row < 0) {
            row = 0;
        }
        if ((moi = this.getUserSelectedModel()) == null) {
            return;
        }
        Vector<String> v = new Vector<String>(3);
        v.addElement(NO_INPUT);
        v.addElement((String)moi);
        v.addElement(NO_INPUT);
        ((RmaTableModel)this.modelOrder.getModel()).insertRow(row, v);
        this.setModified(true);
        this.reorderModels();
        this.setComponentState();
        this.setInputList();
        this.setInputModels();
    }

    protected ProgramOrderItem getUserSelectedModel() {
        SelectSupplementalModelDialog selectDialog = new SelectSupplementalModelDialog((JDialog)((Object)this), true);
        ClientApp.app();
        SupplementalRmiWorkspace smWksp = (SupplementalRmiWorkspace)ClientApp.Workspace().getChildWorkspace("supplemental");
        if (smWksp == null) {
            return null;
        }
        try {
            Vector models = smWksp.getAllPrograms(ClientApp.app().getAppType());
            selectDialog.fillForm(models);
        }
        catch (RemoteException re) {
            System.out.println("getUserSelectedModel: rmi Error getting list of models " + re);
        }
        selectDialog.setVisible(true);
        this.repaint();
        if (selectDialog.isCanceled()) {
            return null;
        }
        ProgramOrderItem poi = selectDialog.getModel();
        int size = this.modelOrder.getRowCount();
        for (int i = 0; i < size; ++i) {
            ProgramOrderItem p = (ProgramOrderItem)this.modelOrder.getCell(i, 1);
            if (!poi.equals(p)) continue;
            try {
                int idx = smWksp.getNextModelIndex(ClientApp.app().getAppType());
                poi = new ProgramOrderItem(poi);
                poi.setIndex(idx);
                poi.setInputModelNumber(-1);
                break;
            }
            catch (RemoteException re) {
                System.out.println("getUserSelectedModel: RMI Error getting next model index  from RmiWorkspace " + re);
                return null;
            }
        }
        return poi;
    }

    public void removeModelFromList() {
        int opt;
        int row = this.modelOrder.getSelectedRow();
        if (row < 0) {
            return;
        }
        Vector v = this.modelOrder.getRow(row);
        if (v == null || v.size() < 2) {
            return;
        }
        ProgramOrderItem moi = (ProgramOrderItem)v.elementAt(1);
        if (moi == null) {
            return;
        }
        String name = moi.getName();
        if ("RSS".equals(name)) {
            name = "ResSim";
        }
        if ((opt = JOptionPane.showConfirmDialog((Component)((Object)this), "Ok to remove " + name + " from program list?", "Confirm Removal", 0)) == 1) {
            return;
        }
        ((RmaTableModel)this.modelOrder.getModel()).deleteRow(row);
        this.reorderModels();
        this.setComponentState();
        this.setInputList();
        this.setInputModels();
        this.setModified(true);
    }

    void reorderModels() {
        for (int i = 0; i < this.modelOrder.getRowCount(); ++i) {
            ProgramOrderItem poi = (ProgramOrderItem)this.modelOrder.getValueAt(i, 1);
            poi.setIndex(i + 1);
        }
    }

    public boolean saveForm() {
        return this.saveForm(true);
    }

    public boolean saveForm(boolean confirmSave) {
        int opt;
        if (confirmSave && (opt = JOptionPane.showConfirmDialog((Component)((Object)this), "Changing the Program Order once it has been set\ncan effect existing setup. Continue?", "Confirm Save", 0)) == 1) {
            return true;
        }
        this.modelOrder.commitEdit(true);
        ClientApp.app();
        SupplementalRmiWorkspace smWksp = (SupplementalRmiWorkspace)ClientApp.Workspace().getChildWorkspace("supplemental");
        if (smWksp == null) {
            return false;
        }
        try {
            Vector<ProgramOrderItem> models = new Vector<ProgramOrderItem>();
            int rows = this.modelOrder.getNumRows();
            Vector listOrder = new Vector(rows);
            for (int i = 0; i < rows; ++i) {
                ProgramOrderItem inputPoi;
                String inputStr = this.modelOrder.getCell(i, 2).toString();
                int inputNum = inputStr == null || inputStr.length() == 0 || inputStr.equals(NO_INPUT) ? -1 : ((inputPoi = this.getInputProgramOrderItem((String)this.modelOrder.getCell(i, 2))) == null ? -1 : inputPoi.getIndex());
                if (inputStr.trim().length() > 0 && inputNum - 1 > i) {
                    System.out.println("saveForm: input position " + inputStr + " is before model Position " + this.modelOrder.getCell(i, 1) + " pos=" + i);
                    JOptionPane.showMessageDialog((Component)((Object)this), "Input position(" + inputStr + ") cannot be before model position (" + this.modelOrder.getCell(i, 1) + ")");
                    this.modelOrder.updateSelection(i, 0, false, false);
                    return false;
                }
                ProgramOrderItem poi = (ProgramOrderItem)this.modelOrder.getCell(i, 1);
                poi.setInputModelNumber(inputNum);
                models.addElement(poi);
            }
            if (!smWksp.setModels(models, ClientApp.app().getAppType(), ClientApp.app().getUser())) {
                System.out.println("saveForm:Failed to update Model order in workspace");
                JOptionPane.showMessageDialog((Component)((Object)this), "Failed to update Model order in workspace");
                return false;
            }
            ClientApp.app();
            ClientApp.Workspace().setModified(true);
            this.setModified(false);
        }
        catch (RemoteException re) {
            System.out.println("defineModel: rmi Error adding model " + re);
            return false;
        }
        return true;
    }

    public void fillForm(Vector models) {
        int size = models.size();
        this.modelOrder.setNumRows(size);
        this._models.clear();
        this._models.addAll(models);
        for (int i = 0; i < size; ++i) {
            this.modelOrder.setCell(models.elementAt(i), i, 1);
        }
        this.setInputList();
        this.setInputModels();
        this.setModified(false);
    }

    public void setModified(boolean b) {
        this.saveMenuItem.setEnabled(b);
        super.setModified(b);
    }

    private void setComponentState() {
        int row = this.modelOrder.getSelectedRow();
        ProgramOrderItem moi = null;
        if (row > -1) {
            moi = (ProgramOrderItem)this.modelOrder.getCell(row, 1);
        }
        boolean enabled = false;
        enabled = moi != null;
        this.deleteMenuItem.setEnabled(enabled);
        this.appendMenuItem.setEnabled(enabled);
    }

    private ProgramOrderItem getInputProgramOrderItem(String inputCellString) {
        if (inputCellString == null) {
            return null;
        }
        int num = RMAIO.parseInt((String)RMAIO.getType((String)inputCellString, (String)" "));
        String name = RMAIO.getParam((String)inputCellString, (String)" ");
        if (name.equals("ResSim")) {
            name = "RSS";
        } else if (name.equals("HMS")) {
            name = "HFP";
        }
        ProgramOrderItem poi = (ProgramOrderItem)this.modelOrder.getCell(num - 1, 1);
        if (poi != null && poi.getName().equals(name)) {
            return poi;
        }
        return null;
    }

    private void setInputList() {
        int i;
        this._inputList.removeAllElements();
        int rows = this.modelOrder.getNumRows();
        for (i = 0; i < rows; ++i) {
            ProgramOrderItem poi = (ProgramOrderItem)this.modelOrder.getCell(i, 1);
            this._inputList.addElement(i + 1 + " " + poi.toString());
        }
        this._inputList.addElement(NO_INPUT);
        for (i = 0; i < rows; ++i) {
            this.modelOrder.setCell((Object)NO_INPUT, i, 2);
        }
    }

    private void setInputModels() {
        int rows = this.modelOrder.getNumRows();
        int size = this._inputList.size();
        block0: for (int i = 1; i < rows; ++i) {
            ProgramOrderItem poi = (ProgramOrderItem)this.modelOrder.getCell(i, 1);
            int inputNum = poi.getInputModelNumber();
            if (inputNum == -1) {
                this.modelOrder.setCell((Object)NO_INPUT, i, 2);
                continue;
            }
            if (inputNum <= -1) continue;
            for (int ii = 0; ii < size; ++ii) {
                ProgramOrderItem inputPoi = (ProgramOrderItem)this.modelOrder.getCell(ii, 1);
                if (inputPoi == null || inputPoi.getIndex() != inputNum) continue;
                this.modelOrder.setCell((Object)(ii + 1 + " " + inputPoi.toString()), i, 2);
                continue block0;
            }
        }
    }

    public void newAlternative() {
        int row = this.modelOrder.getSelectedRow();
        if (row == -1) {
            return;
        }
        ClientApp.app();
        ClientWorkspace wksp = ClientApp.Workspace();
        ProgramOrderItem poi = (ProgramOrderItem)this.modelOrder.getCell(row, 1);
        String supModName = poi.getName();
        Vector<Identifier> idlist = wksp.getManagerIDList("supplemental", "hec.clientapp.supplemental.model.SupplementalProgramAlt");
        Identifier newid = this.getUserSpecifiedName("Alternative for " + supModName, idlist, NO_INPUT);
        this.repaint();
        if (newid == null) {
            return;
        }
        String name = newid.getName();
        if (name == null || name.length() == 0) {
            return;
        }
        Identifier id = wksp.getManagerIdentifier("supplemental", "hec.clientapp.supplemental.model.SupplementalProgramAlt", name, "salt");
        id.setDescription(newid.getDescription());
        Manager newmanager = wksp.newManager("supplemental", "hec.clientapp.supplemental.model.SupplementalProgramAlt");
        ((SupplementalProgramAlt)newmanager).setProgramIndex(poi.getIndex());
        ((SupplementalProgramAlt)newmanager).setProgramName(poi.getName());
        boolean success = wksp.saveManagerAs("supplemental", newmanager, id);
        if (!success) {
            JOptionPane.showMessageDialog((Component)((Object)this), "Unable to save Alternative " + name, "Error", 0);
        }
    }

    protected Identifier getUserSpecifiedName(String typename, Vector idlist, String defaultname) {
        Object object;
        NameDialog namedlg = new NameDialog((Dialog)((Object)this), true);
        String workspaceName = NO_INPUT;
        ClientApp.app();
        if (ClientApp.Workspace() != null) {
            ClientApp.app();
            object = ClientApp.Workspace().getTitleName() + " - ";
        } else {
            object = NO_INPUT;
        }
        workspaceName = object;
        namedlg.setTitle(workspaceName + "Create a New " + typename);
        namedlg.setNameLabel("Name:");
        if (defaultname != null) {
            namedlg.setName(defaultname);
        }
        namedlg.setLocation();
        String name = NO_INPUT;
        String descr = NO_INPUT;
        boolean done = false;
        block0: while (!done) {
            namedlg.setVisible(true);
            if (namedlg.isCanceled()) {
                return null;
            }
            name = namedlg.getName().trim();
            descr = namedlg.getDescription().trim();
            if (name.length() == 0) {
                return null;
            }
            done = true;
            for (int i = 0; i < idlist.size(); ++i) {
                Identifier id = (Identifier)idlist.elementAt(i);
                if (!name.equalsIgnoreCase(id.getName())) continue;
                JOptionPane.showMessageDialog((Component)((Object)this), name + " is used by another " + typename + ", enter a unique name.", "Name Conflict", 0);
                done = false;
                continue block0;
            }
        }
        namedlg.dispose();
        Identifier newid = new Identifier();
        newid.setName(name);
        newid.setDescription(descr);
        return newid;
    }

    public void editAlternatives() {
        ClientApp.app();
        ClientWorkspace wksp = ClientApp.Workspace();
        int row = this.modelOrder.getSelectedRow();
        if (row == -1) {
            return;
        }
        ProgramOrderItem poi = (ProgramOrderItem)this.modelOrder.getCell(row, 1);
        String supModName = poi.getName();
        Vector<Identifier> idlist = wksp.getManagerIDList("supplemental", "hec.clientapp.supplemental.model.SupplementalProgramAlt");
        Vector<SupplementalProgramAlt> mgrList = new Vector<SupplementalProgramAlt>(idlist.size());
        for (int i = 0; i < idlist.size(); ++i) {
            SupplementalProgramAlt alt;
            Identifier id = idlist.get(i);
            if (id.getPath().startsWith("_") || (alt = (SupplementalProgramAlt)wksp.openManager("supplemental", id)) == null) continue;
            mgrList.add(alt);
        }
        SupplementalAltArgsJDialog dialog = new SupplementalAltArgsJDialog((Dialog)((Object)this), true);
        dialog.setProgramOrderItem(poi);
        dialog.setAlternativeList(supModName, mgrList);
        dialog.setVisible(true);
        if (dialog.programOrderItemChanged()) {
            ClientApp.app();
            SupplementalRmiWorkspace smWksp = (SupplementalRmiWorkspace)ClientApp.Workspace().getChildWorkspace("supplemental");
            if (smWksp != null) {
                try {
                    if (smWksp.updateProgram(poi)) {
                        ClientApp.Workspace().setModified(true);
                    }
                }
                catch (RemoteException e) {
                    System.out.println("editAlternatives:error updating ProgramOrderItem " + e);
                }
            }
        }
        this.repaint();
        for (int i = 0; i < mgrList.size(); ++i) {
            wksp.unloadManager("supplemental", ((Manager)((Object)mgrList.get(i))).getIdentifier());
        }
    }

    void deleteModel() {
        if (this._deleteDialog == null) {
            this._deleteDialog = new DeleteSupplementProgramDialog((Dialog)((Object)this), this.isModal());
        }
        Vector<Object> usedModels = new Vector<Object>();
        ClientApp.app();
        SupplementalRmiWorkspace smwksp = (SupplementalRmiWorkspace)ClientApp.Workspace().getChildWorkspace("supplemental");
        String key = ClientApp.app().getAppType();
        try {
            Vector allModels = smwksp.getAllPrograms(key);
            for (int i = 0; i < this.modelOrder.getRowCount(); ++i) {
                usedModels.add(this.modelOrder.getCell(i, 1));
            }
            if (!this._deleteDialog.fillForm(allModels, usedModels)) {
                JOptionPane.showMessageDialog((Component)((Object)this), "There are no programs that are currently available to be deleted", "Information", 1);
                return;
            }
        }
        catch (RemoteException re) {
            System.out.println("deleteModel: RMI error with workspace " + re);
            JOptionPane.showMessageDialog((Component)((Object)this), "Communications Error with workspace", "Error", 0);
            return;
        }
        this._deleteDialog.setVisible(true);
    }
}

