/*
 * Decompiled with CFR 0.152.
 */
package hec.clientapp.supplemental.client;

import hec.clientapp.supplemental.model.SupplementalProgramAlt;
import hec.supplemental.model.ProgramOrderItem;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import mil.army.usace.hec.rmi.client.RmiFileChooserField;
import rma.swing.ButtonCmdPanel;
import rma.swing.ButtonCmdPanelListener;
import rma.swing.RmaInsets;
import rma.swing.RmaJDescriptionField;
import rma.swing.RmaJDialog;
import rma.swing.RmaJTable;
import rma.swing.RmaJTextArea;
import rma.swing.RmaJTextField;

public class SupplementalAltArgsJDialog
extends RmaJDialog {
    private SupplementalProgramAlt _alt;
    private boolean _canceled = false;
    private RmaJTextField nameTxt;
    private RmaJTextField programTxt;
    private RmiFileChooserField programToRunFld;
    private RmaJTable altTable;
    private RmaJDescriptionField descriptionTxt;
    private RmaJTextArea argsTxt;
    private ButtonCmdPanel cmdPanel;
    private ProgramOrderItem _poi;
    private boolean _programOrderItemChanged;

    public SupplementalAltArgsJDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.buildControls();
    }

    public SupplementalAltArgsJDialog(Dialog parent, boolean modal) {
        super(parent, modal);
        this.buildControls();
    }

    private void buildControls() {
        this.setTitle("Supplemental Alt Argument Editor");
        this.getContentPane().setLayout(new GridBagLayout());
        JLabel label = new JLabel("Program: ", 4);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = -1;
        gbc.gridy = -1;
        gbc.gridwidth = 1;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        this.getContentPane().add((Component)label, gbc);
        this.programTxt = new RmaJTextField();
        this.programTxt.setEditable(false);
        gbc.gridx = -1;
        gbc.gridy = -1;
        gbc.gridwidth = 0;
        gbc.weightx = 1.0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        this.getContentPane().add((Component)this.programTxt, gbc);
        label = new JLabel("Program to Run:");
        gbc.gridx = -1;
        gbc.gridy = -1;
        gbc.gridwidth = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.INSETS5505;
        this.getContentPane().add((Component)label, gbc);
        this.programToRunFld = new RmiFileChooserField(){

            public void clearPerformed() {
            }
        };
        gbc.gridx = -1;
        gbc.gridy = -1;
        gbc.gridwidth = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.INSETS5505;
        this.getContentPane().add((Component)this.programToRunFld, gbc);
        JSeparator sep = new JSeparator();
        gbc.gridx = -1;
        gbc.gridy = -1;
        gbc.gridwidth = 0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        this.getContentPane().add((Component)sep, gbc);
        this.altTable = new RmaJTable((Component)((Object)this), new String[]{"Name", "Description"}){

            public Dimension getPreferredScrollableViewportSize() {
                Dimension d = super.getPreferredScrollableViewportSize();
                d.height = 100;
                return d;
            }
        };
        this.altTable.setEditable(false);
        this.altTable.setCellSelectionEnabled(false);
        this.altTable.setColumnSelectionAllowed(false);
        this.altTable.setRowSelectionAllowed(true);
        this.altTable.setPopupMenuEnabled(false);
        this.altTable.setRowHeight(20);
        gbc.gridx = -1;
        gbc.gridy = -1;
        gbc.gridwidth = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        this.getContentPane().add((Component)this.altTable.getScrollPane(), gbc);
        label = new JLabel("Name: ", 4);
        gbc.gridx = -1;
        gbc.gridy = -1;
        gbc.gridwidth = 1;
        gbc.weightx = 0.0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        this.getContentPane().add((Component)label, gbc);
        this.nameTxt = new RmaJTextField();
        this.nameTxt.setEditable(false);
        gbc.gridx = -1;
        gbc.gridy = -1;
        gbc.gridwidth = 0;
        gbc.weightx = 1.0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        this.getContentPane().add((Component)this.nameTxt, gbc);
        label = new JLabel("Description: ", 4);
        gbc.gridx = -1;
        gbc.gridy = -1;
        gbc.gridwidth = 1;
        gbc.anchor = 18;
        gbc.weightx = 0.0;
        gbc.fill = 0;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        this.getContentPane().add((Component)label, gbc);
        this.descriptionTxt = new RmaJDescriptionField();
        this.descriptionTxt.setEditable(false);
        gbc.gridx = -1;
        gbc.gridy = -1;
        gbc.gridwidth = 0;
        gbc.weightx = 1.0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        this.getContentPane().add((Component)this.descriptionTxt, gbc);
        label = new JLabel("Arguments: ", 4);
        gbc.gridx = -1;
        gbc.gridy = -1;
        gbc.gridwidth = 0;
        gbc.anchor = 18;
        gbc.weightx = 0.0;
        gbc.fill = 0;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        this.getContentPane().add((Component)label, gbc);
        this.argsTxt = new RmaJTextArea(10, 40){

            public Dimension getPreferredScrollableViewportSize() {
                Dimension d = super.getPreferredScrollableViewportSize();
                d.height = 100;
                return d;
            }
        };
        this.argsTxt.setEditable(false);
        gbc = new GridBagConstraints();
        gbc.gridx = -1;
        gbc.gridy = -1;
        gbc.gridwidth = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 2.0;
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        this.getContentPane().add((Component)new JScrollPane((Component)this.argsTxt), gbc);
        this.cmdPanel = new ButtonCmdPanel(12);
        gbc.gridx = -1;
        gbc.gridy = -1;
        gbc.gridwidth = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.anchor = 16;
        gbc.fill = 2;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)5, (int)5);
        this.getContentPane().add((Component)this.cmdPanel, gbc);
        this.cmdPanel.addCmdPanelListener(new ButtonCmdPanelListener(){

            public void buttonCmdActionPerformed(ActionEvent e) {
                switch (e.getID()) {
                    case 8: {
                        if (!SupplementalAltArgsJDialog.this.saveForm()) break;
                        SupplementalAltArgsJDialog.this._canceled = false;
                        SupplementalAltArgsJDialog.this.setVisible(false);
                        break;
                    }
                    case 4: {
                        SupplementalAltArgsJDialog.this._canceled = true;
                        SupplementalAltArgsJDialog.this.setVisible(false);
                    }
                }
            }
        });
        this.altTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){
            boolean _ignoreSelections = false;

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                int row = SupplementalAltArgsJDialog.this.altTable.getSelectedRow();
                if (row > -1) {
                    int opt;
                    if (SupplementalAltArgsJDialog.this._alt != null && SupplementalAltArgsJDialog.this.isModified() && (opt = JOptionPane.showConfirmDialog((Component)((Object)SupplementalAltArgsJDialog.this), SupplementalAltArgsJDialog.this._alt.getName() + " has changed. Save Changes?", "Save Changes", 0)) == 0) {
                        SupplementalAltArgsJDialog.this.saveForm();
                    }
                    SupplementalAltArgsJDialog.this.fillForm(row);
                }
            }
        });
        this.pack();
        this.setLocation();
    }

    public void setSupplementalAlt(SupplementalProgramAlt alt) {
        this.altTable.getScrollPane().setVisible(false);
        this.pack();
        this._alt = alt;
        this.fillForm();
    }

    public void setProgramOrderItem(ProgramOrderItem poi) {
        if (poi == null) {
            this.programToRunFld.setEnabled(false);
            return;
        }
        this._poi = poi;
        if (this._poi == null) {
            this.programToRunFld.setEnabled(false);
        } else {
            String script = this._poi.getScript();
            if (script != null) {
                this.programToRunFld.setText(script);
            }
        }
    }

    public void setAlternativeList(String program, Vector altList) {
        this.clearForm();
        this.altTable.deleteCells();
        if (program != null) {
            this.programTxt.setText(program);
        }
        this.altTable.getScrollPane().setVisible(true);
        this.pack();
        if (altList == null) {
            return;
        }
        for (int i = 0; i < altList.size(); ++i) {
            Object obj = altList.get(i);
            if (!(obj instanceof SupplementalProgramAlt)) continue;
            SupplementalProgramAlt alt = (SupplementalProgramAlt)((Object)obj);
            Vector<Object> row = new Vector<Object>(2);
            row.add((Object)alt);
            row.add(alt.getDescription());
            this.altTable.appendRow(row);
        }
    }

    private void fillForm(int row) {
        this.nameTxt.setText("");
        this.descriptionTxt.setText("");
        this.argsTxt.setText("");
        SupplementalProgramAlt alt = (SupplementalProgramAlt)((Object)this.altTable.getCell(row, 0));
        if (alt == null) {
            this.descriptionTxt.setEditable(false);
            this.argsTxt.setEditable(false);
            return;
        }
        this._alt = alt;
        this.descriptionTxt.setEditable(true);
        this.argsTxt.setEditable(true);
        this.nameTxt.setText(alt.getName());
        this.descriptionTxt.setText(alt.getDescription());
        this.argsTxt.setText(alt.getUserSpecifiedProgramArgs());
        this.nameTxt.setEditable(false);
        this.setModified(false);
    }

    protected void fillForm() {
        this.clearForm();
        if (this._alt == null) {
            this.descriptionTxt.setEditable(false);
            this.argsTxt.setEditable(false);
            return;
        }
        this.descriptionTxt.setEditable(true);
        this.argsTxt.setEditable(true);
        this.nameTxt.setText(this._alt.getName());
        this.descriptionTxt.setText(this._alt.getDescription());
        this.programTxt.setText(this._alt.getProgramName());
        this.programTxt.setEditable(false);
        this.nameTxt.setEditable(false);
        this.argsTxt.setText(this._alt.getUserSpecifiedProgramArgs());
    }

    protected boolean saveForm() {
        String cmd;
        if (this._poi != null && !(cmd = this.programToRunFld.getText()).equals(this._poi.getScript())) {
            int opt = JOptionPane.showConfirmDialog((Component)((Object)this), "<html>Changing the <b>Program to Run</b> for " + this._poi + " will change it for all " + this._poi + " alternatives.<br>Save Anyway?", "Confirm Program Change", 1, 3);
            if (opt == 2) {
                return false;
            }
            if (opt == 0) {
                this._poi.setScript(cmd);
                this._poi.setModified(true);
                this._programOrderItemChanged = true;
            } else if (opt == 1 && this._alt == null) {
                return false;
            }
        }
        if (this._alt == null) {
            return true;
        }
        this._alt.setDescription(this.descriptionTxt.getText());
        this._alt.setUserSpecifiedProgramArgs(this.argsTxt.getText());
        this._alt.getProxyList().saveManager("supplemental", this._alt);
        this.setModified(false);
        return true;
    }

    public static void main(String[] args) {
        new SupplementalAltArgsJDialog(new Frame(), false).setVisible(true);
    }

    public void setSelectedAlternative(String name) {
        if (name == null) {
            return;
        }
        int numRows = this.altTable.getRowCount();
        for (int i = 0; i < numRows; ++i) {
            SupplementalProgramAlt alt = (SupplementalProgramAlt)((Object)this.altTable.getValueAt(i, 0));
            if (!name.equals(alt.getName())) continue;
            this.altTable.updateSelection(i, 0, true, false);
            return;
        }
    }

    public boolean programOrderItemChanged() {
        return this._programOrderItemChanged;
    }
}

