/*
 * Decompiled with CFR 0.152.
 */
package hec.clientapp.util;

import com.google.common.flogger.FluentLogger;
import hec.clientapp.util.DssDefaultFileVersionInfo;
import hec.clientapp.util.DssVersion;
import hec.heclib.util.Heclib;
import hec.heclib.util.stringContainer;

public class DssUtilities {
    private static final FluentLogger LOGGER = FluentLogger.forEnclosingClass();
    private static final String USE_DSS_6_PROPERTY = ".UseDss6";

    private DssUtilities() {
    }

    public static void setupDSSDefaultsForApp(String applicationName) {
        String dssVerProperty = applicationName + USE_DSS_6_PROPERTY;
        if (Boolean.getBoolean(dssVerProperty)) {
            ((FluentLogger.Api)LOGGER.atInfo()).log("%s using DSS 6. ALLV set to 6", (Object)applicationName);
            Heclib.zset((String)"ALLV", (String)"", (int)6);
        } else {
            ((FluentLogger.Api)LOGGER.atInfo()).log("%s using DSS 7. using DSS 7 (Default). ALLV not set. To override, set -D%s=true", (Object)applicationName, (Object)dssVerProperty);
        }
    }

    public static String getDssLibraryVersion() {
        stringContainer dssLibVersion = new stringContainer();
        Heclib.zquery((String)"VERS", (stringContainer)dssLibVersion, (int[])new int[1]);
        return dssLibVersion.string;
    }

    public static String getDssLibraryDate() {
        stringContainer dssDate = new stringContainer();
        Heclib.zquery((String)"DATE", (stringContainer)dssDate, (int[])new int[1]);
        return dssDate.string;
    }

    public static DssDefaultFileVersionInfo getDefaultDssFileVersion() {
        boolean isDSS6;
        int[] dssVer = new int[1];
        Heclib.zquery((String)"ALLV", (stringContainer)new stringContainer(), (int[])dssVer);
        boolean bl = isDSS6 = dssVer[0] == 6;
        if (isDSS6) {
            return new DssDefaultFileVersionInfo(DssVersion.SIX, dssVer[0]);
        }
        if (dssVer[0] > 7) {
            return new DssDefaultFileVersionInfo(DssVersion.UNKNOWN, dssVer[0]);
        }
        return new DssDefaultFileVersionInfo(DssVersion.SEVEN, dssVer[0]);
    }
}

