/*
 * Decompiled with CFR 0.152.
 */
package hec.clientapp.util;

import hec.clientapp.model.StreamAlignment;
import hec.io.FilePath;
import hec.io.HecFile;
import hec.io.Identifier;
import hec.map.WorldLine;
import hec.map.WorldPt;
import hec.model.StreamElement;
import hec.model.StreamNode;
import java.io.File;
import java.util.Vector;
import mil.army.usace.hec.rmi.io.HecFileImpl;

public class StreamAlignConverter {
    protected StreamAlignment _alignment;
    protected double _conversionFactor;
    Identifier _oldId;
    public static final String TO_METRIC = "TOSI";
    public static final String TO_ENGLISH = "TOENGLISH";
    public static final double TO_METRIC_FACTOR = 0.3048;
    public static final double TO_ENGLISH_FACTOR = 3.28083;

    public StreamAlignConverter(String sourceFileName) {
        this._oldId = new Identifier(sourceFileName);
        FilePath path = new FilePath(sourceFileName);
        HecFileImpl file = new HecFileImpl(path);
        if (!file.exists()) {
            System.out.println("StreamAlignConverter: Failed to find file " + file.getPath());
            System.exit(4);
        }
        this._oldId.setFile((HecFile)file);
    }

    public void convertStream(String conversion) {
        if (conversion.equalsIgnoreCase(TO_METRIC)) {
            this.convertStream(0.3048);
        } else if (conversion.equalsIgnoreCase(TO_ENGLISH)) {
            this.convertStream(3.28083);
        } else {
            System.out.println("Unknown conversion type " + conversion);
            System.exit(1);
        }
    }

    private boolean convertStream(double conversionFactor) {
        this._alignment = new StreamAlignment();
        this._alignment.setIdentifier(this._oldId);
        if (!this._alignment.readFile(this._oldId)) {
            System.out.println("Failed to read streamalignment file " + this._oldId.getPath());
            System.exit(2);
            return false;
        }
        Vector streamList = this._alignment.getElementVector();
        for (int y = 0; y < streamList.size(); ++y) {
            StreamElement streamElement = (StreamElement)streamList.get(y);
            WorldPt pt = new WorldPt(streamElement.getReferencePt());
            pt.e *= conversionFactor;
            pt.n *= conversionFactor;
            WorldLine line = streamElement.getLine();
            Vector pts = line.pts;
            for (int j = 0; j < pts.size(); ++j) {
                pt = (WorldPt)pts.get(j);
                pt.e *= conversionFactor;
                pt.n *= conversionFactor;
            }
        }
        Vector nodes = this._alignment.getNodeVector();
        for (int i = 0; i < nodes.size(); ++i) {
            StreamNode node = (StreamNode)nodes.get(i);
            WorldPt pt2 = node.getLocation();
            pt2.e *= conversionFactor;
            pt2.n *= conversionFactor;
        }
        ((HecFileImpl)this._oldId.getFile()).renameTo(new File(this._oldId.getPath() + ".orig"));
        this._alignment.writeFile(this._oldId);
        return true;
    }

    public static void printUsage() {
        System.out.println("USAGE: StreamAlignConverter -f <streamalignment file> -c <TOENGLISH | TOSI>");
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            StreamAlignConverter.printUsage();
            System.exit(3);
        }
        String convType = "";
        String fileName = "";
        for (int r = 0; r < args.length; ++r) {
            if (args[r].startsWith("-f")) {
                if (args[r].length() == 2) {
                    fileName = args[r + 1];
                    ++r;
                    continue;
                }
                fileName = args[r].substring(2);
                continue;
            }
            if (!args[r].startsWith("-c")) continue;
            if (args[r].length() == 2) {
                convType = args[r + 1];
                ++r;
                continue;
            }
            convType = args[r].substring(2);
        }
        StreamAlignConverter streamAlignConverter = new StreamAlignConverter(fileName);
        streamAlignConverter.convertStream(convType);
    }
}

