/*
 * Decompiled with CFR 0.152.
 */
package hec.clientapp.util;

import com.google.common.flogger.FluentLogger;
import java.util.Properties;
import rma.util.RMAIO;

public class VersionUtilities {
    private static final FluentLogger LOGGER = FluentLogger.forEnclosingClass();

    private VersionUtilities() {
    }

    public static void printVersionInformationFor(String appName, Class<?> clazz) {
        Properties props = RMAIO.getAppVersionProperties(clazz);
        if (props != null) {
            String fullVersion = props.getProperty("fullVersion");
            String date = props.getProperty("versionDate");
            if (fullVersion != null) {
                ((FluentLogger.Api)LOGGER.atInfo()).log("%s Version: %s", (Object)appName, (Object)fullVersion);
            }
            if (date != null) {
                ((FluentLogger.Api)LOGGER.atInfo()).log("%s Date: %s", (Object)appName, (Object)date);
            }
        }
    }

    public static String getApplicationVersion(Class<?> clazz) {
        Properties props = RMAIO.getAppVersionProperties(clazz);
        String fullVersion = "unknown";
        if (props != null) {
            fullVersion = props.getProperty("fullVersion");
        }
        return fullVersion;
    }
}

