/*
 * Decompiled with CFR 0.152.
 */
package hec.client;

import hec.client.LookAndFeel;
import hec.heclib.util.HecTime;
import hec.model.DailyRepeatInterval;
import hec.model.MonthlyRepeatInterval;
import hec.model.NoRepeatInterval;
import hec.model.RepeatInterval;
import hec.model.WeeklyRepeatInterval;
import hec.model.YearlyRepeatInterval;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import rma.swing.ButtonCmdPanel;
import rma.swing.ButtonCmdPanelListener;
import rma.swing.RmaInsets;
import rma.swing.RmaJCalendarField;
import rma.swing.RmaJCheckBox;
import rma.swing.RmaJComboBox;
import rma.swing.RmaJDialog;
import rma.swing.RmaJRadioButton;
import rma.swing.RmaJTextArea;
import rma.swing.event.ReflectMultiListener;

public class RepeatDialog
extends RmaJDialog {
    private static final String NONE_PANEL = "None";
    private static final String DATA_PANEL = "Data";
    private static final String[] BY_INTERVALS = new String[]{"Day", "Date"};
    private static final String[] SUFFIXS = new String[]{"", "st", "nd", "rd", "th"};
    private RmaJRadioButton _noneRadio;
    private RmaJRadioButton _dailyRadio;
    private RmaJRadioButton _weeklyRadio;
    private RmaJRadioButton _monthlyRadio;
    private RmaJRadioButton _yearlyRadio;
    private JPanel _cardPanel;
    private JSpinner _intervalAmount;
    private RmaJCalendarField _endsOnField;
    private RmaJComboBox _amountByCombo;
    private JLabel _intervalLabel;
    private JPanel _daysPanel;
    private RmaJCheckBox _sundayCheck;
    private RmaJCheckBox _mondayCheck;
    private RmaJCheckBox _tuesdayCheck;
    private RmaJCheckBox _wednesdayCheck;
    private RmaJCheckBox _thursdayCheck;
    private RmaJCheckBox _fridayCheck;
    private RmaJCheckBox _saturdayCheck;
    private List _weekDaysList = new ArrayList();
    private JTextField _filler;
    private RmaJComboBox _intervalByCombo;
    private RmaJTextArea _msgText;
    private ButtonCmdPanel _cmdPanel;
    private ReflectMultiListener _listener;
    private boolean _canceled;
    private ButtonGroup _bg;

    public RepeatDialog(Dialog parent, boolean modal) {
        super(parent, modal);
        this.buildControls();
    }

    public RepeatDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.buildControls();
    }

    protected void buildControls() {
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle("Repeat");
        this._listener = new ReflectMultiListener();
        JPanel radioPanel = new JPanel(new GridLayout(5, 1));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.anchor = 18;
        gbc.fill = 3;
        gbc.weighty = 1.0;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        this.getContentPane().add((Component)radioPanel, gbc);
        this._noneRadio = new RmaJRadioButton(NONE_PANEL);
        this._noneRadio.setMnemonic('N');
        radioPanel.add((Component)this._noneRadio);
        this._dailyRadio = new RmaJRadioButton("Daily");
        this._dailyRadio.setMnemonic('D');
        radioPanel.add((Component)this._dailyRadio);
        this._weeklyRadio = new RmaJRadioButton("Weekly");
        this._weeklyRadio.setMnemonic('W');
        radioPanel.add((Component)this._weeklyRadio);
        this._monthlyRadio = new RmaJRadioButton("Monthly");
        this._monthlyRadio.setMnemonic('M');
        radioPanel.add((Component)this._monthlyRadio);
        this._yearlyRadio = new RmaJRadioButton("Yearly");
        this._yearlyRadio.setMnemonic('Y');
        radioPanel.add((Component)this._yearlyRadio);
        this._cardPanel = new JPanel(new CardLayout());
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.anchor = 10;
        gbc.fill = 1;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        this.getContentPane().add((Component)this._cardPanel, gbc);
        this.buildCardPanels();
        this._msgText = new RmaJTextArea(){

            public Dimension getPreferredScrollableViewportSize() {
                Dimension d = super.getPreferredScrollableViewportSize();
                d.height = 50;
                return d;
            }
        };
        this._msgText.setEditable(false);
        this._msgText.setRows(3);
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridwidth = 2;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        this.getContentPane().add((Component)new JScrollPane((Component)this._msgText), gbc);
        this._cmdPanel = new ButtonCmdPanel(12);
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.gridwidth = 2;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        this.getContentPane().add((Component)this._cmdPanel, gbc);
        this._noneRadio.addActionListener((ActionListener)this._listener.add((Object)this, (Object)this._noneRadio, "noneRadioSelected"));
        this._dailyRadio.addActionListener((ActionListener)this._listener.add((Object)this, (Object)this._dailyRadio, "dailyRadioSelected"));
        this._weeklyRadio.addActionListener((ActionListener)this._listener.add((Object)this, (Object)this._weeklyRadio, "weeklyRadioSelected"));
        this._monthlyRadio.addActionListener((ActionListener)this._listener.add((Object)this, (Object)this._monthlyRadio, "monthlyRadioSelected"));
        this._yearlyRadio.addActionListener((ActionListener)this._listener.add((Object)this, (Object)this._yearlyRadio, "yearlyRadioSelected"));
        this._bg = new ButtonGroup();
        this._bg.add((AbstractButton)this._noneRadio);
        this._bg.add((AbstractButton)this._dailyRadio);
        this._bg.add((AbstractButton)this._weeklyRadio);
        this._bg.add((AbstractButton)this._monthlyRadio);
        this._bg.add((AbstractButton)this._yearlyRadio);
        this._cmdPanel.addCmdPanelListener(new ButtonCmdPanelListener(){

            public void buttonCmdActionPerformed(ActionEvent e) {
                switch (e.getID()) {
                    case 8: {
                        RepeatDialog.this._canceled = false;
                        RepeatDialog.this.setVisible(false);
                        break;
                    }
                    case 4: {
                        RepeatDialog.this._canceled = true;
                        RepeatDialog.this.setVisible(false);
                    }
                }
            }
        });
        this.pack();
        this.setLocationRelativeTo(this.getParent());
        this._noneRadio.doClick(0);
        this.setResizable(false);
    }

    protected void buildCardPanels() {
        JPanel dataPanel = new JPanel(new GridBagLayout());
        JLabel label = new JLabel("Every:");
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        dataPanel.add((Component)label, gbc);
        SpinnerNumberModel model = new SpinnerNumberModel(1, 1, 10000, 1);
        this._intervalAmount = new JSpinner(model);
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        dataPanel.add((Component)this._intervalAmount, gbc);
        this._intervalLabel = new JLabel("                   ");
        gbc.gridx = 2;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        dataPanel.add((Component)this._intervalLabel, gbc);
        label = new JLabel("End On:");
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridwidth = 1;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        dataPanel.add((Component)label, gbc);
        this._endsOnField = new RmaJCalendarField("DDMMMYYYY", "");
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.gridwidth = 2;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        dataPanel.add((Component)this._endsOnField, gbc);
        this._cardPanel.add(DATA_PANEL, dataPanel);
        JPanel nonePanel = new JPanel();
        label = new JLabel("<html>Click one of the buttons to the<br>left to set a repeat interval</html>");
        nonePanel.add(label);
        this._daysPanel = this.buildDaysPanel();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.gridwidth = 3;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        dataPanel.add((Component)this._daysPanel, gbc);
        this._filler = new JTextField(" ");
        this._filler.setEnabled(false);
        this._filler.setBorder(null);
        this._filler.setBackground(null);
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.gridwidth = 3;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.insets((int)10, (int)5, (int)0, (int)5);
        dataPanel.add((Component)this._filler, gbc);
        this._cardPanel.add(NONE_PANEL, nonePanel);
        this._intervalAmount.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                RepeatDialog.this.updateMsgText();
            }
        });
    }

    public JPanel buildByPanel() {
        JPanel byPanel = new JPanel(new GridBagLayout());
        JLabel label = new JLabel("By:");
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.insets((int)0, (int)0, (int)0, (int)5);
        byPanel.add((Component)label, gbc);
        this._intervalByCombo = new RmaJComboBox((Object[])BY_INTERVALS);
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.weightx = 1.0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.insets((int)0, (int)5, (int)0, (int)5);
        byPanel.add((Component)this._intervalByCombo, gbc);
        return byPanel;
    }

    public JPanel buildDaysPanel() {
        JPanel daysPanel = new JPanel(new GridBagLayout());
        JLabel label = new JLabel("Days:");
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.weightx = 1.0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.insets((int)0, (int)0, (int)0, (int)5);
        daysPanel.add((Component)label, gbc);
        this._sundayCheck = new RmaJCheckBox();
        this.configureCheck((JCheckBox)this._sundayCheck, "S", "Sun");
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.insets((int)0, (int)0, (int)0, (int)0);
        daysPanel.add((Component)this._sundayCheck, gbc);
        this._mondayCheck = new RmaJCheckBox();
        this.configureCheck((JCheckBox)this._mondayCheck, "M", "Mon");
        gbc.gridx = 2;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.insets((int)0, (int)0, (int)0, (int)0);
        daysPanel.add((Component)this._mondayCheck, gbc);
        this._tuesdayCheck = new RmaJCheckBox();
        this.configureCheck((JCheckBox)this._tuesdayCheck, "T", "Tue");
        gbc.gridx = 3;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.insets((int)0, (int)0, (int)0, (int)0);
        daysPanel.add((Component)this._tuesdayCheck, gbc);
        this._wednesdayCheck = new RmaJCheckBox();
        this.configureCheck((JCheckBox)this._wednesdayCheck, "W", "Wed");
        gbc.gridx = 4;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.insets((int)0, (int)0, (int)0, (int)0);
        daysPanel.add((Component)this._wednesdayCheck, gbc);
        this._thursdayCheck = new RmaJCheckBox();
        this.configureCheck((JCheckBox)this._thursdayCheck, "T", "Thu");
        gbc.gridx = 5;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.insets((int)0, (int)0, (int)0, (int)0);
        daysPanel.add((Component)this._thursdayCheck, gbc);
        this._fridayCheck = new RmaJCheckBox();
        this.configureCheck((JCheckBox)this._fridayCheck, "F", "Fri");
        gbc.gridx = 6;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.insets((int)0, (int)0, (int)0, (int)0);
        daysPanel.add((Component)this._fridayCheck, gbc);
        this._saturdayCheck = new RmaJCheckBox();
        this.configureCheck((JCheckBox)this._saturdayCheck, "S", "Sat");
        gbc.gridx = 7;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.insets((int)0, (int)0, (int)0, (int)0);
        daysPanel.add((Component)this._saturdayCheck, gbc);
        this._weekDaysList.add(this._sundayCheck);
        this._weekDaysList.add(this._mondayCheck);
        this._weekDaysList.add(this._tuesdayCheck);
        this._weekDaysList.add(this._wednesdayCheck);
        this._weekDaysList.add(this._thursdayCheck);
        this._weekDaysList.add(this._fridayCheck);
        this._weekDaysList.add(this._saturdayCheck);
        this._sundayCheck.addActionListener((ActionListener)this._listener.add((Object)this, (Object)this._sundayCheck, "updateMsgText"));
        this._mondayCheck.addActionListener((ActionListener)this._listener.add((Object)this, (Object)this._mondayCheck, "updateMsgText"));
        this._tuesdayCheck.addActionListener((ActionListener)this._listener.add((Object)this, (Object)this._tuesdayCheck, "updateMsgText"));
        this._wednesdayCheck.addActionListener((ActionListener)this._listener.add((Object)this, (Object)this._wednesdayCheck, "updateMsgText"));
        this._thursdayCheck.addActionListener((ActionListener)this._listener.add((Object)this, (Object)this._thursdayCheck, "updateMsgText"));
        this._fridayCheck.addActionListener((ActionListener)this._listener.add((Object)this, (Object)this._fridayCheck, "updateMsgText"));
        this._saturdayCheck.addActionListener((ActionListener)this._listener.add((Object)this, (Object)this._saturdayCheck, "updateMsgText"));
        return daysPanel;
    }

    protected void configureCheck(JCheckBox checkBox, String txt, String name) {
        checkBox.setName(name);
        checkBox.setIcon(new DayCheckBoxIcon(txt, false));
        checkBox.setSelectedIcon(new DayCheckBoxIcon(txt, true));
        checkBox.setMargin(RmaInsets.insets((int)0, (int)0, (int)0, (int)0));
        checkBox.setBorder(UIManager.getBorder("TextField.border"));
    }

    protected void updateMsgText() {
        if (this._noneRadio.isSelected()) {
            this._msgText.setText("");
            return;
        }
        Integer value = (Integer)this._intervalAmount.getValue();
        int i = value;
        if (i == 0) {
            this._msgText.setText("");
        } else {
            String intervalAmt = this._intervalLabel.getText().trim();
            intervalAmt = intervalAmt.substring(0, intervalAmt.length() - 1);
            String suffix = i >= SUFFIXS.length ? SUFFIXS[SUFFIXS.length - 1] : SUFFIXS[i];
            this._msgText.setText("Every " + i + suffix + " " + intervalAmt);
            if (this._weeklyRadio.isSelected()) {
                ArrayList<String> selectedDays = new ArrayList<String>();
                for (i = 0; i < this._weekDaysList.size(); ++i) {
                    JCheckBox cb = (JCheckBox)this._weekDaysList.get(i);
                    if (!cb.isSelected()) continue;
                    selectedDays.add(cb.getName());
                }
                if (selectedDays.size() > 0) {
                    StringBuffer wkdays = new StringBuffer();
                    wkdays.append(" on ");
                    Iterator iter = selectedDays.iterator();
                    while (iter.hasNext()) {
                        wkdays.append(iter.next());
                        iter.remove();
                        if (selectedDays.size() == 1) {
                            wkdays.append(" and ");
                            continue;
                        }
                        if (selectedDays.size() <= 1) continue;
                        wkdays.append(", ");
                    }
                    this._msgText.append(wkdays.toString());
                }
            }
        }
    }

    protected void updatePanel(String panelName, String intervalLabel) {
        ((CardLayout)this._cardPanel.getLayout()).show(this._cardPanel, panelName);
        this._intervalLabel.setText(intervalLabel);
        this.updateMsgText();
        this._daysPanel.setVisible(false);
        this._filler.setVisible(!this._daysPanel.isVisible());
    }

    protected void noneRadioSelected() {
        this.updatePanel(NONE_PANEL, "");
    }

    protected void dailyRadioSelected() {
        this.updatePanel(DATA_PANEL, "Days    ");
    }

    protected void weeklyRadioSelected() {
        this.updatePanel(DATA_PANEL, "Weeks  ");
    }

    protected void monthlyRadioSelected() {
        this.updatePanel(DATA_PANEL, "Months");
    }

    protected void yearlyRadioSelected() {
        this.updatePanel(DATA_PANEL, "Years  ");
    }

    public boolean isCanceled() {
        return this._canceled;
    }

    public RepeatInterval getRepeatInterval() {
        RepeatInterval ri;
        if (this._dailyRadio.isSelected()) {
            ri = new DailyRepeatInterval();
        } else if (this._weeklyRadio.isSelected()) {
            WeeklyRepeatInterval wri = new WeeklyRepeatInterval();
            ri = wri;
            for (int i = 0; i < this._weekDaysList.size(); ++i) {
                wri.setRepeatDayOfWeek(i, ((JCheckBox)this._weekDaysList.get(i)).isSelected());
            }
        } else {
            ri = this._monthlyRadio.isSelected() ? new MonthlyRepeatInterval() : (this._yearlyRadio.isSelected() ? new YearlyRepeatInterval() : new NoRepeatInterval());
        }
        ri.setRepeatNumber((Integer)this._intervalAmount.getValue());
        if (this._endsOnField.getDate() != null) {
            ri.setEndDate(new HecTime(this._endsOnField.getDate(), 0));
        }
        return ri;
    }

    public void setRepeatInterval(RepeatInterval ri) {
        if (ri == null) {
            this._noneRadio.doClick(0);
            return;
        }
        switch (ri.getRepeatType()) {
            case 0: {
                this._noneRadio.doClick(0);
                break;
            }
            case 1: {
                this._dailyRadio.doClick(0);
                break;
            }
            case 2: {
                this._weeklyRadio.doClick(0);
                WeeklyRepeatInterval wri = (WeeklyRepeatInterval)ri;
                boolean[] repeatDays = wri.getRepeatDays();
                for (int i = 0; i < this._weekDaysList.size(); ++i) {
                    ((JCheckBox)this._weekDaysList.get(i)).setSelected(repeatDays[i]);
                }
                break;
            }
            case 3: {
                this._monthlyRadio.doClick(0);
                break;
            }
            case 4: {
                this._yearlyRadio.doClick(0);
            }
        }
        this._intervalAmount.setValue(new Integer(ri.getRepeatNumber()));
        if (ri.getEndDate() != null && ri.getEndDate().isDefined()) {
            this._endsOnField.setText(ri.getEndDate().date(4));
        } else {
            this._endsOnField.setText("");
        }
    }

    public static void main(String[] args) {
        LookAndFeel.setLookAndFeel();
        RepeatDialog dialog = new RepeatDialog(new Frame(), true);
        dialog.setDefaultCloseOperation(3);
        dialog.setVisible(true);
        RepeatInterval ri = dialog.getRepeatInterval();
        if (ri == null) {
            System.exit(0);
        }
        HecTime startTime = new HecTime("12Nov1993", "0100");
        HecTime endTime = new HecTime("12Nov1993", "2400");
        HecTime stopTime = new HecTime("12Dec1993", "2400");
        System.out.println("repeat window start=" + startTime + " end=" + endTime + " repeat type=" + ri + " Stopping on=" + stopTime);
        System.out.println();
        System.exit(0);
    }

    class DayCheckBoxIcon
    implements Icon {
        boolean _selected;
        String _txt;

        DayCheckBoxIcon(String txt, boolean selected) {
            this._selected = selected;
            this._txt = txt;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            Color oldColor = g.getColor();
            FontMetrics fm = c.getFontMetrics(c.getFont());
            int width = fm.stringWidth(this._txt);
            int xoff = (18 - width) / 2;
            xoff += width / 2;
            if (this._selected) {
                g.setColor(UIManager.getColor("List.selectionBackground"));
            } else {
                g.setColor(UIManager.getColor("TextField.background"));
            }
            g.fillRect(x, y, x + 20, y + 20);
            g.setColor(Color.black);
            g.drawRect(x, y, x + 19, y + 19);
            if (this._selected) {
                g.setColor(UIManager.getColor("List.selectionForeground"));
            } else {
                g.setColor(UIManager.getColor("List.foreground"));
            }
            g.drawString(this._txt, xoff, 18);
            g.setColor(oldColor);
        }

        @Override
        public int getIconWidth() {
            return 20;
        }

        @Override
        public int getIconHeight() {
            return 20;
        }
    }
}

