/*
 * Decompiled with CFR 0.152.
 */
package hec.model;

import hec.heclib.util.HecTime;
import hec.model.RepeatInterval;
import java.lang.reflect.Field;

public class DailyRepeatInterval
extends RepeatInterval {
    @Override
    public synchronized Object clone() throws CloneNotSupportedException {
        DailyRepeatInterval ri = (DailyRepeatInterval)super.clone();
        return ri;
    }

    @Override
    public int getRepeatType() {
        return 1;
    }

    public String toString() {
        return "Daily";
    }

    @Override
    protected void getNextTime(HecTime baseStartTime, HecTime stepStartTime, HecTime baseEndTime, HecTime stepEndTime, HecTime[] nextTimes) {
        HecTime start = new HecTime(baseStartTime);
        HecTime end = new HecTime(baseEndTime);
        int minutesPerDay = 1440;
        while (end.lessThanEqualTo(stepStartTime)) {
            start.add(this._repeatNumber * minutesPerDay);
            end.add(this._repeatNumber * minutesPerDay);
        }
        nextTimes[0] = start;
        nextTimes[1] = end;
    }

    @Override
    public Object getFieldObject(Field fld) {
        try {
            Object obj = fld.get(this);
            return obj;
        }
        catch (IllegalAccessException e) {
            return super.getFieldObject(fld);
        }
    }

    @Override
    public boolean setFieldObject(Field fld, Object fobj) {
        try {
            fld.set(this, fobj);
            return true;
        }
        catch (IllegalAccessException e) {
            return super.setFieldObject(fld, fobj);
        }
        catch (IllegalArgumentException e) {
            return super.setFieldObject(fld, fobj);
        }
    }
}

