/*
 * Decompiled with CFR 0.152.
 */
package hec.model;

import hec.heclib.util.HecTime;
import hec.model.RepeatInterval;
import java.lang.reflect.Field;

public class MonthlyRepeatInterval
extends RepeatInterval {
    @Override
    public synchronized Object clone() throws CloneNotSupportedException {
        MonthlyRepeatInterval ri = (MonthlyRepeatInterval)super.clone();
        return ri;
    }

    @Override
    public int getRepeatType() {
        return 3;
    }

    public String toString() {
        return "Monthly";
    }

    @Override
    protected void getNextTime(HecTime baseStartTime, HecTime stepStartTime, HecTime baseEndTime, HecTime stepEndTime, HecTime[] nextTimes) {
        HecTime start = new HecTime(baseStartTime);
        HecTime end = new HecTime(baseEndTime);
        int minutesPerMonth = 43200;
        while (end.lessThanEqualTo(stepStartTime)) {
            start.increment(this._repeatNumber, minutesPerMonth);
            end.increment(this._repeatNumber, minutesPerMonth);
        }
        nextTimes[0] = start;
        nextTimes[1] = end;
    }

    @Override
    public Object getFieldObject(Field fld) {
        try {
            Object obj = fld.get(this);
            return obj;
        }
        catch (IllegalAccessException e) {
            return super.getFieldObject(fld);
        }
    }

    @Override
    public boolean setFieldObject(Field fld, Object fobj) {
        try {
            fld.set(this, fobj);
            return true;
        }
        catch (IllegalAccessException e) {
            return super.setFieldObject(fld, fobj);
        }
        catch (IllegalArgumentException e) {
            return super.setFieldObject(fld, fobj);
        }
    }
}

