/*
 * Decompiled with CFR 0.152.
 */
package hec.model;

import hec.heclib.util.HecTime;
import hec.io.AsciiSerializable;
import java.lang.reflect.Field;

public abstract class RepeatInterval
implements AsciiSerializable,
Cloneable {
    public static final int NO_REPEAT = 0;
    public static final int DAILY_REPEAT = 1;
    public static final int WEEKLY_REPEAT = 2;
    public static final int MONTHLY_REPEAT = 3;
    public static final int YEARLY_REPEAT = 4;
    protected HecTime _endDate;
    protected int _repeatNumber = 1;

    public synchronized Object clone() throws CloneNotSupportedException {
        RepeatInterval ri = (RepeatInterval)super.clone();
        if (this._endDate != null) {
            ri._endDate = new HecTime(this._endDate);
        }
        return ri;
    }

    public abstract int getRepeatType();

    public int getRepeatNumber() {
        if (this._repeatNumber < 1) {
            this._repeatNumber = 1;
        }
        return this._repeatNumber;
    }

    public void setRepeatNumber(int num) {
        if (num < 1) {
            num = 1;
        }
        this._repeatNumber = num;
    }

    public HecTime getEndDate() {
        return this._endDate;
    }

    public void setEndDate(HecTime endDate) {
        if (endDate == null) {
            this._endDate.setUndefined();
            return;
        }
        if (this._endDate == null) {
            this._endDate = new HecTime(endDate);
        } else {
            this._endDate.set(endDate);
        }
    }

    public HecTime[] getNextRepeatTime(HecTime startTime, HecTime stepStartTime, HecTime endTime, HecTime stepEndTime) {
        if (startTime == null || endTime == null || !startTime.isDefined() || !endTime.isDefined()) {
            return new HecTime[0];
        }
        HecTime[] times = this.nextRepeatTime(startTime, stepStartTime, endTime, stepEndTime);
        if (times.length > 0 && this._endDate != null && this._endDate.isDefined()) {
            for (int i = 1; i < times.length; i += 2) {
                endTime = times[i];
                if (!endTime.greaterThan(this._endDate)) continue;
                endTime.set(this._endDate);
            }
        }
        return times;
    }

    protected HecTime[] nextRepeatTime(HecTime startTime, HecTime stepStartTime, HecTime endTime, HecTime stepEndTime) {
        HecTime[] times = new HecTime[]{new HecTime(), new HecTime()};
        this.getNextTime(startTime, stepStartTime, endTime, stepEndTime, times);
        return times;
    }

    protected abstract void getNextTime(HecTime var1, HecTime var2, HecTime var3, HecTime var4, HecTime[] var5);

    public Object getFieldObject(Field fld) {
        try {
            Object obj = fld.get(this);
            return obj;
        }
        catch (IllegalAccessException e) {
            return null;
        }
    }

    public boolean setFieldObject(Field fld, Object fobj) {
        try {
            fld.set(this, fobj);
            return true;
        }
        catch (IllegalAccessException e) {
            return false;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }
}

