/*
 * Decompiled with CFR 0.152.
 */
package hec.model;

import hec.heclib.util.HecTime;
import hec.io.AsciiSerializable;
import hec.io.PairedDataContainer;
import hec.model.Interpolate;
import hec.model.PairedValues;
import hec.model.PairedValuesExt;
import hec.model.RunTime;
import hec.model.RunTimeStep;
import hec.model.SeasonalRecord;
import hec.model.ValueSet;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Vector;

public class SeasonalPairedValues
extends PairedValuesExt
implements AsciiSerializable {
    transient int[] _timeArray = null;
    boolean _hasSeasonalVariation = true;
    HecTime _startTime;
    int _nyears = -1;
    transient int _timeInterpInterval = -2;
    transient double[] _y2array = null;
    transient int[] _interpTimes = null;
    transient double[] _interpValues = null;
    transient double[] _time_y2array = null;
    transient int[] _interpTimesLeap;
    transient int[] _interpTimesNoLeap;
    transient double[] _time_y2arrayLeap = null;
    transient boolean _isLeapYear = false;
    int _timeInterpolationType = 0;
    int m_gmtOffset = 0;

    public void setGmtOffset(int offset) {
        this.m_gmtOffset = offset;
    }

    public int getGmtOffset() {
        return this.m_gmtOffset;
    }

    public void scaleValues(double scl) {
        if (this._dataVector != null) {
            for (int i = 0; i < this._dataVector.size(); ++i) {
                ValueSet vs = (ValueSet)this._dataVector.elementAt(i);
                int j = 0;
                while (j < vs.yval.length) {
                    int n = j++;
                    vs.yval[n] = vs.yval[n] * scl;
                }
            }
            this.clearValues();
            this.init();
        }
    }

    public synchronized SeasonalPairedValues clone() {
        try {
            SeasonalPairedValues sr = (SeasonalPairedValues)super.clone();
            sr.m_gmtOffset = this.m_gmtOffset;
            if (this._timeArray != null) {
                sr._timeArray = new int[this._timeArray.length];
                System.arraycopy(this._timeArray, 0, sr._timeArray, 0, this._timeArray.length);
            }
            sr._dataVector = new Vector();
            if (this._dataVector != null) {
                for (int i = 0; i < this._dataVector.size(); ++i) {
                    ValueSet vs = (ValueSet)this._dataVector.elementAt(i);
                    sr._dataVector.addElement((ValueSet)vs.clone());
                }
            }
            sr.init();
            return sr;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public void init() {
        super.init();
        this.initTimeArray();
    }

    private boolean initTimeArray() {
        int numCurves;
        if (this._curveLabels != null && this._curveLabels.length == this.getNumberCurves()) {
            this._timeArray = null;
            int iyear = 1900;
            int lowerTimeLimit = SeasonalPairedValues.getJulianMinute("01JAN", 1800);
            int upperTimeLimit = SeasonalPairedValues.getJulianMinute("01JAN", 3002);
            int ncurves = this.getNumberCurves();
            this._timeArray = new int[ncurves];
            Arrays.fill(this._timeArray, Integer.MIN_VALUE);
            for (int i = 0; i < ncurves; ++i) {
                int tim = SeasonalPairedValues.getJulianMinute(this._curveLabels[i], iyear);
                if (tim <= lowerTimeLimit || tim >= upperTimeLimit) continue;
                this._timeArray[i] = tim;
            }
        } else if (this._timeArray != null && this._timeArray.length == this.getNumberCurves()) {
            numCurves = this.getNumberCurves();
            this._curveLabels = new String[numCurves];
            for (int i = 0; i < numCurves; ++i) {
                this._curveLabels[i] = SeasonalPairedValues.getDateString(this._timeArray[i]);
            }
        } else {
            return false;
        }
        numCurves = this.getNumberCurves();
        this._interpValues = new double[numCurves + 1];
        this._interpTimesNoLeap = new int[numCurves + 1];
        System.arraycopy(this._timeArray, 0, this._interpTimesNoLeap, 0, numCurves);
        int nyears = 1;
        this._interpTimesNoLeap[this._interpTimesNoLeap.length - 1] = this._interpTimesNoLeap[0] + nyears * 365 * 1440;
        this._interpTimes = this._interpTimesNoLeap;
        this._time_y2array = null;
        this._time_y2arrayLeap = null;
        this.getYears();
        this.makeLeapYearTimeArray();
        return true;
    }

    protected boolean makeLeapYearTimeArray() {
        if (this._interpTimesNoLeap == null || this._interpTimesNoLeap.length < 1) {
            return false;
        }
        int nsize = this._interpTimesNoLeap.length;
        this._interpTimesLeap = new int[nsize];
        for (int i = 0; i < nsize; ++i) {
            int iday = this._interpTimesNoLeap[i] / 1440;
            this._interpTimesLeap[i] = iday > 59 ? this._interpTimesNoLeap[i] + 1440 : this._interpTimesNoLeap[i];
        }
        return true;
    }

    public void setTimeInterpolationType(int type) {
        if (type >= 0 && type <= 2) {
            this._timeInterpolationType = type;
        }
    }

    public int getTimeInterpolationType() {
        return this._timeInterpolationType;
    }

    public boolean setData(PairedDataContainer pdc) {
        if (!super.setData(pdc)) {
            return false;
        }
        this.init();
        return true;
    }

    public void setData(SeasonalRecord sr) {
        if (sr == null || sr.getTimeArray() == null || sr.getTimeArray().length < 2) {
            return;
        }
        this.clearValues();
        int[] times = sr.getTimeArray();
        double[] values = sr.getDataArray();
        int numCurves = times.length - 1;
        double[] yvals = new double[numCurves];
        this._timeArray = new int[numCurves];
        System.arraycopy(values, 0, yvals, 0, numCurves);
        System.arraycopy(times, 0, this._timeArray, 0, numCurves);
        this.addPair(0.0, yvals);
        this.setParamXId(sr.getParameterId());
        this.setParamYId(sr.getParameterId());
        this.setUnitSystem(sr.getUnitSystem());
        this.init();
    }

    public void setData(PairedValues pv, String startDate) {
        this._curveLabels = new String[1];
        this._curveLabels[0] = startDate;
        double[] xvals = pv.getXArray();
        double[] yvals = pv.getYArray();
        for (int i = 0; i < xvals.length; ++i) {
            this.addPair(xvals[i], yvals[i]);
        }
        this.setInterpolationType(pv.getInterpolationType());
        this.setParamXId(pv.getParamXId());
        this.setParamYId(pv.getParamYId());
        this.setUnitSystem(pv.getUnitSystem());
        this.init();
    }

    public PairedValues getPairedValues() {
        PairedValues pv = new PairedValues();
        int nsize = this.size();
        if (nsize >= 1) {
            for (int i = 0; i < nsize; ++i) {
                pv.addPair(this.getXValue(i), this.getYValue(i, 0));
            }
        }
        pv.setParamXId(this.getParamXId());
        pv.setParamYId(this.getParamYId());
        pv.setUnitSystem(this.getUnitSystem());
        pv.setInterpolationType(this.getInterpolationType());
        return pv;
    }

    public int[] getTimeArray() {
        if (this._timeArray == null && this._curveLabels != null) {
            this.initTimeArray();
        }
        return this._timeArray;
    }

    public void setArrays(double[] xArray, double[][] yArrays, int[] timeArray) {
        this.clearValues();
        if (timeArray == null || xArray == null || yArrays == null || yArrays.length < 1) {
            return;
        }
        int ncurves = yArrays.length;
        for (int i = 0; i < xArray.length; ++i) {
            double[] yvals = new double[ncurves];
            for (int k = 0; k < ncurves; ++k) {
                yvals[k] = yArrays[k][i];
            }
            this.addPair(xArray[i], yvals);
        }
        super.init();
        this._timeArray = timeArray;
        this.initTimeArray();
    }

    public void clearValues() {
        super.clearValues();
        this._timeArray = null;
        this._interpTimes = null;
        this._interpTimesNoLeap = null;
        this._interpTimesLeap = null;
        this._interpValues = null;
        this._time_y2array = null;
        this._time_y2arrayLeap = null;
        this._isLeapYear = false;
    }

    public void setHasSeasonalVariation(boolean tf) {
        this._hasSeasonalVariation = tf;
    }

    public boolean hasSeasonalVariation() {
        return this._hasSeasonalVariation;
    }

    private boolean checkTimeArrays() {
        if (this._interpTimes == null || this._interpValues == null) {
            if (!this.initTimeArray()) {
                return false;
            }
            if (this._interpTimes == null || this._interpTimes.length < 2) {
                return false;
            }
        }
        return true;
    }

    public double interpolate(RunTimeStep runtime, double xval) {
        if (!this._hasSeasonalVariation || this.getNumberCurves() == 1) {
            return this.interpolate(xval);
        }
        double value = Double.NEGATIVE_INFINITY;
        if (!this.checkTimeArrays()) {
            return value;
        }
        if (!this.canInterpX()) {
            return value;
        }
        int numCurves = this.getNumberCurves();
        for (int k = 0; k < numCurves; ++k) {
            this._interpValues[k] = this.interpolate(xval, k);
        }
        this._interpValues[numCurves] = this._interpValues[0];
        return this.timeInterpolate(runtime);
    }

    public double interpolate(HecTime htime, double xval) {
        if (!this._hasSeasonalVariation || this.getNumberCurves() == 1) {
            return this.interpolate(xval);
        }
        double value = Double.NEGATIVE_INFINITY;
        if (!this.checkTimeArrays()) {
            return value;
        }
        if (!this.canInterpX()) {
            return value;
        }
        int numCurves = this.getNumberCurves();
        for (int k = 0; k < numCurves; ++k) {
            this._interpValues[k] = this.interpolate(xval, k);
        }
        this._interpValues[numCurves] = this._interpValues[0];
        return this.timeInterpolate(htime);
    }

    public double interpolate(RunTime runtime, double xval) {
        if (!this._hasSeasonalVariation || this.getNumberCurves() == 1) {
            return this.interpolate(xval);
        }
        double value = Double.NEGATIVE_INFINITY;
        if (!this.checkTimeArrays()) {
            return value;
        }
        if (!this.canInterpX()) {
            return value;
        }
        int numCurves = this.getNumberCurves();
        for (int k = 0; k < numCurves; ++k) {
            this._interpValues[k] = this.interpolate(xval, k);
        }
        this._interpValues[numCurves] = this._interpValues[0];
        return this.timeInterpolate(runtime);
    }

    public double interpolate(int interpTime, double xval) {
        if (!this._hasSeasonalVariation || this.getNumberCurves() == 1) {
            return this.interpolate(xval);
        }
        double value = Double.NEGATIVE_INFINITY;
        if (!this.checkTimeArrays()) {
            return value;
        }
        if (this._interpValues == null) {
            return value;
        }
        if (!this.canInterpX()) {
            return value;
        }
        int numCurves = this.getNumberCurves();
        for (int k = 0; k < numCurves; ++k) {
            this._interpValues[k] = this.interpolate(xval, k);
        }
        this._interpValues[numCurves] = this._interpValues[0];
        this._time_y2array = null;
        this._time_y2arrayLeap = null;
        switch (this._timeInterpolationType) {
            case 0: {
                return this.timeInterpolateValue(interpTime);
            }
            case 1: {
                return this.timeInterpolateValueCubicSpline(interpTime);
            }
            case 2: {
                return this.timeInterpolateStepValue(interpTime);
            }
        }
        return this.timeInterpolateValue(interpTime);
    }

    private double timeInterpolate(RunTimeStep runtime) {
        HecTime htime = runtime.getHecTime();
        return this.timeInterpolate(htime);
    }

    private double timeInterpolate(HecTime htime) {
        double value = Double.NEGATIVE_INFINITY;
        if (this._interpValues == null || this._interpTimes == null || this._interpTimes.length < 2) {
            return value;
        }
        if (this._interpTimesLeap == null) {
            this.makeLeapYearTimeArray();
        }
        this._interpTimes = this._interpTimesNoLeap;
        if (HecTime.isLeap((int)htime.year())) {
            this._interpTimes = this._interpTimesLeap;
            this._isLeapYear = true;
        }
        int interpTime = this.intervalTime(htime);
        switch (this._timeInterpolationType) {
            case 0: {
                value = this.timeInterpolateValue(interpTime);
                break;
            }
            case 1: {
                value = this.timeInterpolateValueCubicSpline(interpTime);
                break;
            }
            case 2: {
                value = this.timeInterpolateStepValue(interpTime);
                break;
            }
            default: {
                value = this.timeInterpolateValue(interpTime);
            }
        }
        this._interpTimes = this._interpTimesNoLeap;
        this._isLeapYear = false;
        return value;
    }

    private double timeInterpolate(RunTime runtime) {
        double value = Double.NEGATIVE_INFINITY;
        if (this._interpValues == null || this._interpTimes == null || this._interpTimes.length < 2) {
            return value;
        }
        int interpTime = this.intervalTime(runtime);
        switch (this._timeInterpolationType) {
            case 0: {
                return this.timeInterpolateValue(interpTime);
            }
            case 1: {
                return this.timeInterpolateValueCubicSpline(interpTime);
            }
            case 2: {
                return this.timeInterpolateStepValue(interpTime);
            }
        }
        return this.timeInterpolateValue(interpTime);
    }

    private double timeInterpolateValue(int interpTime) {
        double value = Double.NEGATIVE_INFINITY;
        int k = this.findTimeInterval(interpTime);
        if (k < 0) {
            return value;
        }
        if (k >= this._interpTimes.length - 1) {
            return this._interpValues[this._interpTimes.length - 1];
        }
        double fact = (double)(interpTime - this._interpTimes[k]) / (double)(this._interpTimes[k + 1] - this._interpTimes[k]);
        value = fact * (this._interpValues[k + 1] - this._interpValues[k]) + this._interpValues[k];
        return value;
    }

    private double timeInterpolateStepValue(int interpTime) {
        double value = Double.NEGATIVE_INFINITY;
        int k = this.findTimeInterval(interpTime);
        if (k < 0) {
            return value;
        }
        if (k >= this._interpTimes.length - 1) {
            return this._interpValues[this._interpTimes.length - 1];
        }
        value = this._interpValues[k];
        return value;
    }

    private double timeInterpolateValueCubicSpline(int interpTime) {
        double value = Double.NEGATIVE_INFINITY;
        int k = this.findTimeInterval(interpTime);
        if (k < 0) {
            return value;
        }
        if (k == this._interpTimes.length - 1) {
            return this._interpValues[this._interpTimes.length - 1];
        }
        if (k > this._interpTimes.length - 1) {
            return value;
        }
        double yp0 = 0.0;
        double ypn = 0.0;
        if (this._time_y2array == null) {
            int npts = this._interpTimesNoLeap.length + 2;
            int[] tmpTimeArray = new int[npts];
            double[] tmpDataArray = new double[npts];
            double[] tmpY2array = new double[npts];
            System.arraycopy(this._interpTimesNoLeap, 0, tmpTimeArray, 1, this._interpTimesNoLeap.length);
            System.arraycopy(this._interpValues, 0, tmpDataArray, 1, this._interpTimesNoLeap.length);
            int nyears = this.getYears();
            tmpTimeArray[0] = this._interpTimesNoLeap[this._interpTimesNoLeap.length - 2] - 525600 * nyears;
            tmpDataArray[0] = this._interpValues[this._interpTimesNoLeap.length - 2];
            tmpTimeArray[npts - 1] = this._interpTimesNoLeap[1] + 525600 * nyears;
            tmpDataArray[npts - 1] = this._interpValues[1];
            tmpY2array = Interpolate.cubicSpline((int[])tmpTimeArray, (double[])tmpDataArray, (double)yp0, (double)ypn, (int)npts);
            this._time_y2array = new double[this._interpTimesNoLeap.length];
            System.arraycopy(tmpY2array, 1, this._time_y2array, 0, this._interpTimesNoLeap.length);
            if (this._interpTimesLeap == null) {
                this.makeLeapYearTimeArray();
            }
            System.arraycopy(this._interpTimesLeap, 0, tmpTimeArray, 1, this._interpTimesLeap.length);
            tmpTimeArray[0] = this._interpTimesNoLeap[this._interpTimesNoLeap.length - 2] - 525600 * nyears;
            if (tmpTimeArray[0] < 60) {
                tmpTimeArray[0] = tmpTimeArray[0] - 1;
            }
            tmpTimeArray[npts - 1] = this._interpTimesLeap[1] + 525600 * nyears;
            if (this._interpTimesLeap[1] < 60) {
                int n = npts - 1;
                tmpTimeArray[n] = tmpTimeArray[n] + 1;
            }
            tmpY2array = Interpolate.cubicSpline((int[])tmpTimeArray, (double[])tmpDataArray, (double)yp0, (double)ypn, (int)npts);
            this._time_y2arrayLeap = new double[this._interpTimesLeap.length];
            System.arraycopy(tmpY2array, 1, this._time_y2arrayLeap, 0, this._interpTimesLeap.length);
        }
        value = this._isLeapYear ? Interpolate.splineInterpolate((int[])this._interpTimesLeap, (double[])this._interpValues, (double[])this._time_y2arrayLeap, (int)interpTime, (int)this._interpTimesLeap.length, (int)k) : Interpolate.splineInterpolate((int[])this._interpTimesNoLeap, (double[])this._interpValues, (double[])this._time_y2array, (int)interpTime, (int)this._interpTimesNoLeap.length, (int)k);
        return value;
    }

    int intervalTime(RunTimeStep runtime) {
        HecTime t = runtime.getHecTime();
        return this.intervalTime(t);
    }

    int intervalTime(HecTime t) {
        int simYear = 0;
        if (t == null) {
            return 0;
        }
        int rundate = simYear * 365 * 1440 + t.dayOfYear() * 1440 + t.minutesSinceMidnight();
        if (rundate > this._interpTimes[this._interpTimes.length - 1]) {
            int nyears = this.getYears();
            int shift_time = 525600 * nyears;
            while (rundate > this._interpTimes[this._interpTimes.length - 1]) {
                rundate -= shift_time;
            }
        }
        return rundate;
    }

    private int intervalTime(RunTime runtime) {
        int simYear = 0;
        int rundate = simYear * 365 * 1440 + runtime.hecJul * 1440 + runtime.hecMin;
        if (rundate > this._interpTimes[this._interpTimes.length - 1]) {
            int nyears = this.getYears();
            int shift_time = 525600 * nyears;
            while (rundate > this._interpTimes[this._interpTimes.length - 1]) {
                rundate -= shift_time;
            }
        }
        return rundate;
    }

    public int findTimeInterval(int rundate) {
        if (this._interpTimes.length < 2) {
            return -1;
        }
        int imax = this._interpTimes.length - 1;
        if (this._timeInterpInterval == imax && rundate > this._interpTimes[imax]) {
            return imax;
        }
        if (this._timeInterpInterval < 0 || this._timeInterpInterval >= imax || rundate < this._interpTimes[this._timeInterpInterval] || rundate > this._interpTimes[this._timeInterpInterval + 1]) {
            this._timeInterpInterval = Interpolate.bisearch((int[])this._interpTimes, (int)rundate, (int)this._interpTimes.length);
        }
        if (this._timeInterpInterval < 0 && this._timeInterpInterval > imax) {
            System.out.println(" SeasonalPairedValues linear interpolation outside time interval ");
            System.out.println(" rundate = " + rundate + "  timeInterpInterval = " + this._timeInterpInterval);
            return -1;
        }
        return this._timeInterpInterval;
    }

    public boolean resetWaterYearStart(String waterYearStart) {
        return false;
    }

    public static String getDateString(int minutes) {
        if (minutes < 0) {
            return " ";
        }
        int iday = minutes / 1440;
        int iminutes = minutes - iday * 1440;
        String dateStr = HecTime.juldat((int)iday, (int)4);
        return dateStr.substring(0, 5);
    }

    public static int getJulianMinute(String dateStr) {
        int startYear = 1900;
        return SeasonalPairedValues.getJulianMinute(dateStr, startYear);
    }

    public static int getJulianMinute(String dateStr, int startYear) {
        int jminutes = Integer.MIN_VALUE;
        if (dateStr == null || ((String)dateStr).equals("")) {
            return jminutes;
        }
        if (((String)dateStr).length() == 5) {
            dateStr = (String)dateStr + Integer.toString(startYear);
        }
        HecTime htime = new HecTime((String)dateStr);
        htime.set((String)dateStr, "0000");
        jminutes = htime.value();
        return jminutes;
    }

    public static void main(String[] args) {
        int tmp = SeasonalPairedValues.getJulianMinute("01MAY1901");
        int lowerTimeLimit = SeasonalPairedValues.getJulianMinute("01JAN", 1800);
        int upperTimeLimit = SeasonalPairedValues.getJulianMinute("01JAN", 3002);
        boolean dum = false;
    }

    public int getTime(int id) {
        if (id < 0 || id >= this.size()) {
            return Integer.MIN_VALUE;
        }
        if (this._timeArray == null) {
            return Integer.MIN_VALUE;
        }
        return this._timeArray[id];
    }

    public int getYears() {
        if (this._timeArray == null || this._timeArray.length < 1) {
            return -1;
        }
        int npts = this._timeArray.length;
        int timdur = this._timeArray[npts - 1] - this._timeArray[0];
        int nyears = timdur / 525600;
        if (timdur % 525600 > 0) {
            ++nyears;
        }
        this._nyears = nyears;
        return this._nyears;
    }

    public Object getFieldObject(Field fld) {
        try {
            Object obj = fld.get((Object)this);
            return obj;
        }
        catch (IllegalAccessException e) {
            return super.getFieldObject(fld);
        }
    }

    public boolean setFieldObject(Field fld, Object fobj) {
        try {
            fld.set((Object)this, fobj);
            return true;
        }
        catch (IllegalAccessException e) {
            return super.setFieldObject(fld, fobj);
        }
        catch (IllegalArgumentException e) {
            return super.setFieldObject(fld, fobj);
        }
    }
}

