/*
 * Decompiled with CFR 0.152.
 */
package hec.model;

import hec.data.ParamDouble;
import hec.heclib.util.HecTime;
import hec.heclib.util.HecTimeArray;
import hec.heclib.util.stringContainer;
import hec.model.SeasonalRecord;
import hec.model.SeasonalRecordExt;
import java.text.SimpleDateFormat;
import java.time.ZoneId;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import java.util.Vector;
import rma.swing.table.RmaTableModel;
import rma.swing.table.RmaTableModelInterface;
import rma.util.RMAIO;

public class SeasonalRecWithTimeTableModel
extends RmaTableModel
implements RmaTableModelInterface {
    private final ZoneId _timeZoneId;
    private static final ZoneId DEFAULT_TIME_ZONE = ZoneId.systemDefault();
    SeasonalRecord _sv;
    SeasonalRecordExt _sve;

    public SeasonalRecWithTimeTableModel() {
        this(DEFAULT_TIME_ZONE);
    }

    public SeasonalRecWithTimeTableModel(String[] colNames, boolean[] editable) {
        this(colNames, editable, DEFAULT_TIME_ZONE);
    }

    public SeasonalRecWithTimeTableModel(String[] colNames, SeasonalRecord sv, boolean[] editable) {
        this(colNames, sv, editable, DEFAULT_TIME_ZONE);
    }

    public SeasonalRecWithTimeTableModel(String[] colNames, SeasonalRecordExt sve, boolean[] editable) {
        this(colNames, sve, editable, DEFAULT_TIME_ZONE);
    }

    public SeasonalRecWithTimeTableModel(ZoneId timeZoneId) {
        this._timeZoneId = timeZoneId;
    }

    public SeasonalRecWithTimeTableModel(String[] colNames, boolean[] editable, ZoneId timeZoneId) {
        super(colNames, new Object[0][0], editable);
        this._timeZoneId = timeZoneId;
    }

    public SeasonalRecWithTimeTableModel(String[] colNames, SeasonalRecord sv, boolean[] editable, ZoneId timeZoneId) {
        super(colNames, new Object[0][0], editable);
        this._timeZoneId = timeZoneId;
        this.parseSeasonalRecord(sv, "");
    }

    public SeasonalRecWithTimeTableModel(String[] colNames, SeasonalRecordExt sve, boolean[] editable, ZoneId timeZoneId) {
        super(colNames, new Object[0][0], editable);
        this._timeZoneId = timeZoneId;
        this.parseSeasonalRecord(sve, "");
    }

    public RmaTableModel getModel() {
        return this;
    }

    public void setSeasonalRecord(SeasonalRecord sv) {
        this.setSeasonalRecord(sv, "");
    }

    public void setSeasonalRecord(SeasonalRecord sv, String defaultTime) {
        if (sv != null) {
            this.clearAll();
            this.parseSeasonalRecord(sv, defaultTime);
            this.fireTableDataChanged();
        }
    }

    public void setSeasonalRecord(SeasonalRecordExt sve, String defaultTime) {
        if (sve != null) {
            this.clearAll();
            this.parseSeasonalRecord(sve, defaultTime);
            this.fireTableDataChanged();
        }
    }

    private void parseSeasonalRecord(SeasonalRecord sv, String defaultTime) {
        this._sv = sv;
        int[] timeArray = sv.getTimeArray();
        double[] dataArray = sv.getDataArray();
        TimeZone tz = TimeZone.getTimeZone(this._timeZoneId);
        if (timeArray == null || timeArray.length < 2 || dataArray == null) {
            if (defaultTime != null && defaultTime.length() > 0) {
                Date date = null;
                try {
                    SimpleDateFormat dateFormat = new SimpleDateFormat("ddMMM HHmm");
                    dateFormat.setCalendar(new GregorianCalendar(tz));
                    date = dateFormat.parse(defaultTime);
                }
                catch (Exception e) {
                    System.out.println("ERROR : <SeasonalRecWithTimeTableModel.parseSeasonalRecord()> Error parsing default date and time");
                    System.out.println(e.getMessage());
                    e.printStackTrace();
                }
                if (date != null) {
                    Vector<HecTimeArray> row = new Vector<HecTimeArray>(this.getColumnCount());
                    HecTimeArray hTimeArray = new HecTimeArray(1);
                    hTimeArray.setElementAt(new HecTime(date, this._sv.getGmtOffset() * 60), 0);
                    hTimeArray.setTimeZone(tz);
                    row.addElement(hTimeArray);
                    row.addElement(hTimeArray);
                    this.addRow(row);
                }
            }
            for (int i = 0; i < 10; ++i) {
                this.addRow(new Vector(this.getColumnCount()));
            }
            return;
        }
        int nitems = timeArray.length;
        --nitems;
        long milliTime = 0L;
        stringContainer timeStr = new stringContainer();
        ParamDouble pd = null;
        for (int irow = 0; irow < nitems; ++irow) {
            Vector<Object> row = new Vector<Object>(3);
            if (timeArray[irow] == Integer.MIN_VALUE) continue;
            int iday = timeArray[irow] / 1440;
            int iminutes = timeArray[irow] - iday * 1440;
            String dateStr = HecTime.juldat((int)iday, (int)4);
            HecTime.m2ihm((int)iminutes, (stringContainer)timeStr);
            milliTime = timeArray[irow] - 1440;
            Date date = new Date(milliTime *= 60000L);
            HecTime hTime = new HecTime(date, 0);
            this.setGmtOffset(this._sv.getGmtOffset());
            HecTimeArray hTimeArray = new HecTimeArray(1);
            hTimeArray.setElementAt(hTime, 0);
            hTimeArray.setTimeZone(tz);
            row.addElement(hTimeArray);
            row.addElement(hTimeArray);
            if (dataArray[irow] != Double.NEGATIVE_INFINITY) {
                pd = new ParamDouble(dataArray[irow], this._sv.getParameterId(), this._sv.getUnitSystem(), 2);
                row.add(pd);
            } else {
                row.add("");
            }
            this.addRow(row);
        }
        for (int i = 0; i < 10; ++i) {
            this.addRow(new Vector(this.getColumnCount()));
        }
    }

    private void parseSeasonalRecord(SeasonalRecordExt sve, String defaultTime) {
        this._sve = sve;
        int[] timeArray = sve.getTimeArray();
        double[][] dataArray = sve.getDataArray();
        String[] curveLabels = sve.getCurveLabels();
        TimeZone tz = TimeZone.getTimeZone(this._timeZoneId);
        if (timeArray == null || timeArray.length < 2 || dataArray == null) {
            if (defaultTime != null && defaultTime.length() > 0) {
                Date date = null;
                try {
                    SimpleDateFormat dateFormat = new SimpleDateFormat("ddMMM HHmm");
                    dateFormat.setCalendar(new GregorianCalendar(tz));
                    date = dateFormat.parse(defaultTime);
                }
                catch (Exception e) {
                    System.out.println("ERROR : <SeasonalRecWithTimeTableModel.parseSeasonalRecord()> Error parsing default date and time");
                    System.out.println(e.getMessage());
                    e.printStackTrace();
                }
                if (date != null) {
                    Vector<HecTimeArray> row = new Vector<HecTimeArray>(this.getColumnCount());
                    HecTimeArray hTimeArray = new HecTimeArray(1);
                    hTimeArray.setElementAt(new HecTime(date, this._sve.getGmtOffset() * 60), 0);
                    hTimeArray.setTimeZone(tz);
                    row.addElement(hTimeArray);
                    row.addElement(hTimeArray);
                    this.addRow(row);
                }
            }
            for (int i = 0; i < 10; ++i) {
                this.addRow(new Vector(this.getColumnCount()));
            }
            return;
        }
        int nitems = timeArray.length;
        --nitems;
        long milliTime = 0L;
        stringContainer timeStr = new stringContainer();
        ParamDouble pd = null;
        for (int irow = 0; irow < nitems; ++irow) {
            Vector<Object> row = new Vector<Object>(3);
            if (timeArray[irow] == Integer.MIN_VALUE) continue;
            int iday = timeArray[irow] / 1440;
            int iminutes = timeArray[irow] - iday * 1440;
            String dateStr = HecTime.juldat((int)iday, (int)4);
            HecTime.m2ihm((int)iminutes, (stringContainer)timeStr);
            milliTime = timeArray[irow] - 1440;
            Date date = new Date(milliTime *= 60000L);
            HecTime hTime = new HecTime(date, 0);
            this.setGmtOffset(this._sve.getGmtOffset());
            HecTimeArray hTimeArray = new HecTimeArray(1);
            hTimeArray.setElementAt(hTime, 0);
            hTimeArray.setTimeZone(tz);
            row.addElement(hTimeArray);
            row.addElement(hTimeArray);
            for (int icol = 0; icol < curveLabels.length; ++icol) {
                if (icol >= dataArray.length) {
                    row.add("");
                    continue;
                }
                if (dataArray[icol][irow] != Double.NEGATIVE_INFINITY) {
                    pd = new ParamDouble(dataArray[icol][irow], this._sve.getParameterId(), this._sve.getUnitSystem(), this.countDecimalPlaces(dataArray[icol][irow]));
                    row.add(pd);
                    continue;
                }
                row.add("");
            }
            this.addRow(row);
        }
        if (nitems == 0) {
            Vector<String> row1 = new Vector<String>(this.getColumnCount());
            row1.addElement(defaultTime);
            this.addRow(row1);
        }
        for (int i = 0; i < 10; ++i) {
            this.addRow(new Vector(this.getColumnCount()));
        }
    }

    public void setValueAt(Object val, int row, int col) {
        if (row < 0 || col < 0) {
            return;
        }
        if (col == 0 || col == 1) {
            super.setValueAt(val, row, 0);
            return;
        }
        super.setValueAt(val, row, col);
    }

    public Object getValueAt(int row, int col) {
        if (col == 0 || col == 1) {
            Object val = super.getValueAt(row, 0);
            if (val == null || val.toString().isBlank()) {
                val = new HecTimeArray(0);
                ((HecTimeArray)val).setTimeZone(TimeZone.getTimeZone(this._timeZoneId));
            }
            return val;
        }
        Object obj = super.getValueAt(row, col);
        if (obj != null && !(obj instanceof ParamDouble) && this._sv != null) {
            ParamDouble pd = new ParamDouble(RMAIO.parseDouble((Object)obj), this._sv.getParameterId());
            pd.setUnitSystem(this._sv.getUnitSystem());
            super.setValueAt((Object)pd, row, col);
            return pd;
        }
        return obj;
    }

    public int getColumnParameter(int col) {
        if (this._sv == null) {
            return -1;
        }
        if (col < 0 || col == 1 || col == 0) {
            return -1;
        }
        return this._sv.getParameterId();
    }

    public void storeData(SeasonalRecord sv) {
        String timeStr;
        String dateStr;
        Vector rows = this.getDataVector();
        int npts = 0;
        for (int z = 0; z < rows.size(); ++z) {
            Vector row = (Vector)rows.elementAt(z);
            Object cellVal0 = row.elementAt(0);
            Object cellVal2 = row.elementAt(2);
            if (cellVal0 == null || cellVal0.toString().equals("") || cellVal2 == null || cellVal2.toString().equals("")) continue;
            HecTime hTime = ((HecTimeArray)row.elementAt(0)).element(0);
            dateStr = hTime.date(4);
            timeStr = hTime.time();
            if (dateStr == null || dateStr.equals("")) continue;
            ++npts;
        }
        int[] timeArray = new int[npts + 1];
        double[] dataArray = new double[npts + 1];
        int iyear = 0;
        int icnt = -1;
        int[] ymd = new int[3];
        int[] hecjul = new int[1];
        int prevTime = 0;
        int hoursOffset = this.getGmtOffset();
        if (this._sv != null) {
            hoursOffset = this._sv.getGmtOffset();
        }
        String dateStrPrev = "";
        for (int irow = 0; irow < rows.size(); ++irow) {
            Vector row = (Vector)rows.elementAt(irow);
            Object cellVal0 = row.elementAt(0);
            Object cellVal2 = row.elementAt(2);
            if (cellVal0 == null || cellVal0.toString().equals("") || cellVal2 == null || cellVal2.toString().equals("")) continue;
            HecTime hTime = ((HecTimeArray)row.elementAt(0)).element(0);
            dateStr = hTime.date(4);
            timeStr = hTime.time();
            int itime = (int)(hTime.getTimeInMillis() / 60000L) + 1440;
            String valueStr = row.elementAt(2).toString();
            if (dateStr == null || dateStr.equals("") || valueStr == null || valueStr.equals("")) continue;
            ++icnt;
            if (irow == 0) {
                prevTime = itime;
            } else {
                if (itime < prevTime) {
                    ++iyear;
                }
                prevTime = itime;
                itime += iyear * 1440 * 365;
            }
            if (itime == Integer.MIN_VALUE) {
                timeArray[icnt] = itime;
                dataArray[icnt] = Double.NEGATIVE_INFINITY;
                continue;
            }
            timeArray[icnt] = itime;
            dataArray[icnt] = RMAIO.parseDouble((String)valueStr);
        }
        int nyears = 1;
        if (npts > 1) {
            int minutes = timeArray[npts - 1] - timeArray[0];
            nyears = minutes / 525960 + 1;
        }
        timeArray[npts] = timeArray[0] + nyears * 1440 * 365;
        dataArray[npts] = dataArray[0];
        sv.setArrays(timeArray, dataArray);
        if (this._sv != null) {
            sv.setParameterId(this._sv.getParameterId());
            sv.setUnitSystem(this._sv.getUnitSystem());
            sv.setGmtOffset(this._sv.getGmtOffset());
        }
        sv.setGmtOffset(hoursOffset);
    }

    public void storeData(SeasonalRecordExt sve) {
        String timeStr;
        String dateStr;
        Vector rows = this.getDataVector();
        int npts = 0;
        for (int z = 0; z < rows.size(); ++z) {
            Vector row = (Vector)rows.elementAt(z);
            Object cellVal0 = row.elementAt(0);
            Object cellVal2 = row.elementAt(2);
            if (cellVal0 == null || cellVal0.toString().equals("") || cellVal2 == null || cellVal2.toString().equals("")) continue;
            HecTime hTime = ((HecTimeArray)row.elementAt(0)).element(0);
            dateStr = hTime.date(4);
            timeStr = hTime.time();
            if (dateStr == null || dateStr.equals("")) continue;
            ++npts;
        }
        int nCol = 0;
        int nRow = rows.size();
        if (rows.size() > 0 && npts > 0) {
            nCol = this.getColumnCount() - 2;
            nRow = npts + 1;
        }
        int[] timeArray = new int[npts + 1];
        double[][] dataArray = new double[npts + 1][npts + 1];
        String[] curveLabels = new String[npts + 1];
        if (nCol > 0) {
            dataArray = new double[nCol + 1][npts + 1];
            curveLabels = new String[nCol + 1];
        }
        int iyear = 0;
        int icnt = -1;
        int prevTime = 0;
        int hoursOffset = this.getGmtOffset();
        if (this._sve != null) {
            hoursOffset = this._sve.getGmtOffset();
        }
        String dateStrPrev = "";
        for (int irow = 0; irow < nRow; ++irow) {
            Vector row = (Vector)rows.elementAt(irow);
            Object cellVal0 = row.elementAt(0);
            Object cellVal2 = row.elementAt(2);
            if (cellVal0 == null || cellVal0.toString().equals("") || cellVal2 == null || cellVal2.toString().equals("")) continue;
            HecTime hTime = ((HecTimeArray)row.elementAt(0)).element(0);
            dateStr = hTime.date(4);
            timeStr = hTime.time();
            int itime = (int)(hTime.getTimeInMillis() / 60000L) + 1440;
            String valueStr = row.elementAt(2).toString();
            if (dateStr == null || dateStr.equals("") || valueStr == null || valueStr.equals("")) continue;
            ++icnt;
            if (irow == 0) {
                prevTime = itime;
            } else if (itime < prevTime) {
                ++iyear;
            }
            for (int icol = 2; icol < nCol + 2; ++icol) {
                valueStr = row.elementAt(icol).toString();
                if (dateStr == null && dateStr.equals("") && cellVal2 == null && cellVal2.toString().equals("")) continue;
                prevTime = itime;
                if ((itime += iyear * 1440 * 365) == Integer.MIN_VALUE) {
                    timeArray[icnt] = itime;
                    dataArray[icnt][icol - 2] = Double.NEGATIVE_INFINITY;
                } else {
                    timeArray[icnt] = itime;
                    dataArray[icol - 2][icnt] = RMAIO.parseDouble((String)valueStr);
                }
                curveLabels[icol - 2] = this.getColumnName(icol);
            }
        }
        int nyears = 1;
        if (npts > 1) {
            int minutes = timeArray[npts - 1] - timeArray[0];
            nyears = minutes / 525960 + 1;
        }
        timeArray[npts] = timeArray[0] + nyears * 1440 * 365;
        for (int icol = 0; icol < nCol; ++icol) {
            dataArray[icol][npts] = dataArray[icol][0];
        }
        sve.setArrays(timeArray, dataArray, curveLabels);
        if (this._sv != null) {
            sve.setParameterId(this._sv.getParameterId());
            sve.setUnitSystem(this._sv.getUnitSystem());
            sve.setGmtOffset(this._sv.getGmtOffset());
        }
        sve.setGmtOffset(hoursOffset);
    }

    public int countDecimalPlaces(double value) {
        String sVal = Double.toString(value);
        int length = sVal.length();
        int decimalLoc = sVal.indexOf(".");
        if (decimalLoc < 0) {
            return 0;
        }
        return length - decimalLoc - 1;
    }
}

