/*
 * Decompiled with CFR 0.152.
 */
package hec.model;

import hec.data.ParamDouble;
import hec.heclib.util.HecTime;
import hec.heclib.util.stringContainer;
import hec.model.SeasonalRecord;
import hec.model.SeasonalRecordExt;
import java.util.Vector;
import rma.swing.table.RmaTableModel;
import rma.swing.table.RmaTableModelInterface;
import rma.util.RMAIO;

public class SeasonalRecordTableModel
extends RmaTableModel
implements RmaTableModelInterface {
    SeasonalRecord _sv;
    SeasonalRecordExt _sve;

    public SeasonalRecordTableModel() {
    }

    public SeasonalRecordTableModel(String[] colNames, boolean[] editable) {
        super(colNames, new Object[0][0], editable);
    }

    public SeasonalRecordTableModel(String[] colNames, SeasonalRecord sv, boolean[] editable) {
        this(colNames, sv, editable, "");
    }

    public SeasonalRecordTableModel(String[] colNames, SeasonalRecordExt sve, boolean[] editable) {
        this(colNames, sve, editable, "");
    }

    public SeasonalRecordTableModel(String[] colNames, SeasonalRecord sv, boolean[] editable, String defaultStartYear) {
        super(colNames, new Object[0][0], editable);
        this.parseSeasonalRecord(sv, defaultStartYear);
    }

    public SeasonalRecordTableModel(String[] colNames, SeasonalRecordExt sve, boolean[] editable, String defaultStartYear) {
        super(colNames, new Object[0][0], editable);
        this.parseSeasonalRecord(sve, defaultStartYear);
    }

    public void setSeasonalRecord(SeasonalRecord sv, String defaultStartYear) {
        if (sv != null) {
            this.clearAll();
            this.parseSeasonalRecord(sv, defaultStartYear);
            this.fireTableDataChanged();
        }
    }

    public void setSeasonalRecord(SeasonalRecordExt sve, String defaultStartYear) {
        if (sve != null) {
            this.clearAll();
            this.parseSeasonalRecord(sve, defaultStartYear);
            this.fireTableDataChanged();
        }
    }

    private void parseSeasonalRecord(SeasonalRecord sv, String defaultStartYear) {
        this._sv = sv;
        int[] timeArray = sv.getTimeArray();
        double[] dataArray = sv.getDataArray();
        if (timeArray == null || dataArray == null) {
            Vector<String> row1 = new Vector<String>(this.getColumnCount());
            row1.addElement(defaultStartYear);
            this.addRow(row1);
            for (int i = 1; i < 10; ++i) {
                this.addRow(new Vector(this.getColumnCount()));
            }
            return;
        }
        int nitems = timeArray.length;
        --nitems;
        stringContainer timeStr = new stringContainer();
        for (int irow = 0; irow < nitems; ++irow) {
            Vector<String> row = new Vector<String>(2);
            if (timeArray[irow] == Integer.MIN_VALUE) continue;
            int iday = timeArray[irow] / 1440;
            int iminutes = timeArray[irow] - iday * 1440;
            String dateStr = HecTime.juldat((int)iday, (int)4);
            row.add(dateStr.substring(0, 5));
            if (dataArray[irow] != Double.NEGATIVE_INFINITY) {
                row.add((String)new ParamDouble(dataArray[irow], sv.getParameterId(), sv.getUnitSystem(), this.countDecimalPlaces(dataArray[irow])));
            } else {
                row.add("");
            }
            this.addRow(row);
        }
        if (nitems == 0) {
            Vector<String> row1 = new Vector<String>(this.getColumnCount());
            row1.addElement(defaultStartYear);
            this.addRow(row1);
        }
        for (int i = 0; i < 10; ++i) {
            this.addRow(new Vector(this.getColumnCount()));
        }
    }

    private void parseSeasonalRecord(SeasonalRecordExt sve, String defaultStartYear) {
        this._sve = sve;
        int[] timeArray = sve.getTimeArray();
        double[][] dataArray = sve.getDataArray();
        String[] curveLabels = sve.getCurveLabels();
        if (timeArray == null || dataArray == null) {
            Vector<String> row1 = new Vector<String>(this.getColumnCount());
            row1.addElement(defaultStartYear);
            this.addRow(row1);
            for (int i = 1; i < 10; ++i) {
                this.addRow(new Vector(this.getColumnCount()));
            }
            return;
        }
        int nitems = timeArray.length;
        if (nitems > 1) {
            --nitems;
        }
        stringContainer timeStr = new stringContainer();
        int numYCol = this.getColumnCount() - 1;
        if (dataArray != null && dataArray.length < numYCol) {
            numYCol = dataArray.length;
        }
        for (int irow = 0; irow < nitems; ++irow) {
            Vector<String> row = new Vector<String>(2);
            if (timeArray[irow] == Integer.MIN_VALUE) continue;
            int iday = timeArray[irow] / 1440;
            int iminutes = timeArray[irow] - iday * 1440;
            String dateStr = HecTime.juldat((int)iday, (int)4);
            row.add(dateStr.substring(0, 5));
            for (int icol = 0; icol < numYCol; ++icol) {
                if (icol >= dataArray.length) {
                    row.add("");
                    continue;
                }
                if (dataArray[icol][irow] != Double.NEGATIVE_INFINITY) {
                    row.add((String)new ParamDouble(dataArray[icol][irow], sve.getParameterId(), sve.getUnitSystem(), this.countDecimalPlaces(dataArray[icol][irow])));
                    continue;
                }
                row.add("");
            }
            this.addRow(row);
        }
        if (nitems == 0) {
            Vector<String> row1 = new Vector<String>(this.getColumnCount());
            row1.addElement(defaultStartYear);
            this.addRow(row1);
        }
        for (int i = 0; i < 10; ++i) {
            this.addRow(new Vector(this.getColumnCount()));
        }
    }

    public int countDecimalPlaces(double value) {
        String sVal = Double.toString(value);
        int length = sVal.length();
        int decimalLoc = sVal.indexOf(".");
        if (decimalLoc < 0) {
            return 0;
        }
        return length - decimalLoc - 1;
    }

    public void setColumnParameters(int[] params) {
        super.setColumnParameters(params);
        if (params != null && params.length > 1 && this._sv != null) {
            this._sv.setParameterId(params[1]);
        }
    }

    public int getColumnParameter(int col) {
        if (this._sv == null) {
            return -1;
        }
        if (col > 0) {
            return this._sv.getParameterId();
        }
        return -1;
    }

    public Object getValueAt(int row, int col) {
        Object obj = super.getValueAt(row, col);
        if (col == 0) {
            return obj;
        }
        if (!(obj instanceof ParamDouble) && this._sv != null) {
            ParamDouble pd = new ParamDouble(RMAIO.parseDouble((Object)obj), this._sv.getParameterId());
            pd.setUnitSystem(this._sv.getUnitSystem());
            return pd;
        }
        return obj;
    }

    public RmaTableModel getModel() {
        return this;
    }

    public void storeData(SeasonalRecord sv) {
        Vector rows = this.getDataVector();
        int npts = 0;
        for (int z = 0; z < rows.size(); ++z) {
            Vector row = (Vector)rows.elementAt(z);
            Object cellVal0 = row.elementAt(0);
            Object cellVal1 = row.elementAt(1);
            if (cellVal0 == null || cellVal0.toString().equals("") || cellVal1 == null || cellVal1.toString().equals("")) continue;
            ++npts;
        }
        int[] timeArray = new int[npts + 1];
        double[] dataArray = new double[npts + 1];
        int iyear = 1900;
        int icnt = -1;
        int[] ymd = new int[3];
        int[] hecjul = new int[1];
        Object dateStrPrev = "";
        for (int irow = 0; irow < rows.size(); ++irow) {
            Vector row = (Vector)rows.elementAt(irow);
            Object dateStr = (String)row.elementAt(0);
            Object valueObj = row.elementAt(1);
            if (dateStr == null || ((String)dateStr).equals("") || valueObj == null || valueObj.toString().equals("")) continue;
            ++icnt;
            if (irow == 0) {
                dateStrPrev = dateStr;
                dateStr = (String)dateStr + Integer.toString(iyear);
            } else {
                int[] jul1 = new int[1];
                int[] jul2 = new int[1];
                HecTime.datjul((String)dateStr, (int[])jul1);
                HecTime.datjul((String)dateStrPrev, (int[])jul2);
                if (jul1[0] < jul2[0]) {
                    ++iyear;
                }
                dateStrPrev = dateStr;
                dateStr = (String)dateStr + Integer.toString(iyear);
            }
            if (dateStr == null || ((String)dateStr).equals("") || valueObj == null || valueObj.toString().equals("")) continue;
            int istat = HecTime.datjul((String)dateStr, (int[])hecjul);
            int jday = hecjul[0];
            if (jday == Integer.MIN_VALUE) {
                timeArray[icnt] = jday;
                dataArray[icnt] = Double.NEGATIVE_INFINITY;
                continue;
            }
            timeArray[icnt] = jday * 1440;
            dataArray[icnt] = RMAIO.parseDouble(valueObj);
        }
        int nyears = 1;
        if (npts > 1) {
            int minutes = timeArray[npts - 1] - timeArray[0];
            nyears = minutes / 525960 + 1;
        }
        timeArray[npts] = timeArray[0] + nyears * 1440 * 365;
        dataArray[npts] = dataArray[0];
        sv.setArrays(timeArray, dataArray);
        if (this._sv != null) {
            sv.setParameterId(this._sv.getParameterId());
            sv.setUnitSystem(this._sv.getUnitSystem());
        }
    }

    public void storeData(SeasonalRecordExt sve) {
        String[] curveValues;
        double[][] dataArray;
        Vector rows = this.getDataVector();
        int npts = 0;
        for (int z = 0; z < rows.size(); ++z) {
            Vector row = (Vector)rows.elementAt(z);
            Object cellVal0 = row.elementAt(0);
            Object cellVal1 = row.elementAt(1);
            if (cellVal0 == null || cellVal0.toString().equals("") || cellVal1 == null || cellVal1.toString().equals("")) continue;
            ++npts;
        }
        int nCol = 0;
        int nRow = rows.size();
        if (rows.size() > 0 && npts > 0) {
            nCol = this.getColumnCount() - 1;
            nRow = npts + 1;
        }
        int[] timeArray = new int[npts + 1];
        if (nCol > 0) {
            dataArray = new double[nCol][npts + 1];
            curveValues = new String[nCol];
        } else {
            dataArray = new double[1][npts + 1];
            curveValues = new String[1];
        }
        int iyear = 1900;
        int icnt = -1;
        int[] ymd = new int[3];
        int[] hecjul = new int[1];
        Object dateStrPrev = "";
        for (int irow = 0; irow < nRow; ++irow) {
            Vector row = (Vector)rows.elementAt(irow);
            Object dateStr = (String)row.elementAt(0);
            Object valueObj = row.elementAt(1);
            if (dateStr == null || ((String)dateStr).equals("") || valueObj == null || valueObj.toString().equals("")) continue;
            ++icnt;
            if (irow == 0) {
                dateStrPrev = dateStr;
                dateStr = (String)dateStr + Integer.toString(iyear);
            } else {
                int[] jul1 = new int[1];
                int[] jul2 = new int[1];
                HecTime.datjul((String)dateStr, (int[])jul1);
                HecTime.datjul((String)dateStrPrev, (int[])jul2);
                if (jul1[0] < jul2[0]) {
                    ++iyear;
                }
                dateStrPrev = dateStr;
                dateStr = (String)dateStr + Integer.toString(iyear);
            }
            for (int icol = 1; icol < nCol + 1; ++icol) {
                valueObj = row.elementAt(icol);
                if (dateStr == null || ((String)dateStr).equals("") || valueObj == null || valueObj.toString().equals("")) continue;
                int istat = HecTime.datjul((String)dateStr, (int[])hecjul);
                int jday = hecjul[0];
                if (jday == Integer.MIN_VALUE) {
                    timeArray[icnt] = jday;
                    dataArray[icnt][icol - 1] = Double.NEGATIVE_INFINITY;
                } else {
                    timeArray[icnt] = jday * 1440;
                    dataArray[icol - 1][icnt] = RMAIO.parseDouble(valueObj);
                }
                curveValues[icol - 1] = this.getColumnName(icol);
            }
        }
        int nyears = 1;
        if (npts > 1) {
            int minutes = timeArray[npts - 1] - timeArray[0];
            nyears = minutes / 525960 + 1;
        }
        timeArray[npts] = timeArray[0] + nyears * 1440 * 365;
        for (int icol = 0; icol < nCol; ++icol) {
            dataArray[icol][npts] = dataArray[icol][0];
        }
        sve.setArrays(timeArray, dataArray, curveValues);
        if (this._sve != null) {
            sve.setParameterId(this._sve.getParameterId());
            sve.setUnitSystem(this._sve.getUnitSystem());
        }
    }

    public int getUnitSystem() {
        if (this._sv != null) {
            return this._sv.getUnitSystem();
        }
        return super.getUnitSystem();
    }
}

