/*
 * Decompiled with CFR 0.152.
 */
package hec.model;

import hec.heclib.util.HecTime;
import hec.model.RepeatInterval;
import java.lang.reflect.Field;

public class WeeklyRepeatInterval
extends RepeatInterval {
    private boolean[] _days = new boolean[7];

    @Override
    public synchronized Object clone() throws CloneNotSupportedException {
        WeeklyRepeatInterval ri = (WeeklyRepeatInterval)super.clone();
        if (this._days != null) {
            int len = this._days.length;
            ri._days = new boolean[len];
            System.arraycopy(this._days, 0, ri._days, 0, len);
        }
        return ri;
    }

    @Override
    public int getRepeatType() {
        return 2;
    }

    public String toString() {
        return "Weekly";
    }

    public boolean setRepeatDayOfWeek(int idx, boolean shouldRepeat) {
        if (idx < 0 || idx >= this._days.length) {
            return false;
        }
        this._days[idx] = shouldRepeat;
        return true;
    }

    public boolean[] getRepeatDays() {
        boolean[] days = new boolean[this._days.length];
        System.arraycopy(this._days, 0, days, 0, days.length);
        return days;
    }

    @Override
    protected void getNextTime(HecTime baseStartTime, HecTime stepStartTime, HecTime baseEndTime, HecTime stepEndTime, HecTime[] nextTimes) {
        HecTime start = new HecTime(baseStartTime);
        HecTime end = new HecTime(baseEndTime);
        int minutesPerWeek = 10080;
        while (end.lessThanEqualTo(stepStartTime)) {
            start.add(this._repeatNumber * minutesPerWeek);
            end.add(this._repeatNumber * minutesPerWeek);
        }
        nextTimes[0] = start;
        nextTimes[1] = end;
    }

    @Override
    public Object getFieldObject(Field fld) {
        try {
            Object obj = fld.get(this);
            return obj;
        }
        catch (IllegalAccessException e) {
            return super.getFieldObject(fld);
        }
    }

    @Override
    public boolean setFieldObject(Field fld, Object fobj) {
        try {
            fld.set(this, fobj);
            return true;
        }
        catch (IllegalAccessException e) {
            return super.setFieldObject(fld, fobj);
        }
        catch (IllegalArgumentException e) {
            return super.setFieldObject(fld, fobj);
        }
    }
}

