/*
 * Decompiled with CFR 0.152.
 */
package hec.model;

import hec.heclib.util.HecTime;
import hec.model.RepeatInterval;
import java.lang.reflect.Field;

public class YearlyRepeatInterval
extends RepeatInterval {
    @Override
    public synchronized Object clone() throws CloneNotSupportedException {
        YearlyRepeatInterval ri = (YearlyRepeatInterval)super.clone();
        return ri;
    }

    @Override
    public int getRepeatType() {
        return 4;
    }

    public String toString() {
        return "Yearly";
    }

    @Override
    protected void getNextTime(HecTime baseStartTime, HecTime stepStartTime, HecTime baseEndTime, HecTime stepEndTime, HecTime[] nextTimes) {
        HecTime start = new HecTime(baseStartTime);
        HecTime end = new HecTime(baseEndTime);
        int minutesPerYear = 525600;
        while (end.lessThanEqualTo(stepStartTime)) {
            start.increment(this._repeatNumber, minutesPerYear);
            end.increment(this._repeatNumber, minutesPerYear);
        }
        nextTimes[0] = start;
        nextTimes[1] = end;
    }

    @Override
    public Object getFieldObject(Field fld) {
        try {
            Object obj = fld.get(this);
            return obj;
        }
        catch (IllegalAccessException e) {
            return super.getFieldObject(fld);
        }
    }

    @Override
    public boolean setFieldObject(Field fld, Object fobj) {
        try {
            fld.set(this, fobj);
            return true;
        }
        catch (IllegalAccessException e) {
            return super.setFieldObject(fld, fobj);
        }
        catch (IllegalArgumentException e) {
            return super.setFieldObject(fld, fobj);
        }
    }
}

