/*
 * Decompiled with CFR 0.152.
 */
package hec.watershed.client;

import hec.appInterface.AppDaddy;
import hec.lang.NamedType;
import hec.map.WorldPt;
import hec.map.streamAlignment.StreamAlignmentIfc;
import hec.model.CommonDataList;
import hec.model.DataStruct;
import hec.watershed.client.StudySystemMapGlyph;
import hec.watershed.model.ComputationPoint;
import hec.watershed.model.ComputationPointLayer;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import rma.swing.ButtonCmdPanel;
import rma.swing.ButtonCmdPanelListener;
import rma.swing.RmaInsets;
import rma.swing.RmaJFrame;
import rma.swing.RmaJTable;
import rma.swing.table.RmaTableModelInterface;
import rma.util.RMASort;

public abstract class AbstractCompPointLayerReport
extends RmaJFrame {
    private static final int LAYER_COL = 0;
    private static final int ID_COL = 1;
    private static final int NAME_COL = 2;
    private static final int DESC_COL = 3;
    private static final int STREAM_COL = 4;
    private static final int PROJECT_COL = 5;
    private static final int STREAM_STATION_COL = 6;
    protected RmaJTable cpTable;
    private JLabel watershedNameLabel;
    private JLabel reportTypeLabel = new JLabel();
    private ButtonCmdPanel cmdPanel;
    private StreamAlignmentIfc _alignment;

    public AbstractCompPointLayerReport() {
        this.buildControls();
    }

    protected void buildControls() {
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle("Computation Points");
        this.setSize(450, 150);
        this.setLocation();
        this.watershedNameLabel = new JLabel("", 0);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 11;
        gbc.fill = 2;
        gbc.insets = RmaInsets.insets((int)0, (int)0, (int)0, (int)0);
        gbc.weightx = 1.0;
        this.getContentPane().add((Component)this.watershedNameLabel, gbc);
        this.watershedNameLabel = new JLabel("", 0);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.anchor = 11;
        gbc.fill = 2;
        gbc.insets = RmaInsets.insets((int)0, (int)0, (int)0, (int)0);
        gbc.weightx = 1.0;
        this.getContentPane().add((Component)this.watershedNameLabel, gbc);
        this.cpTable = new RmaJTable((Component)((Object)this), (Object[])new String[]{"Layer\nName", "\nID", " \nName", " \nDescription", "Stream\nName", "Project\nName", "Stream\nStation"});
        this.cpTable.setRowSorter(new TableRowSorter<TableModel>(this.cpTable.getModel()));
        this.cpTable.setMlHeaderRenderer();
        this.cpTable.setEditable(false);
        this.cpTable.setColumnEnabled(false, 1);
        this.cpTable.setDoubleCellEditor(6, true);
        this.cpTable.setColumnVisible(1, false, 0);
        this.cpTable.setCellSelectionEnabled(false);
        this.cpTable.setColumnSelectionAllowed(false);
        this.cpTable.setRowSelectionAllowed(true);
        this.cpTable.getSelectionModel().setSelectionMode(2);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.anchor = 12;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 2.0;
        this.getContentPane().add((Component)this.cpTable.getScrollPane(), gbc);
        this.cmdPanel = new ButtonCmdPanel(256);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 16;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)5, (int)5);
        gbc.fill = 2;
        this.getContentPane().add((Component)this.cmdPanel, gbc);
        this.cmdPanel.addCmdPanelListener(new ButtonCmdPanelListener(){

            public void buttonCmdActionPerformed(ActionEvent e) {
                switch (e.getID()) {
                    case 256: {
                        if (AbstractCompPointLayerReport.this.isModified()) {
                            // empty if block
                        }
                        AbstractCompPointLayerReport.this.setVisible(false);
                        break;
                    }
                    case 4: {
                        AbstractCompPointLayerReport.this.setVisible(false);
                    }
                }
            }
        });
        this.cpTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                AbstractCompPointLayerReport.this.updateMap();
            }
        });
        JMenuBar menuBar = new JMenuBar();
        JMenu menu = new JMenu("File");
        menu.setMnemonic('f');
        menuBar.add(menu);
        JMenuItem menuItem = new JMenuItem("Print", 112);
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractCompPointLayerReport.this.cpTable.printData();
            }
        });
        menu.add(menuItem);
        menuItem = new JMenuItem("Export", 101);
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractCompPointLayerReport.this.cpTable.exportData();
            }
        });
        menu.add(menuItem);
        menu.addSeparator();
        menuItem = new JMenuItem("Close", 99);
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractCompPointLayerReport.this.setVisible(false);
            }
        });
        menu.add(menuItem);
        menu = new JMenu("Help");
        menu.setMnemonic('h');
        menuBar.add(menu);
        menuItem = new JMenuItem("About", 97);
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractCompPointLayerReport.this.helpAbout();
            }
        });
        menu.add(menuItem);
        this.setJMenuBar(menuBar);
        this.pack();
    }

    protected abstract void helpAbout();

    protected abstract CommonDataList getComputationPointDataList();

    protected abstract CommonDataList getComputationPointLayerDataList();

    protected abstract void selectComputationPoint(WorldPt var1, int var2);

    protected abstract void paintMap();

    protected abstract StudySystemMapGlyph getStudySystemGlyph();

    public void setAlignment(StreamAlignmentIfc alignment) {
        this._alignment = alignment;
        if (this._alignment != null) {
            // empty if block
        }
    }

    public void fillForm() {
        String wtrshdName = AppDaddy.getWorkspace().getTitleName();
        this.watershedNameLabel.setText("<html>" + wtrshdName + "<br>List of Computation Point Layers");
        this.reportTypeLabel.setText("List of Computation Point Layers");
        this.setTitle(wtrshdName + " - List of Computation Point Layers");
        this.cpTable.deleteCells();
        CommonDataList dl = this.getComputationPointDataList();
        if (dl == null) {
            return;
        }
        CommonDataList cpldl = this.getComputationPointLayerDataList();
        DataStruct[] objs = dl.getObjectArray();
        DataStruct[] cplObjs = null;
        if (cpldl != null) {
            cplObjs = cpldl.getObjectArray();
        }
        for (int l = 0; l < cplObjs.length; ++l) {
            Vector<Object> row;
            ComputationPointLayer cpl = (ComputationPointLayer)cplObjs[l];
            boolean added = false;
            for (int i = 0; i < objs.length; ++i) {
                ComputationPoint cp = (ComputationPoint)objs[i];
                if (cp == null || !cpl.contains(cp)) continue;
                row = new Vector();
                row.add((Object)cpl);
                row.addElement(new Long(cp.getId()));
                row.addElement(cp.getName());
                row.addElement(cp.getDescription());
                if (this._alignment != null) {
                    row.addElement(this._alignment.findReach(cp.getStreamId()));
                } else {
                    row.addElement("");
                }
                Vector v = cp.getProjects();
                if (v.size() > 0) {
                    row.addElement(((NamedType)v.elementAt(0)).getName());
                } else {
                    row.addElement("");
                }
                row.addElement(new Double(cp.getStreamStation()));
                this.cpTable.appendRow(row);
                added = true;
            }
            if (added) continue;
            row = new Vector<Object>();
            row.add((Object)cpl);
            this.cpTable.appendRow(row);
        }
        Vector rows = ((RmaTableModelInterface)this.cpTable.getModel()).getDataVector();
        int[] sortCols = new int[]{0};
        RMASort.multipleColumnSort((int[])sortCols, (List)rows, (boolean)true);
    }

    private void updateMap() {
        int[] rows = this.cpTable.getSelectedRows();
        if (rows.length == 0) {
            return;
        }
        for (int i = 0; i < rows.length; ++i) {
            int row = rows[i];
            if (row < 0) continue;
            StudySystemMapGlyph glyph = this.getStudySystemGlyph();
            if (glyph == null) {
                return;
            }
            CommonDataList dl = this.getComputationPointDataList();
            if (dl == null) {
                return;
            }
            ComputationPoint cp = (ComputationPoint)dl.getObject(((Long)this.cpTable.getCell(row, 1)).longValue());
            if (cp == null) {
                return;
            }
            WorldPt wpt = cp.getReferencePt();
            if (wpt == null) {
                return;
            }
            this.selectComputationPoint(wpt, i);
        }
        this.paintMap();
    }
}

