/*
 * Decompiled with CFR 0.152.
 */
package hec.watershed.client;

import hec.appInterface.AppDaddy;
import hec.lang.NamedType;
import hec.map.WorldPt;
import hec.map.streamAlignment.StreamAlignmentIfc;
import hec.model.CommonDataList;
import hec.model.DataStruct;
import hec.watershed.client.StudySystemMapGlyph;
import hec.watershed.model.ComputationPoint;
import hec.watershed.model.ComputationPointLayer;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableModel;
import rma.swing.RmaInsets;
import rma.swing.RmaJFrame;
import rma.swing.RmaJTable;
import rma.swing.RmaJTableSorter;
import rma.swing.table.RmaTableModelInterface;
import rma.util.RMASort;

public abstract class AbstractComputationPointReport
extends RmaJFrame {
    private static final int ID_COL = 0;
    private static final int NAME_COL = 1;
    private static final int DESC_COL = 2;
    private static final int STREAM_COL = 3;
    private static final int PROJECT_COL = 4;
    private static final int STREAM_STATION_COL = 5;
    private RmaJTable cpTable;
    private JLabel watershedNameLabel;
    private JLabel reportTypeLabel = new JLabel();
    private StreamAlignmentIfc _alignment;

    public AbstractComputationPointReport() {
        this.buildControls();
    }

    private void buildControls() {
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle("Computation Points");
        this.setSize(450, 150);
        this.setLocation();
        this.watershedNameLabel = new JLabel("", 0);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 11;
        gbc.fill = 2;
        gbc.insets = RmaInsets.insets((int)0, (int)0, (int)0, (int)0);
        gbc.weightx = 1.0;
        this.getContentPane().add((Component)this.watershedNameLabel, gbc);
        this.watershedNameLabel = new JLabel("", 0);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.anchor = 11;
        gbc.fill = 2;
        gbc.insets = RmaInsets.insets((int)0, (int)0, (int)0, (int)0);
        gbc.weightx = 1.0;
        this.getContentPane().add((Component)this.watershedNameLabel, gbc);
        this.cpTable = new RmaJTable((Component)((Object)this), (Object[])new String[]{" \nID", " \nName", " \nDescription", "Stream\nName", "Project\nName", "Stream\nStation", " \nLayers"});
        RmaJTableSorter sorter = new RmaJTableSorter((RmaTableModelInterface)this.cpTable.getModel());
        this.cpTable.setModel((TableModel)sorter);
        this.cpTable.setMlHeaderRenderer();
        this.cpTable.setEditable(false);
        this.cpTable.setColumnEnabled(false, 0);
        this.cpTable.setDoubleCellEditor(5, true);
        this.cpTable.setColumnVisible(0, false, 0);
        this.cpTable.setCellSelectionEnabled(false);
        this.cpTable.setColumnSelectionAllowed(false);
        this.cpTable.setRowSelectionAllowed(true);
        this.cpTable.getSelectionModel().setSelectionMode(2);
        sorter.addMouseListenerToHeaderInTable((JTable)this.cpTable);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.anchor = 12;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)5, (int)5);
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 2.0;
        this.getContentPane().add((Component)this.cpTable.getScrollPane(), gbc);
        this.cpTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                AbstractComputationPointReport.this.updateMap();
            }
        });
        JMenuBar menuBar = new JMenuBar();
        JMenu menu = new JMenu("File");
        menu.setMnemonic('f');
        menuBar.add(menu);
        JMenuItem menuItem = new JMenuItem("Export", 101);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(69, 128, false));
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractComputationPointReport.this.cpTable.exportData();
            }
        });
        menu.add(menuItem);
        menu.addSeparator();
        menuItem = new JMenuItem("Print", 112);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(80, 128, false));
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractComputationPointReport.this.cpTable.printData();
            }
        });
        menu.add(menuItem);
        menuItem = new JMenuItem("Print Preview", 118);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(79, 192));
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractComputationPointReport.this.cpTable.printPreview();
            }
        });
        menu.add(menuItem);
        menu.addSeparator();
        menuItem = new JMenuItem("Close", 99);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(87, 128));
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractComputationPointReport.this.setVisible(false);
            }
        });
        menu.add(menuItem);
        menu = new JMenu("Help");
        menu.setMnemonic('h');
        menuBar.add(menu);
        menuItem = new JMenuItem("About", 97);
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractComputationPointReport.this.helpAbout();
            }
        });
        menu.add(menuItem);
        this.setJMenuBar(menuBar);
        this.pack();
    }

    protected abstract void helpAbout();

    protected abstract CommonDataList getComputationPointDataList();

    protected abstract CommonDataList getComputationPointLayerDataList();

    protected abstract void selectComputationPoint(WorldPt var1, int var2);

    protected abstract void paintMap();

    protected abstract StudySystemMapGlyph getStudySystemGlyph();

    public void setAlignment(StreamAlignmentIfc alignment) {
        this._alignment = alignment;
        if (this._alignment != null) {
            // empty if block
        }
    }

    public void fillForm() {
        String wtrshdName = AppDaddy.getWorkspace().getTitleName();
        this.watershedNameLabel.setText("<html>" + wtrshdName + "<br>List of Computation Points");
        this.reportTypeLabel.setText("List of Computation Points");
        this.setTitle(wtrshdName + " - List of Computation Points");
        this.cpTable.deleteCells();
        CommonDataList dl = this.getComputationPointDataList();
        if (dl == null) {
            return;
        }
        CommonDataList cpldl = this.getComputationPointLayerDataList();
        DataStruct[] objs = dl.getObjectArray();
        DataStruct[] cplObjs = null;
        if (cpldl != null) {
            cplObjs = cpldl.getObjectArray();
        }
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < objs.length; ++i) {
            ComputationPoint cp = (ComputationPoint)objs[i];
            if (cp == null) continue;
            Vector<Object> row = new Vector<Object>();
            row.addElement(new Long(cp.getId()));
            row.addElement(cp.getName());
            row.addElement(cp.getDescription());
            if (this._alignment != null) {
                row.addElement(this._alignment.findReach(cp.getStreamId()));
            } else {
                row.addElement("");
            }
            Vector v = cp.getProjects();
            if (v.size() > 0) {
                row.addElement(((NamedType)v.elementAt(0)).getName());
            } else {
                row.addElement("");
            }
            row.addElement(new Double(cp.getStreamStation()));
            if (cplObjs != null) {
                builder.setLength(0);
                for (int k = 0; k < cplObjs.length; ++k) {
                    ComputationPointLayer layer = (ComputationPointLayer)cplObjs[k];
                    if (!layer.contains(cp)) continue;
                    if (builder.length() > 0) {
                        builder.append(",");
                    }
                    builder.append(layer.getName());
                }
            }
            row.add(builder.toString());
            this.cpTable.appendRow(row);
        }
        Vector rows = ((RmaTableModelInterface)this.cpTable.getModel()).getDataVector();
        int[] sortCols = new int[]{0};
        RMASort.multipleColumnSort((int[])sortCols, (List)rows, (boolean)true);
        this.cpTable.setAutoResizeMode(4);
        this.pack();
    }

    private void updateMap() {
        int[] rows = this.cpTable.getSelectedRows();
        if (rows.length == 0) {
            return;
        }
        for (int i = 0; i < rows.length; ++i) {
            int row = rows[i];
            if (row < 0) continue;
            StudySystemMapGlyph glyph = this.getStudySystemGlyph();
            if (glyph == null) {
                return;
            }
            CommonDataList dl = this.getComputationPointDataList();
            if (dl == null) {
                return;
            }
            ComputationPoint cp = (ComputationPoint)dl.getObject(((Long)this.cpTable.getCell(row, 0)).longValue());
            if (cp == null) {
                return;
            }
            WorldPt wpt = cp.getReferencePt();
            if (wpt == null) {
                return;
            }
            this.selectComputationPoint(wpt, i);
        }
        this.paintMap();
    }
}

