/*
 * Decompiled with CFR 0.152.
 */
package hec.watershed.client;

import hec.appInterface.AppDaddy;
import hec.lang.ClientAppCheck;
import hec.map.LocalPt;
import hec.map.WorldPt;
import hec.map.appInterface.MapApplicationFrame;
import hec.map.streamAlignment.StreamAlignmentGlyph;
import hec.map.streamAlignment.StreamAlignmentIfc;
import hec.model.CommonDataList;
import hec.model.DataListLoader;
import hec.model.DataObject;
import hec.model.DataStruct;
import hec.model.StreamElement;
import hec.model.StreamSegmentIdentifier;
import hec.watershed.client.StudySystemMapGlyph;
import hec.watershed.model.ChannelMod;
import hec.watershed.model.Condition;
import hec.watershed.model.Diversion;
import hec.watershed.model.ImpactArea;
import hec.watershed.model.Levee;
import hec.watershed.model.OtherProject;
import hec.watershed.model.Project;
import hec.watershed.model.Reservoir;
import hec.watershed.model.StoragePool;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableModel;
import rma.swing.RmaInsets;
import rma.swing.RmaJFrame;
import rma.swing.RmaJTable;
import rma.swing.RmaJTableSorter;
import rma.swing.print.PageText;
import rma.swing.table.RmaTableModel;
import rma.swing.table.RmaTableModelInterface;
import rma.util.RMAIO;
import rma.util.RMASort;

public abstract class AbstractReportsFrame
extends RmaJFrame {
    protected RmaJTable reportTable;
    protected JLabel watershedNameLabel;
    protected JLabel reportTypeLabel;

    public AbstractReportsFrame() {
        this.buildControls();
        this.setTitle("Report");
        this.reportTable.setAutoResizeMode(4);
        this.pack();
    }

    private void buildMenus() {
        JMenuBar mb = new JMenuBar();
        JMenu menu = new JMenu("File");
        menu.setMnemonic('f');
        mb.add(menu);
        JMenuItem menuItem = new JMenuItem("Export", 101);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(69, 2, false));
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractReportsFrame.this.reportTable.exportData();
            }
        });
        menu.add(menuItem);
        menu.addSeparator();
        menuItem = new JMenuItem("Print", 112);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(80, 2, false));
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractReportsFrame.this.reportTable.printData();
            }
        });
        menu.add(menuItem);
        menuItem = new JMenuItem("Print Preview", 118);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(79, 192));
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractReportsFrame.this.reportTable.printPreview();
            }
        });
        menu.add(menuItem);
        menu.addSeparator();
        menuItem = new JMenuItem("Close", 99);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(87, 2, false));
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractReportsFrame.this.setVisible(false);
            }
        });
        menu.add(menuItem);
        if (ClientAppCheck.haveClientApp()) {
            menu = new JMenu("Help");
            menu.setMnemonic('h');
            ActionListener listener = this.getAboutMenuListener();
            if (listener != null) {
                menuItem = new JMenuItem("About", 97);
                menuItem.addActionListener(listener);
                menu.add(menuItem);
            }
            mb.add(menu);
        }
        this.setJMenuBar(mb);
    }

    protected abstract ActionListener getAboutMenuListener();

    private void buildControls() {
        this.getContentPane().setLayout(new GridBagLayout());
        this.setSize(400, 400);
        this.setLocation();
        this.buildMenus();
        this.watershedNameLabel = new JLabel("", 0);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 11;
        gbc.fill = 2;
        gbc.insets = RmaInsets.insets((int)0, (int)0, (int)0, (int)0);
        gbc.weightx = 1.0;
        this.getContentPane().add((Component)this.watershedNameLabel, gbc);
        this.reportTypeLabel = new JLabel("", 0);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.anchor = 11;
        gbc.fill = 2;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        gbc.weightx = 1.0;
        this.getContentPane().add((Component)this.reportTypeLabel, gbc);
        this.reportTable = new RmaJTable((Component)((Object)this), new String[]{"", "", ""}){

            public Dimension getPreferredScrollableViewportSize() {
                return new Dimension(600, 250);
            }
        };
        this.buildTable(this.reportTable);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)5, (int)5);
        gbc.weightx = 1.0;
        gbc.weighty = 3.0;
        this.getContentPane().add((Component)this.reportTable.getScrollPane(), gbc);
        this.reportTable.setAutoResizeMode(4);
    }

    protected void buildTable(RmaJTable table) {
        RmaJTableSorter sorter = new RmaJTableSorter((RmaTableModelInterface)table.getModel());
        table.setModel((TableModel)sorter);
        sorter.addMouseListenerToHeaderInTable((JTable)this.reportTable);
        table.setEditable(false);
        table.setCellSelectionEnabled(false);
        table.setColumnSelectionAllowed(false);
        table.setRowSelectionAllowed(true);
        table.setMlHeaderRenderer();
        table.setSelectionMode(2);
        table.setAddRemoveEnabled(false);
        table.setAutoResizeMode(4);
        this.pack();
    }

    public void makeStreamReport(StreamAlignmentIfc alignment) {
        boolean advancedReport = Boolean.getBoolean("StreamAlignment.AdvancedReport");
        if (advancedReport) {
            String[] columnNames = new String[]{"Stream\nName", " \nDescription", "Upstream\nStation", "Downstream\nStation", " \nLength"};
            RmaTableModel model = new RmaTableModel(columnNames, new Object[1][columnNames.length], new boolean[columnNames.length]);
            this.reportTable.setModel((TableModel)model);
            this.buildTable(this.reportTable);
            this.reportTable.setDoubleCellEditor(2, true);
            this.reportTable.setDoubleCellEditor(3, true);
            this.reportTable.setDoubleCellEditor(4, true);
            this.reportTable.setMlHeaderRenderer();
        } else {
            this.reportTable.setColumnLabels(new String[]{"Stream\nName", " \nDescription"});
            if (this.reportTable.getColumnCount() >= 3) {
                this.reportTable.setColumnVisible(2, false, 0);
            }
        }
        this.reportTable.deleteCells();
        this.setTitle("List of Streams");
        if (alignment == null) {
            return;
        }
        Vector v = alignment.getElementVector();
        for (int i = 0; i < v.size(); ++i) {
            Vector<Object> row = new Vector<Object>(1);
            StreamElement elem = (StreamElement)v.get(i);
            row.add(elem);
            row.add(elem.getDescription());
            if (advancedReport) {
                row.add(elem.getUpstreamNode().getStation());
                row.add(elem.getDownstreamNode().getStation());
                row.add(elem.getLine().getLength());
            }
            this.reportTable.appendRow(row);
        }
        this.sortTable();
        Vector rows = ((RmaTableModelInterface)this.reportTable.getModel()).getDataVector();
        int[] sortCols = new int[]{0};
        RMASort.multipleColumnSort((int[])sortCols, (List)rows, (boolean)true);
        this.reportTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                int[] selRows = AbstractReportsFrame.this.reportTable.getSelectedRows();
                if (selRows.length == 0) {
                    return;
                }
                for (int i = 0; i < selRows.length; ++i) {
                    StreamElement elem = (StreamElement)AbstractReportsFrame.this.reportTable.getCell(selRows[i], 0);
                    if (elem == null) {
                        return;
                    }
                    MapApplicationFrame frame = (MapApplicationFrame)AppDaddy.getFrame();
                    StreamAlignmentGlyph glyph = (StreamAlignmentGlyph)frame.getMapPanel().findGlyphOfClass("hec.map.streamAlignment.StreamAlignmentGlyph");
                    if (glyph == null) {
                        return;
                    }
                    if (i == 0) {
                        glyph.selectElement(elem.getName(), false, false);
                        continue;
                    }
                    glyph.selectElement(elem.getName(), true, false);
                }
                MapApplicationFrame frame = (MapApplicationFrame)AppDaddy.getFrame();
                frame.getMapPanel().paintMap();
            }
        });
    }

    protected void sortTable() {
        this.sortTable(0);
    }

    protected void sortTable(int col) {
        Vector rows = ((RmaTableModelInterface)this.reportTable.getModel()).getDataVector();
        int[] sortCols = new int[]{col};
        RMASort.multipleColumnSort((int[])sortCols, (List)rows, (boolean)true);
    }

    public void setTitle(String title) {
        this.reportTypeLabel.setText(title);
        String wkspTitle = AppDaddy.getWorkspace().getTitleName();
        this.watershedNameLabel.setText(wkspTitle);
        super.setTitle(wkspTitle + " - " + title);
        this.reportTable.setPrintTitle(new PageText(wkspTitle + "\n" + title, 0));
    }

    public void makeImpactAreaReport() {
        this.setTitle("List of Impact Areas");
        RmaTableModel model = new RmaTableModel(new String[]{"id", " \nName", " \nDescription", "Stream\nName", "Bank", "Beginning\nStation", "Index\nStation", "Ending\nStation"}, (Object[][])new Object[0][], new boolean[]{false, false, false, false, false, false, false, false});
        this.reportTable.setModel((TableModel)model);
        this.buildTable(this.reportTable);
        this.reportTable.deleteCells();
        this.reportTable.setDoubleCellEditor(5);
        this.reportTable.setDoubleCellEditor(6);
        this.reportTable.setDoubleCellEditor(7);
        this.reportTable.setAutoResizeMode(0);
        CommonDataList dl = DataListLoader.getDataListLoader().getCommonDataList("hec.watershed.model.ImpactArea");
        StreamAlignmentIfc sa = this.getStreamAlignment();
        if (dl == null) {
            return;
        }
        DataStruct[] impactAreaList = dl.getObjectArray();
        for (int i = 0; i < impactAreaList.length; ++i) {
            ImpactArea ia = (ImpactArea)impactAreaList[i];
            if (ia == null) continue;
            Vector<Object> row = new Vector<Object>(7);
            row.addElement(ia);
            row.addElement(ia.getName());
            row.addElement(ia.getDescription());
            StreamElement streamElem = sa.getReach(ia.getStreamId());
            row.addElement(streamElem != null ? streamElem.getName() : "");
            row.addElement(ia.getBank() == 1 ? "Left" : (ia.getBank() == 2 ? "Right" : "Both"));
            String s = RMAIO.setPrecision2((double)ia.getBeginStation(), (int)3);
            if (s.length() > 0) {
                row.addElement(new Double(s));
            } else {
                row.addElement("");
            }
            s = RMAIO.setPrecision2((double)ia.getIndexStation(), (int)3);
            if (s.length() > 0) {
                row.addElement(new Double(s));
            } else {
                row.addElement("");
            }
            s = RMAIO.setPrecision2((double)ia.getEndStation(), (int)3);
            if (s.length() > 0) {
                row.addElement(new Double(s));
            } else {
                row.addElement("");
            }
            this.reportTable.appendRow(row);
        }
        this.sortTable();
        this.reportTable.setColumnVisible(0, false, 0);
        this.reportTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                int[] selRows = AbstractReportsFrame.this.reportTable.getSelectedRows();
                if (selRows.length == 0) {
                    return;
                }
                for (int i = 0; i < selRows.length; ++i) {
                    ImpactArea area = (ImpactArea)AbstractReportsFrame.this.reportTable.getCell(selRows[i], 0);
                    if (area == null) {
                        return;
                    }
                    StudySystemMapGlyph glyph = AbstractReportsFrame.this.getStudySystemMapGlyph();
                    if (glyph == null) {
                        return;
                    }
                    if (i == 0) {
                        glyph.selectImpactArea(area, false, false);
                        continue;
                    }
                    glyph.selectImpactArea(area, true, false);
                }
                MapApplicationFrame frame = (MapApplicationFrame)AppDaddy.getFrame();
                frame.getMapPanel().paintMap();
            }
        });
        this.reportTable.setAutoResizeMode(4);
        this.pack();
    }

    public void makeReserviorReport() {
        this.setTitle("List of All Reservoirs");
        String[] columnNames = new String[]{" \nReservoir\nName", " \n \nDescription", "Stream\nName", "Year\nIn\nService", " \nCorps\nProject", " \nExisting\nProject"};
        boolean[] editable = new boolean[]{false, false, false, false, false, false};
        RmaTableModel model = new RmaTableModel(columnNames, (Object[][])new Object[0][], editable);
        this.reportTable.setModel((TableModel)model);
        this.buildTable(this.reportTable);
        this.reportTable.deleteCells();
        CommonDataList dl = DataListLoader.getDataListLoader().getCommonDataList(Condition.class.getName());
        if (dl == null) {
            return;
        }
        StreamAlignmentIfc sa = this.getStreamAlignment();
        if (sa == null) {
            return;
        }
        Condition c = this.getCondition();
        if (c == null) {
            return;
        }
        Vector projectList = c.getProjects();
        if (projectList == null) {
            return;
        }
        int size = projectList.size();
        for (int i = 0; i < size; ++i) {
            Project proj = (Project)projectList.elementAt(i);
            if (!(proj instanceof Reservoir) || proj == null) continue;
            Vector<Object> row = new Vector<Object>(6);
            row.addElement(proj);
            row.addElement(proj.getDescription());
            StreamElement element = sa.getReach(proj.getStreamId());
            row.addElement(element == null ? "" : element.getName());
            row.addElement("" + ((Reservoir)proj).getYearInService());
            row.addElement(proj.isCorpsProject() ? "Yes" : "No");
            row.addElement(proj.isExisting() ? "Yes" : "No");
            this.reportTable.appendRow(row);
        }
        this.sortTable(0);
        this.reportTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                int[] selRows = AbstractReportsFrame.this.reportTable.getSelectedRows();
                if (selRows.length == 0) {
                    return;
                }
                for (int i = 0; i < selRows.length; ++i) {
                    Reservoir area = (Reservoir)AbstractReportsFrame.this.reportTable.getCell(selRows[i], 0);
                    if (area == null) {
                        return;
                    }
                    MapApplicationFrame frame = (MapApplicationFrame)AppDaddy.getFrame();
                    StudySystemMapGlyph glyph = (StudySystemMapGlyph)frame.getMapPanel().findGlyphOfClass("ressim.hec.watershed.client.StudySystemMapGlyph");
                    if (glyph == null) {
                        return;
                    }
                    if (i == 0) {
                        glyph.selectReservoir(area, false, false);
                        continue;
                    }
                    glyph.selectReservoir(area, true, false);
                }
                MapApplicationFrame frame = (MapApplicationFrame)AppDaddy.getFrame();
                frame.getMapPanel().paintMap();
            }
        });
        this.reportTable.setAutoResizeMode(4);
    }

    public void makeLeveeReport() {
        this.setTitle("List of All Levees");
        String[] columnNames = new String[]{"Levee\nName", " \nDescription", "Stream\nName", "Stream\nBank", "Beginning\nStation", "Ending\nStation", "Corps\nProject", "Year In\nService"};
        boolean[] editable = new boolean[]{false, false, false, false, false, false, false, false};
        RmaTableModel model = new RmaTableModel(columnNames, (Object[][])new Object[0][], editable);
        this.reportTable.setModel((TableModel)model);
        this.buildTable(this.reportTable);
        this.reportTable.setPrecision(3);
        this.reportTable.setDoubleCellEditor(4, true);
        this.reportTable.setDoubleCellEditor(5, true);
        this.reportTable.deleteCells();
        StreamAlignmentIfc sa = this.getStreamAlignment();
        if (sa == null) {
            return;
        }
        Condition c = this.getCondition();
        if (c == null) {
            return;
        }
        Vector projectList = c.getProjects();
        if (projectList == null) {
            return;
        }
        int size = projectList.size();
        for (int i = 0; i < size; ++i) {
            Project proj = (Project)projectList.elementAt(i);
            if (!(proj instanceof Levee) || proj == null) continue;
            Vector<Object> row = new Vector<Object>(6);
            row.addElement(proj);
            row.addElement(proj.getDescription());
            List<StreamSegmentIdentifier> v = ((Levee)proj).getStreamSegmentList();
            StreamSegmentIdentifier ssid = v.get(0);
            if (v == null || v.size() == 0) {
                row.addElement("");
            } else {
                StreamElement element = sa.getReach(ssid.streamId);
                row.addElement(element == null ? "" : element.getName());
            }
            row.addElement(((Levee)proj).getBank() == -1 ? "Left" : "Right");
            if (v == null || v.size() == 0) {
                row.addElement("");
                row.addElement("");
            } else {
                row.addElement(new Double(ssid.startStation));
                row.addElement(new Double(ssid.endStation));
            }
            row.addElement(proj.isCorpsProject() ? "Yes" : "No");
            row.addElement("" + ((Levee)proj).getYearInService());
            this.reportTable.appendRow(row);
        }
        this.sortTable(1);
        this.reportTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                int[] selRows = AbstractReportsFrame.this.reportTable.getSelectedRows();
                if (selRows.length == 0) {
                    return;
                }
                for (int i = 0; i < selRows.length; ++i) {
                    Levee area = (Levee)AbstractReportsFrame.this.reportTable.getCell(selRows[i], 0);
                    if (area == null) {
                        return;
                    }
                    MapApplicationFrame frame = (MapApplicationFrame)AppDaddy.getFrame();
                    StudySystemMapGlyph glyph = (StudySystemMapGlyph)frame.getMapPanel().findGlyphOfClass("ressim.hec.watershed.client.StudySystemMapGlyph");
                    if (glyph == null) {
                        return;
                    }
                    if (i == 0) {
                        glyph.selectLevee(area, false, false);
                        continue;
                    }
                    glyph.selectLevee(area, true, false);
                }
                MapApplicationFrame frame = (MapApplicationFrame)AppDaddy.getFrame();
                frame.getMapPanel().paintMap();
            }
        });
        this.reportTable.setAutoResizeMode(4);
    }

    public void makeDiversionReport() {
        this.setTitle("List of All Diversions");
        String[] columnNames = new String[]{"Diversion\nName", " \nDescription", "Stream\nName", "Reservoir\nName", "Beginning\nStation", "Ending\nStation", "Corps\nProject", "Year In\nService", "Inflow\nComputation Point", "Outflow\nComputation Point"};
        boolean[] editable = new boolean[]{false, false, false, false, false, false, false, false, false, false};
        RmaTableModel model = new RmaTableModel(columnNames, (Object[][])new Object[0][], editable);
        this.reportTable.setModel((TableModel)model);
        this.buildTable(this.reportTable);
        this.reportTable.setPrecision(3);
        this.reportTable.setDoubleCellEditor(4, true);
        this.reportTable.setDoubleCellEditor(5, true);
        this.reportTable.deleteCells();
        StreamAlignmentIfc sa = this.getStreamAlignment();
        if (sa == null) {
            return;
        }
        CommonDataList reservoirDl = DataListLoader.getDataListLoader().getCommonDataList("hec.watershed.model.Reservoir");
        Condition c = this.getCondition();
        if (c == null) {
            return;
        }
        Vector projectList = c.getProjects();
        if (projectList == null) {
            return;
        }
        int size = projectList.size();
        for (int i = 0; i < size; ++i) {
            Project proj = (Project)projectList.elementAt(i);
            if (proj == null || !(proj instanceof Diversion)) continue;
            Diversion div = (Diversion)proj;
            Vector<Object> row = new Vector<Object>(6);
            row.add(proj);
            row.add(proj.getDescription());
            int streamId = div.getUpstreamNode().getStreamIndex();
            StreamElement element = sa.getReach(streamId);
            row.add(element == null ? "unknown id=" + streamId : element.getName());
            if (reservoirDl != null) {
                DataObject dObj = reservoirDl.getObject(div.getReservoirId());
                row.add(dObj != null ? dObj.getName() : "");
            } else {
                row.add("");
            }
            row.add(RMAIO.setPrecision2((double)div.getUpstreamNode().getStreamStation(), (int)3));
            row.add("");
            row.add(proj.isCorpsProject() ? "Yes" : "No");
            row.add(String.valueOf(div.getYearInService()));
            row.add(div.getComputationPoint(true));
            row.add(div.getComputationPoint(false));
            this.reportTable.appendRow(row);
        }
        this.sortTable(0);
        this.reportTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                int[] selRows = AbstractReportsFrame.this.reportTable.getSelectedRows();
                if (selRows.length == 0) {
                    return;
                }
                for (int i = 0; i < selRows.length; ++i) {
                    Diversion elem = (Diversion)AbstractReportsFrame.this.reportTable.getCell(selRows[i], 0);
                    if (elem == null) {
                        return;
                    }
                    StudySystemMapGlyph glyph = AbstractReportsFrame.this.getStudySystemMapGlyph();
                    if (glyph == null) {
                        return;
                    }
                    if (i == 0) {
                        glyph.selectDiversion(elem, false, false);
                        continue;
                    }
                    glyph.selectDiversion(elem, true, false);
                }
                MapApplicationFrame frame = (MapApplicationFrame)AppDaddy.getFrame();
                frame.getMapPanel().paintMap();
            }
        });
        this.reportTable.setAutoResizeMode(4);
    }

    public void makeChannelModificationReport() {
        this.setTitle("List of All Channel Modifications");
        String[] columnNames = new String[]{"Channel Modification\nName", " \nDescription", "Stream\nName", "Beginning\nStation", "Ending\nStation", "Corps\nProject", "Year In\nService"};
        boolean[] editable = new boolean[]{false, false, false, false, false, false, false};
        RmaTableModel model = new RmaTableModel(columnNames, (Object[][])new Object[0][], editable);
        this.reportTable.setModel((TableModel)model);
        this.buildTable(this.reportTable);
        this.reportTable.setPrecision(3);
        this.reportTable.setDoubleCellEditor(3, true);
        this.reportTable.setDoubleCellEditor(4, true);
        this.reportTable.deleteCells();
        StreamAlignmentIfc sa = this.getStreamAlignment();
        if (sa == null) {
            return;
        }
        Condition c = this.getCondition();
        if (c == null) {
            return;
        }
        Vector projectList = c.getProjects();
        if (projectList == null) {
            return;
        }
        int size = projectList.size();
        for (int i = 0; i < size; ++i) {
            Project proj = (Project)projectList.elementAt(i);
            if (!(proj instanceof ChannelMod) || proj == null) continue;
            Vector<Object> row = new Vector<Object>(7);
            row.addElement(proj);
            row.addElement(proj.getDescription());
            StreamElement element = sa.getReach(proj.getStreamId());
            row.addElement(element == null ? "" : element.getName());
            row.addElement(new Double(((ChannelMod)proj).getStartStation()));
            row.addElement(new Double(((ChannelMod)proj).getEndStation()));
            row.addElement(proj.isCorpsProject() ? "Yes" : "No");
            row.addElement("" + ((ChannelMod)proj).getYearInService());
            this.reportTable.appendRow(row);
        }
        this.sortTable(0);
        this.reportTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                int[] selRows = AbstractReportsFrame.this.reportTable.getSelectedRows();
                if (selRows.length == 0) {
                    return;
                }
                for (int i = 0; i < selRows.length; ++i) {
                    ChannelMod area = (ChannelMod)AbstractReportsFrame.this.reportTable.getCell(selRows[i], 0);
                    if (area == null) {
                        return;
                    }
                    StudySystemMapGlyph glyph = AbstractReportsFrame.this.getStudySystemMapGlyph();
                    if (glyph == null) {
                        return;
                    }
                    if (i == 0) {
                        glyph.selectChannelMod(area, false, false);
                        continue;
                    }
                    glyph.selectChannelMod(area, true, false);
                }
                MapApplicationFrame frame = (MapApplicationFrame)AppDaddy.getFrame();
                frame.getMapPanel().paintMap();
            }
        });
        this.reportTable.setAutoResizeMode(4);
    }

    public void makeOffChannelStorageReport() {
        this.setTitle("List of All Off Channel Storage Areas");
        String[] columnNames = new String[]{"Off-Storage\nName", " \nDescription", "Stream\nName", "Corps\nProject", "Year In\nService"};
        boolean[] editable = new boolean[]{false, false, false, false, false};
        RmaTableModel model = new RmaTableModel(columnNames, (Object[][])new Object[0][], editable);
        this.reportTable.setModel((TableModel)model);
        this.buildTable(this.reportTable);
        this.reportTable.deleteCells();
        StreamAlignmentIfc sa = this.getStreamAlignment();
        if (sa == null) {
            return;
        }
        Condition c = this.getCondition();
        if (c == null) {
            return;
        }
        Vector projectList = c.getProjects();
        if (projectList == null) {
            return;
        }
        int size = projectList.size();
        for (int i = 0; i < size; ++i) {
            Project proj = (Project)projectList.elementAt(i);
            if (!(proj instanceof StoragePool) || proj == null) continue;
            Vector<Object> row = new Vector<Object>(4);
            row.addElement(proj);
            row.addElement(proj.getDescription());
            StreamElement element = sa.getReach(proj.getStreamId());
            row.addElement(element == null ? "" : element.getName());
            row.addElement(proj.isCorpsProject() ? "Yes" : "No");
            row.addElement("" + ((StoragePool)proj).getYearInService());
            this.reportTable.appendRow(row);
        }
        this.sortTable(0);
        this.reportTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                int[] selRows = AbstractReportsFrame.this.reportTable.getSelectedRows();
                if (selRows.length == 0) {
                    return;
                }
                for (int i = 0; i < selRows.length; ++i) {
                    StoragePool area = (StoragePool)AbstractReportsFrame.this.reportTable.getCell(selRows[i], 0);
                    if (area == null) {
                        return;
                    }
                    StudySystemMapGlyph glyph = AbstractReportsFrame.this.getStudySystemMapGlyph();
                    if (glyph == null) {
                        return;
                    }
                    if (i == 0) {
                        glyph.selectStoragePool(area, false, false);
                        continue;
                    }
                    glyph.selectStoragePool(area, true, false);
                }
                MapApplicationFrame frame = (MapApplicationFrame)AppDaddy.getFrame();
                frame.getMapPanel().paintMap();
            }
        });
        this.reportTable.setAutoResizeMode(4);
    }

    public void makeOtherProjectReport() {
        this.setTitle("List of All Other Projects");
        String[] columnNames = new String[]{"Other Project\nName", " \nDescription", "Stream\nName", "Corps\nProject", "Year In\nService"};
        boolean[] editable = new boolean[]{false, false, false, false, false};
        RmaTableModel model = new RmaTableModel(columnNames, (Object[][])new Object[0][], editable);
        this.reportTable.setModel((TableModel)model);
        this.buildTable(this.reportTable);
        this.reportTable.deleteCells();
        StreamAlignmentIfc sa = this.getStreamAlignment();
        if (sa == null) {
            return;
        }
        Condition c = this.getCondition();
        if (c == null) {
            return;
        }
        Vector projectList = c.getProjects();
        if (projectList == null) {
            return;
        }
        int size = projectList.size();
        for (int i = 0; i < size; ++i) {
            Project proj = (Project)projectList.elementAt(i);
            if (!(proj instanceof OtherProject) || proj == null) continue;
            Vector<Object> row = new Vector<Object>(4);
            row.addElement(proj);
            row.addElement(proj.getDescription());
            StreamElement element = sa.getReach(proj.getStreamId());
            row.addElement(element == null ? "" : element.getName());
            row.addElement(proj.isCorpsProject() ? "Yes" : "No");
            row.addElement("" + ((OtherProject)proj).getYearInService());
            this.reportTable.appendRow(row);
        }
        this.sortTable(0);
        this.reportTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                int[] selRows = AbstractReportsFrame.this.reportTable.getSelectedRows();
                if (selRows.length == 0) {
                    return;
                }
                for (int i = 0; i < selRows.length; ++i) {
                    OtherProject area = (OtherProject)AbstractReportsFrame.this.reportTable.getCell(selRows[i], 0);
                    if (area == null) {
                        return;
                    }
                    StudySystemMapGlyph glyph = AbstractReportsFrame.this.getStudySystemMapGlyph();
                    if (glyph == null) {
                        return;
                    }
                    if (i == 0) {
                        glyph.selectOtherProject(area, false, false);
                        continue;
                    }
                    glyph.selectOtherProject(area, true, false);
                }
                MapApplicationFrame frame = (MapApplicationFrame)AppDaddy.getFrame();
                frame.getMapPanel().paintMap();
            }
        });
        this.reportTable.setAutoResizeMode(4);
    }

    public void makeProjectsReport() {
        int menuCount = this.getJMenuBar().getMenuCount();
        Vector<JMenu> menus = new Vector<JMenu>();
        for (int i = menuCount - 1; i > 0; --i) {
            menus.addElement(this.getJMenuBar().getMenu(i));
            this.getJMenuBar().remove(i);
        }
        JMenu sortMenu = new JMenu("Sort");
        sortMenu.setMnemonic('s');
        this.getJMenuBar().add(sortMenu);
        JMenuItem menuItem = new JMenuItem("Alphabetic", 97);
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((RmaJTableSorter)AbstractReportsFrame.this.reportTable.getModel()).sortByColumn(1, true);
            }
        });
        sortMenu.add(menuItem);
        menuItem = new JMenuItem("Type", 116);
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((RmaJTableSorter)AbstractReportsFrame.this.reportTable.getModel()).sortByColumn(3, true);
            }
        });
        sortMenu.add(menuItem);
        for (int i = menus.size() - 1; i >= 0; --i) {
            this.getJMenuBar().add((JMenu)menus.elementAt(i));
        }
        this.setTitle("List of All Projects");
        String[] columnNames = new String[]{"id", "Project\nName", " \nDescription", "Project\nType", "Stream\nName", "Corps\nProject"};
        boolean[] editable = new boolean[]{false, false, false, false, false, false};
        RmaTableModel model = new RmaTableModel(columnNames, (Object[][])new Object[0][], editable);
        this.reportTable.setModel((TableModel)model);
        this.buildTable(this.reportTable);
        this.reportTable.deleteCells();
        this.reportTable.setColumnVisible(0, false, 0);
        StreamAlignmentIfc sa = DataListLoader.getDataListLoader().getStreamAlignment();
        if (sa == null) {
            return;
        }
        Condition c = this.getCondition();
        if (c == null) {
            return;
        }
        Vector projectList = c.getProjects();
        if (projectList == null) {
            return;
        }
        int size = projectList.size();
        for (int i = 0; i < size; ++i) {
            Project proj = (Project)projectList.elementAt(i);
            if (proj == null) continue;
            Vector<Object> row = new Vector<Object>(6);
            row.addElement(proj);
            row.addElement(proj.getName());
            row.addElement(proj.getDescription());
            row.addElement(proj.getUserDisplayedType());
            StreamElement element = sa.getReach(proj.getStreamId());
            if (element == null && proj instanceof Diversion) {
                element = sa.getReach(((Diversion)proj).getUpstreamNode().getStreamIndex());
            }
            row.addElement(element == null ? "" : element.getName());
            row.addElement(proj.isCorpsProject() ? "Yes" : "No");
            this.reportTable.appendRow(row);
        }
        this.sortTable(1);
        this.reportTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                AbstractReportsFrame.this.updateMap();
            }
        });
        this.reportTable.setAutoResizeMode(4);
    }

    public void updateMap() {
        int[] selRows = this.reportTable.getSelectedRows();
        if (selRows.length == 0) {
            return;
        }
        for (int i = 0; i < selRows.length; ++i) {
            Project project = (Project)this.reportTable.getCell(selRows[i], 0);
            if (project == null) {
                return;
            }
            boolean add = i != 0;
            WorldPt wpt = project.getReferencePt();
            StudySystemMapGlyph glyph = this.getStudySystemMapGlyph();
            if (glyph == null) {
                return;
            }
            LocalPt pt = null;
            MapApplicationFrame frame = (MapApplicationFrame)AppDaddy.getFrame();
            if (wpt.isValid()) {
                pt = frame.getMapPanel().scale().wp2lp(wpt);
            }
            if (project instanceof Reservoir) {
                glyph.selectReservoir((Reservoir)project, add, false);
                continue;
            }
            if (project instanceof ChannelMod) {
                glyph.selectChannelMod((ChannelMod)project, add, false);
                continue;
            }
            if (project instanceof Diversion) {
                glyph.selectDiversion(pt, add, false);
                continue;
            }
            if (project instanceof StoragePool) {
                glyph.selectStoragePool(pt, add, false);
                continue;
            }
            if (project instanceof OtherProject) {
                glyph.selectOtherProject(pt, add, false);
                continue;
            }
            if (project instanceof Levee) {
                glyph.selectLevee((Levee)project, add, false);
                continue;
            }
            glyph.objectSelect(pt, 0);
        }
        MapApplicationFrame frame = (MapApplicationFrame)AppDaddy.getFrame();
        frame.getMapPanel().paintMap();
    }

    public abstract StreamAlignmentIfc getStreamAlignment();

    protected abstract Condition getCondition();

    protected abstract StudySystemMapGlyph getStudySystemMapGlyph();
}

