/*
 * Decompiled with CFR 0.152.
 */
package hec.watershed.client;

import hec.appInterface.AppDaddy;
import hec.client.ResDrawPropData;
import hec.gfx2d.Symbol;
import hec.gui.NameDialog;
import hec.lang.NamedType;
import hec.map.LocalPt;
import hec.map.MapGlyph;
import hec.map.MapLabelItem;
import hec.map.MapObjectInterface;
import hec.map.MapPanel;
import hec.map.MapScale;
import hec.map.ModelDrawingAttributeSet;
import hec.map.WorldLine;
import hec.map.WorldPt;
import hec.map.WorldRegion;
import hec.map.appInterface.MapApplicationModule;
import hec.map.crs.CRSException;
import hec.map.crs.CoordinateReferenceSystem;
import hec.map.streamAlignment.StreamAlignmentGlyph;
import hec.map.streamAlignment.StreamAlignmentIfc;
import hec.model.CommonDataList;
import hec.model.DataStruct;
import hec.model.Node;
import hec.model.StreamElement;
import hec.model.StreamJunction;
import hec.model.StreamNode;
import hec.model.StreamPolyLine;
import hec.model.StreamReferenceHolder;
import hec.model.StreamSegment;
import hec.model.StreamSegmentIdentifier;
import hec.watershed.client.ChannelModDrawPropData;
import hec.watershed.client.CompPtDrawPropData;
import hec.watershed.client.DiversionDrawPropData;
import hec.watershed.client.ImpactAreaDrawPropData;
import hec.watershed.client.LeveeDrawPropData;
import hec.watershed.client.NewCompPtDialog;
import hec.watershed.client.PlaceCompPtDialog;
import hec.watershed.client.StudyDrawingAttributeSet;
import hec.watershed.client.StudySystemMapGlyph;
import hec.watershed.model.ChannelMod;
import hec.watershed.model.ComputationPoint;
import hec.watershed.model.ComputationPointLayer;
import hec.watershed.model.Condition;
import hec.watershed.model.Diversion;
import hec.watershed.model.ImpactArea;
import hec.watershed.model.Levee;
import hec.watershed.model.OtherProject;
import hec.watershed.model.Project;
import hec.watershed.model.Reservoir;
import hec.watershed.model.StoragePool;
import hec.watershed.model.StudyIfc;
import hec.watershed.model.StudyRegion;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Polygon;
import java.awt.Stroke;
import java.awt.image.ImageObserver;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.Document;
import rma.swing.RmaImage;
import rma.swing.text.DssPathnamePartDocument;
import rma.util.RMAConst;

public abstract class AbstractStudyGlyph
extends MapGlyph
implements StudySystemMapGlyph {
    protected static final double[] _angle = new double[]{0.0, 0.7853981633974483, 1.5707963267948966, 2.356194490192345, Math.PI, 3.9269908169872414, 4.71238898038469, 5.497787143782138, Math.PI};
    static Image _impactImage = null;
    static Image _impactImageNS = null;
    static Image _tsImage = null;
    static Image _selTsImage = null;
    static Image _otherProjImage = null;
    static Image _selOtherProjImage = null;
    protected int[] xy = new int[2];
    protected boolean _debug;
    protected StreamAlignmentIfc _alignment;
    protected List _selectionVector = new ArrayList();
    protected CommonDataList _channelModList;
    protected CommonDataList _compPtList;
    protected CommonDataList _leveeList;
    protected LocalPt tmpLpt = new LocalPt();
    protected WorldPt tmpWpt = new WorldPt();
    protected ModelDrawingAttributeSet _studyDas;
    private StreamAlignmentGlyph _alignmentGlyph;
    private List<ComputationPointLayer> _ccpVisibleLayers = new ArrayList<ComputationPointLayer>();

    public AbstractStudyGlyph(MapPanel panel, StudyIfc study) {
        super(panel, (MapObjectInterface)study);
        if (_impactImage == null) {
            _impactImage = RmaImage.loadURLImage((String)"Images/fia3.gif");
        }
        if (_impactImageNS == null) {
            _impactImageNS = RmaImage.loadURLImage((String)"Images/fiaNS.gif");
        }
        if (_tsImage == null) {
            _tsImage = RmaImage.loadURLImage((String)"Images/modelup.gif");
        }
        if (_selTsImage == null) {
            _selTsImage = RmaImage.loadURLImage((String)"Images/modelsel.gif");
        }
        if (_otherProjImage == null) {
            _otherProjImage = RmaImage.loadURLImage((String)"Images/OtherProjUp.gif");
        }
        if (_selOtherProjImage == null) {
            _selOtherProjImage = RmaImage.loadURLImage((String)"Images/OtherProjDown.gif");
        }
    }

    public void draw(Graphics g, MapScale scl) {
        Reservoir res;
        OtherProject op;
        if (this.getMap() == null) {
            return;
        }
        scl = this._mapPanel.scale((MapGlyph)this);
        this._studyDas = this.getAttributeSet();
        if (this._studyDas instanceof StudyDrawingAttributeSet) {
            ((StudyDrawingAttributeSet)this._studyDas).setGlyph(this);
        }
        this._glyphLevel = this._mapPanel.getGlyphLevel((MapGlyph)this);
        this._alignmentGlyph = null;
        StudyIfc study = this.getStudy();
        this.drawImpactAreas(g, scl, study);
        Condition c = study.getCondition();
        if (c != null) {
            Vector projects = c.getProjects();
            int numProjects = projects.size();
            for (int p = 0; _paintOk && p < numProjects; ++p) {
                Project proj = (Project)projects.elementAt(p);
                if (proj == null) continue;
                if (proj instanceof ChannelMod) {
                    if (!this._studyDas.isAttributeShown("Channel Modifications")) continue;
                    this.drawChannelMod(g, scl, (ChannelMod)proj);
                    continue;
                }
                if (proj instanceof StoragePool) {
                    if (!this._studyDas.isAttributeShown("Off Channel Storage")) continue;
                    this.drawStoragePool(g, scl, (StoragePool)proj);
                    continue;
                }
                if (proj instanceof OtherProject) {
                    if (!this._studyDas.isAttributeShown("Other Projects")) continue;
                    op = (OtherProject)proj;
                    this.drawOtherProject(g, scl, op);
                    continue;
                }
                if (proj instanceof Reservoir) {
                    if (!this._studyDas.isAttributeShown("Reservoirs")) continue;
                    res = (Reservoir)proj;
                    this.drawReservoir(g, scl, res);
                    continue;
                }
                if (proj instanceof Diversion) {
                    if (!this._studyDas.isAttributeShown("Diversions")) continue;
                    this.drawDiversion(g, scl, (Diversion)proj);
                    continue;
                }
                if (!(proj instanceof Levee) || !this._studyDas.isAttributeShown("Levees")) continue;
                this.drawLevee(g, scl, (Levee)proj);
            }
        }
        this.drawComputationPoints(g, scl, study);
        int size = this._selectionVector.size();
        for (int i = 0; _paintOk && i < size; ++i) {
            MapGlyph.Selection sel = (MapGlyph.Selection)this._selectionVector.get(i);
            if (sel.object == null) continue;
            if (sel.object instanceof ImpactArea) {
                if (!this._studyDas.isAttributeShown("Impact Areas")) continue;
                ImpactArea iarea = (ImpactArea)sel.object;
                this.drawSelectedArea(g, scl, iarea, false, sel.editing);
                continue;
            }
            if (sel.object instanceof ChannelMod) {
                if (!this._studyDas.isAttributeShown("Channel Modifications")) continue;
                ChannelMod cm = (ChannelMod)sel.object;
                this.drawSelectedChannelMod(g, scl, cm, false, sel.editing);
                continue;
            }
            if (sel.object instanceof StoragePool) {
                if (!this._studyDas.isAttributeShown("Off Channel Storage")) continue;
                StoragePool sp = (StoragePool)sel.object;
                this.drawSelectedStoragePool(g, scl, sp, false, sel.editing);
                continue;
            }
            if (sel.object instanceof ComputationPoint) {
                if (!this._studyDas.isAttributeShown("Computation Points")) continue;
                ComputationPoint cpt = (ComputationPoint)sel.object;
                this.drawSelectedCompPt(g, scl, cpt, false, sel.editing);
                continue;
            }
            if (sel.object instanceof OtherProject) {
                if (!this._studyDas.isAttributeShown("Other Projects")) continue;
                op = (OtherProject)sel.object;
                this.drawSelectedOtherProject(g, scl, op, false, sel.editing);
                continue;
            }
            if (sel.object instanceof Reservoir) {
                if (!this._studyDas.isAttributeShown("Reservoirs")) continue;
                res = (Reservoir)sel.object;
                this.drawSelectedReservoir(g, scl, res, false, sel.editing);
                continue;
            }
            if (sel.object instanceof Diversion) {
                if (!this._studyDas.isAttributeShown("Diversions")) continue;
                this.drawSelectedDiversion(g, scl, (Diversion)sel.object, false, sel.editing);
                continue;
            }
            if (!(sel.object instanceof Levee) || !this._studyDas.isAttributeShown("Levees")) continue;
            this.drawSelectedLevee(g, scl, (Levee)sel.object, false, sel.editing);
        }
    }

    protected void drawImpactAreas(Graphics g, MapScale scl, StudyIfc study) {
        Object[] iaList = study.getImpactAreaList();
        int size = iaList.length;
        if (!this._studyDas.isAttributeShown("Impact Areas")) {
            return;
        }
        for (int i = 0; _paintOk && i < size; ++i) {
            ImpactArea iarea = (ImpactArea)iaList[i];
            if (iarea == null || this.isSelected(iarea)) continue;
            this.drawArea(g, scl, iarea);
        }
    }

    protected void drawComputationPoints(Graphics g, MapScale scl, StudyIfc study) {
        if (this._compPtList != null && this._studyDas.isAttributeShown("Computation Points")) {
            ComputationPoint cpt;
            int symbolNum;
            Color bgcolor;
            Color fgcolor;
            int symbolSize;
            ComputationPointLayer ccpl;
            DataStruct[] cpts = this._compPtList.getObjectArray();
            int size = cpts.length;
            int ccplSize = this._ccpVisibleLayers.size();
            ComputationPointLayer defaultLayer = null;
            for (int x = 0; x < ccplSize; ++x) {
                ccpl = this._ccpVisibleLayers.get(x);
                if (!ccpl.isDefaultLayer()) continue;
                defaultLayer = ccpl;
            }
            List<ComputationPoint> defaultCptList = null;
            if (defaultLayer != null) {
                defaultCptList = defaultLayer.getCompPts();
            }
            for (int j = 0; j < ccplSize; ++j) {
                ccpl = this._ccpVisibleLayers.get(j);
                if (ccpl == defaultLayer) continue;
                symbolSize = ccpl.getSymbolSize();
                fgcolor = ccpl.getForegroundColor();
                bgcolor = ccpl.getBackgroundColor();
                symbolNum = ccpl.getSymbolNum();
                List<ComputationPoint> cptList = ccpl.getCompPts();
                size = cptList.size();
                for (int i = 0; _paintOk && i < size; ++i) {
                    cpt = cptList.get(i);
                    if (cpt == null) continue;
                    if (defaultCptList != null) {
                        defaultCptList.remove(cpt);
                    }
                    this.drawCompPt(g, scl, cpt, symbolSize, fgcolor, bgcolor, symbolNum);
                }
            }
            if (defaultLayer != null) {
                symbolSize = defaultLayer.getSymbolSize();
                bgcolor = defaultLayer.getBackgroundColor();
                fgcolor = defaultLayer.getForegroundColor();
                symbolNum = defaultLayer.getSymbolNum();
                size = defaultCptList.size();
                for (int i = 0; _paintOk && i < size; ++i) {
                    cpt = defaultCptList.get(i);
                    if (cpt == null) continue;
                    this.drawCompPt(g, scl, cpt, symbolSize, fgcolor, bgcolor, symbolNum);
                }
            }
        }
    }

    public void drawSelectedReservoir(Graphics g, MapScale scl, Reservoir lreg, boolean isXOR, boolean editing) {
        this.drawSelectedReservoir(g, scl, lreg, isXOR, editing, true);
    }

    @Override
    public void drawSelectedReservoir(Graphics g, MapScale scl, Reservoir lreg, boolean isXOR, boolean editing, boolean fillRegion) {
        WorldPt wpt;
        StreamAlignmentGlyph alignglyph = this.getStreamAlignmentGlyph();
        if (alignglyph == null) {
            return;
        }
        int icnt = 0;
        LocalPt pt = new LocalPt();
        int MAX = 4000;
        int[] pxarray = new int[4000];
        int[] pyarray = new int[4000];
        for (int i = 0; i < lreg.getRegion().pts.size() && i < 4000; ++i) {
            wpt = (WorldPt)lreg.getRegion().pts.elementAt(i);
            if (wpt == null) continue;
            scl.wp2lp(wpt, this.tmpLpt);
            pxarray[icnt] = this.tmpLpt.x;
            pyarray[icnt] = this.tmpLpt.y;
            ++icnt;
        }
        Graphics2D g2 = null;
        Composite oldac = null;
        AlphaComposite ac = null;
        Node dsn = lreg.getDownstreamNode();
        if (dsn != null) {
            wpt = dsn.getLocation();
            scl.wp2lp(wpt, pt);
            pxarray[icnt] = pt.x;
            pyarray[icnt] = pt.y;
            ++icnt;
        }
        if (fillRegion) {
            if (g instanceof Graphics2D) {
                g2 = (Graphics2D)g;
                oldac = g2.getComposite();
                ac = AlphaComposite.getInstance(3, 0.6f);
                g2.setComposite(ac);
                g.setColor(Color.yellow);
                g2.fillPolygon(pxarray, pyarray, icnt);
                if (oldac != null) {
                    g2.setComposite(oldac);
                }
            } else {
                if (isXOR) {
                    g.setXORMode(XOR_COLOR);
                }
                g.setColor(Color.yellow);
                g.fillPolygon(pxarray, pyarray, icnt);
                g.setPaintMode();
                if (isXOR) {
                    g.setXORMode(XOR_COLOR);
                }
            }
        } else if (isXOR) {
            g.setXORMode(XOR_COLOR);
        }
        g.setColor(Color.blue);
        g.drawPolygon(pxarray, pyarray, icnt);
        if (editing) {
            int[] xpt = new int[4];
            int[] ypt = new int[4];
            for (int i = 0; i < icnt; ++i) {
                xpt[0] = pxarray[i] - 3;
                ypt[0] = pyarray[i];
                xpt[1] = pxarray[i];
                ypt[1] = pyarray[i] + 3;
                xpt[2] = pxarray[i] + 3;
                ypt[2] = pyarray[i];
                xpt[3] = pxarray[i];
                ypt[3] = pyarray[i] - 3;
                g.fillPolygon(xpt, ypt, 4);
            }
        }
        Reservoir reservoir = lreg;
        double halfwidth = 5.333333333333333;
        Vector<Node> nvec = reservoir.getNodeVector();
        Vector<Integer> ndirvec = reservoir.getNodeDirVector();
        int size = nvec.size();
        Vector<StreamSegment> segvec = reservoir.getStreamSegmentVector();
        ResDrawPropData resDpData = this.getResDrawPropData();
        if (segvec != null) {
            size = segvec.size();
            for (int i = 0; i < size; ++i) {
                int li;
                double c1;
                double c0;
                StreamElement strm;
                StreamSegment ss = segvec.elementAt(i);
                if (ss == null || (strm = this.findStream((StreamReferenceHolder)ss, alignglyph)) == null || (c0 = ss.downstreamStation != Double.NEGATIVE_INFINITY ? strm.getCoordByStation(ss.downstreamStation) : ss.downstreamCoord) == (c1 = ss.upstreamStation != Double.NEGATIVE_INFINITY ? strm.getCoordByStation(ss.upstreamStation) : ss.upstreamCoord)) continue;
                StreamPolyLine line = strm.getLineSegment(c0, c1);
                if (pxarray.length < line.pts.size() * 2) {
                    pxarray = new int[line.pts.size() * 2];
                    pyarray = new int[line.pts.size() * 2];
                }
                if ((li = line.getLocalRegionArrays(scl, pxarray, pyarray, halfwidth)) <= 0) continue;
                g.setColor(Color.yellow);
                g.fillPolygon(pxarray, pyarray, li);
                g.setColor(resDpData.getReachOutlineColor());
                g.drawPolygon(pxarray, pyarray, li);
            }
        } else {
            Color darkerBlue = Color.blue.darker();
            for (int i = 0; i < size; ++i) {
                int li;
                StreamElement stream;
                Node node = nvec.elementAt(i);
                if (node == null || (stream = this.findStream((StreamReferenceHolder)node, alignglyph)) == null || stream == null) continue;
                double c0 = node.getStreamCoord();
                double c1 = Double.NEGATIVE_INFINITY;
                for (int j = 0; j < size; ++j) {
                    Node node1;
                    if (i == j || (node1 = nvec.elementAt(j)) == null || node1.getStreamIndex() != node.getStreamIndex()) continue;
                    c1 = node1.getStreamCoord();
                    break;
                }
                if (c1 == Double.NEGATIVE_INFINITY) {
                    Integer idir = ndirvec.elementAt(i);
                    if (idir == 1) {
                        c1 = 0.0;
                    } else {
                        c1 = c0;
                        c0 = 1.0;
                    }
                } else if (c1 >= c0) continue;
                StreamPolyLine line = stream.getLineSegment(c1, c0);
                if (pxarray.length < line.pts.size() * 2) {
                    pxarray = new int[line.pts.size() * 2];
                    pyarray = new int[line.pts.size() * 2];
                }
                if ((li = line.getLocalRegionArrays(scl, pxarray, pyarray, halfwidth)) <= 0) continue;
                g.setColor(Color.yellow);
                g.fillPolygon(pxarray, pyarray, li);
                g.setColor(darkerBlue);
                g.drawPolygon(pxarray, pyarray, li);
            }
        }
        this.drawReservoirDam(g, scl, reservoir, true, resDpData.getMinDamWidth() / 1.5, alignglyph, resDpData.getDamColor());
        wpt = lreg.getReferencePt();
        scl.wp2lp(wpt, pt);
        int x = pt.x;
        int y = pt.y;
        if (editing) {
            g.setColor(Color.yellow);
            g.fillOval(x - 3, y - 3, 6, 6);
            g.setColor(Color.blue);
            g.drawOval(x - 3, y - 3, 6, 6);
        }
        if (this._studyDas != null && this._studyDas.isAttributeShown("Names")) {
            Font f = g.getFont();
            g.setFont(resDpData.getNameFont());
            g.setColor(Color.red);
            this.drawString(g, lreg.getName(), x + 10, y + 4, 6.0f);
            g.setFont(f);
        }
        if (isXOR) {
            g.setPaintMode();
        }
    }

    private void drawReservoirDam(Graphics g, MapScale scl, Reservoir res, boolean editing, double halfwidth, StreamAlignmentGlyph alignglyph, Color damColor) {
        WorldPt wloc = new WorldPt();
        WorldPt slp = new WorldPt();
        Vector<Node> nvec = res.getNodeVector();
        Vector<Integer> ndirvec = res.getNodeDirVector();
        int[] pxarray = new int[4];
        int[] pyarray = new int[4];
        for (int i = 0; i < nvec.size(); ++i) {
            WorldLine line;
            Node node = (Node)nvec.get(i);
            Integer idir = (Integer)ndirvec.get(i);
            if (node == null) continue;
            StreamElement elem = this.findStream((StreamReferenceHolder)node, alignglyph);
            WorldPt wpt = elem != null ? elem.getLocationByStation(node.getStreamStation()) : node.getLocation();
            LocalPt lpt = scl.wp2lp(wpt);
            if (idir == 1) {
                if (!editing) continue;
                g.fillOval(lpt.x - 4, lpt.y - 4, 8, 8);
                continue;
            }
            StreamElement stream = this.findStream((StreamReferenceHolder)node, alignglyph);
            if (stream == null || (line = stream.getLine()) == null) continue;
            double coord = node.getStreamCoord();
            if (RMAConst.isUndefinedValue((double)coord)) {
                coord = elem.getCoordByStation(node.getStreamStation());
            }
            if (RMAConst.isUndefinedValue((double)coord)) continue;
            line.getSlopeAtCoord(coord, wloc, slp);
            Color c = g.getColor();
            g.setColor(damColor);
            pxarray[0] = (int)((double)lpt.x - slp.n * halfwidth * 2.0 + slp.e * halfwidth / 2.0 + 0.5);
            pxarray[1] = (int)((double)lpt.x - slp.n * halfwidth * 2.0 - slp.e * halfwidth / 2.0 + 0.5);
            pxarray[2] = (int)((double)lpt.x + slp.n * halfwidth * 2.0 - slp.e * halfwidth / 2.0 + 0.5);
            pxarray[3] = (int)((double)lpt.x + slp.n * halfwidth * 2.0 + slp.e * halfwidth / 2.0 + 0.5);
            pyarray[0] = (int)((double)lpt.y - slp.e * halfwidth * 2.0 - slp.n * halfwidth / 2.0 + 0.5);
            pyarray[1] = (int)((double)lpt.y - slp.e * halfwidth * 2.0 + slp.n * halfwidth / 2.0 + 0.5);
            pyarray[2] = (int)((double)lpt.y + slp.e * halfwidth * 2.0 + slp.n * halfwidth / 2.0 + 0.5);
            pyarray[3] = (int)((double)lpt.y + slp.e * halfwidth * 2.0 - slp.n * halfwidth / 2.0 + 0.5);
            g.fillPolygon(pxarray, pyarray, 4);
            g.setColor(c);
            if (!editing) continue;
            g.fillOval(lpt.x - 4, lpt.y - 4, 8, 8);
        }
    }

    @Override
    public void drawSelectedDiversion(Graphics g, MapScale scl, Diversion diversion, boolean isXOR, boolean editing) {
        if (diversion == null) {
            return;
        }
        StreamAlignmentGlyph alignglyph = this.getStreamAlignmentGlyph();
        if (alignglyph == null) {
            return;
        }
        WorldLine line = null;
        line = diversion.getLine();
        ComputationPoint cp0 = diversion.getComputationPoint(true);
        ComputationPoint cp1 = diversion.getComputationPoint(false);
        Node n0 = diversion.getUpstreamNode();
        Node n1 = diversion.getDownstreamNode();
        if (diversion.getReservoirId() > -1L) {
            StreamSegment ss;
            CommonDataList dl = this.getCommonDataList("hec.watershed.model.Reservoir");
            Reservoir res = (Reservoir)dl.getObject(diversion.getReservoirId());
            if (res != null && (ss = n0.getStreamName() != null ? res.getStreamSegment(n0.getStreamName()) : res.getStreamSegment(n0.getStreamIndex())) != null) {
                double offset = diversion.getReservoirOffset();
                double upCoord = ss.upstreamCoord;
                double downCoord = ss.downstreamCoord;
                double divCoord = (upCoord - downCoord) * offset;
                StreamElement elem = this.findStream((StreamReferenceHolder)n0, alignglyph);
                if (elem != null) {
                    line.getFirstPt().init(elem.getLocationByCoord(divCoord));
                }
            }
        } else {
            this.setPointByComptPt(line.getFirstPt(), cp0, n0.getLocation());
        }
        if (n1 != null) {
            this.setPointByComptPt(line.getLastPt(), cp1, n1.getLocation());
        }
        if (n0 == null) {
            return;
        }
        DiversionDrawPropData divDpData = this.getDiversionDrawPropData();
        if (line != null) {
            int[] locxarray = new int[line.pts.size() * 2];
            int[] locyarray = new int[line.pts.size() * 2];
            double halfwidth = (double)divDpData.getDiversionWidth() / 1.5;
            int li = line.getLocalRegionArrays(scl, locxarray, locyarray, halfwidth);
            if (isXOR) {
                g.setXORMode(XOR_COLOR);
            } else {
                g.setColor(divDpData.getFillColor());
            }
            if (li > 0) {
                g.setColor(Color.yellow);
                g.fillPolygon(locxarray, locyarray, li);
                g.setColor(Color.yellow);
                g.drawPolygon(locxarray, locyarray, li);
                if (this.getDiversionDrawPropData().isDrawName() && this._studyDas.isAttributeShown("Names")) {
                    this.drawConformingString(g, scl, diversion.getLine(), diversion.getName(), 0.5, (int)halfwidth, divDpData.getNameFont(), divDpData.getOutlineColor(), 1, this._glyphLevel + 0.3f);
                }
            }
            int[] xpt = new int[4];
            int[] ypt = new int[4];
            if (editing) {
                g.setColor(Color.black);
                int ptSize = divDpData.getDiversionWidth() / 2;
                for (int i = 0; i < line.pts.size(); ++i) {
                    WorldPt wpt = (WorldPt)line.pts.elementAt(i);
                    LocalPt lpt = this._mapPanel.scale().wp2lp(wpt);
                    xpt[0] = lpt.x - ptSize;
                    ypt[0] = lpt.y;
                    xpt[1] = lpt.x;
                    ypt[1] = lpt.y + ptSize;
                    xpt[2] = lpt.x + ptSize;
                    ypt[2] = lpt.y;
                    xpt[3] = lpt.x;
                    ypt[3] = lpt.y - ptSize;
                    g.fillPolygon(xpt, ypt, 4);
                }
            }
        }
        WorldPt midpt = new WorldPt();
        WorldPt slope = new WorldPt();
        line.getSlopeAtCoord(1.0, midpt, slope);
        this.drawEndArrow(g, scl, line.getLastPt(), slope, true, n1 != null);
        if (isXOR) {
            g.setPaintMode();
        }
    }

    public void drawChannelMod(Graphics g, MapScale scl, ChannelMod cm) {
        StreamAlignmentGlyph alignglyph = this.getStreamAlignmentGlyph();
        if (alignglyph == null || cm == null) {
            return;
        }
        double c0 = 0.0;
        double c1 = 0.0;
        double s0 = 0.0;
        double s1 = 0.0;
        StreamPolyLine line = null;
        StreamElement stream = null;
        stream = this.findStream(cm, alignglyph);
        if (stream != null) {
            s0 = cm.getStartStation();
            s1 = cm.getEndStation();
            c0 = stream.getCoordByStation(s0);
            c1 = stream.getCoordByStation(s1);
            line = stream.getLineSegment(c1, c0);
        }
        if (line == null) {
            return;
        }
        cm.setIgnoreModifiedEvents(true);
        cm.setLine((WorldLine)line);
        cm.setIgnoreModifiedEvents(false);
        ChannelModDrawPropData cmDpData = this.getChannelModDrawPropData();
        int[] locxarray = new int[line.pts.size() * 2];
        int[] locyarray = new int[line.pts.size() * 2];
        int i = line.getLocalRegionArrays(scl, locxarray, locyarray);
        double halfwidth = cmDpData.getChannelModWidth() / 2.0;
        i = line.getLocalRegionArrays(scl, locxarray, locyarray, halfwidth);
        Color channelModColor = cmDpData.getFillColor();
        int ID = (int)cm.getId();
        if (i > 0) {
            g.setPaintMode();
            g.setColor(channelModColor);
            g.fillPolygon(locxarray, locyarray, i);
            g.setColor(channelModColor);
            g.drawPolygon(locxarray, locyarray, i);
        }
        if (cmDpData.isDrawName() && stream != null && this._studyDas.isAttributeShown("Names")) {
            double coord = (c0 + c1) / 2.0;
            this.drawConformingString(g, scl, stream.getLine(), cm.getName(), coord, (int)halfwidth, cmDpData.getNameFont(), Color.blue, 1, this._glyphLevel + 0.4f);
        }
    }

    @Override
    public void drawSelectedChannelMod(Graphics g, MapScale scl, ChannelMod cm, boolean isXOR, boolean editing) {
        StreamAlignmentGlyph alignglyph = this.getStreamAlignmentGlyph();
        double c0 = 0.0;
        double c1 = 0.0;
        double s0 = 0.0;
        double s1 = 0.0;
        StreamPolyLine line = null;
        StreamElement stream = null;
        if (alignglyph != null) {
            stream = this.findStream(cm, alignglyph);
        }
        if (stream != null) {
            s0 = cm.getStartStation();
            s1 = cm.getEndStation();
            c0 = stream.getCoordByStation(s0);
            c1 = stream.getCoordByStation(s1);
            line = stream.getLineSegment(c1, c0);
        }
        int[] locxarray = new int[MapGlyph.maxPtArraySz];
        int[] locyarray = new int[MapGlyph.maxPtArraySz];
        int icnt = line.getLocalRegionArrays(scl, locxarray, locyarray);
        g.setColor(Color.red);
        g.fillPolygon(locxarray, locyarray, icnt);
        g.setColor(Color.yellow);
        g.drawPolygon(locxarray, locyarray, icnt);
        if (editing) {
            WorldPt pt = line.getFirstPt();
            LocalPt lpt = this._mapPanel.scale().wp2lp(pt);
            g.fillOval(lpt.x - 4, lpt.y - 4, 8, 8);
            pt = line.getLastPt();
            lpt = this._mapPanel.scale().wp2lp(pt);
            g.fillOval(lpt.x - 4, lpt.y - 4, 8, 8);
        }
    }

    @Override
    public void drawSelectedCompPt(Graphics g, MapScale scl, ComputationPoint compPt, boolean isXOR, boolean editing) {
        if (compPt == null) {
            return;
        }
        CompPtDrawPropData compPtDpData = this.getCompPtDrawPropData();
        int width = compPtDpData.getCompPtWidth() + 2;
        int halfwidth = (int)((double)width / 2.0);
        WorldPt pt = compPt.getReferencePt();
        if (pt == null || !pt.isValid()) {
            return;
        }
        LocalPt lpt = new LocalPt();
        scl.wp2lp(pt, lpt);
        int x = lpt.x;
        int y = lpt.y;
        if (compPt.getSnapToStream()) {
            int streamId = compPt.getStreamId();
            StreamAlignmentGlyph glyph = this.getStreamAlignmentGlyph();
            if (glyph == null) {
                return;
            }
            StreamElement elem = this.findStream(compPt, glyph);
            if (elem != null) {
                WorldPt wpt = elem.getLocationByStation(compPt.getStreamStation());
                scl.wp2lp(wpt, lpt);
                x = lpt.x;
                y = lpt.y;
            } else {
                System.out.println("drawSelectedCompPt: no stream elem for id " + streamId);
            }
            g.setColor(compPtDpData.getFillColor());
            g.fillOval(x - halfwidth, y - halfwidth, width, width);
        } else {
            g.setColor(Color.yellow);
            g.fillOval(x - halfwidth, y - halfwidth, width, width);
            g.setColor(compPtDpData.getOutlineColor());
            g.drawOval(x - halfwidth, y - halfwidth, width, width);
        }
        if (compPtDpData.isDrawName() && this._studyDas.isAttributeShown("Names")) {
            int offset = halfwidth;
            this._mapPanel.viewport().addMapLabelItem(new MapLabelItem(compPt.getName(), x, y, compPt.getLabelPosition(), offset, -1.0f, compPtDpData.getNameFont(), Color.black, null, false, g));
        }
        if (isXOR) {
            g.setXORMode(XOR_COLOR);
        }
        if (editing) {
            g.setColor(Color.black);
            g.fillRect(x - halfwidth - 5, y - halfwidth - 5, 5, 5);
            g.fillRect(x - halfwidth - 5, y + halfwidth, 5, 5);
            g.fillRect(x + halfwidth, y - halfwidth - 5, 5, 5);
            g.fillRect(x + halfwidth, y + halfwidth, 5, 5);
        }
        if (isXOR) {
            g.setPaintMode();
        }
    }

    @Override
    public void drawSelectedStoragePool(Graphics g, MapScale scl, StoragePool pool, boolean isXOR, boolean editing) {
        this.drawSelectedRegion(g, scl, pool, isXOR, editing, Color.blue);
    }

    @Override
    public void drawSelectedArea(Graphics g, MapScale scl, ImpactArea iarea, boolean isXOR, boolean editing) {
        WorldPt wpt;
        int icnt = 0;
        LocalPt pt = new LocalPt();
        int size = iarea.getRegion().pts.size();
        int[] locxarray = new int[size];
        int[] locyarray = new int[size];
        for (int i = 0; i < size; ++i) {
            wpt = (WorldPt)iarea.getRegion().pts.elementAt(i);
            if (wpt == null) continue;
            scl.wp2lp(wpt, pt);
            locxarray[icnt] = pt.x;
            locyarray[icnt] = pt.y;
            ++icnt;
        }
        if (isXOR) {
            g.setXORMode(XOR_COLOR);
        }
        g.setColor(Color.yellow);
        g.fillPolygon(locxarray, locyarray, icnt);
        g.setPaintMode();
        if (isXOR) {
            g.setXORMode(XOR_COLOR);
        }
        g.setColor(Color.red);
        g.drawPolygon(locxarray, locyarray, icnt);
        if (editing) {
            int[] xpt = new int[4];
            int[] ypt = new int[4];
            for (int i = 0; i < icnt; ++i) {
                xpt[0] = locxarray[i] - 3;
                ypt[0] = locyarray[i];
                xpt[1] = locxarray[i];
                ypt[1] = locyarray[i] + 3;
                xpt[2] = locxarray[i] + 3;
                ypt[2] = locyarray[i];
                xpt[3] = locxarray[i];
                ypt[3] = locyarray[i] - 3;
                g.fillPolygon(xpt, ypt, 4);
            }
        }
        wpt = iarea.getLabelPositionPoint();
        scl.wp2lp(wpt, pt);
        int x = pt.x;
        int y = pt.y;
        int offset = 9;
        StreamAlignmentGlyph glyph = this.getStreamAlignmentGlyph();
        StreamElement elem = this.findStream(iarea, glyph);
        if (elem != null) {
            Graphics2D g2d;
            WorldPt pt2 = elem.getLocationByStation(iarea.getIndexStation());
            LocalPt lpt = scl.wp2lp(wpt);
            LocalPt lpt2 = scl.wp2lp(pt2);
            g.setColor(Color.red.brighter());
            Stroke oldStroke = null;
            if (g instanceof Graphics2D) {
                g2d = (Graphics2D)g;
                oldStroke = g2d.getStroke();
                if (oldStroke instanceof BasicStroke) {
                    g2d.setStroke(new BasicStroke(((BasicStroke)oldStroke).getLineWidth() + 1.0f));
                } else {
                    g2d.setStroke(new BasicStroke(2.0f));
                }
            }
            g.drawLine(lpt.x, lpt.y, lpt2.x, lpt2.y);
            if (g instanceof Graphics2D) {
                g2d = (Graphics2D)g;
                g2d.setStroke(oldStroke);
            }
        }
        float priority = this._glyphLevel + 0.3f;
        if (this._studyDas.isAttributeShown("Names")) {
            this._mapPanel.viewport().addMapLabelItem(new MapLabelItem(iarea.getName(), x, y, iarea.getLabelPosition(), offset, priority, g.getFont(), Color.black, null, false, g));
        }
        if (isXOR) {
            g.setPaintMode();
        }
    }

    public void drawSelectedRegion(Graphics g, MapScale scl, StudyRegion sr, boolean isXOR, boolean editing, Color outLine) {
        WorldPt wpt;
        int icnt = 0;
        LocalPt pt = new LocalPt();
        int size = sr.getRegion().pts.size();
        if (sr instanceof ImpactArea) {
            wpt = sr.getReferencePt();
            StreamAlignmentGlyph glyph = this.getStreamAlignmentGlyph();
            StreamElement elem = this.findStream((ImpactArea)sr, glyph);
            if (elem != null) {
                WorldPt pt2 = elem.getLocationByStation(((ImpactArea)sr).getIndexStation());
                pt = scl.wp2lp(wpt);
                LocalPt lpt2 = scl.wp2lp(pt2);
                g.setColor(outLine);
                g.drawLine(pt.x, pt.y, lpt2.x, lpt2.y);
            }
        }
        int[] locxarray = new int[MapGlyph.maxPtArraySz];
        int[] locyarray = new int[MapGlyph.maxPtArraySz];
        for (int i = 0; i < size && i < 4000; ++i) {
            wpt = (WorldPt)sr.getRegion().pts.elementAt(i);
            if (wpt == null) continue;
            scl.wp2lp(wpt, pt);
            locxarray[icnt] = pt.x;
            locyarray[icnt] = pt.y;
            ++icnt;
        }
        if (isXOR) {
            g.setXORMode(XOR_COLOR);
        }
        g.setColor(Color.yellow);
        g.fillPolygon(locxarray, locyarray, icnt);
        g.setPaintMode();
        if (isXOR) {
            g.setXORMode(XOR_COLOR);
        }
        g.setColor(outLine);
        g.drawPolygon(locxarray, locyarray, icnt);
        if (editing) {
            int[] xpt = new int[4];
            int[] ypt = new int[4];
            for (int i = 0; i < icnt; ++i) {
                xpt[0] = locxarray[i] - 3;
                ypt[0] = locyarray[i];
                xpt[1] = locxarray[i];
                ypt[1] = locyarray[i] + 3;
                xpt[2] = locxarray[i] + 3;
                ypt[2] = locyarray[i];
                xpt[3] = locxarray[i];
                ypt[3] = locyarray[i] - 3;
                g.fillPolygon(xpt, ypt, 4);
            }
        }
        wpt = sr.getReferencePt();
        scl.wp2lp(wpt, pt);
        int x = pt.x;
        int y = pt.y;
        if (_impactImage != null) {
            g.drawImage(_impactImage, x - 8, y - 8, 16, 16, (ImageObserver)this._mapPanel);
        } else {
            g.setColor(outLine);
            g.fillOval(x - 2, y - 2, 4, 4);
            g.setColor(Color.blue);
            g.drawOval(x - 2, y - 2, 4, 4);
        }
        g.setColor(outLine);
        if (isXOR) {
            g.setPaintMode();
        }
        this.drawSelectedTSNode(g, scl, sr.getReferencePt(), sr.getName(), isXOR, editing, sr.getLabelPosition());
    }

    public void drawLevee(Graphics g, MapScale scl, Levee levee) {
        WorldLine wl;
        if (levee == null) {
            return;
        }
        if (levee.getFollowsStream()) {
            this.getLeveeLine(g, scl, levee);
        }
        if ((wl = levee.getLine()) == null) {
            System.out.println("drawLevee: no line for Levee " + levee.getName());
            return;
        }
        LeveeDrawPropData leveeData = this.getLeveeDrawPropData();
        double halfwidth = (double)leveeData.getLeveeWidth() / 1.5;
        if (wl.pts.size() > 0) {
            this.drawLine(g, wl, scl, halfwidth, leveeData.getFillColor(), null, false, null, 0);
            if (leveeData.isDrawName()) {
                Font f = g.getFont();
                g.setColor(leveeData.getFillColor());
                g.setFont(leveeData.getNameFont());
                if (this._studyDas.isAttributeShown("Names")) {
                    this.drawConformingString(g, scl, wl, levee.getName(), 0.5, (int)halfwidth, leveeData.getNameFont(), leveeData.getFillColor(), levee.getBank(), this._glyphLevel + 0.35f);
                }
                g.setFont(f);
            }
        }
    }

    @Override
    public void drawSelectedLevee(Graphics g, MapScale scl, Levee levee, boolean isXOR, boolean editing) {
        WorldLine wl;
        if (levee == null) {
            return;
        }
        if (levee.getFollowsStream()) {
            this.getLeveeLine(g, scl, levee);
        }
        if ((wl = levee.getLine()) == null) {
            return;
        }
        LeveeDrawPropData leveeData = this.getLeveeDrawPropData();
        double halfwidth = (double)leveeData.getLeveeWidth() / 1.5;
        if (wl.pts.size() > 0) {
            int ptSize = leveeData.getLeveeWidth() / 2;
            this.drawLine(g, wl, scl, halfwidth, Color.YELLOW, null, editing && !levee.getFollowsStream(), leveeData.getFillColor(), ptSize);
        }
    }

    public void drawDiversion(Graphics g, MapScale scl, Diversion diversion) {
        int[] locyarray;
        int[] locxarray;
        int li;
        ComputationPoint cp0 = diversion.getComputationPoint(true);
        ComputationPoint cp1 = diversion.getComputationPoint(false);
        Node n0 = diversion.getUpstreamNode();
        Node n1 = diversion.getDownstreamNode();
        WorldLine wl = diversion.getLine();
        DiversionDrawPropData divDpData = this.getDiversionDrawPropData();
        double halfwidth = (double)divDpData.getDiversionWidth() / 1.5;
        StreamAlignmentGlyph glyph = this.getStreamAlignmentGlyph();
        if (diversion.getReservoirId() > -1L) {
            StreamSegment ss;
            CommonDataList dl = this.getCommonDataList("hec.watershed.model.Reservoir");
            Reservoir res = (Reservoir)dl.getObject(diversion.getReservoirId());
            if (res != null && (ss = res.getStreamSegment(n0.getStreamIndex())) != null) {
                double offset = diversion.getReservoirOffset();
                double upCoord = ss.upstreamCoord;
                double downCoord = ss.downstreamCoord;
                double divCoord = (upCoord - downCoord) * offset;
                StreamElement elem = this._alignment.findReach(n0.getStreamIndex());
                if (elem != null) {
                    wl.getFirstPt().init(elem.getLocationByCoord(divCoord));
                }
            }
        } else {
            this.setPointByComptPt(wl.getFirstPt(), cp0, n0.getLocation());
        }
        if (n1 != null) {
            this.setPointByComptPt(wl.getLastPt(), cp1, n1.getLocation());
        }
        if ((li = wl.getLocalRegionArrays(scl, locxarray = new int[wl.pts.size() * 2], locyarray = new int[wl.pts.size() * 2], halfwidth)) > 0) {
            g.setPaintMode();
            g.setColor(divDpData.getFillColor());
            g.fillPolygon(locxarray, locyarray, li);
            if (divDpData.isDrawName() && this._studyDas.isAttributeShown("Names")) {
                Font f = g.getFont();
                g.setFont(divDpData.getNameFont());
                this.drawConformingString(g, scl, diversion.getLine(), diversion.getName(), 0.5, (int)halfwidth, divDpData.getNameFont(), divDpData.getFillColor(), 1, this._glyphLevel + 0.3f);
                g.setFont(f);
            }
        }
        WorldPt pt0 = null;
        Object pt1 = null;
        pt0 = n0.getLocation();
        WorldPt midpt = new WorldPt();
        WorldPt slope = new WorldPt();
        wl.getSlopeAtCoord(1.0, midpt, slope);
        if (n1 != null) {
            g.setColor(divDpData.getConColor());
        } else {
            g.setColor(divDpData.getDisConColor());
        }
        this.drawEndArrow(g, scl, wl.getLastPt(), slope, false, n1 != null);
    }

    public void drawStoragePool(Graphics g, MapScale scl, StoragePool pool) {
        this.drawRegion(g, scl, pool, Color.blue, Color.black);
    }

    public void drawCompPt(Graphics g, MapScale scl, ComputationPoint cpt, int size, Color bgcolor, Color fgcolor, int symbolNum) {
        int width = size;
        int halfwidth = (int)((double)width / 2.0);
        Vector projects = cpt.getProjects();
        CompPtDrawPropData compPtDpData = this.getCompPtDrawPropData();
        WorldPt pt = cpt.getReferencePt();
        if (pt == null || !pt.isValid() && !cpt.getSnapToStream()) {
            System.out.println("drawCompPt: null or invalid location for " + cpt.getName());
            return;
        }
        this.getCompPtXY(cpt, this.xy, scl);
        if (cpt.getSnapToStream()) {
            Symbol.draw((Graphics)g, (int)this.xy[0], (int)this.xy[1], (int)symbolNum, (Color)fgcolor, (Color)bgcolor, (float)width);
        } else {
            g.setColor(Color.lightGray);
            Symbol.draw((Graphics)g, (int)this.xy[0], (int)this.xy[1], (int)symbolNum, (Color)fgcolor, (Color)bgcolor, (float)width);
        }
        if (compPtDpData.isDrawName() && this._studyDas.isAttributeShown("Names")) {
            float priority = this._glyphLevel + 0.5f;
            int offset = halfwidth;
            this._mapPanel.viewport().addMapLabelItem(new MapLabelItem(cpt.getName(), this.xy[0], this.xy[1], cpt.getLabelPosition(), offset, priority, compPtDpData.getNameFont(), Color.black, null, false, g));
        }
    }

    public void drawCompPt(Graphics g, MapScale scl, ComputationPoint cpt) {
        if (cpt == null) {
            return;
        }
        CompPtDrawPropData compPtDpData = this.getCompPtDrawPropData();
        int width = compPtDpData.getCompPtWidth();
        int halfwidth = (int)((double)width / 2.0);
        WorldPt pt = cpt.getReferencePt();
        if (pt == null || !pt.isValid() && !cpt.getSnapToStream()) {
            System.out.println("drawCompPt: null or invalid location for " + cpt.getName());
            return;
        }
        this.getCompPtXY(cpt, this.xy, scl);
        if (cpt.getSnapToStream()) {
            g.setColor(compPtDpData.getFillColor());
            g.fillOval(this.xy[0] - halfwidth, this.xy[1] - halfwidth, width, width);
        } else {
            g.setColor(Color.lightGray);
            g.fillOval(this.xy[0] - halfwidth, this.xy[1] - halfwidth, width, width);
            g.setColor(compPtDpData.getOutlineColor());
            g.drawOval(this.xy[0] - halfwidth, this.xy[1] - halfwidth, width, width);
        }
        if (compPtDpData.isDrawName() && this._studyDas.isAttributeShown("Names")) {
            float priority = this._glyphLevel + 0.5f;
            int offset = halfwidth;
            this._mapPanel.viewport().addMapLabelItem(new MapLabelItem(cpt.getName(), this.xy[0], this.xy[1], cpt.getLabelPosition(), offset, priority, compPtDpData.getNameFont(), Color.black, null, false, g));
        }
    }

    public void drawArea(Graphics g, MapScale scl, ImpactArea iarea) {
        if (iarea == null) {
            return;
        }
        this.drawRegion(g, scl, iarea, iarea.getColor(), Color.red);
    }

    public void drawSelectedTSNode(Graphics g, MapScale scl, WorldPt pt, String name, boolean isXOR, boolean editing, int labelPosition) {
        if (pt == null || !pt.isValid()) {
            return;
        }
        if (isXOR) {
            g.setXORMode(XOR_COLOR);
        }
        LocalPt lpt = new LocalPt();
        scl.wp2lp(pt, lpt);
        int x = lpt.x;
        int y = lpt.y;
        int offset = 11;
        if (_selTsImage != null) {
            g.drawImage(_selTsImage, x - 10, y - 10, (ImageObserver)this._mapPanel);
        } else {
            g.setColor(Color.red);
            g.fillOval(x - 4, y - 4, 8, 8);
            g.setColor(Color.blue);
            g.drawOval(x - 4, y - 4, 8, 8);
            offset = 5;
        }
        if (editing) {
            g.setColor(Color.black);
            g.fillRect(x - 14, y - 14, 4, 4);
            g.fillRect(x - 14, y + 12, 4, 4);
            g.fillRect(x + 12, y - 14, 4, 4);
            g.fillRect(x + 12, y + 12, 4, 4);
        }
        g.setColor(Color.blue);
        if (name != null && this._studyDas.isAttributeShown("Names")) {
            float priority = -1.0f;
            this._mapPanel.viewport().addMapLabelItem(new MapLabelItem(name, x, y, labelPosition, offset, priority, g.getFont(), Color.blue, null, false, g));
        }
        if (isXOR) {
            g.setPaintMode();
        }
    }

    public void drawOtherProject(Graphics g, MapScale scl, OtherProject proj) {
        if (proj == null) {
            return;
        }
        WorldPt pt = proj.getReferencePt();
        LocalPt lpt = new LocalPt();
        scl.wp2lp(pt, lpt);
        this.xy[0] = lpt.x;
        this.xy[1] = lpt.y;
        int offset = 11;
        int position = proj.getIconPosition();
        AbstractStudyGlyph.getOtherProjectIconPosition(position, this.xy);
        int x = this.xy[0];
        int y = this.xy[1];
        ComputationPoint cpt = proj.getComputationPoint();
        if (cpt != null) {
            pt = cpt.getReferencePt();
            if (pt == null || !pt.isValid()) {
                return;
            }
            this.getCompPtXY(cpt, this.xy, scl);
            g.drawLine(x + 10, y + 10, this.xy[0], this.xy[1]);
        }
        if (_otherProjImage != null) {
            g.drawImage(_otherProjImage, x, y, (ImageObserver)this._mapPanel);
        } else {
            g.setColor(Color.red);
            g.fillOval(x - 4, y - 4, 8, 8);
            g.setColor(Color.blue);
            g.drawOval(x - 4, y - 4, 8, 8);
            offset = 5;
        }
        float priority = this._glyphLevel + 0.3f;
        if (proj.getName() != null && this._studyDas.isAttributeShown("Names")) {
            this._mapPanel.viewport().addMapLabelItem(new MapLabelItem(proj.getName(), x, y, proj.getLabelPosition(), offset, priority, g.getFont(), Color.blue, null, false, g));
        }
    }

    @Override
    public void drawSelectedOtherProject(Graphics g, MapScale scl, OtherProject proj, boolean isXOR, boolean editing) {
        if (proj == null) {
            return;
        }
        WorldPt pt = proj.getReferencePt();
        if (pt == null || !pt.isValid()) {
            return;
        }
        if (isXOR) {
            g.setXORMode(XOR_COLOR);
        }
        LocalPt lpt = new LocalPt();
        scl.wp2lp(pt, lpt);
        this.xy[0] = lpt.x;
        this.xy[1] = lpt.y;
        int position = proj.getIconPosition();
        AbstractStudyGlyph.getOtherProjectIconPosition(position, this.xy);
        int offset = 11;
        if (_selOtherProjImage != null) {
            g.drawImage(_selOtherProjImage, this.xy[0], this.xy[1], (ImageObserver)this._mapPanel);
        } else {
            g.setColor(Color.red);
            g.fillOval(this.xy[0] - 4, this.xy[1] - 4, 8, 8);
            g.setColor(Color.blue);
            g.drawOval(this.xy[0] - 4, this.xy[1] - 4, 8, 8);
            offset = 5;
        }
        if (editing) {
            g.setColor(Color.black);
            g.fillRect(this.xy[0] - 4, this.xy[1] - 4, 4, 4);
            g.fillRect(this.xy[0] - 4, this.xy[1] + 20, 4, 4);
            g.fillRect(this.xy[0] + 20, this.xy[1] - 4, 4, 4);
            g.fillRect(this.xy[0] + 20, this.xy[1] + 20, 4, 4);
        }
        if (proj.getName() != null && this._studyDas.isAttributeShown("Names")) {
            this._mapPanel.viewport().addMapLabelItem(new MapLabelItem(proj.getName(), this.xy[0], this.xy[1], proj.getLabelPosition(), offset, -1.0f, g.getFont(), Color.blue, null, false, g));
        }
        if (isXOR) {
            g.setPaintMode();
        }
    }

    public void drawReservoir(Graphics g, MapScale scl, Reservoir reservoir) {
        WorldPt pt;
        int i;
        StreamAlignmentGlyph alignglyph = this.getStreamAlignmentGlyph();
        if (alignglyph == null) {
            return;
        }
        StreamPolyLine line = null;
        if (reservoir == null) {
            return;
        }
        ResDrawPropData resDpData = this.getResDrawPropData();
        WorldRegion reg = reservoir.getRegion();
        int size = reg.pts.size();
        LocalPt lpt = new LocalPt();
        int[] locxarray = new int[MapGlyph.maxPtArraySz];
        int[] locyarray = new int[MapGlyph.maxPtArraySz];
        for (i = 0; i < size && (pt = (WorldPt)reg.pts.elementAt(i)) != null; ++i) {
            scl.wp2lp(pt, lpt);
            locxarray[i] = lpt.x;
            locyarray[i] = lpt.y;
        }
        Node dsn = reservoir.getDownstreamNode();
        if (dsn != null) {
            pt = dsn.getLocation();
            scl.wp2lp(pt, lpt);
            locxarray[i] = lpt.x;
            locyarray[i] = lpt.y;
            ++i;
        }
        if (i > 0 && resDpData.isDrawRPolygon()) {
            Graphics2D g2 = null;
            Composite oldac = null;
            AlphaComposite ac = null;
            if (g instanceof Graphics2D) {
                g2 = (Graphics2D)g;
                oldac = g2.getComposite();
                ac = AlphaComposite.getInstance(3, 0.6f);
            }
            g.setColor(resDpData.getTriangleFillColor());
            if (g2 != null) {
                g2.setComposite(ac);
                g2.fillPolygon(locxarray, locyarray, i);
                if (oldac != null) {
                    g2.setComposite(oldac);
                }
                g.setColor(resDpData.getTriangleOutlineColor());
                g.drawPolygon(locxarray, locyarray, i);
            } else {
                g.setXORMode(XOR_COLOR);
                g.fillPolygon(locxarray, locyarray, i);
                g.setPaintMode();
                g.setColor(resDpData.getTriangleOutlineColor());
                g.drawPolygon(locxarray, locyarray, i);
            }
        }
        Vector<Node> nvec = reservoir.getNodeVector();
        Vector<Integer> ndirvec = reservoir.getNodeDirVector();
        size = nvec.size();
        double halfwidth = resDpData.getReachWidth() / 1.5;
        Vector<StreamSegment> segvec = reservoir.getStreamSegmentVector();
        if (segvec != null) {
            size = segvec.size();
            for (i = 0; i < size; ++i) {
                int li;
                double c1;
                double c0;
                StreamElement strm;
                StreamSegment ss = segvec.elementAt(i);
                if (ss == null) continue;
                String streamName = ss.streamName;
                if (streamName != null) {
                    strm = alignglyph.findReach(ss.streamIndex);
                } else {
                    strm = alignglyph.findReach(ss.streamIndex);
                    if (strm != null) {
                        ss.streamName = strm.getName();
                    }
                }
                if (strm == null || (c0 = ss.downstreamStation != Double.NEGATIVE_INFINITY ? strm.getCoordByStation(ss.downstreamStation) : ss.downstreamCoord) == (c1 = ss.upstreamStation != Double.NEGATIVE_INFINITY ? strm.getCoordByStation(ss.upstreamStation) : ss.upstreamCoord)) continue;
                line = strm.getLineSegment(c0, c1);
                if (locxarray.length < line.pts.size() * 2) {
                    locxarray = new int[line.pts.size() * 2];
                    locyarray = new int[line.pts.size() * 2];
                }
                if ((li = line.getLocalRegionArrays(scl, locxarray, locyarray, halfwidth)) <= 0) continue;
                g.setPaintMode();
                g.setColor(resDpData.getReachFillColor());
                g.fillPolygon(locxarray, locyarray, li);
                g.setColor(resDpData.getReachOutlineColor());
                g.drawPolygon(locxarray, locyarray, li);
            }
        } else {
            for (i = 0; i < size; ++i) {
                int li;
                StreamElement stream;
                Node node = nvec.elementAt(i);
                if (node == null || (stream = this.findStream((StreamReferenceHolder)node, alignglyph)) == null) continue;
                double station0 = node.getStreamStation();
                double c0 = node.getStreamCoord();
                double station1 = Double.NEGATIVE_INFINITY;
                double c1 = Double.NEGATIVE_INFINITY;
                for (int j = 0; j < size; ++j) {
                    Node node1;
                    if (i == j || (node1 = nvec.elementAt(j)) == null || node1.getStreamIndex() != node.getStreamIndex()) continue;
                    station1 = node1.getStreamStation();
                    c1 = stream.getCoordByStation(station1);
                    c1 = node1.getStreamCoord();
                    break;
                }
                if (c1 == Double.NEGATIVE_INFINITY) {
                    Integer idir = ndirvec.elementAt(i);
                    if (idir == 1) {
                        c1 = 0.0;
                    } else {
                        c1 = c0;
                        c0 = 1.0;
                    }
                } else if (c1 >= c0) continue;
                line = stream.getLineSegment(c1, c0);
                if (locxarray.length < line.pts.size() * 2) {
                    locxarray = new int[line.pts.size() * 2];
                    locyarray = new int[line.pts.size() * 2];
                }
                if ((li = line.getLocalRegionArrays(scl, locxarray, locyarray, halfwidth)) <= 0) continue;
                g.setPaintMode();
                g.setColor(resDpData.getReachFillColor());
                g.fillPolygon(locxarray, locyarray, li);
                g.setColor(resDpData.getReachOutlineColor());
                g.drawPolygon(locxarray, locyarray, li);
            }
        }
        this.drawReservoirDam(g, scl, reservoir, false, resDpData.getMinDamWidth() / 1.5, alignglyph, resDpData.getDamColor());
        pt = reservoir.getReferencePt();
        scl.wp2lp(pt, lpt);
        int x = lpt.x;
        int y = lpt.y;
        if (_impactImage == null) {
            g.setColor(Color.red);
            g.fillOval(x - 2, y - 2, 4, 4);
            g.setColor(Color.blue);
            g.drawOval(x - 2, y - 2, 4, 4);
        }
        if (resDpData.isDrawName() && this._studyDas.isAttributeShown("Names")) {
            Font f = g.getFont();
            g.setFont(resDpData.getNameFont());
            g.setColor(resDpData.getTriangleOutlineColor());
            this.drawString(g, reservoir.getName(), x + 10, y + 4, 3.0f);
            g.setFont(f);
        }
    }

    public void drawRegion(Graphics g, MapScale scl, StudyRegion region, Color fill, Color outLine) {
        int i;
        WorldPt pt;
        if (region == null) {
            return;
        }
        WorldRegion reg = region.getRegion();
        if (region instanceof ImpactArea) {
            StreamElement elem;
            pt = ((ImpactArea)region).getLabelPositionPoint();
            if (this._alignment != null && (elem = this._alignment.findReach(((ImpactArea)region).getStreamId())) != null) {
                WorldPt pt2 = elem.getLocationByStation(((ImpactArea)region).getIndexStation());
                LocalPt lpt = scl.wp2lp(pt);
                LocalPt lpt2 = scl.wp2lp(pt2);
                g.setColor(outLine);
                g.drawLine(lpt.x, lpt.y, lpt2.x, lpt2.y);
            }
        }
        int size = reg.pts.size();
        int[] locxarray = new int[size];
        int[] locyarray = new int[size];
        LocalPt lpt = new LocalPt();
        for (i = 0; i < size && (pt = (WorldPt)reg.pts.elementAt(i)) != null; ++i) {
            scl.wp2lp(pt, lpt);
            locxarray[i] = lpt.x;
            locyarray[i] = lpt.y;
        }
        Graphics2D g2 = null;
        Composite oldac = null;
        AlphaComposite ac = null;
        if (g instanceof Graphics2D) {
            g2 = (Graphics2D)g;
            oldac = g2.getComposite();
            ac = AlphaComposite.getInstance(3, 0.6f);
        }
        if (i > 0) {
            g.setColor(fill);
            if (g2 != null) {
                g2.setComposite(ac);
                g2.fillPolygon(locxarray, locyarray, i);
                if (oldac != null) {
                    g2.setComposite(oldac);
                }
            } else {
                g.setXORMode(XOR_COLOR);
                g.fillPolygon(locxarray, locyarray, i);
                g.setPaintMode();
            }
            g.setColor(outLine);
            g.drawPolygon(locxarray, locyarray, i);
        }
        pt = region.getReferencePt();
        scl.wp2lp(pt, lpt);
        int x = lpt.x;
        int y = lpt.y;
        int offset = 9;
        g.setColor(outLine);
        ImpactAreaDrawPropData impactAreaDpData = this.getImpactAreaDrawPropData();
        if (region instanceof StoragePool) {
            this.drawTSNode(g, scl, region.getReferencePt(), region.getName(), region.getLabelPosition());
        } else if (region instanceof ImpactArea) {
            if (impactAreaDpData.isDrawName() && this._studyDas.isAttributeShown("Names")) {
                pt = ((ImpactArea)region).getLabelPositionPoint();
                scl.wp2lp(pt, lpt);
                int x1 = lpt.x;
                int y1 = lpt.y;
                ImpactArea iarea = (ImpactArea)region;
                float priority = -1.0f;
                this._mapPanel.viewport().addMapLabelItem(new MapLabelItem(iarea.getName(), x1, y1, iarea.getLabelPosition(), offset, priority, impactAreaDpData.getNameFont(), Color.black, null, false, g));
            }
        } else {
            this.drawString(g, region.getName(), x + 10, y + 4, this._glyphLevel);
        }
    }

    public void drawTSNode(Graphics g, MapScale scl, WorldPt pt, String name, int labelPosition) {
        LocalPt lpt = new LocalPt();
        scl.wp2lp(pt, lpt);
        int x = lpt.x;
        int y = lpt.y;
        int offset = 11;
        if (_tsImage != null) {
            g.drawImage(_tsImage, x - 10, y - 10, (ImageObserver)this._mapPanel);
        } else {
            g.setColor(Color.red);
            g.fillOval(x - 4, y - 4, 8, 8);
            g.setColor(Color.blue);
            g.drawOval(x - 4, y - 4, 8, 8);
            offset = 5;
        }
        if (name != null && this._studyDas.isAttributeShown("Names")) {
            float priority = this._glyphLevel + 0.3f;
            this._mapPanel.viewport().addMapLabelItem(new MapLabelItem(name, x, y, labelPosition, offset, priority, g.getFont(), Color.blue, null, false, g));
        }
    }

    public StreamAlignmentGlyph getStreamAlignmentGlyph() {
        if (this._alignmentGlyph == null) {
            this._alignmentGlyph = (StreamAlignmentGlyph)this._mapPanel.findGlyphOfClass(StreamAlignmentGlyph.class.getName());
        }
        return this._alignmentGlyph;
    }

    public boolean isSelected(Object obj) {
        if (obj == null) {
            return false;
        }
        for (int ii = 0; ii < this._selectionVector.size(); ++ii) {
            MapGlyph.Selection sel = (MapGlyph.Selection)this._selectionVector.get(ii);
            if (sel.object == null || sel.object != obj && !sel.object.equals(obj)) continue;
            return true;
        }
        return false;
    }

    protected abstract StudyIfc getStudy();

    private void drawString(Graphics g, String s, int x, int y, float priority) {
        if (!this._studyDas.isAttributeShown("Names")) {
            return;
        }
        this._mapPanel.viewport().addMapLabelItem(new MapLabelItem(s, x, y, priority, g.getFont(), g.getColor(), null, g));
    }

    private void drawSelectedObject(Graphics g, MapScale scl, Object obj, boolean add, boolean editing) {
        if (obj == null) {
            return;
        }
        if (obj instanceof Diversion) {
            this.drawSelectedDiversion(g, scl, (Diversion)obj, add, editing);
        } else if (obj instanceof Reservoir) {
            this.drawSelectedReservoir(g, scl, (Reservoir)obj, add, editing);
        } else if (obj instanceof ImpactArea) {
            this.drawSelectedArea(g, scl, (ImpactArea)obj, add, editing);
        } else if (obj instanceof StoragePool) {
            this.drawSelectedStoragePool(g, scl, (StoragePool)obj, add, editing);
        } else if (obj instanceof ComputationPoint) {
            this.drawSelectedCompPt(g, scl, (ComputationPoint)obj, add, editing);
        } else if (obj instanceof OtherProject) {
            this.drawSelectedOtherProject(g, scl, (OtherProject)obj, add, editing);
        } else if (obj instanceof ChannelMod) {
            this.drawSelectedChannelMod(g, scl, (ChannelMod)obj, add, editing);
        } else if (obj instanceof Levee) {
            this.drawSelectedLevee(g, scl, (Levee)obj, add, editing);
        }
    }

    void setPointByComptPt(WorldPt pt2set, ComputationPoint cp, WorldPt defaultPt) {
        WorldPt wpt;
        StreamAlignmentGlyph glyph;
        StreamElement elem;
        if (cp != null && (elem = this.findStream(cp, glyph = this.getStreamAlignmentGlyph())) != null && (wpt = elem.getLocationByStation(cp.getStreamStation())) != null && wpt.isValid()) {
            pt2set.init(wpt);
            return;
        }
        if (defaultPt != null) {
            pt2set.init(defaultPt);
        }
    }

    public void drawEndArrow(Graphics g, MapScale scl, WorldPt loc, WorldPt wslope, boolean selected, boolean connected) {
        double hlen = 15.0;
        double hoff = 6.0;
        int idir = 1;
        WorldPt slope = new WorldPt(wslope);
        slope.n *= -1.0;
        LocalPt lpt = new LocalPt();
        scl.wp2lp(loc, lpt);
        int x = lpt.x;
        int y = lpt.y;
        int x1 = x;
        int y1 = y;
        int x0 = x;
        int y0 = y;
        DiversionDrawPropData divDpData = this.getDiversionDrawPropData();
        Polygon p = new Polygon();
        if (connected) {
            g.setColor(divDpData.getConColor());
        } else if (selected) {
            g.setColor(Color.yellow);
        }
        if (idir > 0) {
            x0 = x1 + (int)(-slope.n * hoff - slope.e * hlen);
            y0 = y1 + (int)(slope.e * hoff - slope.n * hlen);
            p.addPoint(x0, y0);
            p.addPoint(x1, y1);
            x0 = x1 + (int)(slope.n * hoff - slope.e * hlen);
            y0 = y1 + (int)(-slope.e * hoff - slope.n * hlen);
            p.addPoint(x0, y0);
            if (!this._mapPanel.getVisibleRect().intersects(p.getBounds())) {
                return;
            }
            g.fillPolygon(p);
            if (connected && selected) {
                g.setColor(Color.black);
            } else if (connected) {
                g.setColor(Color.black);
            } else {
                g.setColor(Color.black);
            }
            g.drawPolygon(p);
        } else {
            x1 = x0 - (int)(-slope.n * hoff - slope.e * hlen);
            y1 = y0 - (int)(slope.e * hoff - slope.n * hlen);
            p.addPoint(x0, y0);
            p.addPoint(x1, y1);
            x1 = x0 - (int)(slope.n * hoff - slope.e * hlen);
            y1 = y0 - (int)(-slope.e * hoff - slope.n * hlen);
            p.addPoint(x1, y1);
            g.setColor(Color.black);
            g.drawPolygon(p);
            g.fillPolygon(p);
        }
    }

    public WorldLine getLeveeLine(Graphics g, MapScale scl, Levee levee) {
        if (levee == null) {
            return null;
        }
        StreamAlignmentGlyph alignglyph = this.getStreamAlignmentGlyph();
        if (alignglyph == null) {
            System.out.println("getLeveeLine:no StreamAlignmentGlyph found");
            return null;
        }
        List<StreamSegmentIdentifier> ssiList = levee.getStreamSegmentList();
        int size = ssiList.size();
        StreamPolyLine streamLine = null;
        int offset = levee.getAveOffset();
        int bank = levee.getBank();
        for (int i = 0; i < size; ++i) {
            StreamSegmentIdentifier ssi = ssiList.get(i);
            StreamElement streamElem = this.findStream((StreamReferenceHolder)ssi, alignglyph);
            if (streamElem == null) continue;
            double startCoord = streamElem.getCoordByStation(ssi.startStation);
            double endCoord = streamElem.getCoordByStation(ssi.endStation);
            StreamPolyLine tmpLine = ((StreamPolyLine)streamElem.getLine()).getLineSegment(startCoord, endCoord);
            if (streamLine == null) {
                streamLine = tmpLine;
                continue;
            }
            streamLine.add((WorldLine)tmpLine);
        }
        if (streamLine == null) {
            System.out.println("getLeveeLine: null streamLine for" + levee.getName());
            return null;
        }
        WorldLine leveeLine = streamLine.createOffsetLine(0.0, 1.0, (double)offset, bank);
        levee.setIgnoreModifiedEvents(true);
        levee.setLine(leveeLine);
        levee.setIgnoreModifiedEvents(false);
        return levee.getLine();
    }

    public static void getOtherProjectIconPosition(int position, int[] xy) {
        int xoff;
        int yoff;
        double ca = Math.cos(_angle[position]);
        double sa = Math.sin(_angle[position]);
        int offset = 15;
        switch (position) {
            case 0: 
            case 4: {
                yoff = (int)((double)(-offset) / 1.4);
                break;
            }
            case 1: 
            case 3: {
                yoff = -offset;
                break;
            }
            case 2: {
                yoff = (int)((double)(-offset) * 1.5);
                break;
            }
            case 5: 
            case 7: {
                yoff = (int)((double)offset / 2.5);
                break;
            }
            default: {
                yoff = 0;
            }
        }
        switch (position) {
            case 0: 
            case 1: 
            case 7: {
                xoff = offset / 2;
                break;
            }
            case 2: 
            case 6: {
                xoff = (int)((double)(-offset) / 1.4);
                break;
            }
            default: {
                xoff = -offset * 2;
            }
        }
        xy[0] = (int)((double)xy[0] + (double)offset * ca + (double)xoff + 0.5);
        xy[1] = (int)((double)xy[1] - (double)offset * sa + (double)yoff + 0.5);
    }

    protected void getCompPtXY(ComputationPoint cpt, int[] xy, MapScale scl) {
        WorldPt pt = cpt.getReferencePt();
        LocalPt lpt = scl.wp2lp(pt);
        xy[0] = lpt.x;
        xy[1] = lpt.y;
        if (cpt.getSnapToStream()) {
            StreamAlignmentGlyph alignglyph = this.getStreamAlignmentGlyph();
            if (alignglyph == null) {
                return;
            }
            int streamId = cpt.getStreamId();
            StreamElement elem = this.findStream(cpt, alignglyph);
            if (elem != null) {
                WorldPt streamWorldPt = elem.getLocationByStation(cpt.getStreamStation());
                MapObjectInterface alignMap = alignglyph.getMap();
                CoordinateReferenceSystem fromCrs = alignMap.getCoordinateReferenceSystem();
                CoordinateReferenceSystem toCrs = this.getMap().getCoordinateReferenceSystem();
                try {
                    WorldPt wpt = this.transformPoint(streamWorldPt, fromCrs, toCrs);
                    lpt = scl.wp2lp(wpt);
                    xy[0] = lpt.x;
                    xy[1] = lpt.y;
                }
                catch (CRSException ex) {
                    Logger.getLogger(AbstractStudyGlyph.class.getName()).log(Level.SEVERE, null, ex);
                }
            } else {
                System.out.println("getCompPtXY: no stream elem for id " + streamId);
            }
        }
    }

    @Override
    public boolean compPtPopupMenu(LocalPt pt) {
        if (this.getStudy() == null || pt == null) {
            return false;
        }
        ComputationPoint cp = this.selectCompPt(pt, false, false);
        if (cp == null) {
            return false;
        }
        this.clearSelection();
        this.addSelection((NamedType)cp, true, false);
        MapApplicationModule mode = (MapApplicationModule)AppDaddy.getFrame().getCurrentModule();
        return mode.objectPopupMenu((NamedType)cp, pt);
    }

    public ComputationPoint selectCompPt(ComputationPoint cp, boolean add, boolean editing) {
        if (!add) {
            this._selectionVector.clear();
        }
        this.addSelection((NamedType)cp, add, editing);
        return cp;
    }

    @Override
    public ComputationPoint selectCompPt(LocalPt pt, boolean add, boolean editing) {
        if (!add) {
            this._selectionVector.clear();
        }
        if (pt == null) {
            return null;
        }
        ComputationPoint compPt = this.findCompPt(pt);
        this.addSelection((NamedType)compPt, add, editing);
        return compPt;
    }

    @Override
    public ComputationPoint findCompPt(LocalPt pt) {
        if (this.getStudy() == null || pt == null) {
            return null;
        }
        double tol = this._mapPanel.scale().x2e(pt.x + 8) - this._mapPanel.scale().x2e(pt.x);
        WorldPt wpt = this._mapPanel.scale().lp2wp(pt);
        ComputationPoint cpt = this.getStudy().findCompPt(wpt, tol);
        return cpt;
    }

    @Override
    public ComputationPoint findCompPt(int streamIndex, double upstreamCoord, double downstreamCoord) {
        return this.getStudy().findCompPt(streamIndex, upstreamCoord, downstreamCoord);
    }

    @Override
    public boolean offChannelPopupMenu(LocalPt pt) {
        if (this.getStudy() == null || pt == null) {
            return false;
        }
        StoragePool pool = this.selectStoragePool(pt, false, false);
        if (pool == null) {
            return false;
        }
        this.clearSelection();
        this.addSelection((NamedType)pool, true, false);
        MapApplicationModule mode = (MapApplicationModule)AppDaddy.getFrame().getCurrentModule();
        return mode.objectPopupMenu((NamedType)pool, pt);
    }

    @Override
    public StoragePool selectStoragePool(StoragePool pool, boolean add, boolean editing) {
        if (!add) {
            this._selectionVector.clear();
        }
        this.addSelection((NamedType)pool, add, editing);
        return pool;
    }

    @Override
    public StoragePool selectStoragePool(LocalPt pt, boolean add, boolean editing) {
        return (StoragePool)this.selectRegion(pt, add, editing, "hec.watershed.model.StoragePool", Color.blue);
    }

    protected StudyRegion selectRegion(LocalPt pt, boolean add, boolean editing, String type, Color outLine) {
        double tol = this._mapPanel.scale().x2e(pt.x + 10) - this._mapPanel.scale().x2e(pt.x);
        if (!add) {
            this._selectionVector.clear();
        }
        if (this.getStudy() == null || pt == null) {
            return null;
        }
        WorldPt wpt = this._mapPanel.scale().lp2wp(pt);
        StudyRegion region = this.getStudy().findRegion(wpt, tol, type);
        this.addSelection((NamedType)region, add, editing);
        return region;
    }

    public void addSelection(NamedType obj, boolean add, boolean editing) {
        if (this._debug) {
            System.out.println("addSelection:adding object " + obj + " editing=" + editing);
        }
        if (obj != null) {
            MapGlyph.Selection sel = new MapGlyph.Selection((MapGlyph)this, (Object)obj, editing);
            if (!this._selectionVector.contains(sel)) {
                this._selectionVector.add(sel);
            }
            if (add) {
                Graphics g = this._mapPanel.viewport().getGraphics();
                this.drawSelectedObject(g, this._mapPanel.scale(), obj, add, editing);
                g.dispose();
            } else {
                this._mapPanel.paintMap();
            }
        } else if (!add) {
            this._mapPanel.paintMap();
        }
        this.fireGlyphSelectionChanged(obj);
    }

    @Override
    public void clearSelection() {
        if (this._debug) {
            System.out.println("clearSelection:clearing");
        }
        this._selectionVector.clear();
        this._mapPanel.paintMap();
    }

    public void clearSelection(NamedType obj) {
        if (obj == null) {
            return;
        }
        NamedType sObj = null;
        for (int i = 0; i < this._selectionVector.size(); ++i) {
            MapGlyph.Selection sel = (MapGlyph.Selection)this._selectionVector.get(i);
            if (sel == null || obj != (sObj = (NamedType)sel.object)) continue;
            this._selectionVector.remove(i);
            this._mapPanel.paintMap();
            break;
        }
    }

    public void clearSelection(String name) {
        boolean found = false;
        for (int i = 0; i < this._selectionVector.size(); ++i) {
            NamedType nt;
            MapGlyph.Selection sel = (MapGlyph.Selection)this._selectionVector.get(i);
            if (sel == null || !name.equals((nt = (NamedType)sel.object).getName())) continue;
            this._selectionVector.remove(sel);
            found = true;
            break;
        }
        if (found) {
            this._mapPanel.paintMap();
        }
    }

    @Override
    public boolean channelModPopupMenu(LocalPt pt) {
        if (this.getStudy() == null || pt == null) {
            return false;
        }
        ChannelMod cm = this.selectChannelMod(pt, false, false);
        if (cm == null) {
            return false;
        }
        this.clearSelection();
        this.addSelection((NamedType)cm, true, false);
        MapApplicationModule mode = (MapApplicationModule)AppDaddy.getFrame().getCurrentModule();
        return mode.objectPopupMenu((NamedType)cm, pt);
    }

    @Override
    public ChannelMod selectChannelMod(LocalPt pt, boolean add, boolean editing) {
        double tol = this._mapPanel.scale().x2e(pt.x + 5) - this._mapPanel.scale().x2e(pt.x);
        if (!add) {
            this._selectionVector.clear();
        }
        if (this._channelModList == null || pt == null) {
            return null;
        }
        WorldPt wpt = this._mapPanel.scale().lp2wp(pt);
        return this.selectChannelMod(this.findChannelMod(wpt, tol), add, editing);
    }

    @Override
    public ChannelMod selectChannelMod(ChannelMod cm, boolean add, boolean editing) {
        if (!add) {
            this._selectionVector.clear();
        }
        this.addSelection((NamedType)cm, add, editing);
        return cm;
    }

    @Override
    public ChannelMod findChannelMod(WorldPt wpt, double tol) {
        StreamAlignmentGlyph alignglyph = this.getStreamAlignmentGlyph();
        if (alignglyph == null) {
            return null;
        }
        if (this._channelModList == null) {
            return null;
        }
        DataStruct[] elemList = this._channelModList.getObjectArray();
        Condition c = this.getStudy().getCondition();
        if (c == null) {
            return null;
        }
        for (int i = 0; i < elemList.length; ++i) {
            DataStruct elem = elemList[i];
            if (elem == null || !(elem instanceof ChannelMod)) continue;
            ChannelMod cm = (ChannelMod)elem;
            StreamElement stream = this.findStream(cm, alignglyph);
            if (stream == null) {
                return null;
            }
            double s0 = cm.getStartStation();
            double s1 = cm.getEndStation();
            double c0 = stream.getCoordByStation(s0);
            double c1 = stream.getCoordByStation(s1);
            StreamPolyLine line = stream.getLineSegment(c1, c0);
            if (!line.nearPt(wpt, tol) || !c.hasProject(cm)) continue;
            return cm;
        }
        return null;
    }

    @Override
    public boolean impactAreaPopupMenu(LocalPt pt) {
        if (this.getStudy() == null || pt == null) {
            return false;
        }
        double tol = this._mapPanel.scale().x2e(pt.x + 10) - this._mapPanel.scale().x2e(pt.x);
        WorldPt wpt = this._mapPanel.scale().lp2wp(pt);
        ImpactArea iregion = this.getStudy().findImpactArea(wpt, tol);
        if (iregion == null) {
            return false;
        }
        this.clearSelection();
        this.addSelection((NamedType)iregion, true, false);
        MapApplicationModule mode = (MapApplicationModule)AppDaddy.getFrame().getCurrentModule();
        return mode.objectPopupMenu((NamedType)iregion, pt);
    }

    @Override
    public boolean leveePopupMenu(LocalPt pt) {
        if (this.getStudy() == null || pt == null) {
            return false;
        }
        double tol = this._mapPanel.scale().x2e(pt.x + 10) - this._mapPanel.scale().x2e(pt.x);
        WorldPt wpt = this._mapPanel.scale().lp2wp(pt);
        Levee levee = this.findLevee(wpt, tol);
        if (levee == null) {
            return false;
        }
        this.clearSelection();
        this.addSelection((NamedType)levee, true, false);
        MapApplicationModule mode = (MapApplicationModule)AppDaddy.getFrame().getCurrentModule();
        return mode.objectPopupMenu((NamedType)levee, pt);
    }

    public Levee findLevee(WorldPt wpt, double tol) {
        if (this._leveeList == null) {
            return null;
        }
        DataStruct[] elemList = this._leveeList.getObjectArray();
        Condition c = this.getStudy().getCondition();
        if (c == null) {
            return null;
        }
        for (int i = 0; i < elemList.length; ++i) {
            DataStruct elem = elemList[i];
            if (elem == null || !(elem instanceof Levee)) continue;
            Levee levee = (Levee)elem;
            WorldLine line = levee.getLine();
            if (line == null) {
                line = this.getLeveeLine(null, null, levee);
            }
            if (line == null) {
                return null;
            }
            if (!line.nearPt(wpt, tol) || !c.hasProject(levee)) continue;
            return levee;
        }
        return null;
    }

    @Override
    public Reservoir selectReservoir(Reservoir res, boolean add, boolean editing) {
        if (!add) {
            this._selectionVector.clear();
        }
        if (res == null) {
            return res;
        }
        this.addSelection((NamedType)res, add, editing);
        return res;
    }

    public Reservoir selectReservoir(LocalPt pt, boolean add, boolean editing) {
        if (!add) {
            this._selectionVector.clear();
        }
        if (pt == null) {
            return null;
        }
        WorldPt wpt = this._mapPanel.scale().lp2wp(pt);
        Reservoir res = this.findReservoir(wpt);
        this.addSelection((NamedType)res, add, editing);
        return res;
    }

    @Override
    public Reservoir findReservoir(LocalPt pt) {
        this._mapPanel.scale().lp2wp(pt, this.tmpWpt);
        return this.findReservoir(this.tmpWpt);
    }

    @Override
    public Reservoir findReservoir(WorldPt wpt) {
        double coord;
        LocalPt pt;
        StreamElement rch;
        StreamAlignmentGlyph alignglyph;
        Condition c = this.getStudy().getCondition();
        if (c == null) {
            return null;
        }
        Reservoir res = this.getStudy().findReservoir(wpt);
        if (res == null && (alignglyph = this.getStreamAlignmentGlyph()) != null && (rch = alignglyph.findReach(pt = this._mapPanel.scale().wp2lp(wpt), null)) != null && (coord = rch.getLine().getCoordAtLocation(wpt)) != Double.NEGATIVE_INFINITY) {
            res = this.getStudy().findReservoir(rch.getIndex(), coord);
        }
        if (c.hasProject(res)) {
            return res;
        }
        return null;
    }

    @Override
    public Diversion findDiversion(WorldPt wpt, double tol) {
        if (this.getStudy() == null || wpt == null) {
            return null;
        }
        Diversion div = this.getStudy().findDiversion(wpt, tol);
        Condition c = this.getStudy().getCondition();
        if (c == null) {
            return null;
        }
        if (c.hasProject(div)) {
            return div;
        }
        return null;
    }

    @Override
    public OtherProject findOtherProject(LocalPt pt) {
        if (this.getStudy() == null || pt == null) {
            return null;
        }
        WorldPt wpt = this._mapPanel.scale().lp2wp(pt);
        return this.findOtherProject(wpt);
    }

    public OtherProject findOtherProject(WorldPt wpt) {
        if (this.getStudy() == null || wpt == null) {
            return null;
        }
        LocalPt pt = this._mapPanel.scale().wp2lp(wpt);
        double tol = this._mapPanel.scale().x2e(pt.x + 20) - this._mapPanel.scale().x2e(pt.x);
        OtherProject op = this.getStudy().findOtherProject(wpt, tol, true);
        Condition c = this.getStudy().getCondition();
        if (c == null) {
            return null;
        }
        if (c.hasProject(op)) {
            return op;
        }
        return null;
    }

    @Override
    public Diversion selectDiversion(Diversion div, boolean add, boolean editing) {
        if (!add) {
            this._selectionVector.clear();
        }
        this.addSelection((NamedType)div, add, editing);
        return div;
    }

    @Override
    public Diversion selectDiversion(LocalPt pt, boolean add, boolean editing) {
        if (!add) {
            this._selectionVector.clear();
        }
        if (pt == null) {
            this._mapPanel.paintMap();
            return null;
        }
        WorldPt wpt = this._mapPanel.scale().lp2wp(pt);
        double tol = this._mapPanel.scale().x2e(pt.x + 10) - this._mapPanel.scale().x2e(pt.x);
        Diversion div = this.findDiversion(wpt, tol);
        this.addSelection((NamedType)div, add, editing);
        return div;
    }

    public boolean objectDoubleClick(LocalPt pt, int modifiers) {
        NamedType obj = this.findObject(pt);
        if (obj != null) {
            this._selectionVector.clear();
            MapGlyph.Selection sel = new MapGlyph.Selection((MapGlyph)this, (Object)obj, true);
            this._selectionVector.add(sel);
            this._mapPanel.paintMap();
            MapApplicationModule mode = (MapApplicationModule)AppDaddy.getFrame().getCurrentModule();
            return mode.objectDoubleClick(obj, pt);
        }
        return false;
    }

    public ImpactArea selectImpactArea(LocalPt pt, boolean add, boolean editing) {
        return (ImpactArea)this.selectRegion(pt, add, editing, "hec.watershed.model.ImpactArea", Color.red);
    }

    @Override
    public void selectImpactArea(ImpactArea area, boolean add, boolean editing) {
        if (!add) {
            this._selectionVector.clear();
        }
        this.addSelection((NamedType)area, add, editing);
    }

    @Override
    public Levee selectLevee(Levee levee, boolean add, boolean editing) {
        if (!add) {
            this._selectionVector.clear();
        }
        if (levee == null) {
            return null;
        }
        this.addSelection((NamedType)levee, add, editing);
        return levee;
    }

    @Override
    public Levee selectLevee(LocalPt pt, boolean add, boolean editing) {
        if (!add) {
            this._selectionVector.clear();
        }
        if (pt == null) {
            return null;
        }
        double tol = this._mapPanel.scale().x2e(pt.x + 5) - this._mapPanel.scale().x2e(pt.x);
        WorldPt wpt = this._mapPanel.scale().lp2wp(pt);
        Levee levee = this.findLevee(wpt, tol);
        if (levee == null) {
            return null;
        }
        this.addSelection((NamedType)levee, add, editing);
        return levee;
    }

    @Override
    public OtherProject selectOtherProject(OtherProject op, boolean add, boolean editing) {
        if (!add) {
            this._selectionVector.clear();
        }
        this.addSelection((NamedType)op, add, editing);
        return op;
    }

    @Override
    public OtherProject selectOtherProject(LocalPt pt, boolean add, boolean editing) {
        if (!add) {
            this._selectionVector.clear();
        }
        if (this.getStudy() == null || pt == null) {
            return null;
        }
        double tol = this._mapPanel.scale().x2e(pt.x + 20) - this._mapPanel.scale().x2e(pt.x);
        WorldPt wpt = this._mapPanel.scale().lp2wp(pt);
        OtherProject proj = this.getStudy().findOtherProject(wpt, tol, true);
        this.addSelection((NamedType)proj, add, editing);
        return proj;
    }

    @Override
    public ImpactArea findImpactArea(LocalPt pt) {
        double tol = this._mapPanel.scale().x2e(pt.x + 10) - this._mapPanel.scale().x2e(pt.x);
        WorldPt wpt = this._mapPanel.scale().lp2wp(pt);
        StudyRegion region = this.getStudy().findRegion(wpt, tol, "hec.watershed.model.ImpactArea");
        return (ImpactArea)region;
    }

    @Override
    public StoragePool findStoragePool(LocalPt pt) {
        double tol = this._mapPanel.scale().x2e(pt.x + 10) - this._mapPanel.scale().x2e(pt.x);
        WorldPt wpt = this._mapPanel.scale().lp2wp(pt);
        StudyRegion region = this.getStudy().findRegion(wpt, tol, "hec.watershed.model.StoragePool");
        return (StoragePool)region;
    }

    @Override
    public void selectObject(NamedType obj) {
        if (obj == null) {
            this._selectionVector.clear();
            return;
        }
        if (obj instanceof ChannelMod) {
            this.selectChannelMod((ChannelMod)obj, true, false);
        } else if (obj instanceof ComputationPoint) {
            this.selectCompPt((ComputationPoint)obj, true, false);
        } else if (obj instanceof Diversion) {
            this.selectDiversion((Diversion)obj, true, false);
        } else if (obj instanceof ImpactArea) {
            this.selectImpactArea((ImpactArea)obj, true, false);
        } else if (obj instanceof Levee) {
            this.selectLevee((Levee)obj, true, false);
        } else if (obj instanceof OtherProject) {
            this.selectOtherProject((OtherProject)obj, true, false);
        } else if (obj instanceof Reservoir) {
            this.selectReservoir((Reservoir)obj, true, false);
        } else if (obj instanceof StoragePool) {
            this.selectStoragePool((StoragePool)obj, true, false);
        }
    }

    @Override
    public NamedType objectSelect(LocalPt pt, int modifiers) {
        NamedType obj = this.findObject(pt);
        if (obj != null) {
            this._selectionVector.clear();
            MapGlyph.Selection sel = new MapGlyph.Selection((MapGlyph)this, (Object)obj, false);
            this._selectionVector.add(sel);
            this._mapPanel.paintMap();
        } else {
            this.clearSelection();
        }
        this.fireGlyphSelectionChanged(obj);
        return obj;
    }

    public boolean objectPopupMenu(LocalPt pt, int modifiers) {
        NamedType obj = this.findObject(pt);
        if (obj != null) {
            this._selectionVector.clear();
            MapGlyph.Selection sel = new MapGlyph.Selection((MapGlyph)this, (Object)obj, false);
            this._selectionVector.add(sel);
            this._mapPanel.paintMap();
            this._mapPanel.waitforPaintComplete();
            MapApplicationModule mode = (MapApplicationModule)AppDaddy.getFrame().getCurrentModule();
            return mode.objectPopupMenu(obj, pt);
        }
        return false;
    }

    @Override
    public Node createDiversionNode(LocalPt pt, Node upnode) {
        WorldPt wpt = this._mapPanel.scale().lp2wp(pt);
        Reservoir existingRes = null;
        StreamAlignmentGlyph alignglyph = this.getStreamAlignmentGlyph();
        if (alignglyph == null) {
            return null;
        }
        StreamElement rch = alignglyph.findReach(pt, null);
        if (rch == null) {
            return null;
        }
        double coord = rch.getLine().getCoordAtLocation(wpt);
        if (coord == Double.NEGATIVE_INFINITY) {
            return null;
        }
        if (upnode == null) {
            existingRes = this.getStudy().findReservoir(wpt);
        }
        Node node = this.getStudy().createNode(wpt);
        node.setStreamIndex(rch.getIndex());
        node.setStreamName(rch.getName());
        node.setStreamCoord(coord);
        node.setStreamStation(rch.getStationByCoord(coord));
        if (existingRes != null) {
            existingRes.addNode(node, 1);
        }
        return node;
    }

    public Node createReservoirNode(LocalPt pt, StreamElement rch0, Vector nodevec) {
        if (pt == null) {
            return null;
        }
        StreamAlignmentGlyph alignglyph = this.getStreamAlignmentGlyph();
        if (alignglyph == null) {
            return null;
        }
        StreamElement rch = alignglyph.findReach(pt, null);
        if (rch == null) {
            return null;
        }
        if (nodevec != null) {
            for (int i = 0; i < nodevec.size(); ++i) {
                Node upnode = (Node)nodevec.elementAt(i);
                if (upnode != null) continue;
            }
        }
        WorldPt wpt = this._mapPanel.scale().lp2wp(pt);
        double coord = rch.getLine().getCoordAtLocation(wpt);
        if (coord == Double.NEGATIVE_INFINITY) {
            return null;
        }
        Reservoir existingRes = null;
        existingRes = this.getStudy().findReservoir(wpt);
        if (existingRes == null) {
            existingRes = this.getStudy().findReservoir(rch.getIndex(), coord);
        }
        if (existingRes != null) {
            return null;
        }
        Node node = this.getStudy().createNode(rch.getLocationByCoord(coord));
        node.setStreamIndex(rch.getIndex());
        node.setStreamCoord(coord);
        node.setStreamStation(rch.getStationByCoord(coord));
        return node;
    }

    public Reservoir createReservoir(Vector ptVec, Vector nodeVec) {
        return this.createReservoir(ptVec, nodeVec, null, null);
    }

    @Override
    public Reservoir createReservoir(Vector ptVec, Vector nodeVec, Vector ndirVec, Vector segVec) {
        if (this.getStudy() == null || ptVec == null) {
            return null;
        }
        if (ptVec.size() < 1) {
            return null;
        }
        WorldRegion reg = new WorldRegion();
        LocalPt pt = (LocalPt)ptVec.elementAt(0);
        double tol = this._mapPanel.scale().x2e(pt.x + 5) - this._mapPanel.scale().x2e(pt.x);
        Reservoir reservoir = null;
        NameDialog dlg = new NameDialog((Frame)AppDaddy.getFrame(), true);
        dlg.setName("");
        dlg.setDescription("");
        dlg.setNameFieldDocument((Document)new DssPathnamePartDocument());
        dlg.setTitle("Name New Reservoir");
        List names = this.getStudy().getObjectNamesList("hec.watershed.model.Reservoir");
        dlg.setExistingNames(names);
        dlg.setVisible(true);
        if (!dlg.isCanceled()) {
            String rname = dlg.getName();
            String rdescrip = dlg.getDescription();
            reservoir = ndirVec == null ? this.getStudy().createReservoir(reg, nodeVec, tol, rname, rdescrip) : this.getStudy().createReservoir(reg, nodeVec, ndirVec, tol, rname, rdescrip);
            reservoir = (Reservoir)reservoir.getDataList().getObject(reservoir.getId());
            reservoir.setStreamSegmentVector(segVec);
            reservoir.setStreamAlignment(this._alignment);
            WorldPt regpt = reservoir.getDownstreamNode().getLocation();
            pt = this._mapPanel.scale().wp2lp(regpt);
            double e = this._mapPanel.scale().x2e(pt.x + 15);
            double n = this._mapPanel.scale().y2n(pt.y);
            reg.pts.addElement(new WorldPt(e, n));
            e = this._mapPanel.scale().x2e(pt.x);
            n = this._mapPanel.scale().y2n(pt.y - 20);
            reg.pts.addElement(new WorldPt(e, n));
            e = this._mapPanel.scale().x2e(pt.x - 15);
            n = this._mapPanel.scale().y2n(pt.y);
            reg.pts.addElement(new WorldPt(e, n));
            reservoir.setRegion(reg);
            reservoir.updateComputationPoint();
        }
        if (reservoir != null) {
            this.drawReservoir(this._mapPanel.viewport().getGraphics(), this._mapPanel.scale(), reservoir);
        }
        this._mapPanel.paintMap();
        return reservoir;
    }

    @Override
    public Levee createLevee(Vector ssiList, int bank) {
        if (this.getStudy() == null) {
            return null;
        }
        if (ssiList == null || ssiList.size() < 1) {
            return null;
        }
        StreamAlignmentGlyph alignglyph = this.getStreamAlignmentGlyph();
        if (alignglyph == null) {
            return null;
        }
        String[] info = this.getNewProjectName("Name New Levee", "hec.watershed.model.Levee");
        if (info == null) {
            this._mapPanel.paintMap();
            return null;
        }
        Levee levee = this.getStudy().addLevee(ssiList, bank, 50, info[0], info[1]);
        this.getLeveeLine(null, null, levee);
        levee.updateComputationPoint();
        this.drawLevee(this._mapPanel.viewport().getGraphics(), this._mapPanel.scale(), levee);
        this._mapPanel.paintMap();
        return levee;
    }

    @Override
    public ComputationPoint createCompPt(LocalPt pt) {
        if (this.getStudy() == null || pt == null) {
            return null;
        }
        if (this.findCompPt(pt) != null) {
            return null;
        }
        WorldPt wpt = this._mapPanel.scale().lp2wp(pt);
        ComputationPoint cpt = null;
        StreamAlignmentGlyph alignglyph = this.getStreamAlignmentGlyph();
        String name = null;
        String description = null;
        if (alignglyph != null) {
            StreamElement stream = alignglyph.findReach(pt);
            if (stream != null) {
                StreamJunction junc = alignglyph.findStreamJunction(stream, pt);
                if (junc != null) {
                    ComputationPointLayer layer;
                    PlaceCompPtDialog dialog = new PlaceCompPtDialog((Frame)AppDaddy.getFrame(), true);
                    dialog.setJunction(junc);
                    CommonDataList layerList = this.getStudy().getCommonDataListContainer().getCommonDataList(ComputationPointLayer.class.getName());
                    dialog.setComputationPointLayers(layerList);
                    for (int i = 0; i < this._ccpVisibleLayers.size(); ++i) {
                        layer = this._ccpVisibleLayers.get(i);
                        if (layer.isDefaultLayer()) continue;
                        dialog.setSelectedComputationPointLayer(layer);
                        break;
                    }
                    dialog.setVisible(true);
                    if (dialog.isCanceled()) {
                        return null;
                    }
                    Object obj = dialog.getSelectedObject();
                    name = dialog.getName();
                    description = dialog.getDescription();
                    cpt = this.getStudy().addCompPt(wpt, false, name, description);
                    if (cpt == null) {
                        return null;
                    }
                    layer = dialog.getComputationPointLayout();
                    if (layer != null && !layer.isDefaultLayer()) {
                        layer.addComputationPoint(cpt);
                    }
                    if (obj == junc) {
                        Vector nodes = junc.getNodeVector();
                        StreamNode node = (StreamNode)nodes.get(0);
                        for (int i = 1; i < nodes.size(); ++i) {
                            StreamNode node2 = (StreamNode)nodes.get(i);
                            if (!(node2.getStreamCoord() > node.getStreamCoord())) continue;
                            node = node2;
                        }
                        stream = node.getStream();
                        cpt.setStreamStation(node.getStation());
                        cpt.setStreamCoord(node.getStreamCoord());
                        cpt.setStreamId(stream.getIndex());
                        cpt.setStreamName(stream.getName());
                        cpt.setReferencePt(stream.getLocationByStation(cpt.getStreamStation()));
                        cpt.setSnapToStream(true);
                        cpt.setJunctionIndex(junc.getIndex());
                    } else if (obj instanceof StreamElement) {
                        stream = (StreamElement)obj;
                        WorldPt streamWorldPt = null;
                        MapObjectInterface map = alignglyph.getMap();
                        CoordinateReferenceSystem toCrs = map.getCoordinateReferenceSystem();
                        CoordinateReferenceSystem fromCrs = this.getMap().getCoordinateReferenceSystem();
                        try {
                            streamWorldPt = this.transformPoint(wpt, fromCrs, toCrs);
                        }
                        catch (CRSException ex) {
                            Logger.getLogger(AbstractStudyGlyph.class.getName()).log(Level.WARNING, null, ex);
                        }
                        double station = stream.getStationByLocation(streamWorldPt);
                        double coord = stream.getCoordByLocation(streamWorldPt);
                        cpt.setStreamStation(station);
                        cpt.setStreamCoord(coord);
                        cpt.setStreamId(stream.getIndex());
                        cpt.setSnapToStream(true);
                    }
                } else {
                    ComputationPointLayer layer;
                    String[] info = this.getNewProjectName("Name New Computation Point", "hec.watershed.model.ComputationPoint");
                    if (info == null) {
                        this._mapPanel.paintMap();
                        return null;
                    }
                    cpt = this.getStudy().addCompPt(wpt, false, info[0], info[1]);
                    if (cpt == null) {
                        return null;
                    }
                    CommonDataList cdl = this.getStudy().getCommonDataListContainer().getCommonDataList(ComputationPointLayer.class.getName());
                    if (cdl != null && info.length >= 3 && (layer = (ComputationPointLayer)cdl.getObject(info[2])) != null) {
                        layer.addComputationPoint(cpt);
                    }
                    WorldPt streamWorldPt = null;
                    MapObjectInterface map = alignglyph.getMap();
                    CoordinateReferenceSystem toCrs = map.getCoordinateReferenceSystem();
                    CoordinateReferenceSystem fromCrs = this.getMap().getCoordinateReferenceSystem();
                    try {
                        streamWorldPt = this.transformPoint(wpt, fromCrs, toCrs);
                    }
                    catch (CRSException ex) {
                        Logger.getLogger(AbstractStudyGlyph.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    double station = stream.getStationByLocation(streamWorldPt);
                    double coord = stream.getCoordByLocation(streamWorldPt);
                    cpt.setStreamStation(station);
                    cpt.setStreamCoord(coord);
                    cpt.setStreamId(stream.getIndex());
                    cpt.setSnapToStream(true);
                }
            } else {
                ComputationPointLayer layer;
                String[] info = this.getNewProjectName("Name New Computation Point", "hec.watershed.model.ComputationPoint");
                if (info == null) {
                    this._mapPanel.paintMap();
                    return null;
                }
                cpt = this.getStudy().addCompPt(wpt, false, info[0], info[1]);
                if (cpt == null) {
                    return null;
                }
                CommonDataList cdl = this.getStudy().getCommonDataListContainer().getCommonDataList(ComputationPointLayer.class.getName());
                if (cdl != null && info.length >= 3 && (layer = (ComputationPointLayer)cdl.getObject(info[2])) != null) {
                    layer.addComputationPoint(cpt);
                }
            }
        }
        if (cpt != null) {
            this.drawCompPt(this._mapPanel.viewport().getBufferedGraphics(), this._mapPanel.scale(), cpt);
        }
        this._mapPanel.paintMap();
        return cpt;
    }

    public String[] getNewProjectName(String title, String projectClassType) {
        String[] info;
        NewCompPtDialog dlg;
        if (ComputationPoint.class.getName().equals(projectClassType)) {
            dlg = new NewCompPtDialog((Frame)AppDaddy.getFrame(), true);
            CommonDataList layerList = this.getStudy().getCommonDataListContainer().getCommonDataList(ComputationPointLayer.class.getName());
            dlg.setComputationPointLayers(layerList);
            for (int i = 0; i < this._ccpVisibleLayers.size(); ++i) {
                ComputationPointLayer layer = this._ccpVisibleLayers.get(i);
                if (!layer.isDefaultLayer()) continue;
                dlg.setSelectedComputationPointLayer(layer);
                break;
            }
        } else {
            dlg = new NameDialog((Frame)AppDaddy.getFrame(), true);
        }
        dlg.setName("");
        dlg.setDescription("");
        dlg.setTitle(title);
        if (projectClassType != null) {
            CommonDataList list = this.getCommonDataList(projectClassType);
            if (list == null) {
                System.out.println("getNewProjectName: Failed to get DataList for " + projectClassType);
                return null;
            }
            DataStruct[] listOfNames = list.getObjectArray();
            dlg.setExistingNames(Arrays.asList(listOfNames));
        }
        dlg.setVisible(true);
        if (dlg.isCanceled()) {
            return null;
        }
        if (dlg instanceof NewCompPtDialog) {
            info = new String[3];
            ComputationPointLayer layout = dlg.getComputationPointLayout();
            if (layout != null) {
                info[2] = layout.getName();
            }
        } else {
            info = new String[]{dlg.getName(), dlg.getDescription()};
        }
        return info;
    }

    protected abstract CommonDataList getCommonDataList(String var1);

    protected abstract ResDrawPropData getResDrawPropData();

    protected abstract DiversionDrawPropData getDiversionDrawPropData();

    protected abstract ChannelModDrawPropData getChannelModDrawPropData();

    protected abstract CompPtDrawPropData getCompPtDrawPropData();

    protected abstract LeveeDrawPropData getLeveeDrawPropData();

    protected abstract ImpactAreaDrawPropData getImpactAreaDrawPropData();

    public boolean isShown() {
        this._studyDas = this.getAttributeSet();
        if (this._studyDas == null) {
            return false;
        }
        if (this._studyDas instanceof StudyDrawingAttributeSet) {
            ((StudyDrawingAttributeSet)this._studyDas).setGlyph(this);
        }
        return this._studyDas.isShown();
    }

    protected StreamElement findStream(StreamReferenceHolder srh, StreamAlignmentGlyph alignglyph) {
        if (srh == null || alignglyph == null) {
            return null;
        }
        StreamElement stream = null;
        if (srh.getStreamName() != null) {
            stream = alignglyph.findReach(srh.getStreamName());
        }
        if (stream == null && (stream = alignglyph.findReach(srh.getStreamIndex())) != null) {
            srh.setStreamName(stream.getName());
        }
        return stream;
    }

    public void setComputationLayerOn(ComputationPointLayer ccpl, boolean selected) {
        if (ccpl == null) {
            return;
        }
        if (selected) {
            if (this._ccpVisibleLayers.contains((Object)ccpl)) {
                return;
            }
            this._ccpVisibleLayers.add(ccpl);
        } else {
            this._ccpVisibleLayers.remove((Object)ccpl);
        }
        this._mapPanel.paintMap();
    }

    @Override
    public List<ComputationPointLayer> getComputationPointLayers() {
        return this._ccpVisibleLayers;
    }
}

