/*
 * Decompiled with CFR 0.152.
 */
package hec.watershed.client;

import hec.appInterface.AppDaddy;
import hec.client.ResDrawPropData;
import hec.map.MapPanel;
import hec.map.appInterface.MapApplicationFrame;
import hec.watershed.client.ChannelModDrawPropData;
import hec.watershed.client.CompPtDrawPropData;
import hec.watershed.client.DiversionDrawPropData;
import hec.watershed.client.ImpactAreaDrawPropData;
import hec.watershed.client.LeveeDrawPropData;
import hec.watershed.client.StationSetPropPanel;
import hec.watershed.client.StudyChannonModPropPanel;
import hec.watershed.client.StudyCompPtPropPanel;
import hec.watershed.client.StudyDiversionPropPanel;
import hec.watershed.client.StudyImpactAreaPropPanel;
import hec.watershed.client.StudyLeveePropPanel;
import hec.watershed.client.StudyResPropPanel;
import hec.watershed.client.StudyStationSetDPData;
import hec.watershed.map.StudyDrawProperties;
import hec.watershed.map.StudyDrawPropertiesFactory;
import hec.watershed.model.Study;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JOptionPane;
import rma.swing.ButtonCmdPanel;
import rma.swing.ButtonCmdPanelListener;
import rma.swing.RmaInsets;
import rma.swing.RmaJDialog;
import rma.swing.RmaJTabbedPane;
import rma.swing.RmaJTextField;

public abstract class AbstractStudyPropertiesEditor
extends RmaJDialog {
    private final Runnable _postSaveAction;
    private RmaJTextField nameTxt;
    private RmaJTabbedPane tabbedPane;
    private StudyResPropPanel reservoirPanel;
    private StudyLeveePropPanel leveePanel;
    private StudyChannonModPropPanel channelModPanel;
    private StudyDiversionPropPanel diversionPanel;
    private StudyCompPtPropPanel compPtPropPanel;
    private StudyImpactAreaPropPanel impactAreaPanel;
    private StationSetPropPanel stationSetPanel;
    private ButtonCmdPanel cmdPanel;
    private Study _study;

    public AbstractStudyPropertiesEditor(Frame parent, boolean modal, Runnable postSaveAction) {
        super(parent, modal);
        this._postSaveAction = postSaveAction;
        this.buildControls();
    }

    private void buildControls() {
        this.getContentPane().setLayout(new GridBagLayout());
        this.setSize(400, 300);
        this.setTitle("Drawing Properties Editor");
        this.setLocation();
        this.tabbedPane = new RmaJTabbedPane();
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)0);
        gbc.weightx = 1.0;
        this.getContentPane().add((Component)this.tabbedPane, gbc);
        this.reservoirPanel = new StudyResPropPanel(this.getStudyReservoirDPData());
        this.leveePanel = new StudyLeveePropPanel(this.getStudyLeveeDPData());
        this.diversionPanel = new StudyDiversionPropPanel(this.getStudyDiversionDPData());
        this.channelModPanel = new StudyChannonModPropPanel(this.getStudyChannelModDPData());
        this.compPtPropPanel = new StudyCompPtPropPanel(this.getStudyCompDPData());
        this.impactAreaPanel = new StudyImpactAreaPropPanel(this.getStudyImpactAreaDPData());
        this.stationSetPanel = new StationSetPropPanel(this.getStationSetDPData());
        this.tabbedPane.add((Component)this.reservoirPanel, (Object)"Reservoir");
        this.tabbedPane.add((Component)this.leveePanel, (Object)"Levees");
        this.tabbedPane.add((Component)this.diversionPanel, (Object)"Diversions");
        this.tabbedPane.add((Component)this.channelModPanel, (Object)"Channel Modification");
        this.tabbedPane.add((Component)this.compPtPropPanel, (Object)"Computation Point");
        this.tabbedPane.add((Component)this.impactAreaPanel, (Object)"Impact Area");
        this.tabbedPane.add((Component)((Object)this.stationSetPanel), (Object)"Stations");
        this.cmdPanel = new ButtonCmdPanel(14);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 5;
        gbc.gridwidth = 4;
        gbc.anchor = 14;
        gbc.fill = 0;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)5, (int)5);
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        this.getContentPane().add((Component)this.cmdPanel, gbc);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                AbstractStudyPropertiesEditor.this.windowClosing();
            }
        });
        this.cmdPanel.addCmdPanelListener(new ButtonCmdPanelListener(){

            public void buttonCmdActionPerformed(ActionEvent e) {
                switch (e.getID()) {
                    case 8: {
                        AbstractStudyPropertiesEditor.this.saveForm();
                        AbstractStudyPropertiesEditor.this.setVisible(false);
                        break;
                    }
                    case 2: {
                        AbstractStudyPropertiesEditor.this.saveForm();
                        break;
                    }
                    case 4: {
                        AbstractStudyPropertiesEditor.this.windowClosing();
                        AbstractStudyPropertiesEditor.this.setVisible(false);
                    }
                }
            }
        });
        this.pack();
    }

    protected abstract StudyStationSetDPData getStationSetDPData();

    protected abstract ImpactAreaDrawPropData getStudyImpactAreaDPData();

    protected abstract CompPtDrawPropData getStudyCompDPData();

    protected abstract ChannelModDrawPropData getStudyChannelModDPData();

    protected abstract DiversionDrawPropData getStudyDiversionDPData();

    protected abstract LeveeDrawPropData getStudyLeveeDPData();

    protected abstract ResDrawPropData getStudyReservoirDPData();

    public void saveForm() {
        this.reservoirPanel.savePanel();
        this.diversionPanel.savePanel();
        this.leveePanel.savePanel();
        this.compPtPropPanel.savePanel();
        this.channelModPanel.savePanel();
        this.impactAreaPanel.savePanel();
        this.stationSetPanel.savePanel();
        try {
            StudyDrawProperties studyDrawProperties = StudyDrawPropertiesFactory.createStudyDrawProperties();
        }
        catch (Exception e) {
            System.out.println("StudyPropertiesEditor. exception " + e);
            return;
        }
        MapApplicationFrame frame = (MapApplicationFrame)AppDaddy.getFrame();
        MapPanel map = frame.getMapPanel();
        if (map != null) {
            map.paintMap();
        }
        this.setModified(false);
        if (this._postSaveAction != null) {
            this._postSaveAction.run();
        }
    }

    public void fillForm() {
    }

    public void windowClosing() {
        int opt;
        if (this.isModified() && (opt = JOptionPane.showConfirmDialog((Component)((Object)this), "Data has changed. Save Changes?", "Confirm Changes", 0)) == 0) {
            this.saveForm();
        }
    }
}

