/*
 * Decompiled with CFR 0.152.
 */
package hec.watershed.client;

import hec.gui.AbstractEditorPanel;
import hec.lang.NamedType;
import hec.map.MapLabelItem;
import hec.map.WorldPt;
import hec.map.streamAlignment.StreamAlignmentIfc;
import hec.model.DataListLoader;
import hec.model.StreamElement;
import hec.model.StreamPolyLine;
import hec.watershed.model.ChannelMod;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.table.TableModel;
import rma.swing.RmaJCheckBox;
import rma.swing.RmaJComboBox;
import rma.swing.RmaJIntegerField;
import rma.swing.RmaJTable;
import rma.swing.RmaJTextField;
import rma.swing.table.RmaTableModel;
import rma.util.RMAIO;

public class ChannelModificationPanel
extends AbstractEditorPanel {
    JPanel jPanel1 = new JPanel();
    RmaJTable m_streamTable;
    JPanel jPanel2 = new JPanel();
    GridBagLayout gridBagLayout3 = new GridBagLayout();
    JLabel jLabel1 = new JLabel();
    RmaJTextField m_streamText = new RmaJTextField(){

        public void setIsEditable(boolean b) {
        }
    };
    RmaJIntegerField m_yearInServiceTxt = new RmaJIntegerField();
    RmaJCheckBox m_existingProjectChk = new RmaJCheckBox("Existing Project");
    RmaJCheckBox m_corpsProjectChk = new RmaJCheckBox("Corps Project");
    JLabel m_labelPositionLbl = new JLabel();
    RmaJComboBox m_labelPositionCmb = new RmaJComboBox();
    ChannelMod m_channelMod = null;

    public ChannelModificationPanel() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.m_streamTable = new RmaJTable((Component)((Object)this)){

            public Dimension getPreferredScrollableViewportSize() {
                Dimension d = super.getPreferredScrollableViewportSize();
                d.height = 2 * this.getRowHeight();
                return d;
            }
        };
        this.setLayout(new GridBagLayout());
        this.jPanel1.setLayout(new GridBagLayout());
        this.jPanel2.setLayout(new GridBagLayout());
        this.m_streamTable.setModel((TableModel)new RmaTableModel(new String[]{" ", "Station", "Easting", "Northing"}, new Object[0][0], new boolean[]{false, true, false, false}));
        this.m_streamTable.setPrecision(2);
        this.m_streamTable.setDoubleCellEditor(1, 3, true);
        this.m_streamTable.setPopupMenuEnabled(false);
        this.m_yearInServiceTxt.setMaxLength(4);
        this.add(this.jPanel1, new GridBagConstraints(0, 4, 1, 1, 1.0, 0.0, 16, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add(new JScrollPane((Component)this.m_streamTable), new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 18, 1, new Insets(5, 5, 0, 5), 0, 0));
        this.add(this.jPanel2, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel2.add((Component)new JLabel("Stream Name:"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.jPanel2.add((Component)this.m_streamText, new GridBagConstraints(1, 0, 1, 3, 1.0, 0.0, 18, 2, new Insets(5, 5, 0, 5), 0, 0));
        this.jPanel2.add((Component)new JLabel("Year In Service"), new GridBagConstraints(2, 0, 1, 2, 0.0, 0.0, 13, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.jPanel2.add((Component)this.m_yearInServiceTxt, new GridBagConstraints(3, 0, 1, 1, 0.0, 1.0, 13, 2, new Insets(5, 5, 0, 5), 75, 0));
        this.jPanel1.add((Component)this.m_existingProjectChk, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 0), 0, 0));
        this.jPanel1.add((Component)this.m_corpsProjectChk, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 0), 0, 0));
        this.jPanel1.add((Component)new JLabel("Label Position:"), new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 0), 0, 0));
        this.jPanel1.add((Component)this.m_labelPositionCmb, new GridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 13, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.m_streamText.setEditable(false);
        this.m_labelPositionCmb.setModel(new DefaultComboBoxModel<String>(MapLabelItem.POSITION_STRINGS));
        this.m_labelPositionCmb.setModifiable(true);
    }

    public String getTabname() {
        return "Channel Modification Information";
    }

    public boolean savePanel() {
        return this.savePanel((NamedType)this.m_channelMod);
    }

    public boolean savePanel(NamedType dobj) {
        this.m_streamTable.commitEdit(true);
        ChannelMod channelMod = null;
        if (dobj == null) {
            channelMod = this.m_channelMod;
        } else if (dobj instanceof ChannelMod) {
            channelMod = (ChannelMod)dobj;
        }
        if (channelMod == null) {
            return true;
        }
        channelMod.setIsCorpsProject(this.m_corpsProjectChk.isSelected());
        channelMod.setIsExisting(this.m_existingProjectChk.isSelected());
        channelMod.setYearInService((short)this.m_yearInServiceTxt.getValue());
        channelMod.setLabelPosition(this.m_labelPositionCmb.getSelectedIndex());
        Vector upstreamData = this.m_streamTable.getRow(0);
        Vector downstreamData = this.m_streamTable.getRow(1);
        channelMod.setStartStation(RMAIO.parseDouble(upstreamData.elementAt(1), (double)0.0));
        channelMod.setEndStation(RMAIO.parseDouble(downstreamData.elementAt(1), (double)0.0));
        return true;
    }

    public void clearPanel() {
        this.m_streamText.setText("");
        this.m_yearInServiceTxt.setText("");
        this.m_streamTable.deleteCells();
    }

    public void fillPanel(NamedType dObj) {
        this.clearPanel();
        if (!(dObj instanceof ChannelMod)) {
            this.m_channelMod = null;
            return;
        }
        this.m_channelMod = (ChannelMod)dObj;
        StreamAlignmentIfc alignment = DataListLoader.getDataListLoader().getStreamAlignment();
        StreamElement elem = null;
        if (alignment != null && (elem = alignment.getReach(this.m_channelMod.getStreamId())) != null) {
            this.m_streamText.setText(elem.getName());
        }
        double startStation = this.m_channelMod.getStartStation();
        double endStation = this.m_channelMod.getEndStation();
        Double undef = new Double(Double.NEGATIVE_INFINITY);
        for (int i = 0; i < 2; ++i) {
            WorldPt pt;
            if (elem == null) continue;
            Vector<Object> rowData = new Vector<Object>();
            double c0 = elem.getCoordByStation(startStation);
            double c1 = elem.getCoordByStation(endStation);
            StreamPolyLine line = elem.getLineSegment(c0, c1);
            if (i == 0) {
                rowData.addElement("Upstream");
                rowData.addElement(new Double(startStation));
                if (line != null) {
                    pt = line.getFirstPt();
                    rowData.addElement(new Double(pt.e));
                    rowData.addElement(new Double(pt.n));
                } else {
                    rowData.addElement(undef);
                    rowData.addElement(undef);
                }
            } else {
                rowData.addElement("Downstream");
                rowData.addElement(new Double(this.m_channelMod.getEndStation()));
                if (line != null) {
                    pt = line.getLastPt();
                    rowData.addElement(new Double(pt.e));
                    rowData.addElement(new Double(pt.n));
                } else {
                    rowData.addElement(undef);
                    rowData.addElement(undef);
                }
            }
            this.m_streamTable.appendRow(rowData);
        }
        this.m_yearInServiceTxt.setValue((int)this.m_channelMod.getYearInService());
        this.m_existingProjectChk.setSelected(this.m_channelMod.isExisting());
        this.m_corpsProjectChk.setSelected(this.m_channelMod.isCorpsProject());
        this.m_labelPositionCmb.setSelectedIndex(this.m_channelMod.getLabelPosition());
    }
}

