/*
 * Decompiled with CFR 0.152.
 */
package hec.watershed.client;

import hec.map.WorldPt;
import hec.model.CommonDataList;
import hec.model.DataListLoader;
import hec.model.DataStruct;
import hec.model.StreamElement;
import hec.model.StreamPolyLine;
import hec.watershed.client.ProjectTablePanel;
import hec.watershed.model.ChannelMod;
import hec.watershed.model.StudyIfc;
import java.util.Vector;
import rma.swing.table.RmaTableModel;
import rma.swing.table.RmaTableModelInterface;
import rma.util.RMAIO;

public class ChannelModificationTablePanel
extends ProjectTablePanel {
    private static final String TABNAME = "Channel Modifications";

    public ChannelModificationTablePanel() {
        this.buildControls();
    }

    private void buildControls() {
        boolean[] editable = new boolean[]{true, true, true, false, false, true, false, false, true, true, true, true, false};
        String[] colNames = new String[]{" \nName", "Stream\nName", "Starting\nStation", "Starting\nEasting", "Starting\nNorthing", "Ending\nStation", "Ending\nEasting", "Ending\nNorthing", "Existing\nProject", "Corps\nProject", "Year in\nService", "Description", ""};
        RmaTableModel tableModel = new RmaTableModel(colNames, new Object[0][0], editable);
        this.setTableModel((RmaTableModelInterface)tableModel);
        this.m_projectTable.setMlHeaderRenderer();
        this.m_projectTable.setDoubleCellEditor(2, 7, true);
        this.m_projectTable.setCheckBoxCellEditor(8);
        this.m_projectTable.setCheckBoxCellEditor(9);
        this.m_projectTable.setColumnWidth(0, 150);
        this.m_projectTable.setColumnWidth(editable.length - 2, 250);
        this.m_projectTable.setColumnVisible(editable.length - 1, false, 0);
    }

    @Override
    public String getTabname() {
        return TABNAME;
    }

    public boolean savePanel() {
        this.m_projectTable.commitEdit(true);
        Vector rowData = null;
        for (int i = 0; i < this.m_modifiedRows.size(); ++i) {
            int rowNum = this.m_modifiedRows.elementAt(i);
            rowData = this.m_projectTable.getRow(rowNum);
            if (rowData == null) continue;
            ChannelMod mod = (ChannelMod)rowData.elementAt(this.m_projectTable.getModel().getColumnCount() - 1);
            mod.setName((String)rowData.elementAt(0));
            StreamElement stream = (StreamElement)rowData.elementAt(1);
            mod.setStreamId(stream != null ? stream.getIndex() : -1);
            mod.setStartStation(RMAIO.parseDouble(rowData.elementAt(2), (double)0.0));
            mod.setEndStation(RMAIO.parseDouble(rowData.elementAt(5), (double)0.0));
            mod.setIsExisting((Boolean)rowData.elementAt(8));
            mod.setIsCorpsProject((Boolean)rowData.elementAt(9));
            mod.setYearInService((short)RMAIO.parseInt(rowData.elementAt(10)));
            mod.setDescription((String)rowData.elementAt(11));
        }
        this.m_modifiedRows.removeAllElements();
        return true;
    }

    @Override
    public void fillPanel() {
        super.fillPanel();
        this.m_projectTable.deleteCells();
        StudyIfc study = super.getOpenStudy();
        if (study == null) {
            return;
        }
        CommonDataList dl = DataListLoader.getDataListLoader().getCommonDataList("hec.watershed.model.ChannelMod");
        if (dl == null) {
            return;
        }
        DataStruct[] dataObjList = dl.getObjectArray();
        for (int i = 0; dataObjList != null && i < dataObjList.length; ++i) {
            ChannelMod mod = (ChannelMod)dataObjList[i];
            if (mod == null) continue;
            Vector<Object> rowData = new Vector<Object>();
            rowData.addElement(mod.getName());
            StreamElement stream = this.getStreamElement(mod.getStreamId());
            rowData.addElement(stream);
            double startStation = mod.getStartStation();
            double endStation = mod.getEndStation();
            rowData.addElement(new Double(startStation));
            if (stream != null) {
                WorldPt wp;
                double c0 = stream.getCoordByStation(startStation);
                double c1 = stream.getCoordByStation(endStation);
                StreamPolyLine line = stream.getLineSegment(c1, c0);
                WorldPt worldPt = wp = line != null ? line.getLastPt() : null;
                if (wp != null) {
                    rowData.addElement(new Double(wp.e));
                    rowData.addElement(new Double(wp.n));
                } else {
                    rowData.addElement("");
                    rowData.addElement("");
                }
                rowData.addElement(new Double(endStation));
                WorldPt worldPt2 = wp = line != null ? line.getFirstPt() : null;
                if (wp != null) {
                    rowData.addElement(new Double(wp.e));
                    rowData.addElement(new Double(wp.n));
                } else {
                    rowData.addElement("");
                    rowData.addElement("");
                }
            }
            rowData.addElement(mod.isExisting());
            rowData.addElement(mod.isCorpsProject());
            rowData.addElement(new Integer(mod.getYearInService()));
            rowData.addElement(mod.getDescription());
            rowData.addElement(mod);
            this.m_projectTable.appendRow(rowData);
        }
        this.m_projectTable.setColumnEnabled(false, 1);
    }
}

