/*
 * Decompiled with CFR 0.152.
 */
package hec.watershed.client;

import hec.gui.NameDialog;
import hec.gui.SelectorPanelEditor;
import hec.lang.NamedType;
import hec.model.CommonDataList;
import hec.model.DataObject;
import hec.watershed.client.CompPtLayerPanel;
import hec.watershed.model.ComputationPointLayer;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;

public class CompPtLayerEditor
extends SelectorPanelEditor {
    private CompPtLayerPanel _compPtLayerPanel;
    private JMenuItem _newMenu;
    private JMenuItem _saveMenu;
    private JMenuItem _saveAsMenu;
    private JMenuItem _deleteMenu;
    private JMenuItem _closeMenu;
    private CommonDataList _cplDataList;

    public CompPtLayerEditor(Frame parent, boolean modal) {
        super(parent, modal);
        this.buildControls();
        this.addListeners();
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    public CompPtLayerEditor(Dialog parent, boolean modal) {
        super(parent, modal);
        this.buildControls();
        this.addListeners();
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    protected void buildControls() {
        this.setTitle("Computation Point Layer Editor");
        this.buildMenus();
        this._compPtLayerPanel = new CompPtLayerPanel(this);
        this.addPanel(this._compPtLayerPanel);
    }

    protected void buildMenus() {
        JMenuBar mbar = new JMenuBar();
        JMenu fileMenu = new JMenu("Layers");
        mbar.add(fileMenu);
        this._newMenu = new JMenuItem("New...");
        fileMenu.add(this._newMenu);
        this._saveMenu = new JMenuItem("Save");
        fileMenu.add(this._saveMenu);
        this._saveAsMenu = new JMenuItem("Save As");
        fileMenu.add(this._saveAsMenu);
        this._deleteMenu = new JMenuItem("Delete");
        fileMenu.add(this._deleteMenu);
        fileMenu.addSeparator();
        this._closeMenu = new JMenuItem("Close");
        fileMenu.add(this._closeMenu);
        this.setJMenuBar(mbar);
    }

    private void addListeners() {
        this._newMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CompPtLayerEditor.this.newAction();
            }
        });
        this._saveMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CompPtLayerEditor.this.saveForm();
            }
        });
        this._saveAsMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CompPtLayerEditor.this.saveAsAction();
            }
        });
        this._deleteMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CompPtLayerEditor.this.deleteAction();
            }
        });
        this._closeMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CompPtLayerEditor.this.closeAction();
            }
        });
    }

    public void setEditable(boolean editable) {
        super.setEditable(editable);
        this._newMenu.setEnabled(editable);
        this._saveAsMenu.setEnabled(editable);
        this._saveMenu.setEnabled(editable);
        this._deleteMenu.setEnabled(editable);
    }

    protected void closeAction() {
        super.closeDialog();
    }

    protected void deleteAction() {
        this._compPtLayerPanel.deleteAction();
    }

    protected void saveAsAction() {
        ComputationPointLayer cdl = (ComputationPointLayer)((Object)this.getSelectorPanel().getSelectedItem());
        if (cdl == null) {
            return;
        }
        NameDialog dlg = new NameDialog((Dialog)((Object)this), "Save " + cdl + " As", true);
        dlg.setExistingNames(this.getSelectorPanel().getSelectorItems());
        dlg.setVisible(true);
        if (dlg.isCanceled()) {
            return;
        }
        ComputationPointLayer newCdl = (ComputationPointLayer)this._cplDataList.newDataObject(dlg.getName(), dlg.getDescription());
        newCdl.setForegroundColor(cdl.getForegroundColor());
        newCdl.setBackgroundColor(cdl.getBackgroundColor());
        newCdl.setSymbolNum(cdl.getSymbolNum());
        newCdl.setSymbolSize(cdl.getSymbolSize());
        newCdl.setCompPts(cdl.getCompPts());
        newCdl.setSubLayers(cdl.getSubLayers());
        newCdl.setModified(true);
        if (this._cplDataList.addNewObject((DataObject)newCdl)) {
            this.getSelectorPanel().addSelectionItem((Object)newCdl, true);
        }
    }

    protected void newAction() {
        String desc;
        NameDialog dlg = new NameDialog((Dialog)((Object)this), "New Computation Point Layer", true);
        dlg.setExistingNames(this.getSelectorPanel().getSelectorItems());
        dlg.setLocationRelativeTo((Component)((Object)this));
        dlg.setVisible(true);
        if (dlg.isCanceled()) {
            return;
        }
        String name = dlg.getName();
        ComputationPointLayer newLayer = (ComputationPointLayer)this._cplDataList.newDataObject(name, desc = dlg.getDescription());
        if (this._cplDataList.addNewObject((DataObject)newLayer)) {
            this.getSelectorPanel().addSelectionItem((Object)newLayer, true);
        }
        this.setModified(true);
    }

    public void fillForm(CommonDataList cplDataList) {
        this._cplDataList = cplDataList;
        Object[] cplArray = this._cplDataList.getObjectArray();
        this.setSelectionList(cplArray);
        this._compPtLayerPanel.setComputationPointDataList(this._cplDataList);
        if (cplArray.length > 0) {
            this.fillForm((NamedType)((ComputationPointLayer)((Object)cplArray[0])));
        }
    }
}

