/*
 * Decompiled with CFR 0.152.
 */
package hec.watershed.client;

import hec.clientapp.gui.MoverDialog2;
import hec.gfx2d.G2dSymbolRenderer;
import hec.gfx2d.Symbol;
import hec.gui.AbstractEditorPanel;
import hec.lang.NamedType;
import hec.model.CommonDataList;
import hec.model.DataStruct;
import hec.watershed.client.CompPtLayerEditor;
import hec.watershed.model.ComputationPoint;
import hec.watershed.model.ComputationPointLayer;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import rma.swing.RmaInsets;
import rma.swing.RmaJButton;
import rma.swing.RmaJColorComboBox;
import rma.swing.RmaJComboBox;
import rma.swing.RmaJList;
import rma.swing.RmaJSpinner;
import rma.swing.list.RmaListModel;

public class CompPtLayerPanel
extends AbstractEditorPanel {
    private RmaJColorComboBox _backgroundColorCombo;
    private RmaJComboBox _symbolCombo;
    private RmaJSpinner _sizeSpinner;
    private RmaJList _compPtList;
    private JButton _editCompPtButton;
    private RmaJList _childLayersList;
    private JButton _editChildLayersButton;
    private ComputationPointLayer _layer;
    private CommonDataList _cplDataList;
    private CompPtLayerEditor _parent;
    private G2dSymbolRenderer _symbolRenderer;
    private RmaJColorComboBox _foregroundColorCombo;

    public CompPtLayerPanel(CompPtLayerEditor parent) {
        super((LayoutManager)new GridBagLayout());
        this._parent = parent;
        this.buildControls();
        this.addListeners();
        this._symbolCombo.setSize(this._symbolCombo.getWidth(), this._symbolCombo.getHeight() + 15);
    }

    protected void buildControls() {
        JPanel drawPropPanel = new JPanel(new GridBagLayout());
        drawPropPanel.setBorder(BorderFactory.createTitledBorder(""));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 0.01;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.INSETS5505;
        this.add(drawPropPanel, gbc);
        JLabel label = new JLabel("Background Color:");
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.INSETS5505;
        drawPropPanel.add((Component)label, gbc);
        this._backgroundColorCombo = new RmaJColorComboBox();
        this._backgroundColorCombo.setModifiable(true);
        label.setLabelFor((Component)this._backgroundColorCombo);
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.INSETS5505;
        drawPropPanel.add((Component)this._backgroundColorCombo, gbc);
        label = new JLabel("Foreground Color:");
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.INSETS5505;
        drawPropPanel.add((Component)label, gbc);
        this._foregroundColorCombo = new RmaJColorComboBox();
        this._foregroundColorCombo.setModifiable(true);
        label.setLabelFor((Component)this._foregroundColorCombo);
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.INSETS5505;
        drawPropPanel.add((Component)this._foregroundColorCombo, gbc);
        label = new JLabel("Symbol:");
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.INSETS5505;
        drawPropPanel.add((Component)label, gbc);
        this._symbolCombo = new RmaJComboBox();
        Integer[] symbolTypes = new Integer[Symbol.numSymbols()];
        for (int i = 0; i < Symbol.numSymbols(); ++i) {
            symbolTypes[i] = new Integer(i);
        }
        DefaultComboBoxModel<Integer> comboModel = new DefaultComboBoxModel<Integer>(symbolTypes);
        this._symbolCombo.setModel(comboModel);
        this._symbolRenderer = new G2dSymbolRenderer(this._foregroundColorCombo.getSelectedColor(), this._backgroundColorCombo.getSelectedColor());
        this._symbolCombo.setRenderer((ListCellRenderer)this._symbolRenderer);
        label.setLabelFor((Component)this._symbolCombo);
        this._symbolCombo.setModifiable(true);
        gbc.gridx = 1;
        gbc.gridy = 2;
        gbc.weightx = 1.0;
        gbc.weighty = 0.5;
        gbc.ipady = 5;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.INSETS5505;
        drawPropPanel.add((Component)this._symbolCombo, gbc);
        label = new JLabel("Symbol Size:");
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.ipady = 0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.INSETS5505;
        drawPropPanel.add((Component)label, gbc);
        this._sizeSpinner = new RmaJSpinner((SpinnerModel)new SpinnerNumberModel(5, 4, 25, 1));
        label.setLabelFor((Component)this._sizeSpinner);
        gbc.gridx = 1;
        gbc.gridy = 3;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.INSETS5505;
        drawPropPanel.add((Component)this._sizeSpinner, gbc);
        JPanel panel2 = new JPanel(new GridBagLayout());
        panel2.setBorder(BorderFactory.createTitledBorder(""));
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.insets = RmaInsets.INSETS5505;
        this.add(panel2, gbc);
        label = new JLabel("Computation Points:");
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.INSETS5505;
        panel2.add((Component)label, gbc);
        this._compPtList = new RmaJList((ListModel)new RmaListModel(true));
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.insets = RmaInsets.INSETS5505;
        panel2.add((Component)new JScrollPane((Component)this._compPtList), gbc);
        this._editCompPtButton = new RmaJButton("Edit"){

            public void setEnabled(boolean enabled) {
                if (enabled && !CompPtLayerPanel.this._parent.isEditable()) {
                    return;
                }
                super.setEnabled(enabled);
            }
        };
        gbc.gridx = 2;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.INSETS5505;
        panel2.add((Component)this._editCompPtButton, gbc);
        label = new JLabel("Child Layers:");
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.INSETS5505;
        panel2.add((Component)label, gbc);
        this._childLayersList = new RmaJList((ListModel)new RmaListModel(true));
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 0.5;
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.insets = RmaInsets.INSETS5505;
        panel2.add((Component)new JScrollPane((Component)this._childLayersList), gbc);
        this._editChildLayersButton = new RmaJButton("Edit"){

            public void setEnabled(boolean enabled) {
                if (enabled && !CompPtLayerPanel.this._parent.isEditable()) {
                    return;
                }
                super.setEnabled(enabled);
            }
        };
        gbc.gridx = 2;
        gbc.gridy = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.INSETS5505;
        panel2.add((Component)this._editChildLayersButton, gbc);
        this.setEnabled(false);
    }

    protected void addListeners() {
        this._editCompPtButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CompPtLayerPanel.this.editCompPtsAction();
            }
        });
        this._editChildLayersButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CompPtLayerPanel.this.editChildLayersAction();
            }
        });
        this._backgroundColorCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 2) {
                    return;
                }
                Color clr = CompPtLayerPanel.this._backgroundColorCombo.getSelectedColor();
                CompPtLayerPanel.this._symbolRenderer.setBackgroundColor(clr);
            }
        });
        this._foregroundColorCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 2) {
                    return;
                }
                Color clr = CompPtLayerPanel.this._foregroundColorCombo.getSelectedColor();
                CompPtLayerPanel.this._symbolRenderer.setForegroundColor(clr);
            }
        });
    }

    protected void editChildLayersAction() {
        RmaListModel model = (RmaListModel)this._childLayersList.getModel();
        List selected = model.getList();
        ArrayList<DataStruct> available = new ArrayList<DataStruct>();
        DataStruct[] objs = this._cplDataList.getObjectArray();
        for (int i = 0; i < objs.length; ++i) {
            ComputationPointLayer cpl = (ComputationPointLayer)objs[i];
            if (cpl == this._layer || cpl.isDefaultLayer()) continue;
            available.add(objs[i]);
        }
        MoverDialog2 mover = new MoverDialog2((JDialog)((Object)this._parent), true);
        mover.setDescVisible(false);
        mover.setTitle("Select Computation Point Layers");
        mover.setData(available, selected);
        mover.setVisible(true);
        if (mover.isCanceled()) {
            return;
        }
        selected = mover.getSelectedObjectsList();
        RmaListModel newModel = new RmaListModel(true, (Collection)selected);
        this._childLayersList.setModel((ListModel)newModel);
        this.setModified(true);
    }

    protected void editCompPtsAction() {
        RmaListModel model = (RmaListModel)this._compPtList.getModel();
        List selected = model.getList();
        ArrayList<DataStruct> available = new ArrayList<DataStruct>();
        DataStruct[] objs = this._cplDataList.getCommonDataListContainer().getCommonDataList(ComputationPoint.class.getName()).getObjectArray();
        for (int i = 0; i < objs.length; ++i) {
            available.add(objs[i]);
        }
        MoverDialog2 mover = new MoverDialog2((JDialog)((Object)this._parent), true);
        mover.setDescVisible(false);
        mover.setTitle("Select Computation Points");
        mover.setData(available, selected);
        mover.setVisible(true);
        if (mover.isCanceled()) {
            return;
        }
        selected = mover.getSelectedObjectsList();
        RmaListModel newModel = new RmaListModel(true, (Collection)selected);
        this._compPtList.setModel((ListModel)newModel);
        this.setModified(true);
    }

    public void fillPanel(NamedType dobj) {
        if (!(dobj instanceof ComputationPointLayer)) {
            this.setEnabled(false);
            return;
        }
        if (this._parent.isEditable()) {
            this.setEnabled(true);
        }
        this._layer = (ComputationPointLayer)dobj;
        Color bgclr = this._layer.getBackgroundColor();
        this._backgroundColorCombo.setSelectedColor(bgclr);
        Color fgclr = this._layer.getForegroundColor();
        this._foregroundColorCombo.setSelectedColor(fgclr);
        int symbolNum = this._layer.getSymbolNum();
        this._symbolCombo.setSelectedItem((Object)symbolNum);
        int size = this._layer.getSymbolSize();
        this._sizeSpinner.setValue((Object)size);
        List<ComputationPoint> compPts = this._layer.getCompPts();
        RmaListModel newModel = new RmaListModel(true, compPts);
        this._compPtList.setModel((ListModel)newModel);
        List<ComputationPointLayer> layers = this._layer.getSubLayers();
        newModel = new RmaListModel(true, layers);
        this._childLayersList.setModel((ListModel)newModel);
        this._editChildLayersButton.setEnabled(!this._layer.isDefaultLayer());
        this._editCompPtButton.setEnabled(!this._layer.isDefaultLayer());
        this.setModified(false);
    }

    public String getTabname() {
        return "Layers";
    }

    public boolean savePanel(NamedType dobj) {
        if (dobj != null && dobj != this._layer) {
            this._layer = (ComputationPointLayer)dobj;
        }
        this._layer.setBackgroundColor(this._backgroundColorCombo.getSelectedColor());
        this._layer.setForegroundColor(this._foregroundColorCombo.getSelectedColor());
        this._layer.setSymbolNum(this._symbolCombo.getSelectedIndex());
        this._layer.setSymbolSize((Integer)this._sizeSpinner.getValue());
        RmaListModel model = (RmaListModel)this._compPtList.getModel();
        ArrayList<ComputationPoint> ccps = new ArrayList<ComputationPoint>(model.getSize());
        for (int i = 0; i < model.getSize(); ++i) {
            ccps.add((ComputationPoint)model.get(i));
        }
        this._layer.setCompPts(ccps);
        model = (RmaListModel)this._childLayersList.getModel();
        ArrayList<ComputationPointLayer> layers = new ArrayList<ComputationPointLayer>(model.getSize());
        for (int i = 0; i < model.getSize(); ++i) {
            layers.add((ComputationPointLayer)((Object)model.get(i)));
        }
        this._layer.setSubLayers(layers);
        this._layer.setModified(true);
        this.setModified(false);
        return true;
    }

    public void setComputationPointDataList(CommonDataList cplDataList) {
        this._cplDataList = cplDataList;
    }

    public void deleteAction() {
        if (this._layer == null) {
            return;
        }
        int opt = JOptionPane.showConfirmDialog((Component)((Object)this._parent), "<html>Confirm Deletion of Computation Point Layer <b>" + this._layer.getName() + "<br>.", "Confirm Delete", 0);
        if (opt == 0 && this._layer.getDataList().removeObject(this._layer.getId())) {
            this._parent.getSelectorPanel().removeSelectionItem((Object)this._layer);
            this.setModified(true);
        }
    }
}

