/*
 * Decompiled with CFR 0.152.
 */
package hec.watershed.client;

import hec.clientapp.gui.MoverDialog2;
import hec.gui.AbstractEditorPanel;
import hec.lang.NamedType;
import hec.map.MapLabelItem;
import hec.map.WorldPt;
import hec.model.CommonDataListContainer;
import hec.model.DataObject;
import hec.model.StreamElement;
import hec.model.StreamJunction;
import hec.watershed.model.ComputationPoint;
import hec.watershed.model.ComputationPointLayer;
import hec.watershed.model.ComputationPointLayerContainer;
import hec.watershed.model.ProjectRef;
import hec.watershed.model.Reservoir;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import rma.swing.RmaInsets;
import rma.swing.RmaJButton;
import rma.swing.RmaJCheckBox;
import rma.swing.RmaJComboBox;
import rma.swing.RmaJDecimalField;
import rma.swing.RmaJList;
import rma.swing.RmaJTextField;
import rma.swing.list.RmaListModel;

public class ComputationPointPanel
extends AbstractEditorPanel {
    private RmaJTextField locationIDFld;
    private RmaJTextField streamNameFld;
    private RmaJDecimalField streamStationFld;
    private RmaJDecimalField streamCoordFld;
    private RmaJDecimalField eastingFld;
    private RmaJDecimalField northingFld;
    private RmaJList projectsList;
    private RmaJCheckBox snapToStreamCB;
    private RmaJCheckBox autoGeneratedCB;
    private RmaJComboBox labelLocation;
    private ComputationPoint _compPt;
    private StreamElement _reach;
    private RmaJList _layersList;
    private JButton _editLayersBtn;
    private JDialog _parent;
    private RmaJCheckBox _atJunctionCB;
    private RmaJList _tributaryList;

    public ComputationPointPanel(JDialog parent) {
        super((LayoutManager)new GridBagLayout());
        this._parent = parent;
        this.buildControls();
    }

    private void buildControls() {
        JPanel jPanel1 = new JPanel(new GridBagLayout());
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        this.add(jPanel1, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 2, RmaInsets.INSETS0000, 0, 0));
        this.add(jPanel2, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 18, 1, RmaInsets.INSETS0000, 0, 0));
        this.add(jPanel3, new GridBagConstraints(1, 0, 1, 2, 1.0, 1.0, 12, 1, RmaInsets.INSETS0000, 0, 0));
        JLabel label = new JLabel("Label Position:", 4);
        label.setDisplayedMnemonic('L');
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)0);
        gbc.weightx = 0.0;
        jPanel3.add((Component)label, gbc);
        this.labelLocation = new RmaJComboBox((Object[])MapLabelItem.POSITION_STRINGS);
        this.labelLocation.setModifiable(true);
        label.setLabelFor((Component)this.labelLocation);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.anchor = 12;
        gbc.fill = 2;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        gbc.weightx = 1.0;
        jPanel3.add((Component)this.labelLocation, gbc);
        JPanel layersPanel = new JPanel(new GridBagLayout());
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridwidth = 2;
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.insets = RmaInsets.insets((int)0, (int)0, (int)0, (int)0);
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        jPanel3.add((Component)layersPanel, gbc);
        this._layersList = new RmaJList((ListModel)new RmaListModel(true)){

            public Dimension getPreferredSize() {
                Dimension d = super.getPreferredSize();
                d.height = 100;
                return d;
            }
        };
        this._layersList.setFixedCellHeight(14);
        this._layersList.setFixedCellWidth(235);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)5, (int)5);
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        JScrollPane jsp = new JScrollPane((Component)this._layersList);
        jsp.setBorder(BorderFactory.createTitledBorder("Associated Layers:"));
        layersPanel.add((Component)jsp, gbc);
        this._editLayersBtn = new RmaJButton("Edit...");
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 10;
        gbc.fill = 0;
        gbc.insets = RmaInsets.INSETS5005;
        layersPanel.add((Component)this._editLayersBtn, gbc);
        this.projectsList = new RmaJList((ListModel)new RmaListModel(true)){

            public Dimension getPreferredSize() {
                Dimension d = super.getPreferredSize();
                d.height = 100;
                return d;
            }
        };
        this.projectsList.setFixedCellHeight(14);
        this.projectsList.setFixedCellWidth(235);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.gridwidth = 2;
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)5, (int)5);
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        jsp = new JScrollPane((Component)this.projectsList);
        jPanel3.add((Component)jsp, gbc);
        jsp.setBorder(BorderFactory.createTitledBorder("Associated Project:"));
        label = new JLabel("Stream Name:", 4);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)0);
        jPanel1.add((Component)label, gbc);
        this.streamNameFld = new RmaJTextField();
        this.streamNameFld.setEnabled(false);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.anchor = 12;
        gbc.fill = 2;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        gbc.weightx = 1.0;
        jPanel1.add((Component)this.streamNameFld, gbc);
        JPanel streamLocation = new JPanel(new GridBagLayout());
        streamLocation.setBorder(BorderFactory.createTitledBorder("Location Information:"));
        jPanel1.add((Component)streamLocation, new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 18, 2, RmaInsets.INSETS0000, 0, 0));
        label = new JLabel("Stream Station:", 4);
        label.setDisplayedMnemonic('s');
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)0);
        gbc.weightx = 0.0;
        streamLocation.add((Component)label, gbc);
        this.streamStationFld = new RmaJDecimalField();
        label.setLabelFor((Component)this.streamStationFld);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)0);
        gbc.weightx = 1.0;
        streamLocation.add((Component)this.streamStationFld, gbc);
        label = new JLabel("Easting:", 4);
        label.setDisplayedMnemonic('e');
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)0);
        gbc.weightx = 0.0;
        streamLocation.add((Component)label, gbc);
        this.eastingFld = new RmaJDecimalField();
        this.eastingFld.setEditable(false);
        label.setLabelFor((Component)this.eastingFld);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)0);
        gbc.weightx = 1.0;
        streamLocation.add((Component)this.eastingFld, gbc);
        label = new JLabel("Northing:", 4);
        label.setDisplayedMnemonic('n');
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)0);
        gbc.weightx = 0.0;
        gbc.weighty = 1.0;
        streamLocation.add((Component)label, gbc);
        this.northingFld = new RmaJDecimalField();
        this.northingFld.setEditable(false);
        label.setLabelFor((Component)this.northingFld);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 2;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)0);
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        streamLocation.add((Component)this.northingFld, gbc);
        this.streamCoordFld = new RmaJDecimalField();
        JPanel panel = new JPanel(new GridBagLayout());
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 2;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.INSETS0000;
        jPanel2.add((Component)panel, gbc);
        label = new JLabel("Location ID:", 4);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)0);
        gbc.weightx = 0.0;
        panel.add((Component)label, gbc);
        this.locationIDFld = new RmaJTextField();
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        gbc.weightx = 1.0;
        panel.add((Component)this.locationIDFld, gbc);
        this.snapToStreamCB = new RmaJCheckBox("Snap to Stream Element");
        this.snapToStreamCB.setMnemonic('s');
        this.snapToStreamCB.setModifiable(false);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridwidth = 1;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)0);
        jPanel2.add((Component)this.snapToStreamCB, gbc);
        this.snapToStreamCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ComputationPointPanel.this.updateCoordinates();
                ComputationPointPanel.this.updateSnapToStream();
            }
        });
        this.autoGeneratedCB = new RmaJCheckBox("System Generated");
        this.autoGeneratedCB.setEnabled(false);
        this.autoGeneratedCB.setModifiable(false);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.weighty = 1.0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)5, (int)0);
        jPanel2.add((Component)this.autoGeneratedCB, gbc);
        JPanel junctionPanel = new JPanel(new GridBagLayout());
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.gridwidth = 2;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.insets = RmaInsets.INSETS0000;
        jPanel2.add((Component)junctionPanel, gbc);
        this._atJunctionCB = new RmaJCheckBox("At Junction");
        this._atJunctionCB.setEnabled(false);
        this._atJunctionCB.setModifiable(false);
        gbc.gridx = -1;
        gbc.gridy = -1;
        gbc.gridwidth = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.INSETS5505;
        junctionPanel.add((Component)this._atJunctionCB, gbc);
        label = new JLabel("Tributaries");
        gbc.gridx = -1;
        gbc.gridy = -1;
        gbc.gridwidth = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.INSETS5505;
        junctionPanel.add((Component)label, gbc);
        this._tributaryList = new RmaJList();
        gbc.gridx = -1;
        gbc.gridy = -1;
        gbc.gridwidth = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.insets = RmaInsets.INSETS5505;
        junctionPanel.add((Component)new JScrollPane((Component)this._tributaryList), gbc);
        this.streamStationFld.addFocusListener((FocusListener)new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                if (e.isTemporary()) {
                    return;
                }
                if (!ComputationPointPanel.this.streamStationFld.isEditable()) {
                    return;
                }
                double station = ComputationPointPanel.this.streamStationFld.getValueUndefined();
                if (station == Double.NEGATIVE_INFINITY) {
                    return;
                }
                if (ComputationPointPanel.this._reach == null) {
                    return;
                }
                WorldPt wpt = ComputationPointPanel.this._reach.getLocationByStation(station);
                ComputationPointPanel.this.eastingFld.setValue(wpt.e);
                ComputationPointPanel.this.northingFld.setValue(wpt.n);
            }
        });
        this._editLayersBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ComputationPointPanel.this.editLayersAction();
            }
        });
    }

    protected void editLayersAction() {
        ComputationPointLayerContainer dl = (ComputationPointLayerContainer)this._compPt.getCommonDataListContainer().getCommonDataList(ComputationPointLayer.class.getName());
        List<ComputationPointLayer> selected = dl.getLayersForComputationPoint(this._compPt);
        List<ComputationPointLayer> available = dl.getCompPointLayers(false);
        available.removeAll(selected);
        MoverDialog2 mover = new MoverDialog2(this._parent, true);
        mover.setData(available, selected);
        mover.setVisible(true);
        if (mover.isCanceled()) {
            return;
        }
        List newSelections = mover.getSelectedObjectsList();
        for (int i = 0; i < newSelections.size(); ++i) {
            ComputationPointLayer layer = (ComputationPointLayer)((Object)newSelections.get(i));
            if (layer.contains(this._compPt)) continue;
            layer.addComputationPoint(this._compPt);
        }
        selected = dl.getLayersForComputationPoint(this._compPt);
        RmaListModel newModel = new RmaListModel(true, selected);
        this._layersList.setModel((ListModel)newModel);
    }

    public void fillPanel(NamedType dobj) {
        if (dobj instanceof ComputationPoint) {
            this.fillPanel((ComputationPoint)dobj);
        }
    }

    public void fillPanel(ComputationPoint cp) {
        this._compPt = cp;
        this._reach = null;
        if (cp == null) {
            return;
        }
        int idx = cp.getStreamId();
        boolean enabled = cp.isAutoGenerated();
        this.autoGeneratedCB.setSelected(enabled);
        this.streamStationFld.setEditable(!enabled);
        this.snapToStreamCB.setEnabled(!enabled);
        this.locationIDFld.setText(this._compPt.getLocation());
        this.labelLocation.setSelectedIndex(cp.getLabelPosition());
        if (this._alignment != null) {
            this._reach = this._alignment.findReach(idx);
            if (this._reach != null) {
                this.streamNameFld.setText(this._reach.getName());
            }
        }
        Vector v = cp.getProjectsRefs();
        int size = v.size();
        Vector<String> projects = new Vector<String>(size);
        CommonDataListContainer dlc = this._compPt.getDataList().getCommonDataListContainer();
        boolean snapToStreamEnabled = true;
        for (int i = 0; i < size; ++i) {
            DataObject dobj;
            ProjectRef ref = (ProjectRef)v.elementAt(i);
            if (ref == null || (dobj = dlc.findObjectById(ref.getProjectId(), ref.getProjectType())) == null) continue;
            if (dobj instanceof Reservoir) {
                snapToStreamEnabled = false;
            }
            projects.addElement(dobj.toString());
        }
        RmaListModel model = new RmaListModel(true, projects);
        this.projectsList.setModel((ListModel)model);
        this.streamStationFld.setValue(cp.getStreamStation());
        if (cp.getStreamCoord() != Double.NEGATIVE_INFINITY) {
            this.streamCoordFld.setValue(cp.getStreamCoord());
        } else {
            this.streamCoordFld.setValue(this.getStreamCoord(cp.getStreamId(), cp.getStreamStation()));
        }
        WorldPt refPt = cp.getReferencePt();
        this.eastingFld.setValue(refPt.e);
        this.northingFld.setValue(refPt.n);
        this.snapToStreamCB.setSelected(cp.getSnapToStream());
        this.snapToStreamCB.setEnabled(snapToStreamEnabled);
        ComputationPointLayerContainer dl = (ComputationPointLayerContainer)cp.getCommonDataListContainer().getCommonDataList(ComputationPointLayer.class.getName());
        List<ComputationPointLayer> layers = dl.getLayersForComputationPoint(cp);
        RmaListModel layerModel = new RmaListModel(true, layers);
        this._layersList.setModel((ListModel)layerModel);
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                ComputationPointPanel.this.updateSnapToStream();
            }
        });
        if (cp.getJunctionIndex() > -1) {
            this._atJunctionCB.setSelected(true);
            List<StreamElement> tribs = this.getTributaries(cp.getStreamId(), cp.getJunctionIndex());
            RmaListModel tribModel = new RmaListModel(true, tribs);
            this._tributaryList.setModel((ListModel)tribModel);
        } else {
            this._atJunctionCB.setSelected(false);
            this._tributaryList.setModel((ListModel)new RmaListModel(false));
        }
    }

    private List<StreamElement> getTributaries(int streamId, int junctionIndex) {
        ArrayList<StreamElement> tribs = new ArrayList<StreamElement>();
        if (this._alignment != null) {
            StreamElement elem = this._alignment.findReach(streamId);
            StreamJunction junc = this._alignment.getJunction(junctionIndex);
            if (junc == null) {
                System.out.println("getTributaries: failed to find junction for id " + junc);
                return tribs;
            }
            Vector vec = new Vector();
            junc.getInflowingStreams(vec);
            junc.getOutflowingStreams(vec);
            for (int i = 0; i < vec.size(); ++i) {
                StreamElement trib = (StreamElement)vec.get(i);
                if (trib == elem) continue;
                tribs.add(trib);
            }
        }
        return tribs;
    }

    private double getStreamCoord(int streamId, double streamStation) {
        StreamElement elem;
        if (this._alignment != null && (elem = this._alignment.findReach(streamId)) != null) {
            return elem.getCoordByStation(streamStation);
        }
        return Double.NEGATIVE_INFINITY;
    }

    private void updateCoordinates() {
        if (this.snapToStreamCB.isSelected()) {
            WorldPt wpt = new WorldPt(this.eastingFld.getValueUndefined(), this.northingFld.getValueUndefined());
            if (this._alignment != null) {
                System.out.println("alignment is " + this._alignment);
                System.out.println("updateCoordinates wpt is " + wpt);
                this._reach = this._alignment.findNearestReach(wpt, new WorldPt());
            }
            if (this._reach != null) {
                System.out.println("updateCoordinates: reach for " + this.eastingFld.getValueUndefined() + "e " + this.northingFld.getValueUndefined() + "n is" + this._reach.getName());
                double station = this._reach.getStationByLocation(wpt);
                WorldPt pt = this._reach.getLocationByStation(station);
                if (pt.isValid()) {
                    this.eastingFld.setValue(pt.e);
                    this.northingFld.setValue(pt.n);
                    wpt.init(pt);
                    station = this._reach.getStationByLocation(wpt);
                    this.streamStationFld.setValue(station);
                    this.streamNameFld.setText(this._reach.getName());
                    this.streamCoordFld.setValue(this.getStreamCoord(this._reach.getIndex(), station));
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void updateSnapToStream() {
        boolean b = this.autoGeneratedCB.isSelected();
        if (b) {
            this.eastingFld.setEditable(!b);
            this.northingFld.setEditable(!b);
            this.streamStationFld.setEditable(!b);
            return;
        }
        b = this.snapToStreamCB.isSelected();
        if (b) {
            if (this._alignment != null) {
                WorldPt wpt = new WorldPt(this.eastingFld.getValueUndefined(), this.northingFld.getValueUndefined());
                if (this._reach == null) {
                    this._reach = this._alignment.findNearestReach(wpt, new WorldPt());
                    this.updateCoordinates();
                }
                if (this._reach == null) {
                    // empty if block
                }
            }
        } else {
            this.streamNameFld.setText("");
            this.streamStationFld.setText("");
        }
        this.eastingFld.setEditable(!b);
        this.northingFld.setEditable(!b);
        this.streamStationFld.setEditable(b);
    }

    public boolean savePanel() {
        return this.savePanel((NamedType)this._compPt);
    }

    public boolean savePanel(NamedType dobj) {
        ComputationPoint compPt = null;
        if (dobj == null) {
            compPt = this._compPt;
        } else if (dobj instanceof ComputationPoint) {
            compPt = (ComputationPoint)dobj;
        }
        if (compPt == null) {
            return true;
        }
        if (this.snapToStreamCB.isSelected() && this._reach != null) {
            compPt.setStreamId(this._reach.getIndex());
        } else {
            compPt.setStreamId(Integer.MIN_VALUE);
        }
        compPt.setStreamStation(this.streamStationFld.getValueUndefined());
        compPt.setStreamCoord(this.streamCoordFld.getValueUndefined());
        WorldPt refPt = new WorldPt(this.eastingFld.getValueUndefined(), this.northingFld.getValueUndefined());
        compPt.setReferencePt(refPt);
        compPt.setSnapToStream(this.snapToStreamCB.isSelected());
        compPt.setLocation(this.locationIDFld.getText());
        compPt.setLabelPosition(this.labelLocation.getSelectedIndex());
        compPt.updateProjects();
        return true;
    }

    public String getTabname() {
        return "Computation Point";
    }
}

