/*
 * Decompiled with CFR 0.152.
 */
package hec.watershed.client;

import hec.appInterface.AppDaddy;
import hec.appInterface.ApplicationModule;
import hec.gui.AbstractEditorPanel;
import hec.gui.MoverDialog;
import hec.gui.NameDialog;
import hec.gui.SelectorPanel;
import hec.gui.SelectorPanelEditor;
import hec.lang.NamedType;
import hec.lang.TimeStep;
import hec.model.DataObject;
import hec.watershed.client.ConditionGISPanel;
import hec.watershed.client.ConditionProjectsPanel;
import hec.watershed.client.ConditionSelectorPanel;
import hec.watershed.client.WatershedConfigMode;
import hec.watershed.model.Condition;
import hec.watershed.model.ConditionContainer;
import hec.watershed.model.Project;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.Vector;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import rma.swing.RmaInsets;
import rma.swing.RmaJTabbedPane;
import rma.swing.RmaJTextArea;
import rma.swing.RmaJTextField;
import rma.swing.event.ReflectMultiListener;
import rma.swing.list.RmaListModel;
import rma.util.RMAIO;

public class ConditionEditor
extends SelectorPanelEditor {
    private ConditionProjectsPanel projectsPanel;
    private ConditionGISPanel gisPanel;
    protected AbstractEditorPanel modelsPanel;
    private JMenuItem newMenuItem;
    private JMenuItem saveAsMenuItem;
    private JMenuItem deleteMenuItem;
    private JMenuItem editProjMenuItem;
    private JMenuItem projectNotesMenuItem;
    private JMenuItem renameMenuItem;
    private JMenu projectsMenu;
    private ConditionContainer _conditionList;
    private JPanel _topPanel;
    private RmaJTextField conditionNameTxt;
    private RmaJTextArea conditionDescTxt;
    private ConditionSelectorPanel _selectorPanel;
    String[] items = TimeStep.TIME_STEP_STRINGS;

    public ConditionEditor(Frame parent, boolean modal) {
        this(parent, modal, false, false);
    }

    public ConditionEditor(Frame parent, boolean modal, boolean hasModelsPanel, boolean hasGisPanel) {
        super(parent, modal, (SelectorPanel)new ConditionSelectorPanel());
        this._selectorPanel = (ConditionSelectorPanel)this.getSelectorPanel();
        this.buildControls(hasModelsPanel, hasGisPanel);
    }

    private void buildControls(boolean hasModelsPanel, boolean hasGisPanel) {
        RmaJTabbedPane tabPane;
        this.setSize(400, 400);
        this.setDefaultSize(400, 400);
        this.setLocation();
        this.setTitle("Configuration Editor");
        this.buildMenus();
        this.projectsPanel = new ConditionProjectsPanel(this);
        if (hasGisPanel) {
            this.gisPanel = new ConditionGISPanel();
        }
        if (hasModelsPanel) {
            this.createModelPanel();
        }
        this.addPanel(this.projectsPanel);
        if (this.gisPanel != null) {
            this.addPanel(this.gisPanel);
        }
        if (this.modelsPanel != null) {
            this.addPanel(this.modelsPanel);
        }
        if ((tabPane = this.getTabbedPane()) != null) {
            tabPane.addChangeListener(new ChangeListener(){
                final /* synthetic */ JTabbedPane val$tabPane;
                {
                    this.val$tabPane = jTabbedPane;
                }

                @Override
                public void stateChanged(ChangeEvent e) {
                    boolean visible = this.val$tabPane.getSelectedIndex() == 0;
                    ConditionEditor.this.projectsMenu.setVisible(visible);
                }
            });
        }
        if (hasGisPanel) {
            this.getTabbedPane().setEnabledAt(1, "fda".equals(AppDaddy.getApp().getAppType()));
        }
        this.setNavPanelVisible(false);
    }

    protected void createModelPanel() {
        try {
            Class<?> c = Class.forName("hec.watershed.client.ConditionModelPanel");
            this.modelsPanel = (AbstractEditorPanel)c.newInstance();
            this.addPanel(this.modelsPanel);
        }
        catch (Exception e) {
            System.out.println("Exception creating the ConditionModelPanel " + e);
        }
    }

    private void buildMenus() {
        JMenuBar menuBar = new JMenuBar();
        JMenu menu = new JMenu("Configuration");
        menu.setMnemonic('c');
        this.newMenuItem = new JMenuItem("New...", 78);
        this.newMenuItem.setAccelerator(KeyStroke.getKeyStroke(78, 2, false));
        this.newMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConditionEditor.this.newCondition();
            }
        });
        menu.add(this.newMenuItem);
        this.saveAsMenuItem = new JMenuItem("Save As...", 83);
        this.saveAsMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConditionEditor.this.saveConditionAs();
            }
        });
        menu.add(this.saveAsMenuItem);
        this.renameMenuItem = new JMenuItem("Rename As...", 82);
        this.renameMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConditionEditor.this.renameCondition();
            }
        });
        menu.add(this.renameMenuItem);
        this.deleteMenuItem = new JMenuItem("Delete", 100);
        this.deleteMenuItem.setAccelerator(KeyStroke.getKeyStroke(127, 2, false));
        this.deleteMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConditionEditor.this.deleteCondition();
            }
        });
        menu.add(this.deleteMenuItem);
        menu.addSeparator();
        JMenuItem menuItem = new JMenuItem("Close", 99);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(87, 2, false));
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConditionEditor.this.windowClosing();
                ConditionEditor.this.setVisible(false);
            }
        });
        menu.add(menuItem);
        menuBar.add(menu);
        menu = new JMenu("Edit");
        menu.setMnemonic('e');
        menuBar.add(menu);
        this.projectNotesMenuItem = new JMenuItem("Project Notes", 112);
        ReflectMultiListener listener = new ReflectMultiListener();
        this.projectNotesMenuItem.addActionListener((ActionListener)listener.add((Object)this, (Object)this.projectNotesMenuItem, "projectNotes"));
        menu.add(this.projectNotesMenuItem);
        this.projectsMenu = new JMenu("Projects");
        this.projectsMenu.setMnemonic('p');
        this.editProjMenuItem = new JMenuItem("Edit Project List...", 101);
        this.editProjMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConditionEditor.this.selectProject();
            }
        });
        this.projectsMenu.add(this.editProjMenuItem);
        menuBar.add(this.projectsMenu);
        this.setJMenuBar(menuBar);
    }

    public void setConditionList(ConditionContainer container) {
        this._conditionList = container;
    }

    public void newCondition() {
        NameDialog namedlg = new NameDialog((Dialog)((Object)this), true);
        String workspaceName = "";
        workspaceName = AppDaddy.getWorkspace() != null ? AppDaddy.getWorkspace().getTitleName() + " - " : "";
        namedlg.setTitle(workspaceName + "Create a New Configuration");
        namedlg.setNameLabel("Name:");
        namedlg.setLocation();
        String name = "";
        String descr = "";
        boolean done = false;
        Condition c = null;
        while (!done) {
            namedlg.setVisible(true);
            if (namedlg.isCanceled()) {
                return;
            }
            name = namedlg.getName().trim();
            descr = namedlg.getDescription().trim();
            if (name.length() == 0) {
                return;
            }
            done = true;
            DataObject[] conditions = this._conditionList.getObjects();
            for (int i = 0; i < conditions.length; ++i) {
                c = (Condition)conditions[i];
                if (c == null || !name.equalsIgnoreCase(c.getName())) continue;
                JOptionPane.showMessageDialog((Component)((Object)this), name + " is used by another Configuration, enter a unique name.", "Name Conflict", 0);
                done = false;
                break;
            }
            if ((c = (Condition)this._conditionList.newDataObject(name, descr)) == null) break;
            c.setProjects(this.getExistingProjects());
            if (!this._conditionList.addNewObject((DataObject)c)) continue;
            ((RmaListModel)this.selectorPanel.getComboBox().getModel()).addElement((Object)c);
            this.selectorPanel.setSelectedItem((Object)c);
            this.selectorPanel.updateNavPanel();
            this.setMenusState(c);
        }
        if (c != null) {
            c.setModified(true);
            this.setModified(true);
        }
        this.repaint();
        namedlg.dispose();
    }

    public void saveConditionAs() {
        Condition c = (Condition)this.selectorPanel.getSelectedItem();
        if (c == null) {
            return;
        }
        NameDialog dlg = new NameDialog((Dialog)((Object)this), "Save As..", true);
        dlg.setExistingNames(this._conditionList.getNamesVector());
        dlg.setName(c.getName());
        dlg.setDescription(c.getDescription());
        dlg.setVisible(true);
        if (dlg.isCanceled()) {
            return;
        }
        String newName = dlg.getName();
        String newDesc = dlg.getDescription();
        Condition newC = (Condition)this._conditionList.newDataObject(newName, newDesc);
        newC.copyInto(c);
        newC.setName(newName);
        newC.setDescription(newDesc);
        this._conditionList.addNewObject((DataObject)newC);
        this.fillForm();
        this.fillForm(newC);
        this.selectorPanel.setSelectedItem((Object)newC);
    }

    public void renameCondition() {
        Condition c = (Condition)this.selectorPanel.getSelectedItem();
        if (c == null) {
            return;
        }
        NameDialog dlg = new NameDialog((Dialog)((Object)this), "Rename As..", true);
        dlg.setExistingNames(this._conditionList.getNamesVector());
        dlg.setName(c.getName());
        dlg.setDescription(c.getDescription());
        dlg.setVisible(true);
        if (dlg.isCanceled()) {
            return;
        }
        String newName = dlg.getName();
        String newDesc = dlg.getDescription();
        c.rename(newName);
        c.setDescription(newDesc);
        this.fillForm();
        this.selectorPanel.setSelectedItem((Object)c);
    }

    public void deleteCondition() {
        Condition c = (Condition)this.selectorPanel.getSelectedItem();
        if (c == null) {
            return;
        }
        int opt = JOptionPane.showConfirmDialog((Component)((Object)this), "Okay to delete Configuration " + c.getName(), "Confirm Delete", 0);
        if (opt == 1) {
            return;
        }
        if (this._conditionList.removeObject(c.getId())) {
            ((RmaListModel)this.selectorPanel.getComboBox().getModel()).removeElement((Object)c);
            if (this.selectorPanel.getComboBox().getItemCount() > 0) {
                this.selectorPanel.getComboBox().setSelectedIndex(0);
            } else {
                this.selectorPanel.getComboBox().setSelectedIndex(-1);
            }
        } else {
            JOptionPane.showMessageDialog((Component)((Object)this), "Failed to remove Configuration " + c.getName());
        }
    }

    public boolean saveForm() {
        if (!super.saveForm()) {
            return false;
        }
        if (this._selectedItem == null) {
            return true;
        }
        ((Condition)this._selectedItem).setConditionDate(this._selectorPanel.getConditionDate());
        ApplicationModule mode = AppDaddy.getFrame().getCurrentModule();
        if (mode instanceof WatershedConfigMode) {
            WatershedConfigMode wscm = (WatershedConfigMode)mode;
            wscm.updateConditionList();
            wscm.setSelectedCondition((Condition)this._selectedItem);
        }
        return true;
    }

    private void saveCondition(Condition c) {
        if (c == null) {
            return;
        }
        this.projectsPanel.savePanel();
        if (c.isModified()) {
            c.save();
        }
    }

    public void selectProject() {
        Condition c = (Condition)this.selectorPanel.getSelectedItem();
        if (c == null) {
            return;
        }
        MoverDialog moverDialog = new MoverDialog((JDialog)((Object)this), true, "Project Selector");
        moverDialog.setDescVisible(false);
        JPanel topPanel = this.getMoverDialogTopPanel();
        moverDialog.addTopPanel(topPanel);
        Vector available = this._conditionList.getStudyCondition().getProjects();
        Vector selected = c.getProjects();
        moverDialog.setData((List)available, (List)selected);
        moverDialog.setAvailableListLabel("Available Projects");
        moverDialog.setSelectedListLabel("Projects in Configuration");
        moverDialog.pack();
        moverDialog.setSize(100, 50);
        moverDialog.setVisible(true);
        this.repaint();
        if (moverDialog.isCanceled()) {
            return;
        }
        Vector newSelections = moverDialog.getSelectedObjectsVector();
        c.setProjects(newSelections);
        moverDialog.dispose();
        this.projectsPanel.fillPanel((NamedType)c);
        if (this.gisPanel != null) {
            this.gisPanel.fillPanel((NamedType)c);
        }
    }

    private JPanel getMoverDialogTopPanel() {
        JPanel topPanel = new JPanel(new GridBagLayout());
        JLabel label = new JLabel("Name:", 4);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.weightx = 0.0;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)0);
        topPanel.add((Component)label, gbc);
        RmaJTextField conditionNameTxt = new RmaJTextField();
        conditionNameTxt.setEditable(false);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)0);
        topPanel.add((Component)conditionNameTxt, gbc);
        label = new JLabel("Description:", 4);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.weightx = 0.0;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)0);
        topPanel.add((Component)label, gbc);
        RmaJTextArea conditionDescTxt = new RmaJTextArea(2, 50);
        conditionDescTxt.setEditable(false);
        conditionDescTxt.setWrapStyleWord(true);
        conditionDescTxt.setLineWrap(true);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.ipady = 10;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)0);
        topPanel.add((Component)new JScrollPane((Component)conditionDescTxt), gbc);
        Condition c = this.getSelectedCondition();
        if (c == null) {
            return topPanel;
        }
        conditionNameTxt.setText(c.getName());
        conditionDescTxt.setText(c.getDescription());
        return topPanel;
    }

    public void removeProject() {
    }

    public void setVisible(boolean b) {
        if (b && this._conditionList == null) {
            System.out.println("setVisible: Unable to find Configuration List");
            JOptionPane.showMessageDialog((Component)((Object)this), "Unable to find Configuration List");
            return;
        }
        super.setVisible(b);
    }

    public void fillForm() {
        if (this._conditionList == null) {
            return;
        }
        DataObject[] conditions = this._conditionList.getObjects();
        Vector<Condition> list = new Vector<Condition>(conditions.length);
        for (int i = 0; i < conditions.length; ++i) {
            Condition c;
            if (conditions[i] == null || (c = (Condition)conditions[i]).isStudyCondition()) continue;
            list.add(c);
        }
        this.setSelectionList(list);
        if (list.size() > 0) {
            this.selectorPanel.setSelectedIndex(0);
        }
    }

    public void fillForm(NamedType nt) {
        super.fillForm(nt);
        if (nt != null && nt instanceof Condition) {
            this._selectorPanel.setConditionDate(((Condition)nt).getConditionDate());
        }
    }

    private void fillForm(Condition c) {
        this.setMenusState(c);
        super.fillForm((NamedType)c);
        if (c == null) {
            return;
        }
        this._selectorPanel.setConditionDate(c.getConditionDate());
    }

    private String generateTimeStepString(int timeStep, int timeInc) {
        switch (timeInc) {
            case 3: {
                return timeStep + " Day(s)";
            }
            case 1: {
                return timeStep + " Minute(s)";
            }
            case 2: {
                return timeStep + " Hour(s)";
            }
            case 0: {
                return timeStep + " Second(s)";
            }
        }
        return "Invalid Time Increment";
    }

    private int parseTimeStep(String timeInc) {
        if (timeInc == null) {
            return -1;
        }
        int index = timeInc.indexOf(" ");
        if (index < 0) {
            return -1;
        }
        return RMAIO.parseInt((String)timeInc.substring(0, index).trim());
    }

    private int parseTimeIncrement(String timeInc) {
        if (timeInc == null) {
            return -1;
        }
        int index = timeInc.indexOf(" ");
        if (index < 0) {
            return -1;
        }
        String increment = timeInc.substring(index).trim();
        if (increment.indexOf("Hour") != -1) {
            return 2;
        }
        if (increment.indexOf("Day") != -1) {
            return 3;
        }
        if (increment.indexOf("Minute") != -1) {
            return 1;
        }
        if (increment.indexOf("Second") != -1) {
            return 0;
        }
        return -1;
    }

    private Vector getExistingProjects() {
        Vector<Project> v = new Vector<Project>();
        Condition c = this._conditionList.getStudyCondition();
        if (c == null) {
            return v;
        }
        Vector projects = c.getProjects();
        if (projects == null) {
            return v;
        }
        int size = projects.size();
        for (int i = 0; i < size; ++i) {
            Project p = (Project)projects.elementAt(i);
            if (p == null || !p.isExisting()) continue;
            v.addElement(p);
        }
        return v;
    }

    private void setMenusState(Condition c) {
        boolean enabled = c != null;
        this.saveAsMenuItem.setEnabled(enabled);
        this.deleteMenuItem.setEnabled(enabled);
        this.editProjMenuItem.setEnabled(enabled);
        this.projectNotesMenuItem.setEnabled(enabled);
    }

    protected void projectNotes() {
        this.projectsPanel.projectNotes();
    }

    public Condition getSelectedCondition() {
        return (Condition)this.selectorPanel.getSelectedItem();
    }

    public void setEditable(boolean editable) {
        super.setEditable(editable);
        this.newMenuItem.setEnabled(editable);
        this.saveAsMenuItem.setEnabled(editable);
        this.deleteMenuItem.setEnabled(editable);
        this.editProjMenuItem.setEnabled(editable);
        this.projectNotesMenuItem.setEnabled(editable);
    }
}

