/*
 * Decompiled with CFR 0.152.
 */
package hec.watershed.client;

import hec.client.MoverDialog;
import hec.clientapp.client.ClientApp;
import hec.gui.AbstractEditorPanel;
import hec.lang.NamedType;
import hec.map.MapGlyph;
import hec.map.MapIdentifier;
import hec.watershed.map.raster.dbf.RasterDbfMap;
import hec.watershed.model.Condition;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import rma.swing.EditableComponent;
import rma.swing.RmaImage;
import rma.swing.RmaInsets;
import rma.swing.RmaJList;
import rma.swing.list.RmaListModel;

public class ConditionGISPanel
extends AbstractEditorPanel {
    public static final String NO_LAYER_SELECTED = "No Layer Selected";
    private RmaJList gisLayersList;
    private RmaJList selectedLayersList;
    private EditableJButton spinDownButton;
    private EditableJButton spinUpButton;
    private EditableJButton editButton;
    private JLabel currentLayerLabel;
    private Condition _condition;

    public ConditionGISPanel() {
        this.buildControls();
    }

    private void buildControls() {
        this.setLayout(new GridBagLayout());
        JPanel mapLayersPanel = new JPanel(new GridBagLayout());
        mapLayersPanel.setBorder(new TitledBorder("GIS Layers"));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridheight = 3;
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        gbc.weightx = 2.0;
        this.add(mapLayersPanel, gbc);
        Vector<String> v = new Vector<String>();
        v.addElement("Land Use Layer");
        v.addElement("Census Layer");
        v.addElement("Terrain Layer");
        v.addElement("Inundation Layer");
        this.gisLayersList = new RmaJList((ListModel)new RmaListModel(false, v)){

            public void clearPerformed() {
            }

            public void setIsEditable(boolean editable) {
            }
        };
        this.gisLayersList.setSelectionMode(0);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.insets = RmaInsets.insets((int)0, (int)0, (int)0, (int)0);
        mapLayersPanel.add((Component)new JScrollPane((Component)this.gisLayersList), gbc);
        this.selectedLayersList = new RmaJList((ListModel)new RmaListModel(false)){

            public void clearPerformed() {
                ((RmaListModel)this.getModel()).clear();
            }
        };
        this.selectedLayersList.setSelectionMode(0);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 2.0;
        gbc.weighty = 6.0;
        gbc.gridheight = 2;
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.insets = RmaInsets.insets((int)15, (int)5, (int)0, (int)5);
        this.currentLayerLabel = new JLabel(NO_LAYER_SELECTED, 0);
        JScrollPane sp = new JScrollPane((Component)this.selectedLayersList);
        sp.setColumnHeaderView(this.currentLayerLabel);
        this.add(sp, gbc);
        JPanel spinButtonPanel = new JPanel(new GridBagLayout());
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 1;
        gbc.anchor = 13;
        gbc.fill = 0;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        this.add(spinButtonPanel, gbc);
        this.spinUpButton = new EditableJButton(RmaImage.getImageIcon((String)"images/spinUp2.gif"));
        this.spinUpButton.setEnabled(false);
        this.spinUpButton.setMargin(RmaInsets.insets((int)0, (int)0, (int)0, (int)0));
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 10;
        gbc.fill = 0;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        spinButtonPanel.add((Component)this.spinUpButton, gbc);
        this.spinDownButton = new EditableJButton(RmaImage.getImageIcon((String)"images/spinDown2.gif"));
        this.spinDownButton.setMargin(RmaInsets.insets((int)0, (int)0, (int)0, (int)0));
        this.spinDownButton.setEnabled(false);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.anchor = 10;
        gbc.fill = 0;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        spinButtonPanel.add((Component)this.spinDownButton, gbc);
        this.editButton = new EditableJButton("Edit List...");
        this.editButton.setEnabled(false);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 2;
        gbc.weighty = 1.0;
        gbc.anchor = 15;
        gbc.fill = 0;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)5, (int)5);
        this.add(this.editButton, gbc);
        this.editButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConditionGISPanel.this.editList();
            }
        });
        this.gisLayersList.setSelectedIndex(0);
        this.gisLayersList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                if (!ConditionGISPanel.this.currentLayerLabel.getText().equals(ConditionGISPanel.NO_LAYER_SELECTED)) {
                    ConditionGISPanel.this.saveCurrentLayer(ConditionGISPanel.this.currentLayerLabel.getText());
                }
                Object obj = ConditionGISPanel.this.gisLayersList.getSelectedValue();
                String title = ConditionGISPanel.NO_LAYER_SELECTED;
                if (obj != null) {
                    title = obj.toString();
                }
                ConditionGISPanel.this.currentLayerLabel.setText(title);
                ConditionGISPanel.this.selectedLayersList.clearSelection();
                ConditionGISPanel.this.loadCurrentLayer();
            }
        });
        this.selectedLayersList.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                boolean enabled = true;
                if (ConditionGISPanel.this.selectedLayersList.getSelectedIndex() < 0) {
                    enabled = false;
                }
                ConditionGISPanel.this.spinDownButton.setEnabled(enabled);
                ConditionGISPanel.this.spinUpButton.setEnabled(enabled);
            }
        });
        ActionListener spinAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int idx;
                Object obj = e.getSource();
                boolean moveUp = false;
                if (obj == ConditionGISPanel.this.spinUpButton) {
                    moveUp = true;
                }
                if ((idx = ConditionGISPanel.this.selectedLayersList.getSelectedIndex()) < 0) {
                    return;
                }
                RmaListModel model = (RmaListModel)ConditionGISPanel.this.selectedLayersList.getModel();
                if (moveUp && idx < 1) {
                    return;
                }
                if (!moveUp && idx == model.size() - 1) {
                    return;
                }
                obj = model.elementAt(idx);
                model.removeElementAt(idx);
                idx = moveUp ? --idx : ++idx;
                model.insertElementAt(obj, idx);
                ConditionGISPanel.this.selectedLayersList.setSelectedIndex(idx);
                ConditionGISPanel.this.setModified(true);
            }
        };
        this.spinDownButton.addActionListener(spinAction);
        this.spinUpButton.addActionListener(spinAction);
    }

    public void fillPanel(NamedType nt) {
        if (!(nt instanceof Condition)) {
            return;
        }
        this._condition = (Condition)nt;
        this.loadCurrentLayer();
    }

    public boolean savePanel(NamedType dobj) {
        return true;
    }

    protected void editList() {
        int i;
        MapIdentifier mapId;
        if (this._condition == null) {
            return;
        }
        String gisLayer = this.gisLayersList.getSelectedValue().toString();
        if (gisLayer == null) {
            return;
        }
        Vector gisVector = this._condition.getGISLayers(gisLayer);
        Vector<MapIdentifier> selectedMaps = new Vector<MapIdentifier>(gisVector.size());
        Vector<MapIdentifier> availableMaps = this.getMapIdVector();
        Vector<MapIdentifier> tmp = new Vector<MapIdentifier>(availableMaps.size());
        Class<?> gisMapClass = null;
        block4: for (int ii = 0; ii < availableMaps.size(); ++ii) {
            mapId = (MapIdentifier)availableMaps.elementAt(ii);
            if (mapId == null) continue;
            Class<?> watershedMapClass = null;
            try {
                watershedMapClass = Class.forName(mapId.getClassName());
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (watershedMapClass == null) continue;
            if ((gisLayer.equals("Land Use Layer") || gisLayer.equals("Census Layer")) && watershedMapClass.getName().equals(RasterDbfMap.class.getName())) {
                tmp.add(mapId);
                continue;
            }
            if (gisLayer.equals("Inundation Layer") && watershedMapClass.getName().equals("hec.map.inundation.InundationGroup")) {
                tmp.add(mapId);
                continue;
            }
            if (!gisLayer.equals("Terrain Layer")) continue;
            if (gisMapClass == null) {
                try {
                    gisMapClass = Class.forName("hec.map.ElevationMap");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (gisMapClass == null) continue;
            }
            Class<?>[] interfaces = watershedMapClass.getInterfaces();
            for (int jj = 0; jj < interfaces.length; ++jj) {
                if (!interfaces[jj].equals(gisMapClass)) continue;
                tmp.add(mapId);
                continue block4;
            }
        }
        availableMaps = tmp;
        for (i = 0; i < gisVector.size(); ++i) {
            String s = gisVector.elementAt(i).toString();
            for (int j = 0; j < availableMaps.size(); ++j) {
                mapId = (MapIdentifier)availableMaps.elementAt(j);
                if (mapId == null) continue;
                String mapIdPath = mapId.getPath();
                ClientApp.app();
                if (ClientApp.Workspace().isFullPath(mapIdPath)) {
                    ClientApp.app();
                    mapIdPath = ClientApp.Workspace().getRelativePath(mapIdPath);
                }
                if (!mapIdPath.equals(s)) continue;
                selectedMaps.addElement(mapId);
            }
        }
        MoverDialog moverDialog = new MoverDialog((JDialog)SwingUtilities.windowForComponent((Component)((Object)this)), true);
        if (gisLayer.equals("Land Use Layer") || gisLayer.equals("Census Layer")) {
            moverDialog.setSelectionType(1);
        }
        moverDialog.setMoveUpDownVisible(true);
        moverDialog.setTitle("Select " + gisLayer + "s");
        moverDialog.setData(availableMaps, selectedMaps);
        moverDialog.setAvailableListLabel("Available Layers");
        moverDialog.setSelectedListLabel("Selected Layers");
        moverDialog.setDescVisible(false);
        moverDialog.setVisible(true);
        if (moverDialog.isCanceled()) {
            return;
        }
        Vector newSelections = moverDialog.getSelectedObjectsVector();
        Vector<String> newSelectionPaths = new Vector<String>(newSelections.size());
        RmaListModel model = (RmaListModel)this.selectedLayersList.getModel();
        model.clear();
        for (i = 0; i < newSelections.size(); ++i) {
            mapId = (MapIdentifier)newSelections.elementAt(i);
            if (mapId == null) continue;
            String mapIdPath = mapId.getPath();
            ClientApp.app();
            if (ClientApp.Workspace().isFullPath(mapIdPath)) {
                ClientApp.app();
                mapIdPath = ClientApp.Workspace().getRelativePath(mapIdPath);
            }
            newSelectionPaths.addElement(mapIdPath);
            model.addElement((Object)mapId);
        }
        this._condition.setGISLayers(gisLayer, newSelectionPaths);
        this.setModified(true);
    }

    private void saveCurrentLayer(String gisLayer) {
        if (this._condition == null) {
            return;
        }
        Vector currentLayers = this._condition.getGISLayers(gisLayer);
        Vector layers = ((RmaListModel)this.selectedLayersList.getModel()).getVector();
        int size = layers.size();
        if (currentLayers.size() == 0 && size == 0) {
            return;
        }
        Vector<String> layerPaths = new Vector<String>(size);
        for (int i = 0; i < size; ++i) {
            MapIdentifier mapId = (MapIdentifier)layers.elementAt(i);
            if (mapId == null) continue;
            String mapIdPath = mapId.getPath();
            ClientApp.app();
            if (ClientApp.Workspace().isFullPath(mapIdPath)) {
                ClientApp.app();
                mapIdPath = ClientApp.Workspace().getRelativePath(mapIdPath);
            }
            layerPaths.addElement(mapIdPath);
        }
        this._condition.setGISLayers(gisLayer, layerPaths);
    }

    private void loadCurrentLayer() {
        MapIdentifier mapId;
        RmaListModel model = (RmaListModel)this.selectedLayersList.getModel();
        model.clear();
        if (this._condition == null) {
            return;
        }
        Object obj = this.gisLayersList.getSelectedValue();
        if (obj == null) {
            return;
        }
        String gisLayer = obj.toString();
        Vector currentLayers = this._condition.getGISLayers(gisLayer);
        if (currentLayers == null) {
            return;
        }
        Vector mapIds = this.getMapIdVector();
        boolean foundMap = false;
        Class<?> gisMapClass = null;
        for (int ii = 0; ii < mapIds.size(); ++ii) {
            mapId = (MapIdentifier)mapIds.elementAt(ii);
            if (mapId == null) continue;
            Class<?> watershedMapClass = null;
            try {
                watershedMapClass = Class.forName(mapId.getClassName());
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (watershedMapClass == null) continue;
            if ((gisLayer.equals("Land Use Layer") || gisLayer.equals("Census Layer")) && watershedMapClass.getName().equals(RasterDbfMap.class.getName())) {
                foundMap = true;
                break;
            }
            if (gisLayer.equals("Inundation Layer") && watershedMapClass.getName().equals("hec.map.inundation.InundationGroup")) {
                foundMap = true;
                break;
            }
            if (!gisLayer.equals("Terrain Layer") && !gisLayer.equals("Inundation Layer")) continue;
            if (gisMapClass == null) {
                try {
                    gisMapClass = Class.forName("hec.map.ElevationMap");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (gisMapClass == null) continue;
            }
            Class<?>[] interfaces = watershedMapClass.getInterfaces();
            boolean foundInterface = false;
            for (int jj = 0; jj < interfaces.length; ++jj) {
                if (!interfaces[jj].equals(gisMapClass)) continue;
                foundInterface = true;
                break;
            }
            if (!foundInterface) continue;
            foundMap = true;
            break;
        }
        if (foundMap) {
            this.editButton.setEnabled(true);
        } else {
            this.editButton.setEnabled(false);
        }
        int size = currentLayers.size();
        int mapIdSize = mapIds.size();
        for (int i = 0; i < size; ++i) {
            String path = currentLayers.elementAt(i).toString();
            if (path == null) continue;
            ClientApp.app();
            if (ClientApp.Workspace().isFullPath(path)) {
                ClientApp.app();
                path = ClientApp.Workspace().getRelativePath(path);
            }
            for (int j = 0; j < mapIdSize; ++j) {
                mapId = (MapIdentifier)mapIds.elementAt(j);
                if (mapId == null) continue;
                String mapIdPath = mapId.getPath();
                ClientApp.app();
                if (ClientApp.Workspace().isFullPath(mapIdPath)) {
                    ClientApp.app();
                    mapIdPath = ClientApp.Workspace().getRelativePath(mapIdPath);
                }
                if (!mapIdPath.equals(path)) continue;
                model.addElement((Object)mapId);
            }
        }
    }

    private Vector getMapIdVector() {
        ClientApp.app();
        List glyphVector = ClientApp.frame().getMapPanel().glyphList();
        int size = glyphVector.size();
        Vector<MapIdentifier> mapIdVector = new Vector<MapIdentifier>(size);
        for (int i = 0; i < size; ++i) {
            MapGlyph glyph = (MapGlyph)glyphVector.get(i);
            if (glyph == null) continue;
            mapIdVector.addElement(glyph.getMap().getMapIdentifier());
        }
        return mapIdVector;
    }

    public String getTabname() {
        return "GIS";
    }

    public class EditableJButton
    extends JButton
    implements EditableComponent {
        boolean isEditable;

        public EditableJButton(String s) {
            super(s);
            this.isEditable = false;
        }

        public EditableJButton(ImageIcon i) {
            super(i);
            this.isEditable = false;
        }

        public void setIsEditable(boolean b) {
            this.isEditable = b;
            if (!b) {
                this.setEnabled(false);
            }
        }

        @Override
        public void setEnabled(boolean b) {
            if (this.isEditable) {
                super.setEnabled(b);
            } else {
                super.setEnabled(false);
            }
        }
    }
}

