/*
 * Decompiled with CFR 0.152.
 */
package hec.watershed.client;

import hec.clientapp.client.ClientApp;
import hec.clientapp.client.ClientWorkspace;
import hec.clientapp.model.Manager;
import hec.clientapp.model.ManagerProxy;
import hec.clientapp.supplemental.SupplementalRmiWorkspace;
import hec.clientapp.supplemental.model.SupplementalProgramAlt;
import hec.gui.AbstractEditorPanel;
import hec.gui.MoverDialog;
import hec.io.Identifier;
import hec.lang.ModelReference;
import hec.lang.NamedType;
import hec.lang.WorkspaceNameFactory;
import hec.model.ModelConstants;
import hec.supplemental.model.ProgramOrderItem;
import hec.watershed.model.Condition;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.rmi.RemoteException;
import java.util.Collection;
import java.util.List;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import rma.swing.RmaImage;
import rma.swing.RmaInsets;
import rma.swing.RmaJList;
import rma.swing.RmaJObjectLabel;
import rma.swing.list.RmaListModel;
import rma.util.RMAIO;

public class ConditionModelPanel
extends AbstractEditorPanel
implements ModelConstants {
    public static final String NO_MODEL_SELECTED = "No Model Selected";
    protected RmaJList modelsList;
    private RmaJList selectedModelsList;
    private JButton spinDownButton;
    private JButton spinUpButton;
    private RmaJObjectLabel currentLayerLabel;
    private JButton editButton;
    private Condition _condition;
    private Vector _modelOrder = null;
    protected Vector _rssAltList = new Vector();
    protected Vector _rasAltList = new Vector();
    protected Vector _hfpAltList = new Vector();
    protected Vector _fiaAltList = new Vector();
    protected Vector _mfpAltList = new Vector();
    protected Vector _supAltList = new Vector();
    private String _lastModelName;
    private ListSelectionListener _listSelectionListener;

    public ConditionModelPanel() {
        this.buildControls();
    }

    private void buildControls() {
        this.setLayout(new GridBagLayout());
        JPanel mapLayersPanel = new JPanel(new GridBagLayout());
        mapLayersPanel.setBorder(new TitledBorder("Models"));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridheight = 3;
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        gbc.weightx = 2.0;
        this.add(mapLayersPanel, gbc);
        this.modelsList = new RmaJList((ListModel)new RmaListModel(false)){
            private Dimension _d;
            {
                this._d = new Dimension(256, 128);
            }

            public Dimension getPreferredScrollableViewportSize() {
                return this._d;
            }

            public void clearPerformed() {
            }
        };
        this.modelsList.setSelectionMode(0);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.insets = RmaInsets.insets((int)0, (int)0, (int)0, (int)0);
        mapLayersPanel.add((Component)new JScrollPane((Component)this.modelsList), gbc);
        JPanel selectedModelsPanel = new JPanel(new GridBagLayout());
        selectedModelsPanel.setBorder(new TitledBorder("Configuration Alternatives"));
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 2.0;
        gbc.weighty = 6.0;
        gbc.gridheight = 2;
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        this.currentLayerLabel = new RmaJObjectLabel((Object)NO_MODEL_SELECTED, 0);
        this.add(selectedModelsPanel, gbc);
        this.selectedModelsList = new RmaJList((ListModel)new RmaListModel(true)){
            private Dimension _d;
            {
                this._d = new Dimension(256, 128);
            }

            public Dimension getPreferredScrollableViewportSize() {
                return this._d;
            }

            public void clearPerformed() {
                ((RmaListModel)this.getModel()).clear();
            }
        };
        this.selectedModelsList.setSelectionMode(0);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 2.0;
        gbc.weighty = 6.0;
        gbc.gridheight = 1;
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        this.currentLayerLabel = new RmaJObjectLabel((Object)NO_MODEL_SELECTED, 0);
        JScrollPane sp = new JScrollPane((Component)this.selectedModelsList);
        sp.setColumnHeaderView((Component)this.currentLayerLabel);
        selectedModelsPanel.add((Component)sp, gbc);
        JPanel spinButtonPanel = new JPanel(new GridBagLayout());
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 1;
        gbc.anchor = 13;
        gbc.fill = 0;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        this.add(spinButtonPanel, gbc);
        this.spinUpButton = new JButton(RmaImage.getImageIcon((String)"images/spinUp2.gif"));
        this.spinUpButton.setEnabled(false);
        this.spinUpButton.setMargin(RmaInsets.insets((int)0, (int)0, (int)0, (int)0));
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 10;
        gbc.fill = 0;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        this.spinDownButton = new JButton(RmaImage.getImageIcon((String)"images/spinDown2.gif"));
        this.spinDownButton.setMargin(RmaInsets.insets((int)0, (int)0, (int)0, (int)0));
        this.spinDownButton.setEnabled(false);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.anchor = 10;
        gbc.fill = 0;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        this.editButton = new JButton("Edit List...");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.weighty = 1.0;
        gbc.anchor = 15;
        gbc.fill = 0;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)5, (int)5);
        selectedModelsPanel.add((Component)this.editButton, gbc);
        this.editButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConditionModelPanel.this.editList();
            }
        });
        this.modelsList.setSelectedIndex(0);
        this._listSelectionListener = new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                if (!ConditionModelPanel.this.currentLayerLabel.getText().equals(ConditionModelPanel.NO_MODEL_SELECTED)) {
                    ConditionModelPanel.this.saveCurrentLayer(ConditionModelPanel.this.currentLayerLabel.getText());
                }
                ProgramOrderItem poi = (ProgramOrderItem)ConditionModelPanel.this.modelsList.getSelectedValue();
                String title = ConditionModelPanel.NO_MODEL_SELECTED;
                if (poi != null) {
                    ConditionModelPanel.this.currentLayerLabel.setObject((Object)poi);
                } else {
                    ConditionModelPanel.this.currentLayerLabel.setObject(null);
                    ConditionModelPanel.this.currentLayerLabel.setText(title);
                }
                ConditionModelPanel.this.selectedModelsList.clearSelection();
                ConditionModelPanel.this.loadCurrentLayer();
            }
        };
        this.modelsList.addListSelectionListener(this._listSelectionListener);
        this.selectedModelsList.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                boolean enabled = true;
                if (ConditionModelPanel.this.selectedModelsList.getSelectedIndex() < 0) {
                    enabled = false;
                }
                ConditionModelPanel.this.spinDownButton.setEnabled(enabled);
                ConditionModelPanel.this.spinUpButton.setEnabled(enabled);
            }
        });
        ActionListener spinAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int idx;
                Object obj = e.getSource();
                boolean moveUp = false;
                if (obj == ConditionModelPanel.this.spinUpButton) {
                    moveUp = true;
                }
                if ((idx = ConditionModelPanel.this.selectedModelsList.getSelectedIndex()) < 0) {
                    return;
                }
                RmaListModel model = (RmaListModel)ConditionModelPanel.this.selectedModelsList.getModel();
                if (moveUp && idx < 1) {
                    return;
                }
                if (!moveUp && idx == model.size() - 1) {
                    return;
                }
                obj = model.elementAt(idx);
                model.removeElementAt(idx);
                idx = moveUp ? --idx : ++idx;
                model.insertElementAt(obj, idx);
            }
        };
        this.spinDownButton.addActionListener(spinAction);
        this.spinUpButton.addActionListener(spinAction);
    }

    private void makeAltLists() {
        ClientWorkspace wksp = ClientApp.Workspace();
        this._rssAltList.removeAllElements();
        this._rasAltList.removeAllElements();
        this._hfpAltList.removeAllElements();
        this._fiaAltList.removeAllElements();
        this._mfpAltList.removeAllElements();
        this._supAltList.removeAllElements();
        this.getManagerList("hfp", "wcds.hfp.model.HfpAlternative", this._hfpAltList);
        this.getManagerList("mfp", "wcds.mfp.model.MfpAlternative", this._mfpAltList);
        this.getManagerList("rss", "hec.rss.model.RssAlt", this._rssAltList);
        this.getManagerList("ras", "hec.ras.model.Plan", this._rasAltList);
        this.getManagerList("fia", "hec.fia.model.FiaAlt", this._fiaAltList);
        Vector idlist = wksp.getManagerIDList("supplemental", "hec.clientapp.supplemental.model.SupplementalProgramAlt");
        if (idlist.size() <= 0) {
            System.out.println("Warning: No Supplemental Alternatives available");
        } else {
            for (int zz = 0; zz < idlist.size(); ++zz) {
                Manager mgr;
                Identifier id = (Identifier)idlist.elementAt(zz);
                if (id == null || (mgr = wksp.openManager("supplemental", id)) == null) continue;
                this._supAltList.addElement(mgr);
            }
        }
    }

    protected void getManagerList(String wkspName, String clsName, Vector mgrList) {
        Vector idlist = ClientApp.Workspace().getManagerIDList(wkspName, clsName);
        if (idlist == null || idlist.size() <= 0) {
            System.out.println("Warning: No " + wkspName + " Alternatives available");
        } else {
            for (int zz = 0; zz < idlist.size(); ++zz) {
                ManagerProxy proxy;
                Identifier id = (Identifier)idlist.elementAt(zz);
                if (id == null || (proxy = ClientApp.Workspace().getManager(wkspName, id)) == null) continue;
                mgrList.addElement(proxy);
            }
        }
    }

    public void fillPanel(NamedType nt) {
        this.makeAltLists();
        try {
            SupplementalRmiWorkspace smWksp = (SupplementalRmiWorkspace)ClientApp.Workspace().getChildWorkspace("supplemental");
            if (smWksp != null) {
                this._modelOrder = smWksp.getOrderedModels(ClientApp.app().getAppType());
            }
        }
        catch (RemoteException re) {
            System.out.println("fillPanel: failed to get model execution order from Supplemental RmiWorkspace " + re);
        }
        RmaListModel model = (RmaListModel)this.modelsList.getModel();
        this.modelsList.removeListSelectionListener(this._listSelectionListener);
        model.removeAllElements();
        int i = 1;
        if (this._modelOrder != null) {
            for (i = 0; i < this._modelOrder.size(); ++i) {
                Object obj = this._modelOrder.elementAt(i);
                if (!(obj instanceof ProgramOrderItem)) continue;
                ProgramOrderItem moi = (ProgramOrderItem)obj;
                model.addElement((Object)moi);
            }
        }
        this.modelsList.addListSelectionListener(this._listSelectionListener);
        this.modelsList.clearSelection();
        if (!(nt instanceof Condition)) {
            return;
        }
        this._condition = (Condition)nt;
        this.loadCurrentLayer();
    }

    public boolean savePanel(NamedType dobj) {
        return true;
    }

    protected void editList() {
        Object obj;
        int i;
        if (this._condition == null) {
            return;
        }
        int selModelIdx = this.getSelectedModelIndex();
        if (selModelIdx == -1) {
            return;
        }
        ClientWorkspace wksp = ClientApp.Workspace();
        String selModel = this.getSelectedModelName();
        String modelName = this.currentLayerLabel.getText();
        String wkspName = WorkspaceNameFactory.getWorkspaceName((String)modelName);
        Vector modelRefVector = this._condition.getModelAlts(selModelIdx);
        this.updateWorkspace(wkspName);
        Vector modelVector = this.getModelVectorFromRefVector(modelRefVector, selModel);
        Vector available = new Vector();
        Vector totalAvailable = this.getSelectedModelVector();
        if (totalAvailable != null) {
            for (i = 0; i < totalAvailable.size(); ++i) {
                String fileName;
                obj = totalAvailable.get(i);
                if (obj instanceof ManagerProxy) {
                    ManagerProxy proxy = (ManagerProxy)obj;
                    fileName = RMAIO.getFileFromPath((String)proxy.getId().getName());
                } else if (obj instanceof Manager) {
                    Manager mgr = (Manager)obj;
                    fileName = RMAIO.getFileFromPath((String)mgr.getIdentifier().getName());
                } else {
                    fileName = "A:";
                }
                if (fileName.length() >= 2 && (Character.isLetter(fileName.charAt(0)) || Character.isDigit(fileName.charAt(0))) && fileName.charAt(1) == ':' || fileName.length() >= 3 && (Character.isLetter(fileName.charAt(0)) || Character.isDigit(fileName.charAt(0))) && Character.isDigit(fileName.charAt(1)) && fileName.charAt(2) == ':') continue;
                available.add(obj);
            }
        }
        MoverDialog moverDialog = new MoverDialog((JDialog)SwingUtilities.windowForComponent((Component)((Object)this)), true);
        moverDialog.setTitle("Select " + modelName + " Alternatives");
        moverDialog.setData(available, (List)modelVector);
        moverDialog.setAvailableListLabel("Available Alternatives");
        moverDialog.setSelectedListLabel("Selected Alternatives");
        moverDialog.setDescVisible(false);
        moverDialog.setVisible(true);
        if (moverDialog.isCanceled()) {
            return;
        }
        Vector newSelections = moverDialog.getSelectedObjectsVector();
        Vector<ModelReference> newSelectionRefs = new Vector<ModelReference>(newSelections.size());
        RmaListModel model = (RmaListModel)this.selectedModelsList.getModel();
        model.clear();
        for (i = 0; i < newSelections.size(); ++i) {
            ModelReference mref;
            obj = newSelections.elementAt(i);
            if (obj == null) continue;
            if (obj instanceof ManagerProxy) {
                ManagerProxy proxy = (ManagerProxy)obj;
                mref = new ModelReference(proxy.getIndex(), proxy.getClassName(), selModel);
                newSelectionRefs.addElement(mref);
                model.addElement((Object)proxy);
                continue;
            }
            if (!(obj instanceof Manager)) continue;
            Manager manager = (Manager)obj;
            mref = new ModelReference(manager.getIndex(), manager.getClass().getName(), selModel);
            newSelectionRefs.addElement(mref);
            model.addElement((Object)manager);
        }
        this.selectedModelsList.setModified(true);
        this._condition.setModelAlts(selModelIdx, newSelectionRefs);
    }

    protected void updateWorkspace(String wkspName) {
    }

    private void saveCurrentLayer(String gisLayer) {
        if (this._condition == null) {
            return;
        }
    }

    private Vector getSelectedModelVector() {
        String modelName = this.getSelectedModelName();
        if (modelName.equalsIgnoreCase("MFP")) {
            return this._mfpAltList;
        }
        if (modelName.equalsIgnoreCase("HFP") || modelName.equals("HMS")) {
            return this._hfpAltList;
        }
        if (modelName.equalsIgnoreCase("RSS") || modelName.equals("RES")) {
            return this._rssAltList;
        }
        if (modelName.equalsIgnoreCase("RAS")) {
            return this._rasAltList;
        }
        if (modelName.equalsIgnoreCase("FIA")) {
            return this._fiaAltList;
        }
        return this.getSelectedPluginModelVector(modelName);
    }

    protected Vector getSelectedPluginModelVector(String modelName) {
        int index = this.getSelectedModelIndex();
        return this.getSupList(index);
    }

    private void loadCurrentLayer() {
        RmaListModel model = (RmaListModel)this.selectedModelsList.getModel();
        model.clear();
        if (this._condition == null) {
            return;
        }
        int modelIdx = this.getSelectedModelIndex();
        String modelName = this.getSelectedModelName();
        Vector v = this._condition.getModelAlts(modelIdx);
        if (v != null) {
            Vector v2 = this.getModelVectorFromRefVector(v, modelName);
            model.addAll((Collection)v2);
        }
    }

    private void setList(String[] list, String model) {
        if (list == null) {
            return;
        }
        RmaListModel listmodel = (RmaListModel)this.selectedModelsList.getModel();
        listmodel.addAll((Object[])list);
    }

    private void setListById(Vector altList, int programIndex) {
        if (altList.size() == 0) {
            return;
        }
        RmaListModel listmodel = (RmaListModel)this.selectedModelsList.getModel();
        for (int i = 0; i < altList.size(); ++i) {
            Identifier id;
            Object obj = altList.elementAt(i);
            if (obj instanceof ManagerProxy) {
                ManagerProxy proxy = (ManagerProxy)obj;
                id = proxy.getId();
            } else {
                Manager manager = (Manager)obj;
                id = manager.getIdentifier();
            }
            listmodel.addElement((Object)id.getName());
        }
    }

    protected Vector getSupList(int programIndex) {
        if (this._supAltList == null) {
            return null;
        }
        Vector<SupplementalProgramAlt> v = new Vector<SupplementalProgramAlt>();
        for (int i = 0; i < this._supAltList.size(); ++i) {
            SupplementalProgramAlt alt = (SupplementalProgramAlt)this._supAltList.elementAt(i);
            if (alt == null || alt.getProgramIndex() != programIndex) continue;
            v.addElement(alt);
        }
        return v;
    }

    private void fillSupList(int programIndex) {
        Vector<SupplementalProgramAlt> v = new Vector<SupplementalProgramAlt>();
        if (this._supAltList == null) {
            this.setListById(v, programIndex);
            return;
        }
        for (int i = 0; i < this._supAltList.size(); ++i) {
            SupplementalProgramAlt alt = (SupplementalProgramAlt)this._supAltList.elementAt(i);
            if (alt == null || alt.getIndex() != programIndex) continue;
            v.addElement(alt);
        }
        this.setListById(v, programIndex);
    }

    public String getTabname() {
        return "Models";
    }

    protected int getSelectedModelIndex() {
        String modelName = this.currentLayerLabel.getText();
        if (modelName.equals(NO_MODEL_SELECTED)) {
            return -1;
        }
        Object obj = this.currentLayerLabel.getObject();
        if (obj == null) {
            return -1;
        }
        if (!(obj instanceof ProgramOrderItem)) {
            return -1;
        }
        ProgramOrderItem poi = (ProgramOrderItem)obj;
        return poi.getIndex();
    }

    private String getSelectedModelName() {
        String modelName = this.currentLayerLabel.getText();
        if (modelName.equals(NO_MODEL_SELECTED)) {
            return null;
        }
        return WorkspaceNameFactory.getWorkspaceName((String)modelName);
    }

    private Vector getModelVectorFromRefVector(Vector modelRefVector, String modelName) {
        if (modelRefVector == null) {
            return new Vector();
        }
        if (modelName.equalsIgnoreCase("MFP")) {
            return this.getModelVectorFromRefVector(this._mfpAltList, modelRefVector);
        }
        if (modelName.equalsIgnoreCase("HFP") || modelName.equals("HMS")) {
            return this.getModelVectorFromRefVector(this._hfpAltList, modelRefVector);
        }
        if (modelName.equalsIgnoreCase("RSS") || modelName.equals("ResSim")) {
            return this.getModelVectorFromRefVector(this._rssAltList, modelRefVector);
        }
        if (modelName.equalsIgnoreCase("RAS")) {
            return this.getModelVectorFromRefVector(this._rasAltList, modelRefVector);
        }
        if (modelName.equalsIgnoreCase("FIA")) {
            return this.getModelVectorFromRefVector(this._fiaAltList, modelRefVector);
        }
        return this.getPluginModelVectorFromRefVector(modelName, modelRefVector);
    }

    protected Vector getPluginModelVectorFromRefVector(String modelName, Vector modelRefVector) {
        return this.getModelVectorFromRefVector(this._supAltList, modelRefVector);
    }

    protected Vector getModelVectorFromRefVector(Vector modelAltList, Vector modelRefVector) {
        Vector<Object> modelVector = new Vector<Object>();
        if (modelAltList == null) {
            return modelVector;
        }
        int size = modelAltList.size();
        int size2 = modelRefVector.size();
        block0: for (int j = 0; j < size2; ++j) {
            ModelReference mref = (ModelReference)modelRefVector.get(j);
            if (mref == null) continue;
            for (int i = 0; i < size; ++i) {
                Manager manager;
                Object obj = modelAltList.get(i);
                if (obj instanceof ManagerProxy) {
                    ManagerProxy proxy = (ManagerProxy)obj;
                    if (RMAIO.getFileFromPath((String)proxy.getId().getPath()).startsWith("_") || proxy.getIndex() != mref.id || !proxy.getClassName().equals(mref.className)) continue;
                    modelVector.add(proxy);
                    continue block0;
                }
                if (!(obj instanceof Manager) || RMAIO.getFileFromPath((String)(manager = (Manager)obj).getIdentifier().getPath()).startsWith("_") || manager.getIndex() != mref.id || !manager.getClass().getName().equals(mref.className)) continue;
                modelVector.add(manager);
                continue block0;
            }
        }
        return modelVector;
    }
}

