/*
 * Decompiled with CFR 0.152.
 */
package hec.watershed.client;

import hec.model.CommonDataList;
import hec.watershed.model.Condition;
import hec.watershed.model.ImpactArea;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.ComboBoxModel;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import rma.swing.ButtonCmdPanel;
import rma.swing.ButtonCmdPanelListener;
import rma.swing.RmaInsets;
import rma.swing.RmaJCheckBox;
import rma.swing.RmaJComboBox;
import rma.swing.RmaJDialog;
import rma.swing.RmaJTextArea;
import rma.swing.RmaJTextField;
import rma.swing.list.RmaListModel;

public class ConditionNotesEditor
extends RmaJDialog {
    RmaJComboBox impactAreaSelector;
    RmaJTextField conditionText;
    RmaJTextArea notesText;
    RmaJCheckBox nonStructuralCB;
    ButtonCmdPanel cmdPanel;
    CommonDataList _impactAreaDataList;
    Condition _condition;
    ImpactArea _selectedImpactArea = null;

    public ConditionNotesEditor(Dialog parent, boolean modal) {
        super(parent, modal);
        this.buildControls();
    }

    public ConditionNotesEditor(Frame parent, boolean modal) {
        super(parent, modal);
        this.buildControls();
    }

    private void buildControls() {
        this.getContentPane().setLayout(new GridBagLayout());
        this.setSize(400, 300);
        this.setTitle("Configuration Notes Editor");
        this.setLocation();
        JLabel label = new JLabel("Configuration:", 4);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)0);
        this.getContentPane().add((Component)label, gbc);
        this.conditionText = new RmaJTextField();
        this.conditionText.setEditable(false);
        this.conditionText.setEnabled(false);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.ipadx = 150;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        this.getContentPane().add((Component)this.conditionText, gbc);
        label = new JLabel("Impact Area:", 4);
        label.setDisplayedMnemonic('i');
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)0);
        this.getContentPane().add((Component)label, gbc);
        this.impactAreaSelector = new RmaJComboBox((ComboBoxModel)new RmaListModel(true));
        label.setLabelFor((Component)this.impactAreaSelector);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)0);
        this.getContentPane().add((Component)this.impactAreaSelector, gbc);
        label = new JLabel("Configuration Notes:", 4);
        label.setDisplayedMnemonic('c');
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)0);
        this.getContentPane().add((Component)label, gbc);
        this.notesText = new RmaJTextArea(5, 60){

            public Dimension getPreferredScrollableViewportSize() {
                return new Dimension(300, 100);
            }
        };
        this.notesText.setWrapStyleWord(true);
        this.notesText.setLineWrap(true);
        label.setLabelFor((Component)this.notesText);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.gridwidth = 3;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)5, (int)5);
        this.getContentPane().add((Component)new JScrollPane((Component)this.notesText), gbc);
        this.nonStructuralCB = new RmaJCheckBox("Display Non-Structural Symbol");
        this.nonStructuralCB.setMnemonic('d');
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 1;
        gbc.gridwidth = 1;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)0);
        gbc.weightx = 0.0;
        this.getContentPane().add((Component)this.nonStructuralCB, gbc);
        this.cmdPanel = new ButtonCmdPanel(14);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 4;
        gbc.gridwidth = 3;
        gbc.anchor = 14;
        gbc.fill = 2;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)5, (int)5);
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        this.getContentPane().add((Component)this.cmdPanel, gbc);
        this.impactAreaSelector.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 2) {
                    ConditionNotesEditor.this.windowClosing();
                    return;
                }
                ConditionNotesEditor.this.fillForm((ImpactArea)ConditionNotesEditor.this.impactAreaSelector.getSelectedItem());
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                ConditionNotesEditor.this.windowClosing();
            }
        });
        this.cmdPanel.addCmdPanelListener(new ButtonCmdPanelListener(){

            public void buttonCmdActionPerformed(ActionEvent e) {
                switch (e.getID()) {
                    case 8: {
                        ConditionNotesEditor.this.saveForm();
                        ConditionNotesEditor.this.setVisible(false);
                        break;
                    }
                    case 2: {
                        ConditionNotesEditor.this.saveForm();
                        break;
                    }
                    case 4: {
                        ConditionNotesEditor.this.windowClosing();
                        ConditionNotesEditor.this.setVisible(false);
                    }
                }
            }
        });
        this.pack();
    }

    public void setImactAreaDataList(CommonDataList cdl) {
        this._impactAreaDataList = cdl;
    }

    public void fillForm() {
        if (this._impactAreaDataList == null) {
            return;
        }
        Object[] objs = this._impactAreaDataList.getObjectArray();
        RmaListModel comboModel = new RmaListModel(true, objs);
        this.impactAreaSelector.setModel((ComboBoxModel)comboModel);
        ImpactArea ia = (ImpactArea)this.impactAreaSelector.getSelectedItem();
        this.fillForm(ia);
    }

    public void setCurrentCondition(Condition c) {
        this._condition = c;
    }

    public void setSelectedImpactArea(ImpactArea ia) {
        if (ia == null) {
            return;
        }
        this.impactAreaSelector.setSelectedItem((Object)ia);
    }

    protected void fillForm(ImpactArea ia) {
        if (ia == null || this._condition == null) {
            return;
        }
        String s = this._condition.getConditionNotes(ia.getId());
        boolean b = this._condition.getDisplaysSymbol(ia.getId());
        if (s != null) {
            this.notesText.setText(s);
        } else {
            this.notesText.setText("");
        }
        this.nonStructuralCB.setSelected(b);
        this.conditionText.setText(this._condition.getName());
        this._selectedImpactArea = ia;
        this.setModified(false);
    }

    public void saveForm() {
        ImpactArea ia = this._selectedImpactArea;
        if (ia == null || this._condition == null) {
            return;
        }
        this._condition.setConditionNotes(ia.getId(), this.notesText.getText());
        this._condition.setDisplaysSymbol(ia.getId(), this.nonStructuralCB.isSelected());
        this._condition.save();
        this.setModified(false);
    }

    public void windowClosing() {
        int opt;
        if (this.isModified() && (opt = JOptionPane.showConfirmDialog((Component)((Object)this), "Data has changed. Save Changes?", "Confirm Changes", 0)) == 0) {
            this.saveForm();
        }
    }

    public static void main(String[] args) {
        ConditionNotesEditor cne = new ConditionNotesEditor(new JFrame(), true);
        cne.pack();
        cne.setLocation(200, 200);
        cne.setVisible(true);
    }
}

