/*
 * Decompiled with CFR 0.152.
 */
package hec.watershed.client;

import hec.gui.AbstractEditorPanel;
import hec.lang.NamedType;
import hec.watershed.client.ConditionEditor;
import hec.watershed.client.ProjectNotesJDialog;
import hec.watershed.model.Condition;
import hec.watershed.model.Project;
import hec.watershed.model.ProjectRef;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.swing.table.TableCellRenderer;
import rma.swing.RmaInsets;
import rma.swing.RmaJTable;
import rma.swing.table.YesNoRenderer;
import rma.util.RMAIO;

public class ConditionProjectsPanel
extends AbstractEditorPanel {
    private RmaJTable projectTable;
    private ConditionEditor _parent;
    private Condition _condition;

    public ConditionProjectsPanel(ConditionEditor parent) {
        this._parent = parent;
        this.buildControls();
    }

    private void buildControls() {
        this.setLayout(new GridBagLayout());
        Object[] headers = new String[]{"Project\nName", " \nProject Notes", "Project\nType", " \nExisting"};
        this.projectTable = new RmaJTable((Component)((Object)this), headers);
        this.projectTable.getColumnModel().getColumn(3).setCellRenderer((TableCellRenderer)new YesNoRenderer());
        this.projectTable.setPopupMenuEnabled(false);
        this.projectTable.setColumnEnabled(false, 0);
        this.projectTable.setColumnEnabled(false, 1);
        this.projectTable.setColumnEnabled(false, 2);
        this.projectTable.setColumnEnabled(false, 3);
        this.projectTable.setCellSelectionEnabled(false);
        this.projectTable.setColumnSelectionAllowed(false);
        this.projectTable.setRowSelectionAllowed(true);
        this.projectTable.setMlHeaderRenderer();
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.insets = RmaInsets.insets((int)0, (int)0, (int)0, (int)0);
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        this.add(this.projectTable.getScrollPane(), gbc);
    }

    public void fillPanel(NamedType nt) {
        this.projectTable.deleteCells();
        if (!(nt instanceof Condition)) {
            return;
        }
        if (((Condition)nt).isStudyCondition()) {
            return;
        }
        this._condition = (Condition)nt;
        Vector projects = this._condition.getProjects();
        int rowHeight = this.projectTable.getRowHeight();
        int size = projects.size();
        int[] heights = new int[size];
        for (int i = 0; i < size; ++i) {
            Project p = (Project)projects.elementAt(i);
            if (p == null) continue;
            Vector<Object> row = new Vector<Object>(4);
            row.addElement(p);
            ProjectRef ref = this._condition.findProjectRef(p);
            if (ref != null) {
                int numRows;
                row.addElement(ref.getNotes());
                heights[i] = numRows = RMAIO.getNumChars((String)ref.getNotes(), (char)'\n') + 1;
            } else {
                row.addElement("");
            }
            row.addElement(p.getUserDisplayedType());
            row.addElement(p.isExisting());
            this.projectTable.appendRow(row);
        }
        int margin = this.projectTable.getRowMargin();
        for (int i = 0; i < heights.length; ++i) {
            if (heights[i] == 1) continue;
            this.projectTable.setRowHeight(i, heights[i] * rowHeight + margin * 2);
        }
    }

    public boolean savePanel(NamedType dobj) {
        return true;
    }

    public void projectNotes() {
        int row = this.projectTable.getSelectedRow();
        if (row < 0) {
            JOptionPane.showMessageDialog((Component)((Object)this), "Please select a Project to enter notes for.", "No Project Selected", 1);
            return;
        }
        Project proj = (Project)this.projectTable.getCell(row, 0);
        if (proj == null) {
            return;
        }
        ProjectNotesJDialog notesDialog = new ProjectNotesJDialog((Dialog)((Object)this._parent), true);
        notesDialog.setTitle("Project Notes Editor");
        Condition c = this._parent.getSelectedCondition();
        notesDialog.fillForm(c);
        if (c == null || c.isStudyCondition()) {
            notesDialog.setNotesVisible(false);
        } else {
            notesDialog.setNotesVisible(true);
        }
        notesDialog.setSelectedProject(proj);
        notesDialog.setVisible(true);
        ProjectRef ref = c.findProjectRef(proj);
        String notes = "";
        if (ref != null) {
            notes = ref.getNotes();
        }
        this.projectTable.setCell((Object)notes, row, 1);
        this.projectTable.revalidate();
        int rows = RMAIO.getNumChars((String)notes, (char)'\n') + 1;
        this.projectTable.setRowHeight(row, rows * this.projectTable.getRowHeight() + this.projectTable.getRowMargin() * 2);
    }

    public String getTabname() {
        return "Projects";
    }
}

