/*
 * Decompiled with CFR 0.152.
 */
package hec.watershed.client;

import hec.clientapp.client.ClientApp;
import hec.watershed.client.DefaultEditorNode;
import hec.watershed.model.WatershedDefaults;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Hashtable;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreeCellRenderer;
import rma.swing.ButtonCmdPanel;
import rma.swing.ButtonCmdPanelListener;
import rma.swing.RmaInsets;
import rma.swing.RmaJDialog;
import rma.swing.event.ReflectMultiListener;
import rma.swing.tree.CheckBoxEditor;
import rma.swing.tree.CheckBoxRenderer;

public class CustomizeEditorsDialog
extends RmaJDialog {
    JTree m_editorTree;
    ReflectMultiListener m_rml = new ReflectMultiListener();
    WatershedDefaults stateManager = null;
    DefaultEditorNode m_rootNode = null;

    public CustomizeEditorsDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.buildComponents();
        this.buildMenu();
    }

    public CustomizeEditorsDialog(Dialog parent, boolean modal) {
        super(parent, modal);
        this.buildComponents();
        this.buildMenu();
    }

    public CustomizeEditorsDialog(Frame parent, String title, boolean modal) {
        this(parent, modal);
        this.setTitle(title);
    }

    public CustomizeEditorsDialog(Dialog parent, String title, boolean modal) {
        this(parent, modal);
        this.setTitle(title);
    }

    private void buildMenu() {
        JMenuBar menuBar = new JMenuBar();
        JMenu menu = new JMenu("File");
        menu.setMnemonic('f');
        menuBar.add(menu);
        JMenuItem menuItem = new JMenuItem("Close", 99);
        menuItem.addActionListener((ActionListener)this.m_rml.add((Object)this, (Object)menuItem, "closeDialog"));
        menu.add(menuItem);
        menu = new JMenu("Edit");
        menu.setMnemonic('e');
        menuBar.add(menu);
        menuItem = new JMenuItem("Expand", 120);
        menuItem.addActionListener((ActionListener)this.m_rml.add((Object)this, (Object)menuItem, "expandAll"));
        menu.add(menuItem);
        menuItem = new JMenuItem("Collapse", 99);
        menuItem.addActionListener((ActionListener)this.m_rml.add((Object)this, (Object)menuItem, "collapseAll"));
        menu.add(menuItem);
        menuItem = new JMenuItem("Check All", 97);
        menuItem.addActionListener((ActionListener)this.m_rml.add((Object)this, (Object)menuItem, "checkAll"));
        menu.add(menuItem);
        menuItem = new JMenuItem("Uncheck All", 117);
        menuItem.addActionListener((ActionListener)this.m_rml.add((Object)this, (Object)menuItem, "uncheckAll"));
        menu.add(menuItem);
        this.setJMenuBar(menuBar);
    }

    private void buildComponents() {
        this.setTitle("Customize Editors");
        this.getContentPane().setLayout(new GridBagLayout());
        this.stateManager = WatershedDefaults.getDefaults();
        if (this.stateManager != null) {
            ClientApp.app();
            String modeName = ClientApp.frame().getCurrentMode().getClass().getName();
            this.m_rootNode = new DefaultEditorNode("Watershed Defaults", this.stateManager.getDefaults(modeName), true);
            this.m_editorTree = new JTree(this.m_rootNode);
        } else {
            this.m_editorTree = new JTree(new DefaultMutableTreeNode());
        }
        this.m_editorTree.setEditable(true);
        CheckBoxRenderer renderer = new CheckBoxRenderer();
        CheckBoxEditor editor = new CheckBoxEditor();
        this.m_editorTree.setCellRenderer((TreeCellRenderer)renderer);
        this.m_editorTree.setCellEditor((TreeCellEditor)editor);
        this.m_editorTree.setRootVisible(false);
        JScrollPane sp = new JScrollPane(this.m_editorTree);
        sp.setVerticalScrollBarPolicy(22);
        sp.setHorizontalScrollBarPolicy(30);
        this.getContentPane().add((Component)sp, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 1, RmaInsets.INSETS5505, 0, 0));
        ButtonCmdPanel cmdPanel = new ButtonCmdPanel(14);
        this.getContentPane().add((Component)cmdPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 16, 2, RmaInsets.INSETS5555, 0, 0));
        cmdPanel.addCmdPanelListener(new ButtonCmdPanelListener(){

            public void buttonCmdActionPerformed(ActionEvent event) {
                switch (event.getID()) {
                    case 8: {
                        CustomizeEditorsDialog.this.OKActionPerformed();
                        break;
                    }
                    case 2: {
                        CustomizeEditorsDialog.this.ApplyActionPerformed();
                        break;
                    }
                    case 4: {
                        CustomizeEditorsDialog.this.CancelActionPerformed();
                    }
                }
            }
        });
        this.expandAll();
    }

    public void closeDialog() {
        this.CancelActionPerformed();
    }

    private void savePanel() {
        if (this.m_rootNode == null) {
            return;
        }
        Hashtable table = new Hashtable();
        this.m_rootNode.save(table);
        ClientApp.app();
        String modeName = ClientApp.frame().getCurrentMode().getClass().getName();
        this.stateManager.setDefaults(modeName, table);
        this.stateManager.saveManager();
        this.setModified(false);
    }

    private void OKActionPerformed() {
        this.savePanel();
        this.setVisible(false);
        this.dispose();
    }

    private void ApplyActionPerformed() {
        this.savePanel();
    }

    private void CancelActionPerformed() {
        this.setVisible(false);
        this.dispose();
    }

    public void collapseAll() {
        for (int row = this.m_editorTree.getRowCount() - 1; row >= 0; --row) {
            this.m_editorTree.collapseRow(row);
        }
    }

    public void expandAll() {
        for (int row = 0; row < this.m_editorTree.getRowCount(); ++row) {
            this.m_editorTree.expandRow(row);
        }
    }

    public void checkAll() {
        if (this.m_rootNode == null) {
            return;
        }
        this.m_rootNode.setSelected(true);
        this.m_editorTree.repaint();
    }

    public void uncheckAll() {
        if (this.m_rootNode == null) {
            return;
        }
        this.m_rootNode.setSelected(false);
        this.m_editorTree.repaint();
    }

    public static void main(String[] args) {
        CustomizeEditorsDialog ed = new CustomizeEditorsDialog((Frame)null, true);
        ed.setLocation(300, 300);
        ed.pack();
        ed.setVisible(true);
    }
}

