/*
 * Decompiled with CFR 0.152.
 */
package hec.watershed.client;

import java.util.HashMap;
import java.util.Map;
import javax.swing.tree.DefaultMutableTreeNode;
import rma.swing.tree.CheckBoxNode;

public class DefaultEditorNode
extends DefaultMutableTreeNode
implements CheckBoxNode {
    boolean _selected;
    String _key = "";
    boolean _recursiveSelection;

    public DefaultEditorNode(String key, Map children, boolean recursiveSelection) {
        this._key = key;
        this._recursiveSelection = recursiveSelection;
        if (children == null) {
            return;
        }
        for (String tkey : children.keySet()) {
            Object val = children.get(tkey);
            if (val instanceof Boolean) {
                this.add(new DefaultEditorNode(tkey, (Boolean)val, recursiveSelection));
                continue;
            }
            this.add(new DefaultEditorNode(tkey, (Map)val, recursiveSelection));
        }
        this.setUserObject(this.removeObjectIndex(this._key));
    }

    public DefaultEditorNode(String key, Boolean selected, boolean recursiveSelection) {
        this._key = key;
        this._recursiveSelection = recursiveSelection;
        this._selected = selected;
        this.setUserObject(this.removeObjectIndex(this._key));
    }

    private String removeObjectIndex(String value) {
        if (value == null) {
            return null;
        }
        int index = value.indexOf("}");
        if (index < 0) {
            return value;
        }
        if (index + 1 >= value.length()) {
            return "";
        }
        return value.substring(index + 1).trim();
    }

    public boolean isSelected() {
        int childCount = this.getChildCount();
        if (this._recursiveSelection && childCount > 0) {
            boolean selected = true;
            for (int i = 0; i < childCount; ++i) {
                CheckBoxNode node = (CheckBoxNode)this.getChildAt(i);
                selected &= node.isSelected();
            }
            this._selected = selected;
            return selected;
        }
        return this._selected;
    }

    public void setSelected(boolean b) {
        this._selected = b;
        if (this._recursiveSelection) {
            int childCount = this.getChildCount();
            for (int i = 0; i < childCount; ++i) {
                CheckBoxNode node = (CheckBoxNode)this.getChildAt(i);
                node.setSelected(b);
            }
        }
    }

    public int getSelectionMode() {
        return 0;
    }

    public void save(Map dataTable) {
        int childCount = this.getChildCount();
        if (childCount > 0) {
            Map table = this.getParent() == null ? dataTable : new HashMap();
            for (int i = 0; i < childCount; ++i) {
                DefaultEditorNode node = (DefaultEditorNode)this.getChildAt(i);
                node.save(table);
            }
            if (this.getParent() != null) {
                dataTable.put(this._key, table);
            }
        } else {
            dataTable.put(this._key, this.isSelected());
        }
    }
}

