/*
 * Decompiled with CFR 0.152.
 */
package hec.watershed.client;

import hec.gui.AbstractEditorPanel;
import hec.lang.NamedType;
import hec.map.MapLabelItem;
import hec.map.streamAlignment.StreamAlignmentIfc;
import hec.model.CommonDataList;
import hec.model.DataListLoader;
import hec.model.DataObject;
import hec.model.Node;
import hec.model.StreamElement;
import hec.watershed.model.ComputationPoint;
import hec.watershed.model.Diversion;
import hec.watershed.model.Reservoir;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import rma.swing.RmaInsets;
import rma.swing.RmaJCheckBox;
import rma.swing.RmaJComboBox;
import rma.swing.RmaJIntegerField;
import rma.swing.RmaJTable;

public class DiversionProjectPanel
extends AbstractEditorPanel {
    RmaJTable m_diversionTable;
    RmaJCheckBox m_existingProject;
    RmaJCheckBox m_corpsProject;
    RmaJIntegerField m_yearInServiceTxt;
    RmaJComboBox m_labelPosCombo;
    Diversion m_diversion = null;

    public DiversionProjectPanel() {
        this.buildControls();
    }

    protected void buildControls() {
        this.setLayout(new GridBagLayout());
        Object[] colNames = new String[]{"", "Stream\nName", "Common Computation\nPoint Name", "Reservoir\nName"};
        Object[][] rowData = new Object[][]{{"Upstream", "", "", ""}, {"Downstream", "", "", ""}};
        this.m_diversionTable = new RmaJTable((Component)((Object)this), rowData, colNames){

            public Dimension getPreferredScrollableViewportSize() {
                Dimension d = super.getPreferredScrollableViewportSize();
                d.height = this.getRowCount() * this.getRowHeight();
                return d;
            }
        };
        this.m_diversionTable.setMlHeaderRenderer();
        this.m_diversionTable.setPopupMenuEnabled(false);
        for (int i = 0; i < this.m_diversionTable.getModel().getColumnCount(); ++i) {
            this.m_diversionTable.setColumnEnabled(false, i);
        }
        JPanel panel = new JPanel(new GridBagLayout());
        JScrollPane sp = this.m_diversionTable.getScrollPane();
        this.add(sp, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 1, RmaInsets.INSETS5505, 0, 0));
        this.add(panel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 16, 2, RmaInsets.INSETS0000, 0, 0));
        this.m_existingProject = new RmaJCheckBox("Existing Project");
        this.m_existingProject.setMnemonic('e');
        this.m_corpsProject = new RmaJCheckBox("Corps Project");
        this.m_corpsProject.setMnemonic('c');
        JLabel yearInService = new JLabel("Year in Service:");
        this.m_yearInServiceTxt = new RmaJIntegerField();
        this.m_yearInServiceTxt.setMaxLength(4);
        JLabel labelPosLbl = new JLabel("Label Position:");
        this.m_labelPosCombo = new RmaJComboBox((Object[])MapLabelItem.POSITION_STRINGS);
        this.m_labelPosCombo.setModifiable(true);
        this.m_existingProject.setMargin(RmaInsets.INSETS0000);
        this.m_corpsProject.setMargin(RmaInsets.INSETS0000);
        panel.add((Component)this.m_existingProject, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 0, RmaInsets.INSETS5500, 0, 0));
        panel.add((Component)this.m_corpsProject, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 11, 0, RmaInsets.INSETS5500, 0, 0));
        panel.add((Component)yearInService, new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 12, 0, RmaInsets.INSETS5500, 0, 0));
        panel.add((Component)this.m_yearInServiceTxt, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 12, 0, RmaInsets.INSETS5505, 100, 0));
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame();
        frame.getContentPane().add((Component)((Object)new DiversionProjectPanel()), "Center");
        frame.setLocation(250, 250);
        frame.pack();
        frame.setVisible(true);
    }

    public void fillPanel(NamedType proj) {
        if (!(proj instanceof Diversion)) {
            return;
        }
        this.m_diversion = (Diversion)proj;
        if (this.m_diversion == null) {
            return;
        }
        this.m_existingProject.setSelected(this.m_diversion.isExisting());
        this.m_corpsProject.setSelected(this.m_diversion.isCorpsProject());
        this.m_yearInServiceTxt.setValue((int)this.m_diversion.getYearInService());
        this.m_labelPosCombo.setSelectedIndex(this.m_diversion.getLabelPosition());
        Node downStreamNode = this.m_diversion.getDownstreamNode();
        Node upstreamNode = this.m_diversion.getUpstreamNode();
        this.m_diversionTable.setCell((Object)"Upstream", 0, 0);
        this.m_diversionTable.setCell((Object)"Downstream", 1, 0);
        this.fillTableRow(1, downStreamNode, this.m_diversion.getComputationPoint(false));
        this.fillTableRow(0, upstreamNode, this.m_diversion.getComputationPoint(true));
        long id = this.m_diversion.getReservoirId();
        CommonDataList dl = DataListLoader.getDataListLoader().getCommonDataList("hec.watershed.model.Reservoir");
        DataObject res = dl.getObject(id);
        if (res != null) {
            this.fillTableRow(res);
        }
    }

    private void fillTableRow(int row, Node node, ComputationPoint cp) {
        if (row < 0 || row >= this.m_diversionTable.getRowCount()) {
            return;
        }
        if (node != null) {
            StreamAlignmentIfc alignment = DataListLoader.getDataListLoader().getStreamAlignment();
            if (alignment == null) {
                return;
            }
            StreamElement element = alignment.findReach(node.getStreamIndex());
            if (element != null) {
                this.m_diversionTable.setCell((Object)element.getName(), row, 1);
            }
        }
        if (cp != null) {
            this.m_diversionTable.setCell((Object)cp.getName(), row, 2);
        }
    }

    private void fillTableRow(DataObject dataOb) {
        if (dataOb instanceof Reservoir) {
            Reservoir res = (Reservoir)dataOb;
            this.m_diversionTable.setCell((Object)res.toString(), 0, 3);
            this.m_diversionTable.setCell((Object)res.toString(), 1, 3);
        }
    }

    public boolean savePanel() {
        return this.savePanel((NamedType)this.m_diversion);
    }

    public boolean savePanel(NamedType dobj) {
        Diversion diversion = null;
        if (dobj == null) {
            diversion = this.m_diversion;
        } else if (dobj instanceof Diversion) {
            diversion = (Diversion)dobj;
        }
        if (diversion == null) {
            return true;
        }
        diversion.setIsExisting(this.m_existingProject.isSelected());
        diversion.setIsCorpsProject(this.m_corpsProject.isSelected());
        diversion.setYearInService((short)this.m_yearInServiceTxt.getValue());
        diversion.setLabelPosition(this.m_labelPosCombo.getSelectedIndex());
        return true;
    }

    public String getTabname() {
        return "Diversion";
    }

    public void setStreamListEnabled(boolean b) {
    }
}

