/*
 * Decompiled with CFR 0.152.
 */
package hec.watershed.client;

import hec.map.WorldPt;
import hec.model.CommonDataList;
import hec.model.DataListLoader;
import hec.model.DataStruct;
import hec.model.Node;
import hec.model.StreamElement;
import hec.watershed.client.ProjectTablePanel;
import hec.watershed.model.ComputationPoint;
import hec.watershed.model.Diversion;
import hec.watershed.model.Reservoir;
import hec.watershed.model.StudyIfc;
import java.util.Vector;
import rma.swing.table.RmaTableModel;
import rma.swing.table.RmaTableModelInterface;
import rma.util.RMAIO;

public class DiversionTablePanel
extends ProjectTablePanel {
    private static final int NAME_COL = 0;
    private static final int RESERVOI_COL = 1;
    private static final int UPSTREAM_NAME_COL = 2;
    private static final int UPSTREAM_COL = 3;
    private static final int DOWNSTREAM_NAME_COL = 4;
    private static final int DOWNSTREAM_COL = 5;
    private static final int EXSITING_COL = 6;
    private static final int CORP_PROJ_COL = 7;
    private static final int YEAR_SERV_COL = 8;
    private static final int DESC_COL = 9;
    private static final String TABNAME = "Diversions";

    public DiversionTablePanel() {
        this.buildControls();
    }

    private void buildControls() {
        boolean[] editable = new boolean[]{true, true, true, true, true, true, true, true, true, true, false};
        String[] colNames = new String[]{" \nName", "Reservoir\nName", "Starting Stream\nName", "Upstream\nStation", "Ending Stream\nName", "Downstream\nStation", "Existing\nProject", "Corps\nProject", "Year in\nService", "Description", ""};
        RmaTableModel tableModel = new RmaTableModel(colNames, new Object[0][0], editable);
        this.setTableModel((RmaTableModelInterface)tableModel);
        this.m_projectTable.setMlHeaderRenderer();
        this.m_projectTable.setCheckBoxCellEditor(7);
        this.m_projectTable.setCheckBoxCellEditor(6);
        this.m_projectTable.setDoubleCellEditor(3, true);
        this.m_projectTable.setDoubleCellEditor(5, true);
        this.setStreamElementColumn(4);
        this.m_projectTable.setColumnWidth(0, 150);
        this.m_projectTable.setColumnWidth(editable.length - 2, 250);
        this.m_projectTable.setColumnVisible(editable.length - 1, false, 0);
    }

    @Override
    public String getTabname() {
        return TABNAME;
    }

    public boolean savePanel() {
        this.m_projectTable.commitEdit(true);
        for (int row = 0; row < this.m_modifiedRows.size(); ++row) {
            Vector rowData = this.m_projectTable.getRow(this.m_modifiedRows.elementAt(row));
            Diversion div = (Diversion)rowData.elementAt(this.m_projectTable.getModel().getColumnCount() - 1);
            div.setName((String)rowData.elementAt(0));
            Reservoir res = (Reservoir)rowData.elementAt(1);
            div.setReservoirId(res != null ? res.getId() : -1L);
            StreamElement s = (StreamElement)rowData.elementAt(2);
            div.setStreamId(s != null ? s.getIndex() : -1);
            Node node = div.getUpstreamNode();
            node.setStreamIndex(s != null ? s.getIndex() : -1);
            s = (StreamElement)rowData.elementAt(4);
            if (s != null && (node = div.getDownstreamNode()) == null) {
                node.setStreamIndex(s != null ? s.getIndex() : -1);
            }
            div.setIsExisting((Boolean)rowData.elementAt(6));
            div.setIsCorpsProject((Boolean)rowData.elementAt(7));
            div.setYearInService((short)RMAIO.parseInt(rowData.elementAt(8)));
            div.setDescription((String)rowData.elementAt(9));
        }
        this.m_modifiedRows.removeAllElements();
        return true;
    }

    @Override
    public void fillPanel() {
        this.m_projectTable.deleteCells();
        StudyIfc study = super.getOpenStudy();
        if (study == null) {
            return;
        }
        CommonDataList resdl = DataListLoader.getDataListLoader().getCommonDataList("hec.watershed.model.Reservoir");
        DataStruct[] reservoirs = resdl.getObjectArray();
        CommonDataList dl = DataListLoader.getDataListLoader().getCommonDataList("hec.watershed.model.Diversion");
        if (dl == null) {
            return;
        }
        DataStruct[] dataObjList = dl.getObjectArray();
        Node node = null;
        for (int row = 0; dataObjList != null && row < dataObjList.length; ++row) {
            Diversion diversion = (Diversion)dataObjList[row];
            if (diversion == null) continue;
            Vector<Object> rowData = new Vector<Object>();
            rowData.addElement(diversion.getName());
            Reservoir res = (Reservoir)resdl.getObject(diversion.getReservoirId());
            rowData.addElement(res);
            StreamElement elem = this.getStreamElement(diversion.getStreamId());
            rowData.addElement(elem);
            node = diversion.getUpstreamNode();
            rowData.addElement(node != null ? RMAIO.toTable((double)node.getStreamStation()) : "");
            node = diversion.getDownstreamNode();
            rowData.addElement(node != null ? this.getStreamElement(node.getStreamIndex()) : this.getStreamElement(-1));
            rowData.addElement(node != null ? RMAIO.toTable((double)node.getStreamStation()) : "");
            rowData.addElement(diversion.isExisting());
            rowData.addElement(diversion.isCorpsProject());
            rowData.addElement(new Integer(diversion.getYearInService()));
            rowData.addElement(diversion.getDescription());
            rowData.addElement(diversion);
            this.m_projectTable.appendRow(rowData);
        }
        this.m_projectTable.setColumnEnabled(false, 2);
        this.m_projectTable.setColumnEnabled(false, 4);
        this.m_projectTable.setColumnEnabled(false, 1);
    }

    private String getStreamStation(ComputationPoint cp) {
        if (cp == null) {
            return "";
        }
        return RMAIO.toTable((double)cp.getStreamStation());
    }

    private String getNorthing(ComputationPoint cp) {
        if (cp == null) {
            return "";
        }
        WorldPt wp = cp.getReferencePt();
        if (wp == null) {
            return "";
        }
        return RMAIO.toTable((double)wp.n);
    }

    private String getEasting(ComputationPoint cp) {
        if (cp == null) {
            return "";
        }
        WorldPt wp = cp.getReferencePt();
        if (wp == null) {
            return "";
        }
        return RMAIO.toTable((double)wp.e);
    }
}

